// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: groc_sh.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 11/02/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

General purpose search functions used with the grocery list
database.
*/
// ----------------------------------------------------------- //
#ifndef __GROC_SH_HPP__
#define __GROC_SH_HPP__

#include "grocery.hpp"
#include "rbtree.hpp"
#include "dllist.hpp"
#include "btwalk.hpp"

enum GrocDBItem { // Database items used in global database searches
  NAME,
  BRAND,
  STORE
};

// Variable used to count the number of object found during a search
extern int ObjectsFound;

// Global data structures used to organize and store btree nodes
extern DLList<InMemCopy> GrocDB_SH_DLList; // Doubly Linked
extern DLList<InMemCopy> *dllist;         // Doubly Linked
extern DNode<InMemCopy> *dllistptr;       // DLList node pointer
extern RBTree<InMemCopy> GrocDB_SH_RBTree; // Red Black memory based tree
extern RBTree<InMemCopy> *rbtree;         // Red Black memory based tree

// SearchVisitFunc is a function pointer used for a visit action that
// searches each btree node for a specified string database item. All
// visit actions define a procedure used to process node data.
typedef void (*SearchVisitFunc)(CachePointer Node, int item, Grocery &grocery,
				UString &str, int find_all); 

// Recursive functions used to search the btree.
void BtreeSearch(CachePointer t, SearchVisitFunc Visit, int item,
                 Grocery &grocery, UString &str, int find_all = 0); 

// Visit functions used by the btree iterator
void LoadKeys(CachePointer n);
void BtreeNodeSearch(CachePointer n, int item, Grocery &grocery, UString &str,
		     int find_all);

#endif  // __GROC_SH_HPP__ 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

