// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dbconfig.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 11/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Modify this file to customize the marine tank database's user
interface program. 
*/
// ----------------------------------------------------------- //   
#ifndef __DBCONFIG_HPP
#define __DBCONFIG_HPP

// Program's title used in main menu for curses (terminal) program
const char *MMTitle = "------- MARINE TANK WATER TEST MAIN MENU -------" ;

// Program's name
const char *ProgramName = "Marine Tank Water Test Program";
const char *ShortName = "Marine Water Test";

// Define global field names for controls, displays, printing
const char *KeyName = "TEST DATE";
const char *M2Name =  "SPECIFIC GRAVITY";
const char *M3Name =  "pH";
const char *M4Name =  "AMMONIA";
const char *M5Name =  "NITRATE";
const char *M6Name =  "NITRITE";
const char *M7Name =  "COMMENTS";

// Set upper and lower limits for water test analyses
const double sg_lower_limit = 1.020; // Lower limit for specific gravity
const double sg_upper_limit = 1.023; // Upper limit for specific gravity
const double ph_lower_limit = 8.0;   // Lower limit for pH
const double ph_upper_limit = 8.4;   // Upper limit for pH
const double ammonia_limit = 0.1;    // Ammonia limit mg/liter
const int nitrate_limit_fish = 40;   // Nitrate limit for fish mg/liter
const int nitrate_limit_IV = 20;     // Nitrate limit for invertebrates
const double nitrite_limit = 0.1;    // Nitrite limit mg/liter

// Configuration file information
#ifdef __UNIX__
const char *DefaultCfgFile = ".mtank"; // Default user configuration file
#endif

#ifdef __DOS__
const char *DefaultCfgFile = "mtank.ini"; // Default user configuration file
#endif

const char *EnvSetting = "MTANKCFG"; // Environment setting for CFG file 

// Default file names
// Do not use any file extensions when creating or opening file.
// Both data and index will share the same name with different
// file extensions. The data file will have a .pod extension and
// the index file will have a .btx extension.
#ifdef __UNIX__
// UNIX file systems use a forward slash (/) for path separators
const char *DefaultDBFileName = "mtank"; // Default DB file
#endif

#ifdef __DOS__
// DOS file systems use a back slash (\\) for path separators
const char *DefaultDBFileName = "mtank"; // Default DB file
#endif

#endif  // __DBCONFIG_HPP //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
