// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: mtank.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 09/17/1997  
// Date Last Modified: 11/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a test program used to test the (P)ersistent base class
in a practical database application.
*/
// ----------------------------------------------------------- // 
#include "mtank.hpp"

MarineTank::MarineTank(POD *pod) : Persistent(pod)
{
  specific_gravity = pH = ammonia = nitrite = 0;
  nitrate = 0;
  comments = "\0";
}

MarineTank::MarineTank(const POD *pod) : Persistent(pod)
{
  specific_gravity = pH = ammonia = nitrite = 0;
  nitrate = 0;
  comments = "\0";
}

MarineTank::MarineTank() 
{
  specific_gravity = pH = ammonia = nitrite = 0;
  nitrate = 0;
  comments = "\0";
}

unsigned MarineTank::ObjectLength()
{
  unsigned len = cdate.SizeOf() + \
    sizeof(specific_gravity) + \
    sizeof(pH) + \
    sizeof(ammonia) + \
    sizeof(nitrate) + \
    sizeof(nitrite) + \
    StringFileLength(comments);
  
  return len;
}

FAU MarineTank::Write()
{
  ObjectHeader oh;

  FAU addr = pod->OpenDatabase()->Alloc(ObjectLength() + sizeof(ObjectHeader));
  if(!addr) return 0;
  
  oh.ClassID = GetClassID();
  oh.ObjectID = addr;
  WriteObjHeader(oh);

  pod->OpenDatabase()->Write(&cdate, cdate.SizeOf());
  pod->OpenDatabase()->Write(&specific_gravity, sizeof(specific_gravity));
  pod->OpenDatabase()->Write(&pH, sizeof(pH));
  pod->OpenDatabase()->Write(&ammonia, sizeof(ammonia));
  pod->OpenDatabase()->Write(&nitrate, sizeof(nitrate));
  pod->OpenDatabase()->Write(&nitrite, sizeof(nitrite));
  WriteString(comments);
  objectaddress = addr;
  
  // Add the entry to the Index file
  if (UsingIndex()) {
    EntryKey key(cdate.c_str(), oh.ObjectID, oh.ClassID);
    AddKey(key);
  }

  return addr;
}

void MarineTank::Read(FAU Address)
{
  ObjectHeader oh;

  ReadObjHeader(oh, Address);
  if(oh.ClassID != GetClassID()) return; // Incorrect object type

  pod->OpenDatabase()->Read(&cdate, cdate.SizeOf());
  pod->OpenDatabase()->Read(&specific_gravity, sizeof(specific_gravity));
  pod->OpenDatabase()->Read(&pH, sizeof(pH));
  pod->OpenDatabase()->Read(&ammonia, sizeof(ammonia));
  pod->OpenDatabase()->Read(&nitrate, sizeof(nitrate));
  pod->OpenDatabase()->Read(&nitrite, sizeof(nitrite));
  ReadString(comments);
  objectaddress = Address;
}

FAU MarineTank::Find()
{
  MarineTank mtank;
  
  mtank.cdate = this->cdate;
  mtank.specific_gravity = this->specific_gravity;
  mtank.pH = this->pH;
  mtank.ammonia = this->ammonia;
  mtank.nitrate = this->nitrate;
  mtank.nitrite = this->nitrite;
  mtank.comments = this->comments;
  
  int rv; // Return value
 
  // Search the index file for this entry
  if(UsingIndex()) {
    EntryKey e(this->cdate.c_str());
    rv = FindKey(e);
    if(rv) { // Found the object in the index file
      Read(e.object_address);
      return e.object_address;
    }
    else
      return 0;
  }

  FAU addr = 0;
  ObjectHeader oh;

  while(1)
    {
      addr = pod->OpenDatabase()->FindFirstObject(addr);
      if(!addr) break;
      ReadObjHeader(oh, addr);
      if(oh.ClassID == GetClassID()) {
	Read(addr);
	if(mtank.cdate == cdate) {
	  objectaddress = addr;
	  return addr; // Found unique data member
	}
	else {
	  // Reset the objects data
          this->cdate = mtank.cdate;
	  this->specific_gravity = mtank.specific_gravity;
	  this->pH = mtank.pH;
	  this->ammonia = mtank.ammonia;
          this->nitrate = mtank.nitrate;
          this->nitrite = mtank.nitrite;
	  this->comments = mtank.comments;
	}
      }
    }
  return 0; // Could not find 
}

void MarineTank::Copy(const MarineTank &ob)
{
  cdate = ob.cdate;
  specific_gravity = ob.specific_gravity;
  pH = ob.pH;
  ammonia = ob.ammonia;
  pH = ob.pH;
  nitrate = ob.nitrate;
  nitrite = ob.nitrite;
  comments = ob.comments;
}

int MarineTank::FullCompare(const MarineTank &ob)
{
  if(ob.cdate != cdate) return 0;
  if(ob.specific_gravity != specific_gravity) return 0;
  if(ob.pH != pH) return 0;
  if(ob.ammonia != ammonia) return 0;
  if(ob.nitrate != nitrate) return 0;
  if(ob.nitrite != nitrite) return 0;
  if(ob.comments != comments) return 0;
  return 1;
}

int operator==(const MarineTank &a, const MarineTank &b)
{
  return a.GetDate() == b.GetDate();
}

int operator!=(const MarineTank &a, const MarineTank &b)
{
  return a.GetDate() != b.GetDate();
}

int operator<(const MarineTank &a, const MarineTank &b)
{
  return a.GetDate() < b.GetDate();
}
  
FAU MarineTank::Delete()
{
  if(UsingIndex()) {
    EntryKey e(this->cdate.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      DeleteObject(e.object_address); // Delete from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not delete
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  DeleteObject(addr);
  return addr;
}

FAU MarineTank::Remove()
{
  if(UsingIndex()) {
    EntryKey e(this->cdate.c_str());
    int rv = FindKey(e);
    if(rv) {  // Found the object in the index file
      FAU addr = e.object_address;
      RemoveObject(e.object_address); // Remove from the data file
      RemoveKey(e);                   // Remove from the index file
      return addr;
    }
    else
      return 0; // Could not remove
  }

  FAU addr = Find();
  if(!addr) return 0; // Object does not exist
  RemoveObject(addr);
  return addr;
}

int MarineTank::CompareIndex()
// Compares the data file to the index file.
// Returns true if data and index file match.
{
  if(!UsingIndex()) return 0;

  MarineTank mtank(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int matches = 0; // Keep track of matches
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  objects++; // Increment the object count
	  mtank.Read(oa);
	  key.SetStrKey(mtank.GetDateStr());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  int rv = FindKey(key, 1);
	  if(rv) matches++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == matches;
}

int MarineTank::RebuildIndexFile(const char *fname)
{
  if(!UsingIndex()) return 0;

  int rv; // (R)eturn (V)alue
  int CacheSize = 15;

  VBDFilePtr f(new VBDFile);
  Btree btx(CacheSize);
  f->Create(fname, sizeof(BtreeHeader));
  btx.Connect(f, 1);
  
  MarineTank mtank(pod);
  EntryKey key;
  
  FAU oa;          // Object Address
  VBHeader vb;     // Variable Block Header
  ObjectHeader oh; // Object Header
  
  int objects = 0; // Keeps track of good variable blocks
  int inserts = 0; // Keep track of inserts
  
  FAU vbdfileEOF = pod->OpenDatabase()->GetEOF();
  FAU addr = 0;
  addr = pod->OpenDatabase()->FindFirstVB(addr); // Search the entire file

  if(addr == 0) { // No variable blocks found in file
#ifdef CPP_EXCEPTIONS
    throw CNoObjectsExist();
#else
    Error->SignalException(EHandler::NoObjectsExist, EHandler::DISPLAY);
    return 0;
#endif
  }
  
  while(1) { 
    if(addr >= vbdfileEOF) break;
    pod->OpenDatabase()->Read(&vb, sizeof(VBHeader), addr);
    if(vb.CkWord == CheckWord) {
      if((__SBYTE__)vb.Status == NormalVB) {
	oa = addr + sizeof(VBHeader);
	ReadObjHeader(oh, oa);
	if(oh.ClassID == GetClassID()) { 
	  objects++; // Increment the object count
	  mtank.Read(oa);
	  key.SetStrKey(mtank.GetDateStr());
	  key.SetOA(oa);
	  key.SetCID(oh.ClassID);
	  rv = btx.Add(key);
	  if(!rv) { 
#ifdef CPP_EXCEPTIONS
	    throw CAssertError();
#else
	  Error->SignalException(EHandler::AssertError);
#endif
	  }
	  else
	    inserts++; // Index and data file match
	}
      }
      addr = addr + vb.Length; // Goto the next variable block
    }
    else {
      addr = pod->OpenDatabase()->VBSearch(addr); 
      if(!addr) break;
    }
  }

  return objects == inserts;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
