// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: mtank.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 09/17/1997  
// Date Last Modified: 11/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a test program used to test the (P)ersistent base class
in a practical database application.
*/
// ----------------------------------------------------------- //   
#ifndef __MTANK_HPP
#define __MTANK_HPP

#include "persist.hpp"
#include "float64.hpp"
#include "cdate.hpp"

// Object type id
const INT32 MarineTankID = 6798;

// Class version
const INT32 MarineTankVersion = 1025;

class MarineTank : public Persistent
{
public:
  MarineTank(POD *pod);
  MarineTank(const POD *pod);
  MarineTank();
  MarineTank(const MarineTank &ob) { Copy(ob); }
  void operator=(const MarineTank &ob) { Copy(ob); }
  ~MarineTank() { }
  
public:
  void SetDate(__UBYTE__ month, __UBYTE__ day, UINT16 year) {
    cdate.SetDate(month, day, year);
  }
  void SetCDate(const CDate &ob) { cdate = ob; }
  void SetSG(FLOAT64 val) { specific_gravity = val; }
  void SetPH(FLOAT64 val) { pH = val; }
  void SetAmmonia(FLOAT64 val) { ammonia = val; }
  void SetNitrate(INT32 val) { nitrate = val; }
  void SetNitrite(FLOAT64 val) { nitrite = val; }
  void SetComments(UString &s) { comments = s; }
  void SetComments(char *s) { comments = s; }
  void SetComments(const char *s) { comments = s; }
  char *GetDateStr() { return cdate.c_str(); }
  char *GetMonthStr() { return cdate.month_c_str(); }
  char *GetDayStr() { return cdate.day_c_str(); }
  char *GetYearStr() { return cdate.year_c_str(); }
  CDate GetDate() { return cdate; }
  CDate GetDate() const { return cdate; }
  FLOAT64 GetSG() { return specific_gravity; }
  FLOAT64 GetPH() { return pH; }
  FLOAT64 GetAmmonia() { return ammonia; }
  INT32 GetNitrate() { return nitrate; }
  FLOAT64 GetNitrite() { return nitrite; }
  char *GetComments() { return comments.c_str(); }
  const char *GetComments() const { return comments.c_str(); }
  
public:
  void Copy(const MarineTank &ob);
  int FullCompare(const MarineTank &ob);
  
private: // Base class interface
  virtual FAU Write();
  virtual void Read(FAU Address);
  virtual FAU Find();
  virtual FAU Delete();
  virtual FAU Remove();
  
public: // Base class interface
  virtual INT32 GetClassID() const { return MarineTankID; }
  virtual const char *GetClassName() { return "Class MarineTank"; }
  virtual unsigned ObjectLength();
  virtual void SetObjectAddress(FAU addr) { objectaddress = addr; }
  virtual FAU GetObjectAddress() { return objectaddress; }
  virtual int CompareIndex();
  virtual int RebuildIndexFile(const char *fname);
  
public: // Overloaded operators
  friend int operator==(const MarineTank &a, const MarineTank &b);
  friend int operator!=(const MarineTank &a, const MarineTank &b);
  friend int operator<(const MarineTank &a, const MarineTank &b);

private:
  CDate   cdate;            // Date of the water test
  FLOAT64 specific_gravity; // Hydrometer reading for salintiy
  FLOAT64 pH;               // Percentage of hydrogen
  FLOAT64 ammonia;          // NH3-Nitrogen in milligrams/liter or ppm
  INT32   nitrate;          // NO3-Nitrogen in milligrams/liter or ppm
  FLOAT64 nitrite;          // NO2-Nitrogen in milligrams/liter or ppm
  UString comments;         // Comments block
};

#endif  // __MTANK_HPP 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
