#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the database program  
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 09/18/1997 
# Date Last Modified: 11/02/1998
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v    -- Echo compilation
#       g    -- Enable debugging
#	+w   -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# Linker flags 
#	-lm       -- Needed for math library
#	-lcurses  -- Needed for curses library
#	-ltermcap -- Needed for curses library
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define this macro in the main makefile for this application
# Name for the executable
PROJECT = mtank

# Define this macro in the main makefile for this application
# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Define the $(VBDDIR) macro in the main makefile for this application
# Setup path for VBD Base installation directory
# The $(VBDDIR) is defined in the include file.
include ../../../env/vbd_unix.env

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
APP_PATH = $(VBDDIR)$(PATHSEP)examples$(PATHSEP)mtank$(PATHSEP)curses
MTANK_PATH = $(VBDDIR)$(PATHSEP)examples$(PATHSEP)mtank$(PATHSEP)base
CDATE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)cdate$(PATHSEP)base
QUEUE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)queue$(PATHSEP)base
STACK_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)stack$(PATHSEP)base
RBTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)rbtree$(PATHSEP)base
BTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)btree$(PATHSEP)base
CACHE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)cache$(PATHSEP)base
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
USTRING_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ustring$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
SLLISTB_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)sllist$(PATHSEP)base
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)strutil$(PATHSEP)base
CONFIG_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)config$(PATHSEP)base
CHSLIST_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)chslist$(PATHSEP)base
POD_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)pod$(PATHSEP)base
PERSIST_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)persist$(PATHSEP)base
TIMER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)timer$(PATHSEP)base
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)placenew$(PATHSEP)base
DLLISTB_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dllist$(PATHSEP)base
TERMINAL_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)terminal$(PATHSEP)base
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)pscript$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base
ASPRINT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)asprint$(PATHSEP)base

ADD_INC_PATHS = -I$(EHANDLER_PATH) -I$(DTYPES_PATH) -I$(USTRING_PATH) \
-I$(VBDFILE_PATH) -I$(REFCOUNT_PATH) -I$(BTREE_PATH) -I$(SLLISTB_PATH) \
-I$(MTANK_PATH) -I$(STRUTIL_PATH) -I$(CONFIG_PATH) -I$(CHSLIST_PATH) \
-I$(POD_PATH) -I$(PERSIST_PATH) -I$(TIMER_PATH) -I$(CACHE_PATH) \
-I$(PLACENEW_PATH) -I$(DLLISTB_PATH) -I$(QUEUE_PATH) -I$(STACK_PATH) \
-I$(RBTREE_PATH) -I$(TERMINAL_PATH) -I$(DBCONFIG_PATH) -I$(APP_PATH) \
-I$(PSCRIPT_PATH) -I$(CDATE_PATH) -I$(CRC32_PATH) -I$(ASPRINT_PATH)

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ \
-D__CURSES__ -D__USE_VBDREFCOUNT__ -D__UNIX__ \
$(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld    # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= +DAportable +eh +a1 -pta $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LINK_FLAGS = -lcurses -ltermcap -lm

# Build dependency rules
# ===============================================================
VBDSTATS_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(TERMINAL_PATH)$(PATHSEP)terminal.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.hpp

CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

BUCKET_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CACHE_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CACHEB_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CHPTRB_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

MNODE_DEP = $(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

ENTRYKEY_DEP = $(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp 

BTREE_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

POD_DEP = $(POD_PATH)$(PATHSEP)pod.hpp \
	$(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

PERSIST_DEP = $(POD_PATH)$(PATHSEP)pod.hpp \
	$(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(PERSIST_PATH)$(PATHSEP)persist.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(TERMINAL_PATH)$(PATHSEP)terminal.hpp

VBDFILE_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

INT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

VBDREF_DEP = $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp

USTRING_DEP = $(USTRING_PATH)$(PATHSEP)ustring.hpp


SLLISTB_DEP = $(SLLISTB_PATH)$(PATHSEP)sllistb.hpp

MTANK_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(MTANK_PATH)$(PATHSEP)mtank.hpp \
	$(DTYPES_PATH)$(PATHSEP)float64.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(PERSIST_PATH)$(PATHSEP)persist.hpp \
	$(POD_PATH)$(PATHSEP)pod.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint16.hpp \
	$(CDATE_PATH)$(PATHSEP)cdate.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

ASPRINT_DEP = $(ASPRINT_PATH)$(PATHSEP)asprint.hpp

FLOAT64_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)float64.hpp

MAIN_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(MTANK_PATH)$(PATHSEP)mtank.hpp \
	$(DTYPES_PATH)$(PATHSEP)float64.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(PERSIST_PATH)$(PATHSEP)persist.hpp \
	$(POD_PATH)$(PATHSEP)pod.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(CHSLIST_PATH)$(PATHSEP)chslist.hpp \
	$(CONFIG_PATH)$(PATHSEP)config.hpp \
	$(TIMER_PATH)$(PATHSEP)timer.hpp \
	$(MTANK_PATH)$(PATHSEP)version.hpp \
	$(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(ASPRINT_PATH)$(PATHSEP)asprint.hpp \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.hpp \
	$(DLLISTB_PATH)$(PATHSEP)dllist.hpp \
	$(BTREE_PATH)$(PATHSEP)btwalk.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtree.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp \
	$(MTANK_PATH)$(PATHSEP)dbconfig.hpp \
	$(MTANK_PATH)$(PATHSEP)mtank_sh.hpp  \
	$(DTYPES_PATH)$(PATHSEP)uint16.hpp \
	$(CDATE_PATH)$(PATHSEP)cdate.hpp \
	$(TERMINAL_PATH)$(PATHSEP)terminal.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.hpp

TERMINAL_DEP = $(TERMINAL_PATH)$(PATHSEP)terminal.hpp

MTANK_SH_DEP = $(MTANK_PATH)$(PATHSEP)mtank.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)float64.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(PERSIST_PATH)$(PATHSEP)persist.hpp \
	$(POD_PATH)$(PATHSEP)pod.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.hpp \
	$(DLLISTB_PATH)$(PATHSEP)dllist.hpp \
	$(BTREE_PATH)$(PATHSEP)btwalk.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtree.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint16.hpp \
	$(CDATE_PATH)$(PATHSEP)cdate.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CONFIG_DEP = $(CHSLIST_PATH)$(PATHSEP)chslist.hpp \
	$(CONFIG_PATH)$(PATHSEP)config.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp

STRUTIL_DEP = $(STRUTIL_PATH)$(PATHSEP)strutil.hpp 

DLLISTB_DEP = $(DLLISTB_PATH)$(PATHSEP)dllistb.hpp

CHSLIST_DEP = $(CHSLIST_PATH)$(PATHSEP)chslist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp

BTWALK_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btwalk.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

BNODEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp

BSTREEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp 

RBTREEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtree.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp

TWALK_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp

PSCRIPT_DEP = $(PSCRIPT_PATH)$(PATHSEP)pscript.hpp

CDATE_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(CDATE_PATH)$(PATHSEP)cdate.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint16.hpp

UINT16_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint16.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bnodeb.o:	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp

bstreeb.o:	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp

rbtreeb.o:	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp

twalk.o:	$(RBTREE_PATH)$(PATHSEP)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(RBTREE_PATH)$(PATHSEP)twalk.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

main.o:	$(APP_PATH)$(PATHSEP)main.cpp $(MAIN_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(APP_PATH)$(PATHSEP)main.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

sllistb.o:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

dllistb.o:	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DLLISTB_PATH)$(PATHSEP)dllistb.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

pod.o:	$(POD_PATH)$(PATHSEP)pod.cpp $(POD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(POD_PATH)$(PATHSEP)pod.cpp

persist.o:	$(PERSIST_PATH)$(PATHSEP)persist.cpp $(PERSIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PERSIST_PATH)$(PATHSEP)persist.cpp

mtank.o:	$(MTANK_PATH)$(PATHSEP)mtank.cpp $(MTANK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(MTANK_PATH)$(PATHSEP)mtank.cpp

chslist.o:	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CHSLIST_PATH)$(PATHSEP)chslist.cpp

config.o:	$(CONFIG_PATH)$(PATHSEP)config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CONFIG_PATH)$(PATHSEP)config.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

asprint.o:	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp $(ASPRINT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(ASPRINT_PATH)$(PATHSEP)asprint.cpp

mtank_sh.o:	$(MTANK_PATH)$(PATHSEP)mtank_sh.cpp $(MTANK_SH_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(MTANK_PATH)$(PATHSEP)mtank_sh.cpp

btwalk.o:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

float64.o:	$(DTYPES_PATH)$(PATHSEP)float64.cpp $(FLOAT64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)float64.cpp

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

cdate.o:	$(CDATE_PATH)$(PATHSEP)cdate.cpp $(CDATE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CDATE_PATH)$(PATHSEP)cdate.cpp

uint16.o:	$(DTYPES_PATH)$(PATHSEP)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint16.cpp

terminal.o:	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp $(TERMINAL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(TERMINAL_PATH)$(PATHSEP)terminal.cpp

# Make the executable
OBJECTS = ehandler.o int32.o vbdfile.o asprint.o persist.o \
	ustring.o pod.o sllistb.o chslist.o config.o vbdref.o \
	cacheb.o chptrb.o btree.o mnode.o bucket.o cache.o \
	entrykey.o dllistb.o pscript.o strutil.o btwalk.o \
	bnodeb.o bstreeb.o rbtreeb.o twalk.o float64.o cdate.o \
	uint16.o mtank.o mtank_sh.o uint32.o crc32.o \
	terminal.o main.o vbdstats.o

$(PROJECT):	$(OBJECTS)
	$(CPP) $(COMPILE_FLAGS) $(OBJECTS) $(OUTPUT) \
	$(PROJECT) $(LINK_FLAGS)
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing the EXECUTABLE file from working directory
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
