// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: winmain.hpp
// C++ Compiler Used: MSVC40, HPUX CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/16/1997 
// Date Last Modified: 11/04/1998 
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

This is a test program used to test the (P)ersistent base class
in a practical database application using the wxWindow GUI
library version 1.68
*/
// ----------------------------------------------------------- //
#ifndef __WINMAIN_HPP__
#define __WINMAIN_HPP__

#include "mtank.hpp"
#include "config.hpp"
#include "timer.hpp"
#include "version.hpp"
#include "mtank_sh.hpp"
#include "pscript.hpp"

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx_prec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx.h"
#endif

// Define this macro to use the wxWindows printing features under
// Microsoft Windows. A separate PostScript driver is provided for
// UNIX system. Define this macro for UNIX compiles to enable MSW
// style printing in motif using wxWindow 1.68B.
// #ifndef __USE_MSW_PRINTING__
// #define __USE_MSW_PRINTING__
// #endif

#ifdef __USE_MSW_PRINTING__
// Setup wxWindows printing for MSW
#if !USE_PRINTING_ARCHITECTURE
#error You must set USE_PRINTING_ARCHITECTURE to 1 in wx_setup.h to compile 
#endif

#include "wx_mf.h"
#include "wx_print.h"
#endif // __USE_MSW_PRINTING__

// Define new frame types for wxWindow frames and sub-frames
class MyFrame;       // Main window frame
class MyTextWindow;  // Text windos frames
class MyText;        // Class used to encapsulate wxText objects

// Define configurable parameters
int CacheSize = 15;  // Memory cache size for the index file
int AdminRights = 0; // Define user privileges 

// Define file access modes used in the application
VBDFile::AccessMode RWMode = VBDFile::READWRITE;
VBDFile::AccessMode ROMode = VBDFile::READONLY;

// Function prototypes for wxWindows controls
void AddBtnProc(wxButton& but, wxCommandEvent& event);
void ClearAddPanel();
void ChBtnProc(wxButton& but, wxCommandEvent& event);
void ClearChangePanel();
void DsBtnProc(wxButton& but, wxCommandEvent& event);
void ClearDisplayPanel();
void text_proc(wxText &but, wxCommandEvent &event);

#ifdef __USE_MSW_PRINTING__
void  page_btn_proc(wxButton& but, wxCommandEvent& event);
#endif // __USE_MSW_PRINTING__

// File menu functions
void ExportToASCII(MyTextWindow &textWin);
void ImportFromASCII(MyTextWindow &textWin);
void BackUp(MyTextWindow &textWin);
void Merge(MyTextWindow &textWin);
void CreateTemplate(MyTextWindow &textWin);
void CompareIndexFile(MyTextWindow &textWin);
void RebuildIndexFile(MyTextWindow &textWin);

// Database menu functions
void Add(MyTextWindow &textWin);
void Change(MyTextWindow &textWin);
void DisplayDB(MyTextWindow &textWin); 
void SetPurchasing(MyTextWindow &textWin, char purchasing);

// Find menu functions
void FindBy(MyTextWindow &textWin, const char *MemberName, MTankDBItem item);

// Print menu functions
void ASCIIPrintAll(MyTextWindow &textWin); 
void PostScriptPrint(MyTextWindow & textWin);

// View menu functions
void Clear(MyTextWindow &textWin);

// Function prototypes for non-menu functions
int LoadIndexKeys(int build_new_tree = 1, int clear_tree = 1);
void AnalyzeWaterTest(MyTextWindow &textWin, MarineTank &mtank);
void ExportPrintwxMultiText(char *str, ofstream &stream);
char *ImportFormatwxMultiText(char *str);
void DisplayObject(MarineTank &mtank);
void PrintItemBar(ofstream &stream);
void PrintLineByLine(MarineTank &mtank, ofstream &stream);
void PostScriptPrintTotals(MyTextWindow &textWin, ofstream &stream,
			   PostScriptDrv &psdrv);
int PrintPSItemBar(ofstream &stream, PostScriptDrv &psdrv,
		    int x_offset, int char_offset, int max_len);

// Search functions
void MTankDBSearch(MarineTank &mtank, MTankDBItem item, UString &str,
		  MyTextWindow &textWin, const char *wildcard = 0);

// Version number for this windows program 
char *VerNumber();

// Control key macro used for wxWindows key events
#define CONTROL(c) ((c) & 037)

// Identification for the all wxWindows main menu functions
enum MainMenu {
  // File menu constants
  FILE_QUIT = 1,
  FILE_VBDSTATS,
  FILE_EXPORT,
  FILE_IMPORT,
  FILE_BACKUP,
  FILE_MERGE,
  FILE_TEMPLATE,
  FILE_COMPARE_INDEX,
  FILE_REBUILD_INDEX,
  
  // Edit menu constants
  EDIT_CUT,   
  EDIT_COPY,  
  EDIT_PASTE, 

  // Database menu constants
  DB_DISPLAY,
  DB_ADD,
  DB_CHANGE,
  
  // Find menu constants
  FIND_BY_YEAR,
  FIND_BY_COMMENTS,
  
  // Print menu constants
  WXPRINT_PRINT,
  WXPRINT_PRINTER_SETUP,
  WXPRINT_PREVIEW,
  WXPRINT_PAGE_SETUP,
  PRINT_POSTSCRIPT,
  PRINT_ASCII,
  
  // View menu constants
  VIEW_CLEAR,

  // Help menu constants
  HELP_ABOUT,
  HELP_USERLEVEL
};

// Define control button tags for wxWindow panel buttons
#define ADD_BUTTON_ADD     1
#define ADD_BUTTON_CANCEL  2
#define ADD_BUTTON_CLOSE   3
#define ADD_BUTTON_REVERT  4

#define CHANGE_BUTTON_CM     11
#define CHANGE_BUTTON_CANCEL 12
#define CHANGE_BUTTON_CLOSE  13
#define CHANGE_BUTTON_REVERT 14
#define CHANGE_BUTTON_SH     15

#define DISPLAY_BUTTON_NX     21
#define DISPLAY_BUTTON_PREV   22
#define DISPLAY_BUTTON_CHANGE 23
#define DISPLAY_BUTTON_CLOSE  24
#define DISPLAY_BUTTON_REMOVE 25
#define DISPLAY_BUTTON_ANALYZE 26

#ifdef __USE_MSW_PRINTING__
#define PAGE_DIALOG_BUTTON_CLOSE   400
#define PAGE_DIALOG_BUTTON_ACCEPT  401
#define PAGE_DIALOG_BUTTON_CANCEL  402
#define PAGE_DIALOG_BUTTON_DEFAULT 403
#endif // __USE_MSW_PRINTING__


// Define a new text subwindow that can respond to drag-and-drop
class MyTextWindow: public wxTextWindow
{
public:
  MyTextWindow(wxFrame *frame, int x=-1, int y=-1, int width=-1, int height=-1,
               long style=0):
    wxTextWindow(frame, x, y, width, height, style) { DragAcceptFiles(TRUE); }

public:
  void OnDropFiles(int n, char *files[], int x, int y) { LoadFile(files[0]); }
  void OnChar(wxKeyEvent& event);
};

// Define a new application type
class MyApp: public wxApp
{
public:
  MyApp();
  wxFrame *OnInit();
};

// Define a new frame type
class MyFrame: public wxFrame
{
public:
  MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);

public:
  void OnMenuCommand(int id);
  void OnSize(int w, int h);
  Bool OnClose();
  void OnActivate(Bool active) { }
  
public:
  MyTextWindow *textWin;  // Text window for main frame
  wxPanel *apanel;        // Panel for adding objects
  wxPanel *cpanel;        // Panel for changing object
  wxPanel *dpanel;        // Panel for display objects
  MyText *addText;        // wxText object used for the apanel
  MyText *changeText;     // wxText object used for the cpanel
  MyText *displayText;    // wxText object used for the dpanel
};

class MyText: public wxText
{
public:
  MyText(wxPanel *parent, wxFunction func, char *label, char *value = "",
	    int x = -1, int y = -1, int width = -1, int height = -1,
	    long style = 0, char *name = "text");

  MyText() {
    Month = Day = Year = SG = PH = Ammonia = Nitrate = Nitrite = 0;
    Comments = 0;
  }
  ~MyText();
  
public:
  wxText *Month;
  wxText *Day;
  wxText *Year;
  wxText *SG;
  wxText *PH;
  wxText *Ammonia;
  wxText *Nitrate;
  wxText *Nitrite;
  wxMultiText *Comments;
};

// Setup wxWindows printing for MSW
#ifdef __USE_MSW_PRINTING__

// wxWindows MSW Printer defaults
// NOTE: Left/Right and Top/Bottom magrins are in logical units (20 per inch). 
const int mswpLINES_PER_PAGE = 46;    // Default lines per page
const int mswpCELL_LENGTH = 21;       // Default cell length for spacing
const int mswpFONT_SIZE = 9;          // Default font size
const int mswpLR_MARGINS = 20;        // Default for left/right margins
const int mswpORIENTATION = 1;        // Default to portrait
const int mswpFONT = 0;               // Default font code: 0 = wxSWISS
const int mswpTB_MARGINS = 20;        // Default for 1" top/bottom margins
const int mswpLINE_WIDTH = 2;         // Line width for separator lines
const int mswpPRINTABLE_OFFSET_X = 5; // Printable page area x offset
const int mswpPRINTABLE_OFFSET_Y = 5; // Printable page area y offset

// Data structure use to hold various parameters for MSW printing
struct MSWPrintingParameters
{
  MSWPrintingParameters() {
    // Set current print settings using the mswp defaults
    lines_per_page = mswpLINES_PER_PAGE; 
    cell_length = mswpCELL_LENGTH;    
    font_size = mswpFONT_SIZE;   
    orientation = mswpORIENTATION;
    font = mswpFONT;        
    lr_margin = mswpLR_MARGINS;  
    tb_margin = mswpTB_MARGINS; 
    
    // Set previous print setting
    prev_lines_per_page = lines_per_page;
    prev_cell_length = cell_length;
    prev_font_size = font_size;
    prev_orientation = orientation;
    prev_font = font;
    prev_lr_margin = lr_margin;
    prev_tb_margin = tb_margin;
    
    // Set default print setting
    default_lines_per_page = lines_per_page;
    default_cell_length = cell_length;
    default_font_size = font_size;
    default_orientation = orientation;
    default_font = font;
    default_lr_margin = lr_margin;
    default_tb_margin = tb_margin;
  }    

  // Current print settings
  int lines_per_page; // Number of line per page
  int cell_length;    // Spacing between the object's data
  int font_size;      // Font or point size fot the object's data
  int orientation;    // 0 == Landscape, 1 == Portrait
  float lr_margin;    // Left and right magrin in logical units (20 per inch) 
  float tb_margin;    // Top and bottom magrin in logical units (20 per inch)
  int font;           // Font codes must match FontChoiceStrings array:
                      // 0 = wxSWISS
                      // 1 = wxROMAN
                      // 2 = wxDECORATIVE
                      // 3 = wxMODERN 
                      // 4 = wxSCRIPT
                      // 5 = wxDEFAULT
  
  // Previous print setting
  int prev_lines_per_page;
  int prev_cell_length;
  int prev_font_size;
  int prev_orientation;
  float prev_lr_margin;
  float prev_tb_margin;
  int prev_font;
  
  int default_lines_per_page;
  int default_cell_length;
  int default_font_size;
  int default_orientation;
  float default_lr_margin;
  float default_tb_margin;
  int default_font;
};

// Declare a global printer page setup for MSW printing
extern MSWPrintingParameters MSWPrnPars;
extern MSWPrintingParameters *MSWPrintSetup;

// (w)xWindows (S)tring (D)atabase (P)rinting class
class wMTankPrint: public wxPrintout
{
public:
  wMTankPrint(char *title):wxPrintout(title) { }

public: // Override virtual functions in base class 
  Bool OnPrintPage(int page);
  Bool HasPage(int page);
  Bool OnBeginDocument(int startPage, int endPage);
  void OnPreparePrinting();
  void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom,
		   int *selPageTo);

public: 
  void SetFont(int style = wxNORMAL, int weight = wxNORMAL);
  void SetHeaderFont(int size, int font, int style, int weight);
  void SetItemBarFont(int style = wxITALIC, int weight = wxBOLD);
  void ScaleDC(wxDC *dc);
  void PrintText(wxDC *dc, char *s, int max_len, float xpos, float ypos);
  void PrintText(wxDC *dc, char *s, float xpos, float ypos);
  void PrintText(wxDC *dc, char c, float xpos, float ypos);  
  void PrintText(wxDC *dc, int i, float xpos, float ypos);
  void PrintText(wxDC *dc, int i, int max_len, float xpos, float ypos);
  void PrintText(wxDC *dc, long i, float xpos, float ypos);
  void PrintText(wxDC *dc, long i,  int max_len, float xpos, float ypos);
  void PrintText(wxDC *dc, double i, float xpos, float ypos);
  void PrintText(wxDC *dc, double i, int max_len, float xpos, float ypos);
  void PrintText(wxDC *dc, float i, float xpos, float ypos);
  void PrintText(wxDC *dc, float i, int max_len, float xpos, float ypos);
  void DrawTextPage(wxDC *dc, int page);
  void WritePageHeader(wxDC *dc, char *doc_name, char *doc_date = 0);
  void WritePageNumber(wxDC *dc, int pagenum);

private: // Font dependent members
  wxFont *printerFont; // Text font for object's data
  wxFont *itembarFont; // Text font for the item bar
  wxFont *headerFont;  // Text font for page header and page numbers
  float char_width;    // Width of each character based on the font type

private: // Page dependent members
  int page_width;  // Page width in millimetres
  int page_height; // Page height in millimetres
  int last_page;   // Last page in this document
  float start_x;   // Starting x position 
  float start_y;   // Starting y position 

private: // Device Context/Page scaling members
  float logUnitsFactor; // Factor for converting millimetres to logical units
  float scale;          // Factor for printout/screen scaling.
  int ppiScreenX;       // Logical pixels per inch of screen
  int ppiScreenY;       // Logical pixels per inch of screen
  int ppiPrinterX;      // Logical pixels per inch of screen
  int ppiPrinterY;      // Logical pixels per inch of screen
};

#endif // __USE_MSW_PRINTING__

#endif // __WINMAIN_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
