#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the WX windows program
# C/C++ Compiler Used: HP C++ A.10.24 compiled for HP-UX 10.20 
# Produced By: Doug Gaer
# File Creation Date: 12/16/1997 
# Date Last Modified: 10/06/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
#
# To get the current compiler version number enter the 
# following command:
# 
# 	% what /opt/CC/bin/CC
#
# NOTE: Edit the unix.env path to change the path setting
# for the wxWindows GUI library installation path
# ---------------------------------------------------------------

# Set the wxWindows GUI library installation path marco
include ../../../env/wx_unix.env

# All common UNIX compiler flags and options are now in
# this central makefile.
include $(WXDIR)/src/make.env

# Setup path for VBD Base installation directory
# The $(VBDDIR) is defined in the include file.
include ../../../env/vbd_unix.env

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
USTRING_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ustring$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base

ADD_INC_PATHS = -I$(EHANDLER_PATH) -I$(DTYPES_PATH) -I$(USTRING_PATH) \
-I$(VBDFILE_PATH) -I$(REFCOUNT_PATH) -I$(CRC32_PATH)

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Setup define macros
DEFMACS = -D__wxWINDOWS__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define a name for the executable
PROJECT = testprog

# Define macros for compiler and linker
AC     = cc   # ANSI c compiler
CPP    = CC   # C++ compiler
LINKER = ld   # Linker

# Define compiler and linker flags macros
COMPILE_FLAGS= $(CPPFLAGS) $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LINK_FLAGS = $(LDFLAGS) 
LINK_LIBS = $(MOTIFLDLIBS)

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp 

VBDFILE_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

INT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

TESTPROG_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

USTRING_DEP = $(USTRING_PATH)$(PATHSEP)ustring.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

vbdfile.o:	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) testprog.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

# Make the executable
OBJECTS = ehandler.o vbdfile.o testprog.o ustring.o \
	int32.o crc32.o uint32.o

$(PROJECT):	$(OBJECTS) $(WXLIB)
	$(CPP) $(COMPILE_FLAGS) $(OBJECTS) $(OUTPUT) $(PROJECT) \
	$(LINK_FLAGS) $(LINK_LIBS) 
# ===============================================================
# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
