// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 02/04/1997  
// Date Last Modified: 10/15/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the VBDFile class used to read and
write user defined strings to a file.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include "ustring.hpp"
#include "vbdfile.hpp"
#include "vbdstats.hpp"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  VBDFilePtr f(new VBDFile);   // Should always create dynamically
  const char *FName = "strtst.vbd";

  if(!VBDFile::Exists(FName)) {
    cout << "Creating new file..." << endl;
    f->Create(FName);
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(FName);
  }
  
  pause();
  VBDStats(f);
  pause();
  
  UString str("The quick brown fox jumps over the lazy dog 0123456789");
  cout << "Adding string object to VBD file..." << endl;
  cout << "String length = " << strlen(str.c_str()) << endl;

  // Allocate room for the string
  FAU addr = f->Alloc(str.length());
  if(addr)
    f->Write(str.c_str(), str.length());
  else
    cout << "Could not allocate space for string" << endl;

  VBStats(f, addr);
  pause();
  
  cout << "Closing and re-opening file..." << endl; 
  f->Open(FName); // Open() closes first

  pause();
  VBDStats(f);
  pause();
  
  cout << "Reading back the string object from the VBD file..." << endl;
  UString buf;
  unsigned len = f->ObjectLength(addr);
  char *s = new char[len];
  
  f->Read(s, len, addr);
  s[len] = '\0';
  buf = s;
  delete s;
  cout << "String = " << buf << endl;

  pause();
  cout << "Deleting string object..." << endl;
  if(!f->Delete(addr)) cout << "Object was not deleted" << endl;
 
  cout << "Undeleting string object..." << endl;
  if(!f->UnDelete(addr)) cout << "Could not undelete" << endl;

  cout << "Removing the string object..." << endl;
  if(!f->Remove(addr)) cout << "Object was not deleted" << endl;

  cout << "Trying undelete after a remove..." << endl;
  if(!f->UnDelete(addr)) cout << "Could not undelete" << endl;

  pause();

  UString alp("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
  UString num("012345678901");

  cout << "Testing reclaim function after a remove..." << endl;
  cout << "Adding two new string objects to the VBD file" << endl;
  cout << "that will occupy the same space as the removed string" << endl;
  addr = f->Alloc(alp.length());
  f->Write(alp.c_str(), alp.length());
  addr = f->Alloc(num.length());
  f->Write(num.c_str(), num.length());

  pause();
  VBDStats(f);
  pause();
  
  cout << "Testing ReAlloc function..." << endl;
  cout << "Adding another string object to VBD file..." << endl;
  cout << "String length = " << strlen(str.c_str()) << endl;

  addr = f->Alloc(str.length());
  f->Write(str.c_str(), str.length());
  
  cout << "Reallocating space for string object..." << endl;
  str = str + alp;
  cout << "String length = " << strlen(str.c_str()) << endl;
  addr = f->ReAlloc(addr, str.length());
  if(addr)
    f->Write(str.c_str(), str.length());
  else
    cout << "Could not reallocate space for string" << endl;

  pause();
  VBDStats(f);
  pause();
  
  cout << "Closing file and re-creating it..." << endl;
  f->Close();
  f->Create(FName);
  
  cout << "Adding 9 three byte string objects to the new VBD file..." << endl;
  
  UString aa("DOG");
  UString bb("CAT");
  UString cc("COW");
  UString dd("BAT");
  UString ee("ANT");
  UString ff("BUG");
  UString gg("HOG");
  UString hh("PIG");
  UString ii("HEN");

  addr = f->Alloc(aa.length());
  f->Write(aa.c_str(), aa.length());
  addr = f->Alloc(bb.length());
  f->Write(bb.c_str(), bb.length());
  addr = f->Alloc(cc.length());
  f->Write(cc.c_str(), cc.length());
  addr = f->Alloc(dd.length());
  f->Write(dd.c_str(), dd.length());
  addr = f->Alloc(ee.length());
  f->Write(ee.c_str(), ee.length());
  addr = f->Alloc(ff.length());
  f->Write(ff.c_str(), ff.length());
  addr = f->Alloc(gg.length());
  f->Write(gg.c_str(), gg.length());
  addr = f->Alloc(hh.length());
  f->Write(hh.c_str(), hh.length());
  addr = f->Alloc(ii.length());
  f->Write(ii.c_str(), ii.length());

  pause();
  VBDStats(f);
  pause();
  
  cout << "Testing Variable Block find functions..." << endl;

  FAU vb = f->FindFirstVB();
  FAU obj = f->FindFirstObject();
  if(vb) cout << "First VB address =       " << vb << endl;
  if(obj) cout << "First Object's address = " << obj << endl;
  VBStats(f, obj); // VBStats starts at object address

  pause();

  vb = f->FindNextVB(vb);
  obj = f->FindNextObject(vb);
  if(vb) cout << "Next VB address =        " << vb << endl;
  if(obj) cout << "Next Object's address =  " << obj << endl;
  VBStats(f, obj); // VBStats() starts at object address

  cout << endl;
  cout << "Closing file automatically using VBDFile destructor..." << endl;
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
