#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the ASCII to PostScript converter program.
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 12/17/1997  
# Date Last Modified: 05/04/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v                   -- Echo compilation
#       g                   -- Enable debugging
#       Wall                -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = as2ps

# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Setup path for VBD Base installation directory
VBDDIR = ../../../../vbdbase

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2PS_PATH = $(VBDDIR)$(PATHSEP)utils$(PATHSEP)as2ps$(PATHSEP)console
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)pscript$(PATHSEP)base

ADD_INC_PATHS = -I$(PSCRIPT_PATH)

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = gcc
CPP = g++
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
PSCRIPT_DEP = $(PSCRIPT_PATH)$(PATHSEP)pscript.hpp 

AS2PS_DEP = $(PSCRIPT_PATH)$(PATHSEP)pscript.hpp \
	$(AS2PS_PATH)$(PATHSEP)as2ps.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

as2ps.o:	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp $(AS2PS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp

# Make the executable
OBJS = pscript.o as2ps.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
