# --------------------------------------------------------------- 
# Makefile Contents: Make file for the ASCII to PostScript converter program.
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      
# File Creation Date: 12/17/1997  
# Date Last Modified: 05/12/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v    -- Echo compilation
#       g    -- Enable debugging
#	+w   -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# Linker flags 
#	-lm -- Needed for math library
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = as2ps

# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Setup path for VBD Base installation directory
VBDDIR = ../../../../vbdbase

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
AS2PS_PATH = $(VBDDIR)$(PATHSEP)utils$(PATHSEP)as2ps$(PATHSEP)console
PSCRIPT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)pscript$(PATHSEP)base

ADD_INC_PATHS = -I$(PSCRIPT_PATH)

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= +eh +a1 +DAportable $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS = -lm

# Build dependency rules
# ===============================================================
PSCRIPT_DEP = $(PSCRIPT_PATH)$(PATHSEP)pscript.hpp 

AS2PS_DEP = $(PSCRIPT_PATH)$(PATHSEP)pscript.hpp \
	$(AS2PS_PATH)$(PATHSEP)as2ps.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

pscript.o:	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp $(PSCRIPT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(PSCRIPT_PATH)$(PATHSEP)pscript.cpp

as2ps.o:	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp $(AS2PS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(AS2PS_PATH)$(PATHSEP)as2ps.cpp

# Make the executable
OBJS = pscript.o as2ps.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(LFLAGS)
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
