# --------------------------------------------------------------- 
# Makefile Contents: Make file for the hexdump program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      
# File Creation Date: 02/13/1996 
# Date Last Modified: 11/06/1998
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v    -- Echo compilation
#       g    -- Enable debugging
#	+w   -- Turn on all warnings
#       +eh  -- Enable C++ exception handling
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#
#	+DAportable -- Generate code compatible across PA-RISC 1.1 
#	and 2.0 HP workstations and servers, use the option.  
#
#	+DSmodel --  Use the instruction scheduler tuned to the model
#	specified. model can be a model number, PA-RISC architecture 
#	designation or PA-RISC processor name. See the file:
#	/opt/langtools/lib/sched.models for a list of model numbers and 
#	processor names.  
#
#	+Oopt --  Invoke optimizations selected by opt. Defined values 
#	for opt are:
#
#	0    Perform minimal optimizations.  
#	1    Perform optimizations within basic blocks only.
#	2    Perform level 1 and global optimizations. Same as -O.
#	3    Perform level 2 as well as interprocedural global opts.
#	4    Perform level 3 as well as doing link time optimizations.
#	Also sends +Oprocelim and +Ofastaccess to the linker.
#
# Linker flags 
#	-lm -- Needed for math library
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = hexdump

# Setup path for VBD Base installation directory
VBDDIR = ../../../../vbdbase

# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
HEXDUMP_PATH = $(VBDDIR)$(PATHSEP)utils$(PATHSEP)hexdump$(PATHSEP)console
HXCRC_PATH = $(VBDDIR)$(PATHSEP)utils$(PATHSEP)hexdump$(PATHSEP)console

ADD_INC_PATHS = -I$(HEXDUMP_PATH) -I$(HXCRC_PATH)

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= +eh +a1 +DAportable $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS = -lm

# Build dependency rules
# ===============================================================
HEXDUMP_DEP = $(HXCRC_PATH)$(PATHSEP)hxcrc.hpp

HXCRC_DEP = $(HXCRC_PATH)$(PATHSEP)hxcrc.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

hexdump.o:	$(HEXDUMP_PATH)$(PATHSEP)hexdump.cpp $(HEXDUMP_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HEXDUMP_PATH)$(PATHSEP)hexdump.cpp

hxcrc.o:	$(HXCRC_PATH)$(PATHSEP)hxcrc.cpp $(HXCRC_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(HXCRC_PATH)$(PATHSEP)hxcrc.cpp

# Make the executable
OBJS = hexdump.o hxcrc.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(LFLAGS)
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
