// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: hxcrc.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 08/17/1998 
// Date Last Modified: 08/31/1998
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The CRC Class (Cyclic Redundancy Check) is used to calculate a
sophisticated checksum based on the algebra of polynomials over
the integers (mod 2). The Cyclic Redundancy Check, is a way to
detect bit errors that occur during data storage or transmission.
The CRC algorithm operates on a block of data as a single large
numerical value. The algorithm divides this large value by the
CRC polynomial or generator polynomial, leaving the remainder,
which is the CRC result. 
*/
// ----------------------------------------------------------- //   
#ifndef __HXCRC_HPP__
#define __HXCRC_HPP__

#include <fstream.h>

// (C)yclic (R)edundancy (C)heck Class
class hxCRC
{
public:
  hxCRC();
  ~hxCRC() { }
  
public:
  void crc32init();
  void crc16init();
  void crc16CCITTinit();
  
  unsigned long calcCRC32(fstream &infile);
  
  // mode 1 = XModem/Zmodem/Arc/Hpack/LZH    
  // mode 0 = CCITT CRC-16, AX.25 Europan    
  unsigned short calcCRC16(fstream &infile, int mode = 1);
  
public:
  unsigned long crc32tab[256];    // CRC-32 table
  unsigned short crc16tab[256];   // CRC-16 table 
  unsigned short crc16CCITT[256]; // CCITT CRC-16 table
};

#endif  // __HXCRC_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
