#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Make file for the VBD utility program
# C/C++ Compiler Used: GNU gcc g++ 2.7.2.1 
# Produced By: Doug Gaer       
# File Creation Date: 04/14/1997 
# Date Last Modified: 10/15/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = ix_debug

# Installation directory for the application and config files
INSTALL_DIR = ../bin

# Setup path for VBD Base installation directory
VBDDIR = ../../../../vbdbase

# Macro for path separator
PATHSEP=/

# Setup additional paths for includes and source code
IX_DEBUG_PATH = $(VBDDIR)$(PATHSEP)utils$(PATHSEP)ix_debug$(PATHSEP)console
BTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)btree$(PATHSEP)base
CACHE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)cache$(PATHSEP)base
PLACENEW_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)placenew$(PATHSEP)base
EHANDLER_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ehandler$(PATHSEP)base
DTYPES_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)dtypes$(PATHSEP)base
REFCOUNT_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)refcount$(PATHSEP)base
VBDFILE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)vbdfile$(PATHSEP)base
QUEUE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)queue$(PATHSEP)base
SLLISTB_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)sllist$(PATHSEP)base
STACK_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)stack$(PATHSEP)base
RBTREE_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)rbtree$(PATHSEP)base
USTRING_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)ustring$(PATHSEP)base
STRUTIL_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)strutil$(PATHSEP)base
CRC32_PATH = $(VBDDIR)$(PATHSEP)classes$(PATHSEP)crc32$(PATHSEP)base

ADD_INC_PATHS = -I$(EHANDLER_PATH) -I$(DTYPES_PATH) -I$(VBDFILE_PATH) \
-I$(REFCOUNT_PATH) -I$(BTREE_PATH) -I$(CACHE_PATH) -I$(PLACENEW_PATH) \
-I$(QUEUE_PATH) -I$(SLLISTB_PATH) -I$(STACK_PATH) -I$(RBTREE_PATH) \
-I$(USTRING_PATH) -I$(STRUTIL_PATH) -I$(IX_DEBUG_PATH) -I$(CRC32_PATH)

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ -D__UNIX__ 

# Enable to use the template classes
# DEFMACS = -D__CONSOLE__ -D__UNIX__

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -Wall -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDFILE_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CRC32_DEP = $(CRC32_PATH)$(PATHSEP)crc32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32tab.hpp 

UINT32_DEP =  $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp

BUCKET_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CACHE_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CACHEB_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CACSTATS_DEP = $(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

CHPTRB_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

MNODE_DEP = $(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp

ENTRYKEY_DEP = $(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp 

BTREE_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

BTREEPRT_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 

BTWALK_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp\
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp\
	$(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btwalk.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 	

EHANDLER_DEP = $(EHANDLER_PATH)$(PATHSEP)ehandler.hpp

INT32_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)$(PATHSEP)dtypes.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp \
	$(CRC32_PATH)$(PATHSEP)crc32.hpp 

VBDREF_DEP = $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp

SLLISTB_DEP = $(SLLISTB_PATH)$(PATHSEP)sllistb.hpp

USTRING_DEP = $(USTRING_PATH)$(PATHSEP)ustring.hpp

IX_DEBUG_DEP = $(CACHE_PATH)$(PATHSEP)bucket.hpp \
	$(CACHE_PATH)$(PATHSEP)bucketb.hpp \
	$(CACHE_PATH)$(PATHSEP)cache.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheb.hpp \
	$(CACHE_PATH)$(PATHSEP)chptrb.hpp \
	$(CACHE_PATH)$(PATHSEP)cacheptr.hpp \
	$(CACHE_PATH)$(PATHSEP)cactype.hpp \
	$(BTREE_PATH)$(PATHSEP)btree.hpp \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.hpp \
	$(DTYPES_PATH)$(PATHSEP)int32.hpp \
        $(VBDFILE_PATH)$(PATHSEP)vbdfile.hpp \
	$(REFCOUNT_PATH)$(PATHSEP)refcount.hpp \
	$(PLACENEW_PATH)$(PATHSEP)placenew.hpp \
	$(BTREE_PATH)$(PATHSEP)mnode.hpp \
	$(BTREE_PATH)$(PATHSEP)entrykey.hpp \
	$(BTREE_PATH)$(PATHSEP)btreeprt.hpp \
	$(CACHE_PATH)$(PATHSEP)cacstats.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtree.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp \
	$(USTRING_PATH)$(PATHSEP)ustring.hpp \
	$(STRUTIL_PATH)$(PATHSEP)strutil.hpp \
	$(BTREE_PATH)$(PATHSEP)btwalk.hpp \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.hpp \
	$(DTYPES_PATH)$(PATHSEP)uint32.hpp 
 
BNODEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp

BSTREEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp 

RBTREEB_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtree.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp

TWALK_DEP = $(RBTREE_PATH)$(PATHSEP)bnode.hpp \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.hpp \
	$(QUEUE_PATH)$(PATHSEP)queue.hpp \
	$(RBTREE_PATH)$(PATHSEP)rbnode.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllist.hpp \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.hpp \
	$(STACK_PATH)$(PATHSEP)stack.hpp \
	$(RBTREE_PATH)$(PATHSEP)twalk.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

vbdstats.o:	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)$(PATHSEP)uint32.cpp $(UINT31_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)uint32.cpp

crc32.o:	$(CRC32_PATH)$(PATHSEP)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CRC32_PATH)$(PATHSEP)crc32.cpp

bucket.o:	$(CACHE_PATH)$(PATHSEP)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)bucket.cpp

cache.o:	$(CACHE_PATH)$(PATHSEP)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cache.cpp

cacheb.o:	$(CACHE_PATH)$(PATHSEP)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacheb.cpp

chptrb.o:	$(CACHE_PATH)$(PATHSEP)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)chptrb.cpp

cacstats.o:	$(CACHE_PATH)$(PATHSEP)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(CACHE_PATH)$(PATHSEP)cacstats.cpp

mnode.o:	$(BTREE_PATH)$(PATHSEP)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)mnode.cpp

entrykey.o:	$(BTREE_PATH)$(PATHSEP)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)entrykey.cpp

btreeprt.o:	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btreeprt.cpp

btwalk.o:	$(BTREE_PATH)$(PATHSEP)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btwalk.cpp

btree.o:	$(BTREE_PATH)$(PATHSEP)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(BTREE_PATH)$(PATHSEP)btree.cpp

ehandler.o:	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(EHANDLER_PATH)$(PATHSEP)ehandler.cpp

int32.o:	$(DTYPES_PATH)$(PATHSEP)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(DTYPES_PATH)$(PATHSEP)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)$(PATHSEP)vbdref.cpp

sllistb.o:	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(SLLISTB_PATH)$(PATHSEP)sllistb.cpp

ix_debug.o:	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp $(IX_DEBUG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(IX_DEBUG_PATH)$(PATHSEP)ix_debug.cpp

bnodeb.o:	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp $(BNODEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bnodeb.cpp

bstreeb.o:	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp $(BSTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(RBTREE_PATH)$(PATHSEP)bstreeb.cpp

rbtreeb.o:	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp $(RBTREEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(RBTREE_PATH)$(PATHSEP)rbtreeb.cpp

twalk.o:	$(RBTREE_PATH)$(PATHSEP)twalk.cpp $(TWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(RBTREE_PATH)$(PATHSEP)twalk.cpp

ustring.o:	$(USTRING_PATH)$(PATHSEP)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(USTRING_PATH)$(PATHSEP)ustring.cpp

strutil.o:	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(STRUTIL_PATH)$(PATHSEP)strutil.cpp

# Make the executable
OBJS = cacheb.o chptrb.o btree.o ehandler.o vbdfile.o \
	ix_debug.o mnode.o int32.o bucket.o cache.o \
	vbdref.o entrykey.o btreeprt.o cacstats.o \
	sllistb.o bnodeb.o bstreeb.o rbtreeb.o twalk.o \
	ustring.o btwalk.o strutil.o uint32.o crc32.o \
	vbdstats.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Install the binaries and config files to the bin directory
# ===============================================================
install:
	echo Installing $(PROJECT) binaries to the bin directory
	cp $(PROJECT) $(INSTALL_DIR)/. 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
