#ifndef __VIRIMG_H
#define __VIRIMG_H


#define XDISK 1
#define XXMS 2


/*  This file contains a two macros for creating extedend arrays and defines
	the following extended array types
	xdouble, xfloat, xint, xchar
	xxdouble, xxfloat, xxint, xxchar

	A variable x of type xx<type> will return a variable
	of type x<type> from x[<index>]
*/

/* The following are various external parameters for the Virtual Arrays
	all have defaults which are shown as the first in the list */
/* Do you want to keep Extended memory safe : 1=Yes 0=No */
extern char ___safety;
/* What is the file used for keeping extended memory safe : c:\!safety!.xms
extern char *___safe_filename;
/* Do you want informative messages from the array manager : 1=Yes 0=No */
extern char ___msgs;
/* What is the filename for the disk caching manger swap file : virarray.swp*/
extern char *___xfilename;
/* What is the size of the file buffer for the disk manager : 32768*/
extern int ___xfile_buf;
/* Where are the CPP arrays to be cached : XXMS = Extended memory
										   XDISK = Disk */
extern char ___xarrays;
/* How many blocks are to be held in coventional memory for CPP arrays : 4*/
extern int __mem_buf;
/* What is the block size for the CPP manager : 32768 */
extern long __block_size;
/* How many block does the CPP manager want : 16 */
extern int __blocks;
/* If there is not enough Xtended memory should the manger cache to disk
		instead : 1=Yes 0=No */
extern char ___auto_disk;

/* The main variables for XARRAY.H are
	__mem_buf, __block_size and __blocks

	__mem_buf 		is the number of memory block in conventional memory
	__block_size 	is the size of the cache block
	__blocks 		is the total number of block needed
					__block is restricted to 16 in the demo version

	The conventional memory used is __mem_buf*__block_size
	The cache memory used is 		__blocks*__block_size

	By juggling these values around you can trade off speed with memory used
*/


extern "C" {
void initialise_virtual_arrays(int real_img,long array_size,unsigned int no_imgs, int dorx);
void *pointer_add(void *tes,long no);
void *large_array(int no,long ind);
void *img(int no);
void create_xms_array (long x, long y, int size, long **offset, int **block);
void delete_xms_array (long **offset, int **block);

/*Timer to measure the time taken for sections of code */
void start_timer();
void stop_timer();
}

template <class T>
class xarray
{
public:
//private:
	long *offset; int *block;
	char xorxx; char temp; long xxind;
public:
	xarray() {temp = 1;};
	xarray (long size) {construct (size);}
	void construct (long size)
	{
		temp = 0;
		long y=size/256;
		if ((size%256)>0) y++;
		create_xms_array (y,256,sizeof(T), &offset, &block);
		xorxx=1;
	}
	xarray (const xarray<T>& x)
	{
		offset=x.offset;
		block=x.block;
		xorxx=x.xorxx;
		xxind=x.xxind;
		temp=1;
	}
	void destroy()
	{
		if (!temp) delete_xms_array (&offset, &block);
	}
	~xarray() { destroy();}
	T& operator[](long index)
	{
		long ind= index>>8;
		if (xorxx) return *( T *)(large_array(block[ind],offset[ind]+((index&255)*sizeof(T))));
		return *( T *)(large_array(block[xxind],offset[xxind]+(index*sizeof(T))));
	}
//	friend class xxarray<T>;
};

template <class T>
class xxarray
{
private :
	xarray<T> normal;
public:
	xxarray () {normal.temp=1;};
	xxarray (long x, long y) { construct (x,y);}
	xxarray (const xxarray<T>& x)
	{
		normal=x.normal;
		normal.temp=1;
	}
	void construct (long x, long y)
	{
		create_xms_array (x,y,sizeof(T), &normal.offset, &normal.block);
		normal.xorxx=0;
		normal.temp=0;
	}
	void destroy() { normal.destroy();}
	~xxarray() { destroy();}
	xarray<T>& operator[](long index)
	{
		normal.xxind=index;
		return normal;
	}
};


#endif
