* Example program for writing code that allows keep filling EPROM with new code
* This is similar to making multi-session CDs, so each new burning is called a
* SESSION for the purposes of this demo.
* Written for ASM11 by Tony G. Papadimitriou on August 25, 1998
* Assuming a MC68HC711E9
* -- I M P O R T A N T --
* When filling up your program with new code, the top of memory will be filled
* downwards with vectors (similar to how a stack operates).  Your program
* should only fill memory upwards.  Eventually, it is possible for one to
* overlap the other.  Make sure (by checking the listing) you have not caused
* an overlap which, of course, would corrupt both code and vectors.
*
* -- I M P O R T A N T --
* Never correct existing code from a previous session.  You should have
* provided hooks for code sections that should be replaceable.  The rest
* you cannot alter.

$EXTRAON -- Allow extra mnemonics

*******************************************************************************
* THE FOLLOWING LINE IS VERY IMPORTANT. START WITH 1 AND ADD 1 FOR EACH NEW   *
* SESSION YOU CREATE TO KEEP VECTORS CORRECT                                  *
* (MAKE SURE YOU DON'T LEAVE GAPS IN NUMBERING CONSECUTIVE SESSIONS)          *
*******************************************************************************
SESSION   equ       3                   This should add 1 for every new session
*******************************************************************************

ROM       equ       $D000               711E9, change for other MCUs
RAMEND    equ       $FFBF               711E9, change for other MCUs
STACKTOP  equ       $01FF               711E9 et al, change for other MCUs
RESET     equ       $FFFE               Single-chip and expanded for all MCUs

;The following line defines what an erased EPROM word looks like.  Change
;accordingly if the EPROM you're using has a different erased state (normally,
;it's either $0000 or $FFFF).
ERASED    equ       $FFFF               Value of erased EPROM word (for 711E9)

; -- Standard reset sequence follows --
          org       ROM
ColdBoot  lds       #STACKTOP
;
; --- Add here only code that *must* be executed within the 64-cycle limit
;     (Normally, you should enable as many things as possible to disable
;     them later in each specific session's reset.  Some things cannot be
;     changed beyond the first burning, such as INIT.  You only have the
;     very first time to decide this, because the routine that searches
;     for your current session will quickly waste the first 64-cycles.)
;
          ldx       #END
ColdLoop  ldd       ,x                  Get first vector (starting from end)
          cmpd      #ERASED             Is it uninitialized?
          beq       SoftBoot            Yes, so previous one was program start
          dex                           Go back a word
          dex
          bra       ColdLoop
SoftBoot  ldx       2,x                 Get vector of last session
          jmp       ,x
Halt      sei
          cls
          stop
          bra       $-1

; --- Original boot sequence
SoftBoot1 equ       *
; --- Add your code here
          bra       Halt                You may change to BRA if possible

; --- Added new code here
SoftBoot2 equ       *
; --- Add your code here
          bra       Halt                You may change to BRA if possible

; --- Added new code here
SoftBoot3 equ       *
          clrd
          clrx
          clry
; --- Add your code here
          bra       Halt                You may change to BRA if possible

; --- Add new code here
;SoftBoot4 ...

*******************************************************************************
*                                                                             *
*                                                                             *
*    N E V E R   add code above already present code for a previous session   *
*                                                                             *
*                                                                             *
*******************************************************************************

BootSize  equ       SESSION*2+2         SESSION should be 1,2,3,4,...
          rmb       RAMEND+1-$-BootSize DO NOT CHANGE
          dw        ERASED              *** R E Q U I R E D ***
BEGIN
; --- Add here consequent "dw SoftBoot?" statements going backwards
; --- Note that no matter how many entries you add, older ones fall always in
;     the same address
;         .
;         .
;         .
          dw        SoftBoot3           Address of third session (if any)
          dw        SoftBoot2           Address of second session (if any)
END       dw        SoftBoot1           THIS SHOULD ALWAYS BE DEFINED

$if END+2-BEGIN/2 <> SESSION
$error No of SoftBoot entries does not match SESSION
$endif

;
; --- Define your other vectors here (possibly some pointing to RAM pseudo-
;     vectors, that each session initializes differently).  Specifically,
;     the SWI handler could point in RAM so that any important function
;     can be remapped (and possibly fixed or updated).
;
          org       RESET
          dw        ColdBoot            DO NOT CHANGE THIS LINE
