/*
 * cde.c - A modification of DOS's chdir (cd) command that returns
 *         an errorlevel of 2 if the function cannot be performed.
 *
 *	   This is intended to be a simple experiment in duplicating
 *	   DOS commands and coming up with nifty stuff for more
 *	   intelligent batch files.
 *
 * Usage:  cde <path>
 *
 * Return: errorlevel 0 = chdir was successful
 *         errorlevel 1 = cde was called with no parameters, OR
 *                        the path parameter ended with a slash (\)
 *         errorlevel 2 = the directory doesn't exist (for whatever
 *                        reason).
 *
 * Example Usage:
 *
 * A good example of how to use this is from within a batch file:
 *
 *	 echo off
 *	 cde %1
 *	 if errorlevel 2 goto MAKE_DIR
 *	 goto DONE
 *	:MAKE_DIR
 *	 mkdir %1
 *	 cde %1
 *	:DONE
 */

/* INCLUDES */

#include <stdio.h>
#include <process.h>
#include <dir.h>
#include <mem.h>
#include <string.h>




/* GLOBALS */

static char cur_dir[MAXPATH], new_dir[MAXPATH];

static int  cur_dsk, new_dsk;




/* MAIN */

/*
 * main() must be defined as an int return value in order for the status
 * code passed to exit() to be passed back to DOS for setting the
 * "errorlevel" global variable.  If main() were defined as a void,
 * the return value would never be set, and the program would ALWAYS
 * leave errorlevel set to 0.
 */
int main(int argc, char **argv)
{
 cur_dir[0] = '\\';			/* Start path with '\'		*/

 getcurdir(0, &cur_dir[1]);		/* Get current path		*/

 cur_dsk = getdisk();			/* Get current disk drive	*/

 /*
  * If CDE was called with no parameters, simply display the current
  * directory path and exit with an error condition of 1.
  */

 if(argc == 1)
  {
  printf("%c:%s\n", cur_dsk+'A', cur_dir);
  exit(1);
  }

 strcpy(new_dir, argv[1]);		/* Get Path parameter		*/

 strupr(new_dir);			/* Convert to uppercase		*/

 /*
  * If the defined path ends with a slash (\), then exit with an
  * "Invalid path" command.  Errorlevel is set to 1.
  */

 if(new_dir[strlen(new_dir)-1] == '\\')
  {
  printf("Invalid path\n");
  exit(1);
  }

 /*
  * If a Drive was specified in the path parameter, get the drive and
  * strip it and the colon from the directory path.
  */

 if(new_dir[1] == ':')
  {
  new_dsk = new_dir[0] - 'A';

  movmem(&new_dir[2], &new_dir[1], MAXPATH-1);

  new_dir[0] = '\\';

  if(new_dir[1] == '\\')
   movmem(&new_dir[2], &new_dir[1], MAXPATH-1);
  }
 else
  new_dsk = cur_dsk;

 strcat(cur_dir, "\\");			/* Add a '\' to end of path	*/

 if(new_dir[0] == '\\')			/* If parameter is a root path	*/
  strcpy(cur_dir, new_dir);		/*  overwrite the current path	*/
 else					/* Otherwise			*/
  strcat(cur_dir, new_dir);		/*  add path to end of current	*/

 setdisk(new_dsk);			/* Move to the new drive	*/

 if(!chdir(cur_dir))			/* Was ChDir successful?	*/
  exit(0);				/*  YES..exit w/ errorlevel 0	*/
 else
  {
  setdisk(cur_dsk);                     /*  Reset to original drive	*/
  printf("%s\n", cur_dir);
  exit(2);				/*  NO..exit w/ errorlevel 2	*/
  }

 /*
  * The following return() call is unreachable, but including it
  * prevents the compiler from generating the "function should return
  * a value in function main()" warning.  Kind of an irritating message,
  * if you ask me.  Of course, you wouldn't encounter this message if the
  * appropriate warning flag were turned off, but I have the tendency to
  * "bullet-proof" my code by making sure I don't do *anything* wrong
  * (knock on wood).
  */

 return 0;
}
