;************************************************************************
;*                                                                      *
;*      Tolow (C) 1997 RonSoft.                                         *
;*                                                                      *
;*      This is a utility that converts all long filenames to lower     *
;*      case. Every time I have been messing around in my web work      *
;*      directory from DOS the filenames has been changed. It's a       *
;*      pain to manually rename them to lowercase so the web server     *
;*      and html stuff will recognise them. It renames ALL files in     *
;*      the given directory or the current if nothing on command line.  *
;*      Usage:   Tolow [path]                                           *
;*      Example: Tolow A:\MYDIR                                         *
;*                                                                      *
;*                                                                      *
;*      Ronald Nordberg                                                 *
;*      Silvervgen 3                                                   *
;*      907 50 Ume                                                     *
;*      Sweden                                                          *
;*      christine.martinson@swipnet.se                                  *
;*      http://home2.swipnet.se/~w-20064                                *
;*                                                                      *
;************************************************************************
                                        ;some euqates for readability
video           equ     10h             ;video irq
kbd             equ     16h             ;keyboard irq
msdos           equ     21h             ;MSDOS irq

setpos          equ     02h             ;set cursor position
getpos          equ     03h             ;get cursor position
getmode         equ     0fh             ;get current video mode

reset           equ     0dh             ;disk reset
setdisk         equ     0eh             ;set current disk
dfopen          equ     0fh             ;open disk file
dfclose         equ     10h             ;close disk file
searchf         equ     11h             ;search first
searchn         equ     12h             ;search next
seqread         equ     14h             ;sequential disk read
seqwrite        equ     15h             ;     "       "  write
getdisk         equ     19h             ;get current disk
setdta          equ     1ah             ;set disk transfer area address
break           equ     33h             ;get/set break flag
getdiskdata     equ     36h             ;get free disk data
setdir          equ     3bh             ;set current directory
createf         equ     3ch             ;create file with handle
openf           equ     3dh             ;open file with handle
closef          equ     3eh             ;close file with handle
readf           equ     3fh             ;read from file with handle
writef          equ     40h             ;write to file with handle
unlink          equ     41h             ;UNLINK(delete file)
getdir          equ     47h             ;get current dir
allocmem        equ     48h             ;allocate memory
freemem         equ     49h             ;free memory
changebs        equ     4ah             ;change block size
findfirst       equ     4eh             ;find first file
findnext        equ     4fh             ;find next file
rename          equ     56h             ;rename/move
rename95        equ     7156h           ;rename long filename
getname95       equ     7160h           ;get canonical long filename
exit            equ     4c00h           ;msdos exit

[BITS 16]
[ORG 0x100]

        mov     ax,cs                   ;get code segment
        mov     ds,ax                   ;use it now
        mov     [comseg],ds
        mov     byte [flag],0           ;clear command line flag

        mov     si,0080h                ;DOS command line page 0
        lodsb                           ;load size of command line
        cmp     al,0                    ;anything on command line ?
        jbe     here                    ;noo, use current dir
        cbw                             ;extend AL to AX
        xchg    bx,ax                   ;swap size to bx for indexing
        mov     byte [bx+si],0          ;null terminate command line
        call    parse                   ;parse command line
        mov     byte [flag],1           ;set flag
here:
        mov    bx,[progend]            ;program end address
        mov    ax,es                   ;segment of the program beginning
        sub    bx,ax                   ;memory size needed for ourselves
        shr    bx,4                    ;make paragraphs
        mov    ah,changebs             ;modify memory block
        int    msdos                   ;free memory
        jnc    resok
        mov    bx,errt0                ;error
        jmp    errout
resok:
        mov     bx,-1                   ;get all available memory
        shr     bx,4                    ;make paragraphs
        mov     ah,allocmem             ;allocate memory
        int     msdos                   ;call dos
        mov     ax,bx
        shl     ax,4                    ;make bytes
        mov     [memsize],ax            ;save bytes free
        mov     ah,allocmem             ;biggest available now in BX
        int     msdos
        jnc     memok
        mov     bx,errt4
        jmp     errout
memok:
        mov     [address],ax            ;save address
        mov     ah,getdisk              ;get default drive
        int     msdos                   ;call dos
        add     al,41h                  ;drive in al, make it ASCII
        mov     byte [curdir],al        ;fill buffer with name (A:..etc)
        
        mov     word [curdir+1],":\"    ;copy separator to path
        mov     si,curdir               ;pointer path buffer
        add     si,3                    ;offset doscall part
        mov     ah,getdir               ;get current dir
        mov     dl,0                    ;0 = default
        int     msdos                   ;call dos
        jnc     diskok                  ;ok
        mov     bx,errt0                ;could not find current dir ?? If You
        jmp     errout                  ;get an error here You probably have
diskok:                                 ;forgot to turn on Your computer.
        cmp     byte [flag],1           ;using path ?
        je      ownpath                 ;yeahh
        mov     ah,setdir               ;func Set Current Directory(CD)
        mov     dx,curdir               ;path to directory
        int     msdos                   ;do it
        jmp     dowork
ownpath:
        mov     si,inbuff               ;get command line
        lodsb                           ;get drive
        and     al,0DFH                 ;force upper case
        sub     al,'A'                  ;make binary
        mov     dl,al                   ;in DL for doscall
        mov     ah,setdisk              ;set current disk
        int     msdos                   ;do it
        jnc     setdok                  ;all ok
        mov     bx,errt8                ;wrong drive
        jmp     errout
setdok:
        mov     ah,setdir               ;set current dir (CD)
        mov     dx,inbuff               ;get path
        int     msdos                   ;do it
        jnc     dowork                  ;all ok
        mov     bx,errt7                ;error
        jmp     errout                  ;skip
dowork:
        mov     ah,setdta               ;set our DTA-area
        mov     dx,mydta                ;our DTA structure
        int     msdos

        mov     word [filecount],0      ;number of files to rename
        mov     di,[address]            ;buffer for short name storage

        mov     ah,findfirst            ;see if the files out there
        mov     cx,0fh                  ;all files
        mov     dx,wild                 ;*.*
        int     msdos                   ;do the stuff
        jnc     fileok                  ;all ok, process first file
        mov     bx,errt0                ;no entry in directory                
        jmp     errout                  ;skip this
fscan:  mov     dx,wild                 ;*.*
        mov     ah,findnext             ;the function
        int     msdos                   ;call dos
        jnc     fileok                  ;more files
        jmp     nameit                  ;done
fileok: mov     si,mydta+30             ;copy original name
cplo:   lodsb                           ;load AL
        cmp     al,0                    ;0 ?
        je      done0                   ;yeahh
        stosb                           ;noo, copy char
        jmp     cplo                    ;check next char
done0:  stosb                           ;null termination
        add     word [filecount],1      ;increase number of files
        jmp     fscan                   ;get next short name 

nameit: mov     cx,[filecount]          ;get number of files to rename
        mov     si,[address]            ;name buffer
        mov     [filename],si           ;first short filename
nam1:   push    cx                      ;save counter
        mov     ax,getname95            ;get canonical long filename
        mov     cl,02h
        mov     ch,00h
        mov     si,[filename]           ;buffer short filename
        mov     di,canon                ;long filename buffer
        int     msdos                   ;call dos
        jnc     longok                  ;all ok
        mov     bx,errt6                ;something wrong
        call    write                   ;let us know
        jmp     namok                   ;try next file anyway
longok:
        mov     si,canon                ;buffer long filename
conv:   cmp     byte [si],0             ;end of name ?
        je      convd                   ;yeahh :)
        cmp     byte [si],'A'           ;below ascii A ?
        jb      nolow                   ;yeahh
        cmp     byte [si],'Z'           ;above ascii Z ?
        ja      nolow                   ;yeahh
        add     byte [si],32            ;convert to lower case
nolow:  inc     byte si                 ;next byte
        jmp     conv
convd:
        mov     ax,rename95             ;rename long filename
        mov     dx,[filename]           ;pointer short filename
        mov     di,canon                ;pointer lower case long filename
        int     msdos                   ;do the request
        jnc     namok                   ;all ok

        mov     bx,errt1                ;error, let us know
        call    write
        mov     bx,[filename]
        call    write
        mov     bx,text
        call    write
        mov     bx,canon
        call    write
        mov     bx,feed
        call    write

namok:  mov     si,[filename]           ;try next filename
dump0:  lodsb                           ;get new name
        cmp     al,0                    ;zero ?
        je      dump1                   ;yeahh
        jmp     dump0                   ;noo, dump on
dump1:  mov     [filename],si           ;next short filename
        pop     cx                      ;get file # counter
        loop    nam1                    ;next 
        mov     bx,mess
        call    write
        mov     ax,[filecount]
        cwd
        mov     edx,eax
        call    bindec
        mov     bx,si
        call    write
        mov     bx,text
        call    write
        cmp     byte [flag],0           ;any path ?
        je      quit                    ;noo, just skip

        mov     si,curdir               ;get current dir
        lodsb                           ;get drive
        and     al,0DFH                 ;force upper case
        sub     al,'A'                  ;make binary
        mov     dl,al                   ;in DL for doscall
        mov     ah,setdisk              ;set current disk
        int     msdos                   ;do it
        mov     ah,setdir               ;cd back to where we came from
        mov     dx,curdir               ;path to directory
        int     msdos                   ;do it
        jmp     quit                    ;done

;*************************** errorexit ***********************
errout: call    write                   ;show errormessage
quit:
        xor     eax,eax                 ;better do this
        mov     ax,exit                 ;MS-DOS successful exit
        int     msdos                   ;back to the operating system

;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*       OR writes out data,BX and size,CX if called at lwrite.          *
;*************************************************************************
write:  pusha
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop:  lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      lwrite                   ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
lwrite: mov     dx,bx                   ;text address in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,writef               ;MS-DOS writefile with handle is 040
        int     msdos                   ;write buffer to standard output
        popa
        ret                             ;done

;***********************************************************************
; Convert binary 32 bit number to ascii decimal using succesive
; subraction.  Input edx, output numbuff.
;************************************************************************
bindec:
        mov     esi,divtab      ;pointer subtract values
        mov     edi,numbuff     ;output buffer
        mov     cx,10           ;10 digits
sublop: xor     al,al           ;clear counter
sblop:  cmp     edx,[esi]       ;number < subractor ?
        jb      tolow           ;yeah
        sub     edx,[esi]       ;noo, subtract
        add     al,1            ;incrase times subtracted
        jmp     sblop           ;subtract again
tolow:
        add     al,30h          ;make ascii
        stosb                   ;store in buffer
        add     si,4            ;next subtractor
        loop    sublop          ;do it
        mov     al,0
        stosb
        mov     si,numbuff
strip:  lodsb
        cmp     al,'0'                  ;any leading zeroes ?
        jne     nozero                  ;noo
        mov     byte [si-1],32
        jmp     strip                   ;yeahh, check next
nozero: dec     si                      ;adjust that back one byte
        ret

;*************************************************************************
;*      My kind of command line parsing. It just checks if theres
;*      any blankspaces between the options. The parameters ends up
;*      in the inbuff separated by 0:s, binary zeroes.
;*************************************************************************
parse:
        mov     di,inbuff               ;our buffer
dospc:  cmp     byte [si],32            ;any leading spaces ?
        jne     nospc                   ;nooo
        inc     si                      ;yeahh, dump it
        jmp     dospc                   ;check next
nospc:  mov     cx,1                    ;we're here, so we got one arg
copy1:  lodsb                           ;load byte SI to AL
        cmp     al,0                    ;0 ?(end of line)
        je      done                    ;yeahh
        cmp     al,32                   ;SPACE ?
        je      cop2                    ;yeah
        stosb                           ;noo, move AL to DI, incrase DI
        jmp     copy1                   ;go on
cop2:   mov     byte [di],0             ;null terminate
        add     cx,1
        inc     di                      ;dump that byte(SPACE)
        jmp     copy1                   ;back
done:   mov     byte [di],0             ;null terminate
        ret                             ;return


[SECTION .data]
divtab          dd 1000000000      ;subtractor values
                dd  100000000
                dd   10000000
                dd    1000000
                dd     100000
                dd      10000           
                dd       1000
                dd        100
                dd         10
                dd          1

mydta           times 64 dw 0           ;use 128 bytes as DTA
inbuff          times 64 dw 0           ;and command line buffer
curdir          times 34 dw 0
numbuff         times  6 dw 0           ;word ascii number buffer
filecount       dw 0
address         dw 0
memsize         dw 0
comseg          dw 0
filename        dw 0

canon           times 216 db 0
mess            db      'Tolow (C) 1997 RonSoft.',13,10,0
text            db      ' Files converted OK.',13,10,0
errt0           db      'Could not find directory entry.',13,10,0
errt1           db      'Could not rename ',0
errt2           db      'Could not lock volume.',13,10,0
errt3           db      'Could not unlock volume.',13,10,0
errt4           db      'Could not allocate memory.',13,10,0
errt5           db      'Could not get lock flag stauts.',13,10,0
errt6           db      'Could not get canonical long filename.',13,10,0
errt7           db      'Invalid directory.',13,10,0
errt8           db      'Invalid drive.',13,10,0
feed            db      13,10,0
wild            db      '*.*',0
flag            db      0

progend:

        END     
