#ident "$Id: scsierr.h,v 1.3 1992/01/12 15:24:44 chris Exp $"

/*
 * $Log: scsierr.h,v $
 * Revision 1.3  1992/01/12  15:24:44  chris
 * Add the E$EndOfMediuom error macro
 *
 * Revision 1.2  1991/05/03  10:34:59  chris
 * Add errorcodes for streamer support used by ada.c
 *
 * Revision 1.1  1991/03/21  11:11:16  chris
 * Initial revision
 *
 */

/*
 * This headerfile defines all the scsi/ada error codes
 */

static char *scsi_err_id = "$Id: scsierr.h,v 1.3 1992/01/12 15:24:44 chris Exp $";

/* Error codes returned by the scsi functions */

#define E$NoErr 0           /* No Error */
#define E$NoAspi -1         /* No Aspi Manager Installed */
#define E$Busy -2           /* Aspi Module is busy (this should never occur */
#define E$AspiErr -3        /* Undefined Aspi error */
#define E$NoMem -4          /* Can't allocate memory */
#define E$NoDevice -5       /* The device is not installed */
#define E$AspiInval -6      /* Invalid ASPI request */
#define E$NoAdapter -7      /* Invalid Host Adapter Number */
#define E$Abort -8          /* ASPI request aborted by Host */
#define E$SelTimeout -9     /* Selection Timeout */
#define E$DataOverrun -10   /* Data over-run/under-run */
#define E$BusFree -11       /* Unexpected Bus Free */
#define E$BusFail -12       /* Target bus phase sequence failure */
#define E$TargetBusy -13    /* The specified Target/LUN is busy */
#define E$Reservation -14   /* Reservation conflict */
#define E$NotReady -15      /* lun cannot be accessed */
#define E$Medium -16        /* Medium Error */
#define E$Hardware -17      /* Non recoverable hardware error */
#define E$IllegalReq -18    /* Illegal Request */
#define E$UnitAttention -19 /* Unit Attention */
#define E$DataProtect -20   /* The Block is protected */
#define E$BlankCheck -21    /* Encounterd non blank data */
#define E$TargetAbort -22   /* The Target Aborted the command */
#define E$VolOverflow -23   /* Volume overflow */
#define E$Miscompare -24    /* Source and data did nor match */
#define E$IOErr -25         /* An IO Error of unknown type */

/* Additional errorcodes used in ada.c */
#define E$LockLMem -26      /* Can not lock local memory */
#define E$LockGMem -27      /* Can not lock global memory */
#define E$Fatal    -28      /* Fatal Error - unemploy the programmer :-) */
#define E$NoChannel -29     /* The logical channel is not initialized */
#define E$NotActive -30     /* The logical channel is not active */
#define E$ChannelOverflow -31 /* Logical Channel overflow */
#define E$StreamerInUse -32 /* streamer is already configured for a channel */
#define E$BlockLimit -33    /* Illegal blocksize for a streamer */
#define E$Offset -34        /* Illegal offset allowed for this operation */
#define E$Position -35      /* Illegal position for this operarion */
#define E$BlockLen -36      /* Illegal block length for this operation */

/*
 * later added errorcodes for both modules ada.c & aspi.c
 */

#define E$EndOfMedium -37   /* End of Medium detected, not really an error */
