/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#include <rhide.h>

#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <stdlib.h>
#include <stdio.h>
#ifdef __DJGPP__
#include <dos.h>
#include <dpmi.h>
#endif

#ifdef __DJGPP__
static int win_version()
{
  __dpmi_regs r;
  r.x.ax = 0x160a;
  __dpmi_int(0x2f,&r);
  if (r.x.ax == 0) return r.x.bx;
  return 0;
}
#endif

static char *_getenv(char *v)
{
  char *vv = getenv(v);
  return vv ? vv : "";
}

static void sample_program(char *& buf,int c)
{
  char *cmd;
  FILE *f;
  char Buf[1000];
#ifdef __DJGPP__
  string_dup(cmd,"echo \"int main(){return 0;}\" | redir -eo gcc -Xlinker -v -Wa,-v -v -o /dev/null -x ");
#else
  string_dup(cmd,"echo \"int main(){return 0;}\" | gcc -Xlinker -v -Wa,-v -v -o /dev/null -x ");
#endif
  string_cat(cmd,c?"c -":"c++ -");
#ifndef __DJGPP__
  string_cat(cmd," 2>&1");
#endif
  f = popen(cmd,"r");
  if (!f) return;
  while (fgets(Buf,999,f))
  {
    string_cat(buf,Buf);
  }
  pclose(f);
}

char *create_bug_report(int call_gcc)
{
  char *buf = NULL;
#ifdef __DJGPP__
  char temp[100];
  int winver;
#endif
  string_cat(buf,"This is a bug report for ");
  string_cat(buf,IDEVersion);
  string_cat(buf," (");
  string_cat(buf,build_date);
  string_cat(buf," ");
  string_cat(buf,build_time);
  string_cat(buf,")\n");
#ifdef __DJGPP__
  _get_dos_version(1);
  sprintf(temp,"%s %d.%d",_os_flavor,_osmajor,_osminor);
  string_cat(buf,"I am running ");
  string_cat(buf,temp);
  winver = win_version();
  if (winver > 0)
  {
    string_cat(buf," (Windows ");
    if (winver >= 0x0400)
      string_cat(buf,"95");
    else
    {
      sprintf(temp,"%d.%d",winver / 0x100,winver & 0xff);
      string_cat(buf,temp);
    }
    string_cat(buf,")");
  }
#endif
  string_cat(buf,"\n\nImportant environment variables:");
#define VAR(x) string_cat(buf,"\n"#x"="); string_cat(buf,_getenv(#x))
  VAR(PATH);
#ifdef __DJGPP__
  VAR(DJGPP);
  VAR(LFN);
#endif
  VAR(INFOPATH);
  VAR(LOCALEDIR);
  VAR(LANGUAGE);
  VAR(SHELL);
#ifdef __DJGPP__
  VAR(COMSPEC);
  VAR(DJSYSFLAGS);
#endif
#ifdef __linux__
  VAR(TERM);
#endif
  string_cat(buf,"\n");
  if (call_gcc)
  {
    string_cat(buf,"\nHere is the output from a sample compilation and link for C\n");
    sample_program(buf,1);
    string_cat(buf,"\nEnd of the sample\n");
    string_cat(buf,"\nHere is the output from a sample compilation and link for C++\n");
    sample_program(buf,0);
    string_cat(buf,"\nEnd of the sample\n");
  }
  string_cat(buf,"\n\n
My problem is the following:
============================
\n\n");
  return buf;
}

#ifdef TEST

int main()
{
  fprintf(stderr,"%s",create_bug_report(1));
  return 0;
}

#endif




