/*****************************************************************************

  This file is part of the:

  TCEditor class by SET, copyright (c) 1996.

    This files can be used by Robert Hhne for your RHIDE, any other use
  needs the permission of the author.

  E-Mail: salvador@inti.edu.ar
  
  Telephone: (+541) 759-0013
  
  Postal Address:
  Salvador E. Tropea
  Curapalige 2124
  (1678) Caseros - 3 de Febrero
  Prov: Buenos Aires
  Argentina

 26/09
   Modified by Robert for the Palette customization and multilanguage
 support.

 26/10
 Bug Killed: Changed cmUpdateTitle by cmcUpdateTitle.

*****************************************************************************/

// That's the first include because is used to configure the editor.
#include "ceditint.h"

#define Uses_TFrame
#define Uses_TWindow
#define Uses_TRect
#define Uses_TIndicator
#define Uses_TEvent
#define Uses_TScrollBar
#define Uses_TStreamableClass
#define Uses_TStreamable
#define Uses_opstream
#define Uses_ipstream
#define Uses_TStringCollection
#define Uses_TPalette
#include <tv.h>

#define Uses_TCEditor
#define Uses_TCFileEditor
#define Uses_TCEditWindow
#include "ceditor.h"

#ifdef STANDALONE
void RemoveFromEditorsHelper(TCEditWindow *p);
void AddToEditorsHelper(TCEditWindow *p);
#endif

//  Palette management added by Robert to allow the customization of the
// palette.
#define cpBlueEditWindow "\x08\x09\x0A\x0B\x0C\x40\x41\x42\x43\x44\x45\x46"\
                         "\x47\x48\x49\x4A\x4B\x4C\x4D\x4E\x4F\x50\x51\x76"\
                         "\x77\x78\x79"
#define cpCyanEditWindow "\x10\x11\x12\x13\x14\x52\x53\x54\x55\x56\x57\x58"\
                         "\x59\x5A\x5B\x5C\x5D\x5E\x5F\x60\x61\x62\x63\x76"\
                         "\x77\x78\x79"
#define cpGrayEditWindow "\x18\x19\x1A\x1B\x1C\x64\x65\x66\x67\x68\x69\x6A"\
                         "\x6B\x6C\x6D\x6E\x6F\x70\x71\x72\x73\x74\x75\x76"\
                         "\x77\x78\x79"

TPalette & TCEditWindow::getPalette() const
{
  static TPalette blue(cpBlueEditWindow,sizeof(cpBlueEditWindow)-1);
  static TPalette cyan(cpCyanEditWindow,sizeof(cpCyanEditWindow)-1);
  static TPalette gray(cpGrayEditWindow,sizeof(cpGrayEditWindow)-1);
  static TPalette * palettes[] =
  {
    &blue,
    &cyan,
    &gray
  };
  return *(palettes[palette]);
}

const TPoint minEditWinSize = {24, 6};

TCEditWindow::TCEditWindow( const TRect& bounds,
                          const char *fileName,
                          int aNumber
                        ) :
    TWindow( bounds, 0, aNumber ),
    TWindowInit( &TCEditWindow::initFrame )
{
    options |= ofTileable;

    TScrollBar *hScrollBar =
        new TScrollBar( TRect( 18, size.y - 1, size.x - 2, size.y ) );
    #ifdef __GNUC__
    // Why doesn't work in BC?
    hScrollBar->hide();
    #endif
    insert(hScrollBar);

    TScrollBar *vScrollBar =
        new TScrollBar( TRect( size.x - 1, 1, size.x, size.y - 1 ) );
    #ifdef __GNUC__
    vScrollBar->hide();
    #endif
    insert(vScrollBar);

    TIndicator *indicator =
        new TIndicator( TRect( 2, size.y - 1, 16, size.y ) );
    #ifdef __GNUC__
    indicator->hide();
    #endif
    insert(indicator);


    TRect r( getExtent() );
    r.grow(-1, -1);
    editor = new TCFileEditor( r, hScrollBar, vScrollBar, indicator, fileName );
    insert(editor);
}


void TCEditWindow::close()
{
    if( editor->isClipboard() )
        hide();
    else
      {
#ifdef STANDALONE
       RemoveFromEditorsHelper(this);
#endif
       TWindow::close();
      }
}

const char *TCEditWindow::getTitle( short )
{
    if( editor->isClipboard() )
        return _(clipboardTitle);
    else if( *(editor->fileName) == EOS )
        return _(untitled);
    else
        return editor->fileName;
}

void TCEditWindow::handleEvent( TEvent& event )
{
    TWindow::handleEvent(event);
    if( event.what == evBroadcast && event.message.command == cmcUpdateTitle )
        {
        if( frame != 0 )
            frame->drawView();
        clearEvent(event);
        }
}

void TCEditWindow::sizeLimits( TPoint& min, TPoint& max )
{
    TWindow::sizeLimits(min, max);
    min = minEditWinSize;
}

void TCEditWindow::write( opstream& os )
{
    TWindow::write( os );
    os << editor;
}

void *TCEditWindow::read( ipstream& is )
{
    TWindow::read( is );
    is >> editor;
    return this;
}

TStreamable *TCEditWindow::build()
{
    return new TCEditWindow( streamableInit );
}

TCEditWindow::TCEditWindow( StreamableInit ) :
    TWindow( streamableInit ),
    TWindowInit( NULL )
{
}


#if !defined( RHIDE ) // in RHIDE this is defined in a separate files
const char * const near TCEditWindow::name = "TCEditWindow";
#endif
const char * near TCEditWindow::clipboardTitle = __("Clipboard");
const char * near TCEditWindow::untitled = __("Untitled");

