/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Black 0
#define Blue 1
#define Green 2
#define Cyan 3
#define Red 4
#define Magenta 5
#define Brown 6
#define Lightgray 7
#define Darkgray 8
#define Lightblue 9
#define Lightgreen A
#define Lightcyan B
#define Lightred C
#define Lightmagenta D
#define Yellow E
#define White F

#define __S(color) #color
#define _S(bg,fg) __S(\x##bg##fg)
#define S(index,foreground,background,comment...) _S(background,foreground)

/* This is the palette for the system when in color mode */
#define cpIDEColor\
        S( 1,Blue,Lightgray,background) \
        \
        S( 2,Black,Lightgray,normal text, Used by menus and statusline) \
        S( 3,Darkgray,Lightgray,disabled text) \
        S( 4,Red,Lightgray,shortcut) \
        S( 5,Black,Green,normal selected) \
        S( 6,Darkgray,Green,disabled selected) \
        S( 7,Red,Green,shortcut selected) \
        \
        S( 8,Lightgray,Blue,passive frame, Used by blue windows ) \
        S( 9,White,Blue,active frame) \
        S( A,Lightgreen,Blue,frame icons) \
        S( B,Blue,Cyan,scrollbar) \
        S( C,Blue,Cyan,scrollbar icons) \
        S( D,Yellow,Blue,normal text) \
        S( E,Blue,Lightgray,selected text) \
        \
        S( F,Black,Black,reserved) \
        \
        S(10,Lightgray,Cyan,passive frame, Used by cyan windows ) \
        S(11,White,Cyan,active frame) \
        S(12,Lightgreen,Cyan,frame icons) \
        S(13,Cyan,Blue,scrollbar) \
        S(14,Cyan,Blue,scrollbar icons) \
        S(15,Yellow,Cyan,normal text) \
        S(16,Blue,Green,selected text) \
        \
        S(17,Black,Black,reserved) \
        \
        S(18,Lightgray,Black,passive frame, Used by gray windows ) \
        S(19,White,Black,active frame) \
        S(1A,White,Black,frame icons) \
        S(1B,Lightgray,Black,scrollbar) \
        S(1C,White,Black,scrollbar icons) \
        S(1D,Lightgray,Black,normal text) \
        S(1E,Black,Lightgray,selected text) \
        \
        S(1F,Black,Black,reserved) \
        \
        S(20,Black,Lightgray,passive frame, Used by dialogs) \
        S(21,White,Lightgray,active frame) \
        S(22,Lightgreen,Lightgray,frame icons) \
        S(23,Cyan,Blue,scrollbar) \
        S(24,Cyan,Blue,scrollbar icons) \
        S(25,Black,Lightgray,static text) \
        S(26,Black,Lightgray,label normal) \
        S(27,White,Lightgray,label selected) \
        S(28,Yellow,Lightgray,label shortcut) \
        S(29,Black,Green,button normal) \
        S(2A,Lightcyan,Green,button default) \
        S(2B,White,Green,button focused) \
        S(2C,Darkgray,Lightgray,butten disabled) \
        S(2D,Yellow,Green,button shortcut) \
        S(2E,Black,Lightgray,button shadow) \
        S(2F,Black,Cyan,cluster normal) \
        S(30,White,Cyan,cluster selected) \
        S(31,Yellow,Cyan,cluster shortcut) \
        S(32,White,Blue,inputline normal) \
        S(33,White,Green,inputline selected) \
        S(34,Lightgreen,Blue,inputline arrows) \
        S(35,Black,Green,history arrow) \
        S(36,Green,Lightgray,history side) \
        S(37,Blue,Cyan,history window scrollbar) \
        S(38,Blue,Cyan,history window scrollbar icons) \
        S(39,Black,Cyan,list normal) \
        S(3A,White,Green,list focused) \
        S(3B,Yellow,Cyan,list selected) \
        S(3C,Blue,Cyan,list divider) \
        S(3D,Cyan,Blue,infopane) \
        \
        S(3E,Black,Black,reserved) \
        S(3F,Black,Black,reserved) \
        \
        S(40,Lightgray,Blue,passive frame, Used by blue editors) \
        S(41,White,Blue,active frame) \
        S(42,Lightgreen,Blue,frame icons) \
        S(43,Blue,Cyan,scrollbar) \
        S(44,Blue,Cyan,scrollbar icons) \
        S(45,Yellow,Blue,normal text) \
        S(46,Blue,Lightgray,marked text) \
        S(47,Lightgray,Blue,comment) \
        S(48,White,Blue,reserved word) \
        S(49,Yellow,Blue,identifier) \
        S(4A,White,Blue,symbol) \
        S(4B,Lightcyan,Blue,string) \
        S(4C,Lightmagenta,Blue,integer decimal) \
        S(4D,Lightmagenta,Blue,float) \
        S(4E,Lightmagenta,Blue,octal) \
        S(4F,Lightmagenta,Blue,hex) \
        S(50,Lightcyan,Blue,character) \
        S(51,Lightgreen,Blue,preprocessor) \
        S(52,Black,Red,illegal character) \
        S(53,White,Blue,user reserved word) \
        S(54,Black,Cyan,CPU line) \
        S(55,White,Red,breakpoint) \
        S(56,White,Blue,symbol2) \
        S(57,Lightgray,Black,cross cursor) \
        S(58,Black,Lightgray,editor statusline) \
        S(59,Lightred,Lightgray,matching paranthesis) \
        S(5A,White,Magenta,rectangular blocks) \
        \
        S(5B,Black,Black,resreved) \
        S(5C,Black,Black,reserved) \
        S(5D,Black,Black,reserved) \
        S(5E,Black,Black,reserved) \
        S(5F,Black,Black,reserved) \
        \
        S(60,Lightgray,Cyan,passive frame, Used by cyan editors ) \
        S(61,White,Cyan,active frame) \
        S(62,Lightgreen,Cyan,frame icons) \
        S(63,Cyan,Blue,scrollbar) \
        S(64,Cyan,Blue,scrollbar icons) \
        S(65,Yellow,Cyan,normal text) \
        S(66,Cyan,Lightgray,marked text) \
        S(67,Lightgray,Cyan,comment) \
        S(68,White,Cyan,reserved word) \
        S(69,Yellow,Cyan,identifier) \
        S(6A,White,Cyan,symbol) \
        S(6B,Lightcyan,Cyan,string) \
        S(6C,Lightmagenta,Cyan,integer decimal) \
        S(6D,Lightmagenta,Cyan,float) \
        S(6E,Lightmagenta,Cyan,octal) \
        S(6F,Lightmagenta,Cyan,hex) \
        S(70,Lightcyan,Cyan,character) \
        S(71,Lightgreen,Cyan,preprocessor) \
        S(72,Black,Red,illegal character) \
        S(73,White,Cyan,user reserved word) \
        S(74,Black,Blue,CPU line) \
        S(75,White,Red,breakpoint) \
        S(76,White,Cyan,symbol2) \
        S(77,Lightgray,Black,cross cursor) \
        S(78,Black,Lightgray,editor statusline) \
        S(79,Lightred,Lightgray,matching paranthesis) \
        S(7A,White,Magenta,rectangular blocks) \
        \
        S(7B,Black,Black,resreved) \
        S(7C,Black,Black,reserved) \
        S(7D,Black,Black,reserved) \
        S(7E,Black,Black,reserved) \
        S(7F,Black,Black,reserved) \
        \
        S(80,Lightgray,Black,passive frame, Used by gray editors ) \
        S(81,White,Black,active frame) \
        S(82,White,Black,frame icons) \
        S(83,Lightgray,Black,scrollbar) \
        S(84,White,Black,scrollbar icons) \
        S(85,Yellow,Black,normal text) \
        S(86,Black,Lightgray,marked text) \
        S(87,Lightgray,Black,comment) \
        S(88,White,Black,reserved word) \
        S(89,Yellow,Black,identifier) \
        S(8A,White,Black,symbol) \
        S(8B,Lightcyan,Black,string) \
        S(8C,Lightmagenta,Black,integer decimal) \
        S(8D,Lightmagenta,Black,float) \
        S(8E,Lightmagenta,Black,octal) \
        S(8F,Lightmagenta,Black,hex) \
        S(90,Lightcyan,Black,character) \
        S(91,Lightgreen,Black,preprocessor) \
        S(92,Black,Red,illegal character) \
        S(93,White,Black,user reserved word) \
        S(94,Black,Cyan,CPU line) \
        S(95,White,Red,breakpoint) \
        S(96,White,Black,symbol2) \
        S(97,Lightgray,Magenta,cross cursor) \
        S(98,Black,Lightgray,editor statusline) \
        S(99,Lightred,Lightgray,matching paranthesis) \
        S(9A,White,Magenta,rectangular blocks) \
        \
        S(9B,Black,Black,resreved) \
        S(9C,Black,Black,reserved) \
        S(9D,Black,Black,reserved) \
        S(9E,Black,Black,reserved) \
        S(9F,Black,Black,reserved) \
        \
        S(A0,Lightgray,Cyan,passive frame, used by the help viewer) \
        S(A1,White,Cyan,active frame) \
        S(A2,Lightgreen,Cyan,frame icons) \
        S(A3,Cyan,Blue,scollbar) \
        S(A4,Cyan,Blue,scrollbar icons) \
        S(A5,Black,Cyan,normal text) \
        S(A6,Yellow,Cyan,keyword) \
        S(A7,Yellow,Blue,selected keyword) \
        S(A8,Yellow,Red,keyword in marked area) \
        S(A9,Yellow,Green,marked text, currently fixed to "\0x70") \
        \
        S(AA,Black,Black,reserved) \
        S(AB,Black,Black,reserved) \
        S(AC,Black,Black,reserved) \
        S(AD,Black,Black,reserved) \
        S(AE,Black,Black,reserved) \
        S(AF,Black,Black,reserved)


#define Normal 07
#define Light 0F
#define Inverse 70
#define Underline 01
#define Empty 00

#define __M(color) #color
#define _M(col) __M(\x##col)
#define M(index,color,comment...) _M(color)

/* This is the palette for the system when in monochrome mode */
#define cpIDEMono\
        M( 1,Normal,background) \
        \
        M( 2,Normal,normal text, Used by menus and statusline) \
        M( 3,Normal,disabled text) \
        M( 4,Underline,shortcut) \
        M( 5,Inverse,normal selected) \
        M( 6,Underline,disabled selected) \
        M( 7,Inverse,shortcut selected) \
        \
        M( 8,Normal,passive frame, Used by blue windows ) \
        M( 9,Light,active frame) \
        M( A,Normal,frame icons) \
        M( B,Normal,scrollbar) \
        M( C,Normal,scrollbar icons) \
        M( D,Normal,normal text) \
        M( E,Inverse,selected text) \
        \
        M( F,Empty,reserved) \
        \
        M(10,Normal,passive frame, Used by blue windows ) \
        M(11,Light,active frame) \
        M(12,Normal,frame icons) \
        M(13,Normal,scrollbar) \
        M(14,Normal,scrollbar icons) \
        M(15,Normal,normal text) \
        M(16,Inverse,selected text) \
        \
        M(17,Empty,reserved) \
        \
        M(18,Normal,passive frame, Used by blue windows ) \
        M(19,Light,active frame) \
        M(1A,Normal,frame icons) \
        M(1B,Normal,scrollbar) \
        M(1C,Normal,scrollbar icons) \
        M(1D,Normal,normal text) \
        M(1E,Inverse,selected text) \
        \
        M(1F,Empty,reserved) \
        \
        M(20,Normal,passive frame, Used by dialogs) \
        M(21,Light,active frame) \
        M(22,Normal,frame icons) \
        M(23,Normal,scrollbar) \
        M(24,Normal,scrollbar icons) \
        M(25,Normal,static text) \
        M(26,Normal,label normal) \
        M(27,Inverse,label selected) \
        M(28,Underline,label shortcut) \
        M(29,Inverse,button normal) \
        M(2A,Underline,button default) \
        M(2B,Inverse,button focused) \
        M(2C,Normal,butten disabled) \
        M(2D,Normal,button shortcut) \
        M(2E,Normal,button shadow) \
        M(2F,Inverse,cluster normal) \
        M(30,Normal,cluster selected) \
        M(31,Light,cluster shortcut) \
        M(32,Underline,inputline normal) \
        M(33,Inverse,inputline selected) \
        M(34,Normal,inputline arrows) \
        M(35,Normal,history arrow) \
        M(36,Normal,history side) \
        M(37,Normal,history window scrollbar) \
        M(38,Normal,history window scrollbar icons) \
        M(39,Inverse,list normal) \
        M(3A,Normal,list focused) \
        M(3B,Underline,list selected) \
        M(3C,Normal,list divider) \
        M(3D,Normal,infopane) \
        \
        M(3E,Empty,reserved) \
        M(3F,Empty,reserved) \
        \
        M(40,Normal,passive frame, Used by blue editors) \
        M(41,Light,active frame) \
        M(42,Normal,frame icons) \
        M(43,Normal,scrollbar) \
        M(44,Normal,scrollbar icons) \
        M(45,Normal,normal text) \
        M(46,Inverse,marked text) \
        M(47,Light,comment) \
        M(48,Light,reserved word) \
        M(49,Normal,identifier) \
        M(4A,Light,symbol) \
        M(4B,Light,string) \
        M(4C,Light,integer decimal) \
        M(4D,Light,float) \
        M(4E,Light,octal) \
        M(4F,Light,hex) \
        M(50,Light,character) \
        M(51,Light,preprocessor) \
        M(52,Inverse,illegal character) \
        M(53,Light,user reserved word) \
        M(54,Underline,CPU line) \
        M(55,Inverse,breakpoint) \
        M(56,Light,symbol2) \
        M(57,Inverse,cross cursor) \
        M(58,Inverse,editor statusline) \
        M(59,Inverse,matching paranthesis) \
        M(5A,Inverse,rectangular blocks) \
        \
        M(5B,Empty,resreved) \
        M(5C,Empty,reserved) \
        M(5D,Empty,reserved) \
        M(5E,Empty,reserved) \
        M(5F,Empty,reserved) \
        \
        M(60,Normal,passive frame, Used by blue editors) \
        M(61,Light,active frame) \
        M(62,Normal,frame icons) \
        M(63,Normal,scrollbar) \
        M(64,Normal,scrollbar icons) \
        M(65,Normal,normal text) \
        M(66,Inverse,marked text) \
        M(67,Light,comment) \
        M(68,Light,reserved word) \
        M(69,Normal,identifier) \
        M(6A,Light,symbol) \
        M(6B,Light,string) \
        M(6C,Light,integer decimal) \
        M(6D,Light,float) \
        M(6E,Light,octal) \
        M(6F,Light,hex) \
        M(70,Light,character) \
        M(71,Light,preprocessor) \
        M(72,Inverse,illegal character) \
        M(73,Light,user reserved word) \
        M(74,Underline,CPU line) \
        M(75,Inverse,breakpoint) \
        M(76,Light,symbol2) \
        M(77,Inverse,cross cursor) \
        M(78,Inverse,editor statusline) \
        M(79,Inverse,matching paranthesis) \
        M(7A,Inverse,rectangular blocks) \
        \
        M(7B,Empty,resreved) \
        M(7C,Empty,reserved) \
        M(7D,Empty,reserved) \
        M(7E,Empty,reserved) \
        M(7F,Empty,reserved) \
        \
        M(80,Normal,passive frame, Used by blue editors) \
        M(81,Light,active frame) \
        M(82,Normal,frame icons) \
        M(83,Normal,scrollbar) \
        M(84,Normal,scrollbar icons) \
        M(85,Normal,normal text) \
        M(86,Inverse,marked text) \
        M(87,Light,comment) \
        M(88,Light,reserved word) \
        M(89,Normal,identifier) \
        M(8A,Light,symbol) \
        M(8B,Light,string) \
        M(8C,Light,integer decimal) \
        M(8D,Light,float) \
        M(8E,Light,octal) \
        M(8F,Light,hex) \
        M(90,Light,character) \
        M(91,Light,preprocessor) \
        M(92,Inverse,illegal character) \
        M(93,Light,user reserved word) \
        M(94,Underline,CPU line) \
        M(95,Inverse,breakpoint) \
        M(96,Light,symbol2) \
        M(97,Inverse,cross cursor) \
        M(98,Inverse,editor statusline) \
        M(99,Inverse,matching paranthesis) \
        M(9A,Inverse,rectangular blocks) \
        \
        M(9B,Empty,resreved) \
        M(9C,Empty,reserved) \
        M(9D,Empty,reserved) \
        M(9E,Empty,reserved) \
        M(9F,Empty,reserved) \
        \
        M(A0,Normal,passive frame, used by the help viewer) \
        M(A1,Light,active frame) \
        M(A2,Normal,Cyan,frame icons) \
        M(A3,Normal,scollbar) \
        M(A4,Normal,scrollbar icons) \
        M(A5,Normal,normal text) \
        M(A6,Underline,keyword) \
        M(A7,Inverse,selected keyword) \
        M(A8,Inverse,keyword in marked area) \
        M(A9,Inverse,marked text, currently fixed to "\0x70") \
        \
        M(AA,Empty,reserved) \
        M(AB,Empty,reserved) \
        M(AC,Empty,reserved) \
        M(AD,Empty,reserved) \
        M(AE,Empty,reserved) \
        M(AF,Empty,reserved)


#define cpIDEBlackWhite cpIDEColor


