This is Info file ld.info, produced by Makeinfo version 1.67 from the
input file ./ld.texinfo.

START-INFO-DIR-ENTRY
* Ld: (ld).                       The GNU linker.
END-INFO-DIR-ENTRY

   This file documents the GNU linker LD.

   Copyright (C) 1991, 92, 93, 94, 95, 96, 1997 Free Software
Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: ld.info,  Node: Option Commands,  Prev: Version Script,  Up: Commands

Option Commands
===============

   The command language includes a number of other commands that you can
use for specialized purposes.  They are similar in purpose to
command-line options.

`CONSTRUCTORS'
     When linking using the `a.out' object file format, the linker uses
     an unusual set construct to support C++ global constructors and
     destructors.  When linking object file formats which do not support
     arbitrary sections, such as `ECOFF' and `XCOFF', the linker will
     automatically recognize C++ global constructors and destructors by
     name.  For these object file formats, the `CONSTRUCTORS' command
     tells the linker where this information should be placed.  The
     `CONSTRUCTORS' command is ignored for other object file formats.

     The symbol `__CTOR_LIST__' marks the start of the global
     constructors, and the symbol `__DTOR_LIST' marks the end.  The
     first word in the list is the number of entries, followed by the
     address of each constructor or destructor, followed by a zero
     word.  The compiler must arrange to actually run the code.  For
     these object file formats GNU C++ calls constructors from a
     subroutine `__main'; a call to `__main' is automatically inserted
     into the startup code for `main'.  GNU C++ runs destructors either
     by using `atexit', or directly from the function `exit'.

     For object file formats such as `COFF' or `ELF' which support
     multiple sections, GNU C++ will normally arrange to put the
     addresses of global constructors and destructors into the `.ctors'
     and `.dtors' sections.  Placing the following sequence into your
     linker script will build the sort of table which the GNU C++
     runtime code expects to see.

                __CTOR_LIST__ = .;
                LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
                *(.ctors)
                LONG(0)
                __CTOR_END__ = .;
                __DTOR_LIST__ = .;
                LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
                *(.dtors)
                LONG(0)
                __DTOR_END__ = .;

     Normally the compiler and linker will handle these issues
     automatically, and you will not need to concern yourself with
     them.  However, you may need to consider this if you are using C++
     and writing your own linker scripts.

`FLOAT'
`NOFLOAT'
     These keywords were used in some older linkers to request a
     particular math subroutine library.  `ld' doesn't use the
     keywords, assuming instead that any necessary subroutines are in
     libraries specified using the general mechanisms for linking to
     archives; but to permit the use of scripts that were written for
     the older linkers, the keywords `FLOAT' and `NOFLOAT' are accepted
     and ignored.

`FORCE_COMMON_ALLOCATION'
     This command has the same effect as the `-d' command-line option:
     to make `ld' assign space to common symbols even if a relocatable
     output file is specified (`-r').

`INCLUDE FILENAME'
     Include the linker script FILENAME at this point.  The file will
     be searched for in the current directory, and in any directory
     specified with the `-L' option.  You can nest calls to `INCLUDE'
     up to 10 levels deep.

`INPUT ( FILE, FILE, ... )'
`INPUT ( FILE FILE ... )'
     Use this command to include binary input files in the link, without
     including them in a particular section definition.  Specify the
     full name for each FILE, including `.a' if required.

     `ld' searches for each FILE through the archive-library search
     path, just as for files you specify on the command line.  See the
     description of `-L' in *Note Command Line Options: Options.

     If you use `-lFILE', `ld' will transform the name to `libFILE.a'
     as with the command line argument `-l'.

`GROUP ( FILE, FILE, ... )'
`GROUP ( FILE FILE ... )'
     This command is like `INPUT', except that the named files should
     all be archives, and they are searched repeatedly until no new
     undefined references are created.  See the description of `-(' in
     *Note Command Line Options: Options.

`OUTPUT ( FILENAME )'
     Use this command to name the link output file FILENAME.  The
     effect of `OUTPUT(FILENAME)' is identical to the effect of
     `-o FILENAME', which overrides it.  You can use this command to
     supply a default output-file name other than `a.out'.

`OUTPUT_ARCH ( BFDNAME )'
     Specify a particular output machine architecture, with one of the
     names used by the BFD back-end routines (*note BFD::.).  This
     command is often unnecessary; the architecture is most often set
     implicitly by either the system BFD configuration or as a side
     effect of the `OUTPUT_FORMAT' command.

`OUTPUT_FORMAT ( BFDNAME )'
     When `ld' is configured to support multiple object code formats,
     you can use this command to specify a particular output format.
     BFDNAME is one of the names used by the BFD back-end routines
     (*note BFD::.).  The effect is identical to the effect of the
     `--oformat' command-line option.  This selection affects only the
     output file; the related command `TARGET' affects primarily input
     files.

`SEARCH_DIR ( PATH )'
     Add PATH to the list of paths where `ld' looks for archive
     libraries.  `SEARCH_DIR(PATH)' has the same effect as `-LPATH' on
     the command line.

`STARTUP ( FILENAME )'
     Ensure that FILENAME is the first input file used in the link
     process.

`TARGET ( FORMAT )'
     When `ld' is configured to support multiple object code formats,
     you can use this command to change the input-file object code
     format (like the command-line option `-b' or its synonym
     `--format').  The argument FORMAT is one of the strings used by
     BFD to name binary formats.  If `TARGET' is specified but
     `OUTPUT_FORMAT' is not, the last `TARGET' argument is also used as
     the default format for the `ld' output file.  *Note BFD::.

     If you don't use the `TARGET' command, `ld' uses the value of the
     environment variable `GNUTARGET', if available, to select the
     output file format.  If that variable is also absent, `ld' uses
     the default format configured for your machine in the BFD
     libraries.

`NOCROSSREFS ( SECTION SECTION ... )'
     This command may be used to tell `ld' to issue an error about any
     references among certain sections.

     In certain types of programs, particularly on embedded systems,
     when one section is loaded into memory, another section will not
     be.  Any direct references between the two sections would be
     errors.  For example, it would be an error if code in one section
     called a function defined in the other section.

     The `NOCROSSREFS' command takes a list of section names.  If `ld'
     detects any cross references between the sections, it reports an
     error and returns a non-zero exit status.  The `NOCROSSREFS'
     command uses output section names, defined in the `SECTIONS'
     command.  It does not use the names of input sections.


File: ld.info,  Node: Machine Dependent,  Next: BFD,  Prev: Commands,  Up: Top

Machine Dependent Features
**************************

   `ld' has additional features on some platforms; the following
sections describe them.  Machines where `ld' has no additional
functionality are not listed.

* Menu:

* H8/300::                      `ld' and the H8/300
* i960::                        `ld' and the Intel 960 family


File: ld.info,  Node: H8/300,  Next: i960,  Up: Machine Dependent

`ld' and the H8/300
===================

   For the H8/300, `ld' can perform these global optimizations when you
specify the `--relax' command-line option.

*relaxing address modes*
     `ld' finds all `jsr' and `jmp' instructions whose targets are
     within eight bits, and turns them into eight-bit program-counter
     relative `bsr' and `bra' instructions, respectively.

*synthesizing instructions*
     `ld' finds all `mov.b' instructions which use the sixteen-bit
     absolute address form, but refer to the top page of memory, and
     changes them to use the eight-bit address form.  (That is: the
     linker turns `mov.b `@'AA:16' into `mov.b `@'AA:8' whenever the
     address AA is in the top page of memory).


File: ld.info,  Node: i960,  Prev: H8/300,  Up: Machine Dependent

`ld' and the Intel 960 family
=============================

   You can use the `-AARCHITECTURE' command line option to specify one
of the two-letter names identifying members of the 960 family; the
option specifies the desired output target, and warns of any
incompatible instructions in the input files.  It also modifies the
linker's search strategy for archive libraries, to support the use of
libraries specific to each particular architecture, by including in the
search loop names suffixed with the string identifying the architecture.

   For example, if your `ld' command line included `-ACA' as well as
`-ltry', the linker would look (in its built-in search paths, and in
any paths you specify with `-L') for a library with the names

     try
     libtry.a
     tryca
     libtryca.a

The first two possibilities would be considered in any event; the last
two are due to the use of `-ACA'.

   You can meaningfully use `-A' more than once on a command line, since
the 960 architecture family allows combination of target architectures;
each use will add another pair of name variants to search for when `-l'
specifies a library.

   `ld' supports the `--relax' option for the i960 family.  If you
specify `--relax', `ld' finds all `balx' and `calx' instructions whose
targets are within 24 bits, and turns them into 24-bit program-counter
relative `bal' and `cal' instructions, respectively.  `ld' also turns
`cal' instructions into `bal' instructions when it determines that the
target subroutine is a leaf routine (that is, the target subroutine does
not itself call any subroutines).


File: ld.info,  Node: BFD,  Next: Reporting Bugs,  Prev: Machine Dependent,  Up: Top

BFD
***

   The linker accesses object and archive files using the BFD libraries.
These libraries allow the linker to use the same routines to operate on
object files whatever the object file format.  A different object file
format can be supported simply by creating a new BFD back end and adding
it to the library.  To conserve runtime memory, however, the linker and
associated tools are usually configured to support only a subset of the
object file formats available.  You can use `objdump -i' (*note
objdump: (binutils.info)objdump.) to list all the formats available for
your configuration.

   As with most implementations, BFD is a compromise between several
conflicting requirements. The major factor influencing BFD design was
efficiency: any time used converting between formats is time which
would not have been spent had BFD not been involved. This is partly
offset by abstraction payback; since BFD simplifies applications and
back ends, more time and care may be spent optimizing algorithms for a
greater speed.

   One minor artifact of the BFD solution which you should bear in mind
is the potential for information loss.  There are two places where
useful information can be lost using the BFD mechanism: during
conversion and during output. *Note BFD information loss::.

* Menu:

* BFD outline::                 How it works: an outline of BFD


File: ld.info,  Node: BFD outline,  Up: BFD

How it works: an outline of BFD
===============================

   When an object file is opened, BFD subroutines automatically
determine the format of the input object file.  They then build a
descriptor in memory with pointers to routines that will be used to
access elements of the object file's data structures.

   As different information from the the object files is required, BFD
reads from different sections of the file and processes them.  For
example, a very common operation for the linker is processing symbol
tables.  Each BFD back end provides a routine for converting between
the object file's representation of symbols and an internal canonical
format. When the linker asks for the symbol table of an object file, it
calls through a memory pointer to the routine from the relevant BFD
back end which reads and converts the table into a canonical form.  The
linker then operates upon the canonical form. When the link is finished
and the linker writes the output file's symbol table, another BFD back
end routine is called to take the newly created symbol table and
convert it into the chosen output format.

* Menu:

* BFD information loss::	Information Loss
* Canonical format::		The BFD	canonical object-file format


File: ld.info,  Node: BFD information loss,  Next: Canonical format,  Up: BFD outline

Information Loss
----------------

   *Information can be lost during output.* The output formats
supported by BFD do not provide identical facilities, and information
which can be described in one form has nowhere to go in another format.
One example of this is alignment information in `b.out'. There is
nowhere in an `a.out' format file to store alignment information on the
contained data, so when a file is linked from `b.out' and an `a.out'
image is produced, alignment information will not propagate to the
output file. (The linker will still use the alignment information
internally, so the link is performed correctly).

   Another example is COFF section names. COFF files may contain an
unlimited number of sections, each one with a textual section name. If
the target of the link is a format which does not have many sections
(e.g., `a.out') or has sections without names (e.g., the Oasys format),
the link cannot be done simply. You can circumvent this problem by
describing the desired input-to-output section mapping with the linker
command language.

   *Information can be lost during canonicalization.* The BFD internal
canonical form of the external formats is not exhaustive; there are
structures in input formats for which there is no direct representation
internally.  This means that the BFD back ends cannot maintain all
possible data richness through the transformation between external to
internal and back to external formats.

   This limitation is only a problem when an application reads one
format and writes another.  Each BFD back end is responsible for
maintaining as much data as possible, and the internal BFD canonical
form has structures which are opaque to the BFD core, and exported only
to the back ends. When a file is read in one format, the canonical form
is generated for BFD and the application. At the same time, the back
end saves away any information which may otherwise be lost. If the data
is then written back in the same format, the back end routine will be
able to use the canonical form provided by the BFD core as well as the
information it prepared earlier.  Since there is a great deal of
commonality between back ends, there is no information lost when
linking or copying big endian COFF to little endian COFF, or `a.out' to
`b.out'.  When a mixture of formats is linked, the information is only
lost from the files whose format differs from the destination.


File: ld.info,  Node: Canonical format,  Prev: BFD information loss,  Up: BFD outline

The BFD canonical object-file format
------------------------------------

   The greatest potential for loss of information occurs when there is
the least overlap between the information provided by the source
format, that stored by the canonical format, and that needed by the
destination format. A brief description of the canonical form may help
you understand which kinds of data you can count on preserving across
conversions.

*files*
     Information stored on a per-file basis includes target machine
     architecture, particular implementation format type, a demand
     pageable bit, and a write protected bit.  Information like Unix
     magic numbers is not stored here--only the magic numbers' meaning,
     so a `ZMAGIC' file would have both the demand pageable bit and the
     write protected text bit set.  The byte order of the target is
     stored on a per-file basis, so that big- and little-endian object
     files may be used with one another.

*sections*
     Each section in the input file contains the name of the section,
     the section's original address in the object file, size and
     alignment information, various flags, and pointers into other BFD
     data structures.

*symbols*
     Each symbol contains a pointer to the information for the object
     file which originally defined it, its name, its value, and various
     flag bits.  When a BFD back end reads in a symbol table, it
     relocates all symbols to make them relative to the base of the
     section where they were defined.  Doing this ensures that each
     symbol points to its containing section.  Each symbol also has a
     varying amount of hidden private data for the BFD back end.  Since
     the symbol points to the original file, the private data format
     for that symbol is accessible.  `ld' can operate on a collection
     of symbols of wildly different formats without problems.

     Normal global and simple local symbols are maintained on output,
     so an output file (no matter its format) will retain symbols
     pointing to functions and to global, static, and common variables.
     Some symbol information is not worth retaining; in `a.out', type
     information is stored in the symbol table as long symbol names.
     This information would be useless to most COFF debuggers; the
     linker has command line switches to allow users to throw it away.

     There is one word of type information within the symbol, so if the
     format supports symbol type information within symbols (for
     example, COFF, IEEE, Oasys) and the type is simple enough to fit
     within one word (nearly everything but aggregates), the
     information will be preserved.

*relocation level*
     Each canonical BFD relocation record contains a pointer to the
     symbol to relocate to, the offset of the data to relocate, the
     section the data is in, and a pointer to a relocation type
     descriptor. Relocation is performed by passing messages through
     the relocation type descriptor and the symbol pointer. Therefore,
     relocations can be performed on output data using a relocation
     method that is only available in one of the input formats. For
     instance, Oasys provides a byte relocation format.  A relocation
     record requesting this relocation type would point indirectly to a
     routine to perform this, so the relocation may be performed on a
     byte being written to a 68k COFF file, even though 68k COFF has no
     such relocation type.

*line numbers*
     Object formats can contain, for debugging purposes, some form of
     mapping between symbols, source line numbers, and addresses in the
     output file.  These addresses have to be relocated along with the
     symbol information.  Each symbol with an associated list of line
     number records points to the first record of the list.  The head
     of a line number list consists of a pointer to the symbol, which
     allows finding out the address of the function whose line number
     is being described. The rest of the list is made up of pairs:
     offsets into the section and line numbers. Any format which can
     simply derive this information can pass it successfully between
     formats (COFF, IEEE and Oasys).


File: ld.info,  Node: Reporting Bugs,  Next: MRI,  Prev: BFD,  Up: Top

Reporting Bugs
**************

   Your bug reports play an essential role in making `ld' reliable.

   Reporting a bug may help you by bringing a solution to your problem,
or it may not.  But in any case the principal function of a bug report
is to help the entire community by making the next version of `ld' work
better.  Bug reports are your contribution to the maintenance of `ld'.

   In order for a bug report to serve its purpose, you must include the
information that enables us to fix the bug.

* Menu:

* Bug Criteria::                Have you found a bug?
* Bug Reporting::               How to report bugs


File: ld.info,  Node: Bug Criteria,  Next: Bug Reporting,  Up: Reporting Bugs

Have you found a bug?
=====================

   If you are not sure whether you have found a bug, here are some
guidelines:

   * If the linker gets a fatal signal, for any input whatever, that is
     a `ld' bug.  Reliable linkers never crash.

   * If `ld' produces an error message for valid input, that is a bug.

   * If `ld' does not produce an error message for invalid input, that
     may be a bug.  In the general case, the linker can not verify that
     object files are correct.

   * If you are an experienced user of linkers, your suggestions for
     improvement of `ld' are welcome in any case.


File: ld.info,  Node: Bug Reporting,  Prev: Bug Criteria,  Up: Reporting Bugs

How to report bugs
==================

   A number of companies and individuals offer support for GNU
products.  If you obtained `ld' from a support organization, we
recommend you contact that organization first.

   You can find contact information for many support companies and
individuals in the file `etc/SERVICE' in the GNU Emacs distribution.

   In any event, we also recommend that you send bug reports for `ld'
to `bug-gnu-utils@prep.ai.mit.edu'.

   The fundamental principle of reporting bugs usefully is this:
*report all the facts*.  If you are not sure whether to state a fact or
leave it out, state it!

   Often people omit facts because they think they know what causes the
problem and assume that some details do not matter.  Thus, you might
assume that the name of a symbol you use in an example does not matter.
Well, probably it does not, but one cannot be sure.  Perhaps the bug is
a stray memory reference which happens to fetch from the location where
that name is stored in memory; perhaps, if the name were different, the
contents of that location would fool the linker into doing the right
thing despite the bug.  Play it safe and give a specific, complete
example.  That is the easiest thing for you to do, and the most helpful.

   Keep in mind that the purpose of a bug report is to enable us to fix
the bug if it is new to us.  Therefore, always write your bug reports
on the assumption that the bug has not been reported previously.

   Sometimes people give a few sketchy facts and ask, "Does this ring a
bell?"  Those bug reports are useless, and we urge everyone to *refuse
to respond to them* except to chide the sender to report bugs properly.

   To enable us to fix the bug, you should include all these things:

   * The version of `ld'.  `ld' announces it if you start it with the
     `--version' argument.

     Without this, we will not know whether there is any point in
     looking for the bug in the current version of `ld'.

   * Any patches you may have applied to the `ld' source, including any
     patches made to the `BFD' library.

   * The type of machine you are using, and the operating system name
     and version number.

   * What compiler (and its version) was used to compile `ld'--e.g.
     "`gcc-2.7'".

   * The command arguments you gave the linker to link your example and
     observe the bug.  To guarantee you will not omit something
     important, list them all.  A copy of the Makefile (or the output
     from make) is sufficient.

     If we were to try to guess the arguments, we would probably guess
     wrong and then we might not encounter the bug.

   * A complete input file, or set of input files, that will reproduce
     the bug.  It is generally most helpful to send the actual object
     files, uuencoded if necessary to get them through the mail system.
     Making them available for anonymous FTP is not as good, but may
     be the only reasonable choice for large object files.

     If the source files were assembled using `gas' or compiled using
     `gcc', then it may be OK to send the source files rather than the
     object files.  In this case, be sure to say exactly what version of
     `gas' or `gcc' was used to produce the object files.  Also say how
     `gas' or `gcc' were configured.

   * A description of what behavior you observe that you believe is
     incorrect.  For example, "It gets a fatal signal."

     Of course, if the bug is that `ld' gets a fatal signal, then we
     will certainly notice it.  But if the bug is incorrect output, we
     might not notice unless it is glaringly wrong.  You might as well
     not give us a chance to make a mistake.

     Even if the problem you experience is a fatal signal, you should
     still say so explicitly.  Suppose something strange is going on,
     such as, your copy of `ld' is out of synch, or you have
     encountered a bug in the C library on your system.  (This has
     happened!)  Your copy might crash and ours would not.  If you told
     us to expect a crash, then when ours fails to crash, we would know
     that the bug was not happening for us.  If you had not told us to
     expect a crash, then we would not be able to draw any conclusion
     from our observations.

   * If you wish to suggest changes to the `ld' source, send us context
     diffs, as generated by `diff' with the `-u', `-c', or `-p' option.
     Always send diffs from the old file to the new file.  If you even
     discuss something in the `ld' source, refer to it by context, not
     by line number.

     The line numbers in our development sources will not match those
     in your sources.  Your line numbers would convey no useful
     information to us.

   Here are some things that are not necessary:

   * A description of the envelope of the bug.

     Often people who encounter a bug spend a lot of time investigating
     which changes to the input file will make the bug go away and which
     changes will not affect it.

     This is often time consuming and not very useful, because the way
     we will find the bug is by running a single example under the
     debugger with breakpoints, not by pure deduction from a series of
     examples.  We recommend that you save your time for something else.

     Of course, if you can find a simpler example to report *instead*
     of the original one, that is a convenience for us.  Errors in the
     output will be easier to spot, running under the debugger will take
     less time, and so on.

     However, simplification is not vital; if you do not want to do
     this, report the bug anyway and send us the entire test case you
     used.

   * A patch for the bug.

     A patch for the bug does help us if it is a good one.  But do not
     omit the necessary information, such as the test case, on the
     assumption that a patch is all we need.  We might see problems
     with your patch and decide to fix the problem another way, or we
     might not understand it at all.

     Sometimes with a program as complicated as `ld' it is very hard to
     construct an example that will make the program follow a certain
     path through the code.  If you do not send us the example, we will
     not be able to construct one, so we will not be able to verify
     that the bug is fixed.

     And if we cannot understand what bug you are trying to fix, or why
     your patch should be an improvement, we will not install it.  A
     test case will help us to understand.

   * A guess about what the bug is or what it depends on.

     Such guesses are usually wrong.  Even we cannot guess right about
     such things without first using the debugger to find the facts.


File: ld.info,  Node: MRI,  Next: Index,  Prev: Reporting Bugs,  Up: Top

MRI Compatible Script Files
***************************

   To aid users making the transition to GNU `ld' from the MRI linker,
`ld' can use MRI compatible linker scripts as an alternative to the
more general-purpose linker scripting language described in *Note
Command Language: Commands.  MRI compatible linker scripts have a much
simpler command set than the scripting language otherwise used with
`ld'.  GNU `ld' supports the most commonly used MRI linker commands;
these commands are described here.

   In general, MRI scripts aren't of much use with the `a.out' object
file format, since it only has three sections and MRI scripts lack some
features to make use of them.

   You can specify a file containing an MRI-compatible script using the
`-c' command-line option.

   Each command in an MRI-compatible script occupies its own line; each
command line starts with the keyword that identifies the command (though
blank lines are also allowed for punctuation).  If a line of an
MRI-compatible script begins with an unrecognized keyword, `ld' issues
a warning message, but continues processing the script.

   Lines beginning with `*' are comments.

   You can write these commands using all upper-case letters, or all
lower case; for example, `chip' is the same as `CHIP'.  The following
list shows only the upper-case form of each command.

`ABSOLUTE SECNAME'
`ABSOLUTE SECNAME, SECNAME, ... SECNAME'
     Normally, `ld' includes in the output file all sections from all
     the input files.  However, in an MRI-compatible script, you can
     use the `ABSOLUTE' command to restrict the sections that will be
     present in your output program.  If the `ABSOLUTE' command is used
     at all in a script, then only the sections named explicitly in
     `ABSOLUTE' commands will appear in the linker output.  You can
     still use other input sections (whatever you select on the command
     line, or using `LOAD') to resolve addresses in the output file.

`ALIAS OUT-SECNAME, IN-SECNAME'
     Use this command to place the data from input section IN-SECNAME
     in a section called OUT-SECNAME in the linker output file.

     IN-SECNAME may be an integer.

`ALIGN SECNAME = EXPRESSION'
     Align the section called SECNAME to EXPRESSION.  The EXPRESSION
     should be a power of two.

`BASE EXPRESSION'
     Use the value of EXPRESSION as the lowest address (other than
     absolute addresses) in the output file.

`CHIP EXPRESSION'
`CHIP EXPRESSION, EXPRESSION'
     This command does nothing; it is accepted only for compatibility.

`END'
     This command does nothing whatever; it's only accepted for
     compatibility.

`FORMAT OUTPUT-FORMAT'
     Similar to the `OUTPUT_FORMAT' command in the more general linker
     language, but restricted to one of these output formats:

       1. S-records, if OUTPUT-FORMAT is `S'

       2. IEEE, if OUTPUT-FORMAT is `IEEE'

       3. COFF (the `coff-m68k' variant in BFD), if OUTPUT-FORMAT is
          `COFF'

`LIST ANYTHING...'
     Print (to the standard output file) a link map, as produced by the
     `ld' command-line option `-M'.

     The keyword `LIST' may be followed by anything on the same line,
     with no change in its effect.

`LOAD FILENAME'
`LOAD FILENAME, FILENAME, ... FILENAME'
     Include one or more object file FILENAME in the link; this has the
     same effect as specifying FILENAME directly on the `ld' command
     line.

`NAME OUTPUT-NAME'
     OUTPUT-NAME is the name for the program produced by `ld'; the
     MRI-compatible command `NAME' is equivalent to the command-line
     option `-o' or the general script language command `OUTPUT'.

`ORDER SECNAME, SECNAME, ... SECNAME'
`ORDER SECNAME SECNAME SECNAME'
     Normally, `ld' orders the sections in its output file in the order
     in which they first appear in the input files.  In an
     MRI-compatible script, you can override this ordering with the
     `ORDER' command.  The sections you list with `ORDER' will appear
     first in your output file, in the order specified.

`PUBLIC NAME=EXPRESSION'
`PUBLIC NAME,EXPRESSION'
`PUBLIC NAME EXPRESSION'
     Supply a value (EXPRESSION) for external symbol NAME used in the
     linker input files.

`SECT SECNAME, EXPRESSION'
`SECT SECNAME=EXPRESSION'
`SECT SECNAME EXPRESSION'
     You can use any of these three forms of the `SECT' command to
     specify the start address (EXPRESSION) for section SECNAME.  If
     you have more than one `SECT' statement for the same SECNAME, only
     the *first* sets the start address.

