

FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


NNNAAAMMMEEE
     find - search for files in a directory hierarchy

SSSYYYNNNOOOPPPSSSIIISSS
     fffiiinnnddd [path...] [expression]

DDDEEESSSCCCRRRIIIPPPTTTIIIOOONNN
     This manual page documents the GNU version of fffiiinnnddd.   fffiiinnnddd  searches  the
     directory  tree  rooted  at  each given file name by evaluating the given
     expression from left to right, according to the rules of precedence  (see
     section  OPERATORS),  until  the  outcome is known (the left hand side is
     false for _a_n_d operations, true for _o_r), at which point fffiiinnnddd moves  on  to
     the next file name.

     The first argument that begins with `-', `(', `)', `,', or `!'  is  taken
     to  be the beginning of the expression; any arguments before it are paths
     to search, and any arguments after it are the rest of the expression.  If
     no  paths  are given, the current directory is used.  If no expression is
     given, the expression `-print' is used.

     fffiiinnnddd exits with status 0 if all files are processed successfully, greater
     than 0 if errors occur.

EEEXXXPPPRRREEESSSSSSIIIOOONNNSSS

     The expression is made up of  options  (which  affect  overall  operation
     rather  than  the processing of a specific file, and always return true),
     tests (which return a true or false value), and actions (which have  side
     effects  and  return  a true or false value), all separated by operators.
     -and is assumed  where  the  operator  is  omitted.   If  the  expression
     contains  no  actions other than -prune, -print is performed on all files
     for which the expression is true.

     OOOPPPTTTIIIOOONNNSSS

     All options always return true.  They always  take  effect,  rather  than
     being  processed  only  when  their  place  in the expression is reached.
     Therefore, for clarity, it is best to place them at the beginning of  the
     expression.

     -daystart
          Measure times (for -amin, -atime, -cmin, -ctime, -mmin, and  -mtime)
          from the beginning of today rather than from 24 hours ago.

     -depth
          Process each directory's contents before the directory itself.

     -follow
          Dereference symbolic links.  Implies -noleaf.

     -help, --help
          Print a summary of the command-line usage of fffiiinnnddd and exit.

     -maxdepth _l_e_v_e_l_s
          Descend  at  most  _l_e_v_e_l_s  (a  non-negative   integer)   levels   of
          directories  below  the command line arguments.  `-maxdepth 0' means


                                      \                                      1



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


          only apply the tests and actions to the command line arguments.

     -mindepth _l_e_v_e_l_s
          Do not apply any tests or actions at levels less than _l_e_v_e_l_s (a non-
          negative integer).  `-mindepth 1' means process all files except the
          command line arguments.

     -mount
          Don't descend directories on other filesystems.  An  alternate  name
          for -xdev, for compatibility with some other versions of fffiiinnnddd.

     -noleaf
          Do not  optimize  by  assuming  that  directories  contain  2  fewer
          subdirectories  than  their  hard link count.  This option is needed
          when searching filesystems that do not follow  the  Unix  directory-
          link  convention, such as CD-ROM or MS-DOS filesystems or AFS volume
          mount points.  Each directory on a normal  Unix  filesystem  has  at
          least  2 hard links: its name and its `.'  entry.  Additionally, its
          subdirectories (if any) each have  a  `..'   entry  linked  to  that
          directory.  When fffiiinnnddd is examining a directory, after it has statted
          2 fewer subdirectories than the directory's  link  count,  it  knows
          that  the  rest  of the entries in the directory are non-directories
          (`leaf' files in the directory tree).  If only the files' names need
          to  be  examined,  there  is  no  need  to  stat  them; this gives a
          significant increase in search speed.

     -version, --version
          Print the fffiiinnnddd version number and exit.

     -xdev
          Don't descend directories on other filesystems.

     TTTEEESSSTTTSSS

     Numeric arguments can be specified as

     +_n   for greater than _n,

     -_n   for less than _n,

     _n    for exactly _n.

     -amin _n
          File was last accessed _n minutes ago.

     -anewer _f_i_l_e
          File was  last  accessed  more  recently  than  _f_i_l_e  was  modified.
          -anewer  is affected by -follow only if -follow comes before -anewer
          on the command line.

     -atime _n
          File was last accessed _n*24 hours ago.

     -cmin _n
          File's status was last changed _n minutes ago.



                                      \                                      2



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     -cnewer _f_i_l_e
          File's status was last changed more recently than _f_i_l_e was modified.
          -cnewer  is affected by -follow only if -follow comes before -cnewer
          on the command line.

     -ctime _n
          File's status was last changed _n*24 hours ago.

     -empty
          File is empty and is either a regular file or a directory.

     -false
          Always false.

     -fstype _t_y_p_e
          File is on a filesystem of type _t_y_p_e.  The  valid  filesystem  types
          vary  among  different  versions  of  Unix;  an  incomplete  list of
          filesystem types that are  accepted  on  some  version  of  Unix  or
          another  is:  ufs, 4.2, 4.3, nfs, tmp, mfs, S51K, S52K.  You can use
          -printf with the %F directive to see the types of your filesystems.

     -gid _n
          File's numeric group ID is _n.

     -group _g_n_a_m_e
          File belongs to group _g_n_a_m_e (numeric group ID allowed).

     -ilname _p_a_t_t_e_r_n
          Like -lname, but the match is case insensitive.

     -iname _p_a_t_t_e_r_n
          Like -name, but the match is case  insensitive.   For  example,  the
          patterns  `fo*'  and `F??' match the file names `Foo', `FOO', `foo',
          `fOo', etc.

     -inum _n
          File has inode number _n.

     -ipath _p_a_t_t_e_r_n
          Like -path, but the match is case insensitive.

     -iregex _p_a_t_t_e_r_n
          Like -regex, but the match is case insensitive.

     -links _n
          File has _n links.

     -lname _p_a_t_t_e_r_n
          File is a symbolic link whose contents match shell pattern  _p_a_t_t_e_r_n.
          The metacharacters do not treat `/' or `.' specially.

     -mmin _n
          File's data was last modified _n minutes ago.





                                      \                                      3



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     -mtime _n
          File's data was last modified _n*24 hours ago.

     -name _p_a_t_t_e_r_n
          Base of file name (the path with the  leading  directories  removed)
          matches  shell  pattern  _p_a_t_t_e_r_n.  The metacharacters (`*', `?', and
          `[]') do not match a `.' at the start of the base name.  To ignore a
          directory  and the files under it, use -prune; see an example in the
          description of -path.

     -newer _f_i_l_e
          File was modified more recently than _f_i_l_e.  -newer  is  affected  by
          -follow only if -follow comes before -newer on the command line.

     -nouser
          No user corresponds to file's numeric user ID.

     -nogroup
          No group corresponds to file's numeric group ID.

     -path _p_a_t_t_e_r_n
          File name matches shell pattern _p_a_t_t_e_r_n.  The metacharacters do  not
          treat `/' or `.' specially; so, for example,
                      find . -path './sr*sc'
          will print an entry for a  directory  called  './src/misc'  (if  one
          exists).   To  ignore a whole directory tree, use -prune rather than
          checking every file in the tree.  For example, to skip the directory
          `src/emacs'  and  all  files and directories under it, and print the
          names of the other files found, do something like this:
                      find . -path './src/emacs' -prune -o -print

     -perm _m_o_d_e
          File's  permission  bits  are  exactly  _m_o_d_e  (octal  or  symbolic).
          Symbolic modes use mode 0 as a point of departure.

     -perm -_m_o_d_e
          All of the permission bits _m_o_d_e are set for the file.

     -perm +_m_o_d_e
          Any of the permission bits _m_o_d_e are set for the file.

     -regex _p_a_t_t_e_r_n
          File name matches regular expression _p_a_t_t_e_r_n.  This is  a  match  on
          the  whole  path,  not a search.  For example, to match a file named
          `./fubar3', you can use the regular expression `.*bar.' or `.*b.*3',
          but not `b.*r3'.

     -size _n[bckw]
          File uses _n units of  space.   The  units  are  512-byte  blocks  by
          default  or  if  `b' follows _n, bytes if `c' follows _n, kilobytes if
          `k' follows _n, or 2-byte words if `w' follows _n.  The size does  not
          count indirect blocks, but it does count blocks in sparse files that
          are not actually allocated.





                                      \                                      4



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     -true
          Always true.

     -type _c
          File is of type _c:

     b    block (buffered) special

     c    character (unbuffered) special

     d    directory

     p    named pipe (FIFO)

     f    regular file

     l    symbolic link

     s    socket

     -uid _n
          File's numeric user ID is _n.

     -used _n
          File was last accessed _n days after its status was last changed.

     -user _u_n_a_m_e
          File is owned by user _u_n_a_m_e (numeric user ID allowed).

     -xtype _c
          The same as -type unless the file is a symbolic link.  For  symbolic
          links:  if -follow has not been given, true if the file is a link to
          a file of type _c; if -follow has been given, true if _c is  `l'.   In
          other  words, for symbolic links, -xtype checks the type of the file
          that -type does not check.

     AAACCCTTTIIIOOONNNSSS

     -exec _c_o_m_m_a_n_d ;
          Execute _c_o_m_m_a_n_d; true  if  0  status  is  returned.   All  following
          arguments  to fffiiinnnddd are taken to be arguments to the command until an
          argument consisting of `;'  is  encountered.   The  string  `{}'  is
          replaced  by  the  current  file  name being processed everywhere it
          occurs in the arguments to the command, not just in arguments  where
          it   is  alone,  as  in  some  versions  of  fffiiinnnddd.   Both  of  these
          constructions might need to be escaped (with a  `\')  or  quoted  to
          protect  them  from expansion by the shell.  The command is executed
          in the starting directory.

     -dosexec _c_o_m_m_a_n_d ;
          Like -exec, but all the slashes in the  filename  are  converted  to
          DOS-style  backslashes.  This should be used with DOS prograns which
          don't understand pathnames with Unix-style  forward  slashes.   Note
          that  this  option  is  currently implemented in a way that makes it
          effect global: it also affects any -exec or -ok options that  follow
          -dosexec on the command line.


                                      \                                      5



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     -fls _f_i_l_e
          True; like -ls but write to _f_i_l_e like -fprint.

     -fprint _f_i_l_e
          True; print the full file name into file _f_i_l_e.   If  _f_i_l_e  does  not
          exist  when  fffiiinnnddd  is  run,  it  is created; if it does exist, it is
          truncated.  The file names ``/dev/stdout'' and  ``/dev/stderr''  are
          handled  specially;  they  refer to the standard output and standard
          error output, respectively.

     -fprint0 _f_i_l_e
          True; like -print0 but write to _f_i_l_e like -fprint.

     -fprintf _f_i_l_e _f_o_r_m_a_t
          True; like -printf but write to _f_i_l_e like -fprint.

     -ok _c_o_m_m_a_n_d ;
          Like -exec but ask the user first (on the standard  input);  if  the
          response does not start with `y' or `Y', do not run the command, and
          return false.

     -dosok _c_o_m_m_a_n_d ;
          Like -ok, but all the slashes in the filename are converted to  DOS-
          style  backslashes.   This  should  be  used with DOS prograns which
          don't understand pathnames with Unix-style  forward  slashes.   Note
          that  this  option  is  currently implemented in a way that makes it
          effect global: it also affects any -ok or -exec options that  follow
          -dosok on the command line.

     -print
          True; print the full file name on the standard output, followed by a
          newline.

     -print0
          True; print the full file name on the standard output, followed by a
          null  character.  This allows file names that contain newlines to be
          correctly interpreted by programs that process the fffiiinnnddd output.

     -printf _f_o_r_m_a_t
          True; print _f_o_r_m_a_t on the standard output, interpreting `\'  escapes
          and `%' directives.  Field widths and precisions can be specified as
          with the `printf' C function.  Unlike -print, -printf does not add a
          newline at the end of the string.  The escapes and directives are:

     \a   Alarm bell.

     \b   Backspace.

     \c   Stop printing from this format immediately and flush the output.

     \f   Form feed.

     \n   Newline.





                                      \                                      6



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     \r   Carriage return.

     \t   Horizontal tab.

     \v   Vertical tab.

     \\   A literal backslash (`\').

     A `\' character followed by any other character is treated as an ordinary
     character, so they both are printed.

     %%   A literal percent sign.

     %a   File's last access time in the format  returned  by  the  C  `ctime'
          function.

     %A_k  File's last access time in the  format  specified  by  _k,  which  is
          either  `@'  or  a  directive  for  the  C `strftime' function.  The
          possible values for _k are listed below; some of them  might  not  be
          available  on  all systems, due to differences in `strftime' between
          systems.

     @    seconds since Jan. 1, 1970, 00:00 GMT.

     Time fields:

     H    hour (00..23)

     I    hour (01..12)

     k    hour ( 0..23)

     l    hour ( 1..12)

     M    minute (00..59)

     p    locale's AM or PM

     r    time, 12-hour (hh:mm:ss [AP]M)

     S    second (00..61)

     T    time, 24-hour (hh:mm:ss)

     X    locale's time representation (H:M:S)

     Z    time zone (e.g., EDT), or nothing if no time zone is determinable

     Date fields:

     a    locale's abbreviated weekday name (Sun..Sat)

     A    locale's full weekday name, variable length (Sunday..Saturday)





                                      \                                      7



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     b    locale's abbreviated month name (Jan..Dec)

     B    locale's full month name, variable length (January..December)

     c    locale's date and time (Sat Nov 04 12:02:33 EST 1989)

     d    day of month (01..31)

     D    date (mm/dd/yy)

     h    same as b

     j    day of year (001..366)

     m    month (01..12)

     U    week number of year with Sunday as first day of week (00..53)

     w    day of week (0..6)

     W    week number of year with Monday as first day of week (00..53)

     x    locale's date representation (mm/dd/yy)

     y    last two digits of year (00..99)

     Y    year (1970...)

     %b   File's size in 512-byte blocks (rounded up).

     %c   File's last status change time in  the  format  returned  by  the  C
          `ctime' function.

     %C_k  File's last status change time in the format specified by  _k,  which
          is the same as for %A.

     %d   File's depth in the directory tree; 0 means the file  is  a  command
          line argument.

     %f   File's name with any leading  directories  removed  (only  the  last
          element).

     %F   Type of the filesystem the file is on; this value can  be  used  for
          -fstype.

     %g   File's group name, or numeric group ID if the group has no name.

     %G   File's numeric group ID.

     %h   Leading directories of file's name (all but the last element).

     %H   Command line argument under which file was found.

     %i   File's inode number (in decimal).




                                      \                                      8



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     %k   File's size in 1K blocks (rounded up).

     %l   Object of symbolic link (empty string if  file  is  not  a  symbolic
          link).

     %m   File's permission bits (in octal).

     %n   Number of hard links to file.

     %p   File's name.

     %P   File's name with the name of the command line argument  under  which
          it was found removed.

     %s   File's size in bytes.

     %t   File's last modification time  in  the  format  returned  by  the  C
          `ctime' function.

     %T_k  File's last modification time in the format specified by _k, which is
          the same as for %A.

     %u   File's user name, or numeric user ID if the user has no name.

     %U   File's numeric user ID.

     A `%' character followed by any other character  is  discarded  (but  the
     other character is printed).

     -prune
          If -depth is not given, true; do not descend the current directory.
          If -depth is given, false; no effect.

     -ls  True; list current file in `ls -dils'  format  on  standard  output.
          The  block  counts are of 1K blocks, unless the environment variable
          POSIXLY_CORRECT is set, in which case 512-byte blocks are used.

     OOOPPPEEERRRAAATTTOOORRRSSS

     Listed in order of decreasing precedence:

     ( _e_x_p_r )
          Force precedence.

     ! _e_x_p_r
          True if _e_x_p_r is false.

     -not _e_x_p_r
          Same as ! _e_x_p_r.

     _e_x_p_r_1 _e_x_p_r_2
          And (implied); _e_x_p_r_2 is not evaluated if _e_x_p_r_1 is false.

     _e_x_p_r_1 -a _e_x_p_r_2
          Same as _e_x_p_r_1 _e_x_p_r_2.



                                      \                                      9



FIND(1L)                   Unix Programmer's Manual                   FIND(1L)


     _e_x_p_r_1 -and _e_x_p_r_2
          Same as _e_x_p_r_1 _e_x_p_r_2.

     _e_x_p_r_1 -o _e_x_p_r_2
          Or; _e_x_p_r_2 is not evaluated if _e_x_p_r_1 is true.

     _e_x_p_r_1 -or _e_x_p_r_2
          Same as _e_x_p_r_1 -o _e_x_p_r_2.

     _e_x_p_r_1 , _e_x_p_r_2
          List; both _e_x_p_r_1 and _e_x_p_r_2 are always evaluated.  The value of _e_x_p_r_1
          is discarded; the value of the list is the value of _e_x_p_r_2.

SSSEEEEEE AAALLLSSSOOO
     lllooocccaaattteee(1L), lllooocccaaattteeedddbbb(5L), uuupppdddaaattteeedddbbb(1L), xxxaaarrrgggsss(1L) FFFiiinnndddiiinnnggg FFFiiillleeesss  (on-line
     in Info, or printed)










































                                     \                                      10

