This is Info file ../f/g77.info, produced by Makeinfo version 1.68 from
the input file ../f/g77.texi.

   This file explains how to use the GNU Fortran system.

   Published by the Free Software Foundation 59 Temple Place - Suite 330
Boston, MA 02111-1307 USA

   Copyright (C) 1995-1997 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License," "Funding for
Free Software," and "Protect Your Freedom--Fight `Look And Feel'" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License," "Funding for Free Software," and "Protect Your Freedom--Fight
`Look And Feel'", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.

   Contributed by James Craig Burley (<burley@gnu.org>).  Inspired by a
first pass at translating `g77-0.5.16/f/DOC' that was contributed to
Craig by David Ronis (<ronis@onsager.chem.mcgill.ca>).

INFO-DIR-SECTION Programming
START-INFO-DIR-ENTRY
* g77: (g77).                  The GNU Fortran compiler.
END-INFO-DIR-ENTRY


File: g77.info,  Node: News,  Next: Changes,  Prev: Invoking G77,  Up: Top

News About GNU Fortran
**********************

   Changes made to recent versions of GNU Fortran are listed below,
with the most recent version first.

   The changes are generally listed in order:

  1. Code-generation and run-time-library bug-fixes

  2. Compiler and run-time-library crashes involving valid code that
     have been fixed

  3. New features

  4. Fixes and enhancements to existing features

  5. New diagnostics

  6. Internal improvements

  7. Miscellany

   This order is not strict--for example, some items involve a
combination of these elements.

In 0.5.23:
==========

   * This release contains several regressions against version 0.5.22
     of `g77', due to using the "vanilla" `gcc' back end instead of
     patching it to fix a few bugs and improve performance in a few
     cases.

     *Note Actual Bugs We Haven't Fixed Yet: Actual Bugs, available in
     plain-text format in `gcc/f/BUGS', for information on the known
     bugs in this version, including the regressions.

     Features that have been dropped from this version of `g77' due to
     their being implemented via `g77'-specific patches to the `gcc'
     back end in previous releases include:

        - Support for `__restrict__' keyword, the options
          `-fargument-alias', `-fargument-noalias', and
          `-fargument-noalias-global', and the corresponding
          alias-analysis code.

          (Version 1.0.1 of `egcs' has the alias-analysis code, but not
          the `__restrict__' keyword.  `egcs' `g77' users benefit from
          the alias-analysis code despite the lack of the
          `__restrict__' keyword, which is a C-language construct.)

        - Support for the GNU compiler options `-fmove-all-movables',
          `-freduce-all-givs', and `-frerun-loop-opt'.

          (Version 1.0.1 of `egcs' supports these options.  `g77' users
          of `egcs' benefit from them even if they are not explicitly
          specified, because the defaults are optimized for `g77'
          users.)

        - Support for the `-W' option warning about integer division by
          zero.

        - The Intel x86-specific option `-malign-double' applying to
          stack-allocated data as well as statically-allocate data.

     Note that the `gcc/f/gbe/' subdirectory has been removed from this
     distribution as a result of `g77' no longer including patches for
     the `gcc' back end.

   * Fix bugs in the `libU77' intrinsic `HostNm' that wrote one byte
     beyond the end of its `CHARACTER' argument, and in the `libU77'
     intrinsics `GMTime' and `LTime' that overwrote their arguments.

   * Support `gcc' version 2.8, and remove support for prior versions
     of `gcc'.

   * Remove support for the `--driver' option, as `g77' now does all
     the driving, just like `gcc'.

   * `CASE DEFAULT' no longer crashes `g77'.

   * Valid combinations of `EXTERNAL', passing that external as a dummy
     argument without explicitly giving it a type, and, in a subsequent
     program unit, referencing that external as an external function
     with a different type no longer crash `g77'.

   * `g77' no longer installs the `f77' command and `f77.1' man page in
     the `/usr' or `/usr/local' heirarchy, even if the `f77-install-ok'
     file exists in the source or build directory.  See the
     installation documentation for more information.

   * `g77' no longer installs the `libf2c.a' library and `f2c.h'
     include file in the `/usr' or `/usr/local' heirarchy, even if the
     `f2c-install-ok' or `f2c-exists-ok' files exist in the source or
     build directory.  See the installation documentation for more
     information.

   * The `libf2c.a' library produced by `g77' has been renamed to
     `libg2c.a'.  It is installed only in the `gcc' "private" directory
     heirarchy, `gcc-lib'.  This allows system administrators and users
     to choose which version of the `libf2c' library from `netlib' they
     wish to use on a case-by-case basis.  See the installation
     documentation for more information.

   * The `f2c.h' include (header) file produced by `g77' has been
     renamed to `g2c.h'.  It is installed only in the `gcc' "private"
     directory heirarchy, `gcc-lib'.  This allows system administrators
     and users to choose which version of the include file from
     `netlib' they wish to use on a case-by-case basis.  See the
     installation documentation for more information.

   * The `g77' command now expects the run-time library to be named
     `libg2c.a' instead of `libf2c.a', to ensure that a version other
     than the one built and installed as part of the same `g77' version
     is picked up.

   * The `-Wunused' option no longer issues a spurious warning about
     the "master" procedure generated by `g77' for procedures
     containing `ENTRY' statements.

   * `g77''s version of `libf2c' separates out the setting of global
     state (such as command-line arguments and signal handling) from
     `main.o' into distinct, new library archive members.

     This should make it easier to write portable applications that
     have their own (non-Fortran) `main()' routine properly set up the
     `libf2c' environment, even when `libf2c' (now `libg2c') is a
     shared library.

   * During the configuration and build process, `g77' creates
     subdirectories it needs only as it needs them, thus avoiding
     unnecessary creation of, for example, `stage1/f/runtime' when
     doing a non-bootstrap build.  Other cleaning up of the
     configuration and build process has been performed as well.

   * `install-info' now used to update the directory of Info
     documentation to contain an entry for `g77' (during installation).

   * Some diagnostics have been changed from warnings to errors, to
     prevent inadvertent use of the resulting, probably buggy, programs.
     These mostly include diagnostics about use of unsupported features
     in the `OPEN', `INQUIRE', `READ', and `WRITE' statements, and
     about truncations of various sorts of constants.

   * Improve documentation and indexing.

   * Upgrade to `libf2c' as of 1998-04-20.

     This should fix a variety of problems, including those involving
     some uses of the `T' format specifier, and perhaps some build
     (porting) problems as well.

In 0.5.22:
==========

   * Fix code generation for iterative `DO' loops that have one or more
     references to the iteration variable, or to aliases of it, in
     their control expressions.  For example, `DO 10 J=2,J' now is
     compiled correctly.

   * Fix a code-generation bug that afflicted Intel x86 targets when
     `-O2' was specified compiling, for example, an old version of the
     `DNRM2' routine.

     The x87 coprocessor stack was being mismanaged in cases involving
     assigned `GOTO' and `ASSIGN'.

   * Fix `DTime' intrinsic so as not to truncate results to integer
     values (on some systems).

   * Fix `SIGNAL' intrinsic so it offers portable support for 64-bit
     systems (such as Digital Alphas running GNU/Linux).

   * Fix run-time crash involving `NAMELIST' on 64-bit machines such as
     Alphas.

   * Fix `g77' version of `libf2c' so it no longer produces a spurious
     `I/O recursion' diagnostic at run time when an I/O operation (such
     as `READ *,I') is interrupted in a manner that causes the program
     to be terminated via the `f_exit' routine (such as via `C-c').

   * Fix `g77' crash triggered by `CASE' statement with an omitted
     lower or upper bound.

   * Fix `g77' crash compiling references to `CPU_Time' intrinsic.

   * Fix `g77' crash (or apparently infinite run-time) when compiling
     certain complicated expressions involving `COMPLEX' arithmetic
     (especially multiplication).

   * Fix `g77' crash on statements such as `PRINT *,
     (REAL(Z(I)),I=1,2)', where `Z' is `DOUBLE COMPLEX'.

   * Fix a `g++' crash.

   * Support `FORMAT(I<EXPR>)' when EXPR is a compile-time constant
     `INTEGER' expression.

   * Fix `g77' `-g' option so procedures that use `ENTRY' can be
     stepped through, line by line, in `gdb'.

   * Fix a profiling-related bug in `gcc' back end for Intel x86
     architecture.

   * Allow any `REAL' argument to intrinsics `Second' and `CPU_Time'.

   * Allow any numeric argument to intrinsics `Int2' and `Int8'.

   * Use `tempnam', if available, to open scratch files (as in
     `OPEN(STATUS='SCRATCH')' so that the `TMPDIR' environment variable,
     if present, is used.

   * Rename the `gcc' keyword `restrict' to `__restrict__', to avoid
     rejecting valid, existing, C programs.  Support for `restrict' is
     now more like support for `complex'.

   * Fix `-fpedantic' to not reject procedure invocations such as
     `I=J()' and `CALL FOO()'.

   * Fix `-fugly-comma' to affect invocations of only external
     procedures.  Restore rejection of gratuitous trailing omitted
     arguments to intrinsics, as in `I=MAX(3,4,,)'.

   * Fix compiler so it accepts `-fgnu-intrinsics-*' and
     `-fbadu77-intrinsics-*' options.

   * Improve diagnostic messages from `libf2c' so it is more likely
     that the printing of the active format string is limited to the
     string, with no trailing garbage being printed.

     (Unlike `f2c', `g77' did not append a null byte to its compiled
     form of every format string specified via a `FORMAT' statement.
     However, `f2c' would exhibit the problem anyway for a statement
     like `PRINT '(I)garbage', 1' by printing `(I)garbage' as the
     format string.)

   * Improve compilation of FORMAT expressions so that a null byte is
     appended to the last operand if it is a constant.  This provides a
     cleaner run-time diagnostic as provided by `libf2c' for statements
     like `PRINT '(I1', 42'.

   * Fix various crashes involving code with diagnosed errors.

   * Fix cross-compilation bug when configuring `libf2c'.

   * Improve diagnostics.

   * Improve documentation and indexing.

   * Upgrade to `libf2c' as of 1997-09-23.  This fixes a formatted-I/O
     bug that afflicted 64-bit systems with 32-bit integers (such as
     Digital Alpha running GNU/Linux).

In 0.5.21:
==========

   * Fix a code-generation bug introduced by 0.5.20 caused by loop
     unrolling (by specifying `-funroll-loops' or similar).  This bug
     afflicted all code compiled by version 2.7.2.2.f.2 of `gcc' (C,
     C++, Fortran, and so on).

   * Fix a code-generation bug manifested when combining local
     `EQUIVALENCE' with a `DATA' statement that follows the first
     executable statement (or is treated as an executable-context
     statement as a result of using the `-fpedantic' option).

   * Fix a compiler crash that occured when an integer division by a
     constant zero is detected.  Instead, when the `-W' option is
     specified, the `gcc' back end issues a warning about such a case.
     This bug afflicted all code compiled by version 2.7.2.2.f.2 of
     `gcc' (C, C++, Fortran, and so on).

   * Fix a compiler crash that occurred in some cases of procedure
     inlining.  (Such cases became more frequent in 0.5.20.)

   * Fix a compiler crash resulting from using `DATA' or similar to
     initialize a `COMPLEX' variable or array to zero.

   * Fix compiler crashes involving use of `AND', `OR', or `XOR'
     intrinsics.

   * Fix compiler bug triggered when using a `COMMON' or `EQUIVALENCE'
     variable as the target of an `ASSIGN' or assigned-`GOTO' statement.

   * Fix compiler crashes due to using the name of a some non-standard
     intrinsics (such as `FTELL' or `FPUTC') as such and as the name of
     a procedure or common block.  Such dual use of a name in a program
     is allowed by the standard.

   * Place automatic arrays on the stack, even if `SAVE' or the
     `-fno-automatic' option is in effect.  This avoids a compiler
     crash in some cases.

   * The `-malign-double' option now reliably aligns `DOUBLE PRECISION'
     optimally on Pentium and Pentium Pro architectures (586 and 686 in
     `gcc').

   * New option `-Wno-globals' disables warnings about "suspicious" use
     of a name both as a global name and as the implicit name of an
     intrinsic, and warnings about disagreements over the number or
     natures of arguments passed to global procedures, or the natures
     of the procedures themselves.

     The default is to issue such warnings, which are new as of this
     version of `g77'.

   * New option `-fno-globals' disables diagnostics about potentially
     fatal disagreements analysis problems, such as disagreements over
     the number or natures of arguments passed to global procedures, or
     the natures of those procedures themselves.

     The default is to issue such diagnostics and flag the compilation
     as unsuccessful.  With this option, the diagnostics are issued as
     warnings, or, if `-Wno-globals' is specified, are not issued at
     all.

     This option also disables inlining of global procedures, to avoid
     compiler crashes resulting from coding errors that these
     diagnostics normally would identify.

   * Diagnose cases where a reference to a procedure disagrees with the
     type of that procedure, or where disagreements about the number or
     nature of arguments exist.  This avoids a compiler crash.

   * Fix parsing bug whereby `g77' rejected a second initialization
     specification immediately following the first's closing `/' without
     an intervening comma in a `DATA' statement, and the second
     specification was an implied-DO list.

   * Improve performance of the `gcc' back end so certain complicated
     expressions involving `COMPLEX' arithmetic (especially
     multiplication) don't appear to take forever to compile.

   * Fix a couple of profiling-related bugs in `gcc' back end.

   * Integrate GNU Ada's (GNAT's) changes to the back end, which
     consist almost entirely of bug fixes.  These fixes are circa
     version 3.10p of GNAT.

   * Include some other `gcc' fixes that seem useful in `g77''s version
     of `gcc'.  (See `gcc/ChangeLog' for details--compare it to that
     file in the vanilla `gcc-2.7.2.3.tar.gz' distribution.)

   * Fix `libU77' routines that accept file and other names to strip
     trailing blanks from them, for consistency with other
     implementations.  Blanks may be forcibly appended to such names by
     appending a single null character (`CHAR(0)') to the significant
     trailing blanks.

   * Fix `CHMOD' intrinsic to work with file names that have embedded
     blanks, commas, and so on.

   * Fix `SIGNAL' intrinsic so it accepts an optional third `Status'
     argument.

   * Fix `IDATE()' intrinsic subroutine (VXT form) so it accepts
     arguments in the correct order.  Documentation fixed accordingly,
     and for `GMTIME()' and `LTIME()' as well.

   * Make many changes to `libU77' intrinsics to support existing code
     more directly.

     Such changes include allowing both subroutine and function forms
     of many routines, changing `MCLOCK()' and `TIME()' to return
     `INTEGER(KIND=1)' values, introducing `MCLOCK8()' and `TIME8()' to
     return `INTEGER(KIND=2)' values, and placing functions that are
     intended to perform side effects in a new intrinsic group,
     `badu77'.

   * Improve `libU77' so it is more portable.

   * Add options `-fbadu77-intrinsics-delete',
     `-fbadu77-intrinsics-hide', and so on.

   * Fix crashes involving diagnosed or invalid code.

   * `g77' and `gcc' now do a somewhat better job detecting and
     diagnosing arrays that are too large to handle before these cause
     diagnostics during the assembler or linker phase, a compiler
     crash, or generation of incorrect code.

   * Make some fixes to alias analysis code.

   * Add support for `restrict' keyword in `gcc' front end.

   * Support `gcc' version 2.7.2.3 (modified by `g77' into version
     2.7.2.3.f.1), and remove support for prior versions of `gcc'.

   * Incorporate GNAT's patches to the `gcc' back end into `g77''s, so
     GNAT users do not need to apply GNAT's patches to build both GNAT
     and `g77' from the same source tree.

   * Modify `make' rules and related code so that generation of Info
     documentation doesn't require compilation using `gcc'.  Now, any
     ANSI C compiler should be adequate to produce the `g77'
     documentation (in particular, the tables of intrinsics) from
     scratch.

   * Add `INT2' and `INT8' intrinsics.

   * Add `CPU_TIME' intrinsic.

   * Add `ALARM' intrinsic.

   * `CTIME' intrinsic now accepts any `INTEGER' argument, not just
     `INTEGER(KIND=2)'.

   * Warn when explicit type declaration disagrees with the type of an
     intrinsic invocation.

   * Support `*f771' entry in `gcc' `specs' file.

   * Fix typo in `make' rule `g77-cross', used only for cross-compiling.

   * Fix `libf2c' build procedure to re-archive library if previous
     attempt to archive was interrupted.

   * Change `gcc' to unroll loops only during the last invocation (of
     as many as two invocations) of loop optimization.

   * Improve handling of `-fno-f2c' so that code that attempts to pass
     an intrinsic as an actual argument, such as `CALL FOO(ABS)', is
     rejected due to the fact that the run-time-library routine is,
     effectively, compiled with `-ff2c' in effect.

   * Fix `g77' driver to recognize `-fsyntax-only' as an option that
     inhibits linking, just like `-c' or `-S', and to recognize and
     properly handle the `-nostdlib', `-M', `-MM', `-nodefaultlibs',
     and `-Xlinker' options.

   * Upgrade to `libf2c' as of 1997-08-16.

   * Modify `libf2c' to consistently and clearly diagnose recursive I/O
     (at run time).

   * `g77' driver now prints version information (such as produced by
     `g77 -v') to `stderr' instead of `stdout'.

   * The `.r' suffix now designates a Ratfor source file, to be
     preprocessed via the `ratfor' command, available separately.

   * Fix some aspects of how `gcc' determines what kind of system is
     being configured and what kinds are supported.  For example, GNU
     Linux/Alpha ELF systems now are directly supported.

   * Improve diagnostics.

   * Improve documentation and indexing.

   * Include all pertinent files for `libf2c' that come from
     `netlib.bell-labs.com'; give any such files that aren't quite
     accurate in `g77''s version of `libf2c' the suffix `.netlib'.

   * Reserve `INTEGER(KIND=0)' for future use.

In 0.5.20:
==========

   * The `-fno-typeless-boz' option is now the default.

     This option specifies that non-decimal-radix constants using the
     prefixed-radix form (such as `Z'1234'') are to be interpreted as
     `INTEGER' constants.  Specify `-ftypeless-boz' to cause such
     constants to be interpreted as typeless.

     (Version 0.5.19 introduced `-fno-typeless-boz' and its inverse.)

   * Options `-ff90-intrinsics-enable' and `-fvxt-intrinsics-enable'
     now are the defaults.

     Some programs might use names that clash with intrinsic names
     defined (and now enabled) by these options or by the new `libU77'
     intrinsics.  Users of such programs might need to compile them
     differently (using, for example, `-ff90-intrinsics-disable') or,
     better yet, insert appropriate `EXTERNAL' statements specifying
     that these names are not intended to be names of intrinsics.

   * The `ALWAYS_FLUSH' macro is no longer defined when building
     `libf2c', which should result in improved I/O performance,
     especially over NFS.

     *Note:* If you have code that depends on the behavior of `libf2c'
     when built with `ALWAYS_FLUSH' defined, you will have to modify
     `libf2c' accordingly before building it from this and future
     versions of `g77'.

   * Dave Love's implementation of `libU77' has been added to the
     version of `libf2c' distributed with and built as part of `g77'.
     `g77' now knows about the routines in this library as intrinsics.

   * New option `-fvxt' specifies that the source file is written in
     VXT Fortran, instead of GNU Fortran.

   * The `-fvxt-not-f90' option has been deleted, along with its
     inverse, `-ff90-not-vxt'.

     If you used one of these deleted options, you should re-read the
     pertinent documentation to determine which options, if any, are
     appropriate for compiling your code with this version of `g77'.

   * The `-fugly' option now issues a warning, as it likely will be
     removed in a future version.

     (Enabling all the `-fugly-*' options is unlikely to be feasible,
     or sensible, in the future, so users should learn to specify only
     those `-fugly-*' options they really need for a particular source
     file.)

   * The `-fugly-assumed' option, introduced in version 0.5.19, has
     been changed to better accommodate old and new code.

   * Make a number of fixes to the `g77' front end and the `gcc' back
     end to better support Alpha (AXP) machines.  This includes
     providing at least one bug-fix to the `gcc' back end for Alphas.

   * Related to supporting Alpha (AXP) machines, the `LOC()' intrinsic
     and `%LOC()' construct now return values of integer type that is
     the same width (holds the same number of bits) as the pointer type
     on the machine.

     On most machines, this won't make a difference, whereas on Alphas,
     the type these constructs return is `INTEGER*8' instead of the
     more common `INTEGER*4'.

   * Emulate `COMPLEX' arithmetic in the `g77' front end, to avoid bugs
     in `complex' support in the `gcc' back end.  New option
     `-fno-emulate-complex' causes `g77' to revert the 0.5.19 behavior.

   * Fix bug whereby `REAL A(1)', for example, caused a compiler crash
     if `-fugly-assumed' was in effect and A was a local (automatic)
     array.  That case is no longer affected by the new handling of
     `-fugly-assumed'.

   * Fix `g77' command driver so that `g77 -o foo.f' no longer deletes
     `foo.f' before issuing other diagnostics, and so the `-x' option
     is properly handled.

   * Enable inlining of subroutines and functions by the `gcc' back end.
     This works as it does for `gcc' itself--program units may be
     inlined for invocations that follow them in the same program unit,
     as long as the appropriate compile-time options are specified.

   * Dummy arguments are no longer assumed to potentially alias
     (overlap) other dummy arguments or `COMMON' areas when any of
     these are defined (assigned to) by Fortran code.

     This can result in faster and/or smaller programs when compiling
     with optimization enabled, though on some systems this effect is
     observed only when `-fforce-addr' also is specified.

     New options `-falias-check', `-fargument-alias',
     `-fargument-noalias', and `-fno-argument-noalias-global' control
     the way `g77' handles potential aliasing.

   * The `CONJG()' and `DCONJG()' intrinsics now are compiled in-line.

   * The bug-fix for 0.5.19.1 has been re-done.  The `g77' compiler has
     been changed back to assume `libf2c' has no aliasing problems in
     its implementations of the `COMPLEX' (and `DOUBLE COMPLEX')
     intrinsics.  The `libf2c' has been changed to have no such
     problems.

     As a result, 0.5.20 is expected to offer improved performance over
     0.5.19.1, perhaps as good as 0.5.19 in most or all cases, due to
     this change alone.

     *Note:* This change requires version 0.5.20 of `libf2c', at least,
     when linking code produced by any versions of `g77' other than
     0.5.19.1.  Use `g77 -v' to determine the version numbers of the
     `libF77', `libI77', and `libU77' components of the `libf2c'
     library.  (If these version numbers are not printed--in
     particular, if the linker complains about unresolved references to
     names like `g77__fvers__'--that strongly suggests your
     installation has an obsolete version of `libf2c'.)

   * New option `-fugly-assign' specifies that the same memory
     locations are to be used to hold the values assigned by both
     statements `I = 3' and `ASSIGN 10 TO I', for example.  (Normally,
     `g77' uses a separate memory location to hold assigned statement
     labels.)

   * `FORMAT' and `ENTRY' statements now are allowed to precede
     `IMPLICIT NONE' statements.

   * Produce diagnostic for unsupported `SELECT CASE' on `CHARACTER'
     type, instead of crashing, at compile time.

   * Fix crashes involving diagnosed or invalid code.

   * Change approach to building `libf2c' archive (`libf2c.a') so that
     members are added to it only when truly necessary, so the user
     that installs an already-built `g77' doesn't need to have write
     access to the build tree (whereas the user doing the build might
     not have access to install new software on the system).

   * Support `gcc' version 2.7.2.2 (modified by `g77' into version
     2.7.2.2.f.2), and remove support for prior versions of `gcc'.

   * Upgrade to `libf2c' as of 1997-02-08, and fix up some of the build
     procedures.

   * Improve general build procedures for `g77', fixing minor bugs
     (such as deletion of any file named `f771' in the parent directory
     of `gcc/').

   * Enable full support of `INTEGER*8' available in `libf2c' and
     `f2c.h' so that `f2c' users may make full use of its features via
     the `g77' version of `f2c.h' and the `INTEGER*8' support routines
     in the `g77' version of `libf2c'.

   * Improve `g77' driver and `libf2c' so that `g77 -v' yields version
     information on the library.

   * The `SNGL' and `FLOAT' intrinsics now are specific intrinsics,
     instead of synonyms for the generic intrinsic `REAL'.

   * New intrinsics have been added.  These are `REALPART', `IMAGPART',
     `COMPLEX', `LONG', and `SHORT'.

   * A new group of intrinsics, `gnu', has been added to contain the
     new `REALPART', `IMAGPART', and `COMPLEX' intrinsics.  An old
     group, `dcp', has been removed.

   * Complain about industry-wide ambiguous references `REAL(EXPR)' and
     `AIMAG(EXPR)', where EXPR is `DOUBLE COMPLEX' (or any complex type
     other than `COMPLEX'), unless `-ff90' option specifies Fortran 90
     interpretation or new `-fugly-complex' option, in conjunction with
     `-fnot-f90', specifies `f2c' interpretation.

   * Make improvements to diagnostics.

   * Speed up compiler a bit.

   * Improvements to documentation and indexing, including a new
     chapter containing information on one, later more, diagnostics
     that users are directed to pull up automatically via a message in
     the diagnostic itself.

     (Hence the menu item `M' for the node `Diagnostics' in the
     top-level menu of the Info documentation.)

In 0.5.19.1:
============

   * Code-generation bugs afflicting operations on complex data have
     been fixed.

     These bugs occurred when assigning the result of an operation to a
     complex variable (or array element) that also served as an input
     to that operation.

     The operations affected by this bug were: `CONJG()', `DCONJG()',
     `CCOS()', `CDCOS()', `CLOG()', `CDLOG()', `CSIN()', `CDSIN()',
     `CSQRT()', `CDSQRT()', complex division, and raising a `DOUBLE
     COMPLEX' operand to an `INTEGER' power.  (The related generic and
     `Z'-prefixed intrinsics, such as `ZSIN()', also were affected.)

     For example, `C = CSQRT(C)', `Z = Z/C', and `Z = Z**I' (where `C'
     is `COMPLEX' and `Z' is `DOUBLE COMPLEX') have been fixed.

In 0.5.19:
==========

   * Fix `FORMAT' statement parsing so negative values for specifiers
     such as `P' (e.g. `FORMAT(-1PF8.1)') are correctly processed as
     negative.

   * Fix `SIGNAL' intrinsic so it once again accepts a procedure as its
     second argument.

   * A temporary kludge option provides bare-bones information on
     `COMMON' and `EQUIVALENCE' members at debug time.

   * New `-fonetrip' option specifies FORTRAN-66-style one-trip `DO'
     loops.

   * New `-fno-silent' option causes names of program units to be
     printed as they are compiled, in a fashion similar to UNIX `f77'
     and `f2c'.

   * New `-fugly-assumed' option specifies that arrays dimensioned via
     `DIMENSION X(1)', for example, are to be treated as assumed-size.

   * New `-fno-typeless-boz' option specifies that non-decimal-radix
     constants using the prefixed-radix form (such as `Z'1234'') are to
     be interpreted as `INTEGER' constants.

   * New `-ff66' option is a "shorthand" option that specifies
     behaviors considered appropriate for FORTRAN 66 programs.

   * New `-ff77' option is a "shorthand" option that specifies
     behaviors considered appropriate for UNIX `f77' programs.

   * New `-fugly-comma' and `-fugly-logint' options provided to perform
     some of what `-fugly' used to do.  `-fugly' and `-fno-ugly' are
     now "shorthand" options, in that they do nothing more than enable
     (or disable) other `-fugly-*' options.

   * Fix parsing of assignment statements involving targets that are
     substrings of elements of `CHARACTER' arrays having names such as
     `READ', `WRITE', `GOTO', and `REALFUNCTIONFOO'.

   * Fix crashes involving diagnosed code.

   * Fix handling of local `EQUIVALENCE' areas so certain cases of
     valid Fortran programs are not misdiagnosed as improperly
     extending the area backwards.

   * Support `gcc' version 2.7.2.1.

   * Upgrade to `libf2c' as of 1996-09-26, and fix up some of the build
     procedures.

   * Change code generation for list-directed I/O so it allows for new
     versions of `libf2c' that might return non-zero status codes for
     some operations previously assumed to always return zero.

     This change not only affects how `IOSTAT=' variables are set by
     list-directed I/O, it also affects whether `END=' and `ERR='
     labels are reached by these operations.

   * Add intrinsic support for new `FTELL' and `FSEEK' procedures in
     `libf2c'.

   * Modify `fseek_()' in `libf2c' to be more portable (though, in
     practice, there might be no systems where this matters) and to
     catch invalid `whence' arguments.

   * Some useless warnings from the `-Wunused' option have been
     eliminated.

   * Fix a problem building the `f771' executable on AIX systems by
     linking with the `-bbigtoc' option.

   * Abort configuration if `gcc' has not been patched using the patch
     file provided in the `gcc/f/gbe/' subdirectory.

   * Add options `--help' and `--version' to the `g77' command, to
     conform to GNU coding guidelines.  Also add printing of `g77'
     version number when the `--verbose' (`-v') option is used.

   * Change internally generated name for local `EQUIVALENCE' areas to
     one based on the alphabetically sorted first name in the list of
     names for entities placed at the beginning of the areas.

   * Improvements to documentation and indexing.

In 0.5.18:
==========

   * Add some rudimentary support for `INTEGER*1', `INTEGER*2',
     `INTEGER*8', and their `LOGICAL' equivalents.  (This support works
     on most, maybe all, `gcc' targets.)

     Thanks to Scott Snyder (<snyder@d0sgif.fnal.gov>) for providing
     the patch for this!

     Among the missing elements from the support for these features are
     full intrinsic support and constants.

   * Add some rudimentary support for the `BYTE' and `WORD'
     type-declaration statements.  `BYTE' corresponds to `INTEGER*1',
     while `WORD' corresponds to `INTEGER*2'.

     Thanks to Scott Snyder (<snyder@d0sgif.fnal.gov>) for providing
     the patch for this!

   * The compiler code handling intrinsics has been largely rewritten
     to accommodate the new types.  No new intrinsics or arguments for
     existing intrinsics have been added, so there is, at this point,
     no intrinsic to convert to `INTEGER*8', for example.

   * Support automatic arrays in procedures.

   * Reduce space/time requirements for handling large *sparsely*
     initialized aggregate arrays.  This improvement applies to only a
     subset of the general problem to be addressed in 0.6.

   * Treat initial values of zero as if they weren't specified (in DATA
     and type-declaration statements).  The initial values will be set
     to zero anyway, but the amount of compile time processing them
     will be reduced, in some cases significantly (though, again, this
     is only a subset of the general problem to be addressed in 0.6).

     A new option, `-fzeros', is introduced to enable the traditional
     treatment of zeros as any other value.

   * With `-ff90' in force, `g77' incorrectly interpreted `REAL(Z)' as
     returning a `REAL' result, instead of as a `DOUBLE PRECISION'
     result.  (Here, `Z' is `DOUBLE COMPLEX'.)

     With `-fno-f90' in force, the interpretation remains unchanged,
     since this appears to be how at least some F77 code using the
     `DOUBLE COMPLEX' extension expected it to work.

     Essentially, `REAL(Z)' in F90 is the same as `DBLE(Z)', while in
     extended F77, it appears to be the same as `REAL(REAL(Z))'.

   * An expression involving exponentiation, where both operands were
     type `INTEGER' and the right-hand operand was negative, was
     erroneously evaluated.

   * Fix bugs involving `DATA' implied-`DO' constructs (these involved
     an errant diagnostic and a crash, both on good code, one involving
     subsequent statement-function definition).

   * Close `INCLUDE' files after processing them, so compiling source
     files with lots of `INCLUDE' statements does not result in being
     unable to open `INCLUDE' files after all the available file
     descriptors are used up.

   * Speed up compiling, especially of larger programs, and perhaps
     slightly reduce memory utilization while compiling (this is *not*
     the improvement planned for 0.6 involving large aggregate
     areas)--these improvements result from simply turning off some
     low-level code to do self-checking that hasn't been triggered in a
     long time.

   * Introduce three new options that implement optimizations in the
     `gcc' back end (GBE).  These options are `-fmove-all-movables',
     `-freduce-all-givs', and `-frerun-loop-opt', which are enabled, by
     default, for Fortran compilations.  These optimizations are
     intended to help toon Fortran programs.

   * Patch the GBE to do a better job optimizing certain kinds of
     references to array elements.

   * Due to patches to the GBE, the version number of `gcc' also is
     patched to make it easier to manage installations, especially
     useful if it turns out a `g77' change to the GBE has a bug.

     The `g77'-modified version number is the `gcc' version number with
     the string `.f.N' appended, where `f' identifies the version as
     enhanced for Fortran, and N is `1' for the first Fortran patch for
     that version of `gcc', `2' for the second, and so on.

     So, this introduces version 2.7.2.f.1 of `gcc'.

   * Make several improvements and fixes to diagnostics, including the
     removal of two that were inappropriate or inadequate.

   * Warning about two successive arithmetic operators, produced by
     `-Wsurprising', now produced *only* when both operators are,
     indeed, arithmetic (not relational/boolean).

   * `-Wsurprising' now warns about the remaining cases of using
     non-integral variables for implied-`DO' loops, instead of these
     being rejected unless `-fpedantic' or `-fugly' specified.

   * Allow `SAVE' of a local variable or array, even after it has been
     given an initial value via `DATA', for example.

   * Introduce an Info version of `g77' documentation, which supercedes
     `gcc/f/CREDITS', `gcc/f/DOC', and `gcc/f/PROJECTS'.  These files
     will be removed in a future release.  The files `gcc/f/BUGS',
     `gcc/f/INSTALL', and `gcc/f/NEWS' now are automatically built from
     the texinfo source when distributions are made.

     This effort was inspired by a first pass at translating
     `g77-0.5.16/f/DOC' that was contributed to Craig by David Ronis
     (<ronis@onsager.chem.mcgill.ca>).

   * New `-fno-second-underscore' option to specify that, when
     `-funderscoring' is in effect, a second underscore is not to be
     appended to Fortran names already containing an underscore.

   * Change the way iterative `DO' loops work to follow the F90
     standard.  In particular, calculation of the iteration count is
     still done by converting the start, end, and increment parameters
     to the type of the `DO' variable, but the result of the
     calculation is always converted to the default `INTEGER' type.

     (This should have no effect on existing code compiled by `g77',
     but code written to assume that use of a *wider* type for the `DO'
     variable will result in an iteration count being fully calculated
     using that wider type (wider than default `INTEGER') must be
     rewritten.)

   * Support `gcc' version 2.7.2.

   * Upgrade to `libf2c' as of 1996-03-23, and fix up some of the build
     procedures.

     Note that the email addresses related to `f2c' have changed--the
     distribution site now is named `netlib.bell-labs.com', and the
     maintainer's new address is <dmg@bell-labs.com>.

In 0.5.17:
==========

   * *Fix serious bug* in `g77 -v' command that can cause removal of a
     system's `/dev/null' special file if run by user `root'.

     *All users* of version 0.5.16 should ensure that they have not
     removed `/dev/null' or replaced it with an ordinary file (e.g. by
     comparing the output of `ls -l /dev/null' with `ls -l /dev/zero'.
     If the output isn't basically the same, contact your system
     administrator about restoring `/dev/null' to its proper status).

     This bug is particularly insidious because removing `/dev/null' as
     a special file can go undetected for quite a while, aside from
     various applications and programs exhibiting sudden, strange
     behaviors.

     I sincerely apologize for not realizing the implications of the
     fact that when `g77 -v' runs the `ld' command with `-o /dev/null'
     that `ld' tries to *remove* the executable it is supposed to build
     (especially if it reports unresolved references, which it should
     in this case)!

   * Fix crash on `CHARACTER*(*) FOO' in a main or block data program
     unit.

   * Fix crash that can occur when diagnostics given outside of any
     program unit (such as when input file contains `@foo').

   * Fix crashes, infinite loops (hangs), and such involving diagnosed
     code.

   * Fix `ASSIGN''ed variables so they can be `SAVE''d or dummy
     arguments, and issue clearer error message in cases where target
     of `ASSIGN' or `ASSIGN'ed `GOTO'/`FORMAT' is too small (which
     should never happen).

   * Make `libf2c' build procedures work on more systems again by
     eliminating unnecessary invocations of `ld -r -x' and `mv'.

   * Fix omission of `-funix-intrinsics-...' options in list of
     permitted options to compiler.

   * Fix failure to always diagnose missing type declaration for
     `IMPLICIT NONE'.

   * Fix compile-time performance problem (which could sometimes crash
     the compiler, cause a hang, or whatever, due to a bug in the back
     end) involving exponentiation with a large `INTEGER' constant for
     the right-hand operator (e.g. `I**32767').

   * Fix build procedures so cross-compiling `g77' (the `fini' utility
     in particular) is properly built using the host compiler.

   * Add new `-Wsurprising' option to warn about constructs that are
     interpreted by the Fortran standard (and `g77') in ways that are
     surprising to many programmers.

   * Add `ERF()' and `ERFC()' as generic intrinsics mapping to existing
     `ERF'/`DERF' and `ERFC'/`DERFC' specific intrinsics.

     *Note:* You should specify `INTRINSIC ERF,ERFC' in any code where
     you might use these as generic intrinsics, to improve likelihood
     of diagnostics (instead of subtle run-time bugs) when using a
     compiler that doesn't support these as intrinsics (e.g. `f2c').

   * Remove from `-fno-pedantic' the diagnostic about `DO' with
     non-`INTEGER' index variable; issue that under `-Wsurprising'
     instead.

   * Clarify some diagnostics that say things like "ignored" when that's
     misleading.

   * Clarify diagnostic on use of `.EQ.'/`.NE.' on `LOGICAL' operands.

   * Minor improvements to code generation for various operations on
     `LOGICAL' operands.

   * Minor improvement to code generation for some `DO' loops on some
     machines.

   * Support `gcc' version 2.7.1.

   * Upgrade to `libf2c' as of 1995-11-15.

In 0.5.16:
==========

   * Fix a code-generation bug involving complicated `EQUIVALENCE'
     statements not involving `COMMON'.

   * Fix code-generation bugs involving invoking "gratis" library
     procedures in `libf2c' from code compiled with `-fno-f2c' by
     making these procedures known to `g77' as intrinsics (not affected
     by -fno-f2c).  This is known to fix code invoking `ERF()',
     `ERFC()', `DERF()', and `DERFC()'.

   * Update `libf2c' to include netlib patches through 1995-08-16, and
     `#define' `WANT_LEAD_0' to 1 to make `g77'-compiled code more
     consistent with other Fortran implementations by outputting
     leading zeros in formatted and list-directed output.

   * Fix a code-generation bug involving adjustable dummy arrays with
     high bounds whose primaries are changed during procedure
     execution, and which might well improve code-generation
     performance for such arrays compared to `f2c' plus `gcc' (but
     apparently only when using `gcc-2.7.0' or later).

   * Fix a code-generation bug involving invocation of `COMPLEX' and
     `DOUBLE COMPLEX' `FUNCTION's and doing `COMPLEX' and `DOUBLE
     COMPLEX' divides, when the result of the invocation or divide is
     assigned directly to a variable that overlaps one or more of the
     arguments to the invocation or divide.

   * Fix crash by not generating new optimal code for `X**I' if `I' is
     nonconstant and the expression is used to dimension a dummy array,
     since the `gcc' back end does not support the necessary mechanics
     (and the `gcc' front end rejects the equivalent construct, as it
     turns out).

   * Fix crash on expressions like `COMPLEX**INTEGER'.

   * Fix crash on expressions like `(1D0,2D0)**2', i.e. raising a
     `DOUBLE COMPLEX' constant to an `INTEGER' constant power.

   * Fix crashes and such involving diagnosed code.

   * Diagnose, instead of crashing on, statement function definitions
     having duplicate dummy argument names.

   * Fix bug causing rejection of good code involving statement function
     definitions.

   * Fix bug resulting in debugger not knowing size of local equivalence
     area when any member of area has initial value (via `DATA', for
     example).

   * Fix installation bug that prevented installation of `g77' driver.
     Provide for easy selection of whether to install copy of `g77' as
     `f77' to replace the broken code.

   * Fix `gcc' driver (affects `g77' thereby) to not gratuitously
     invoke the `f771' program (e.g. when `-E' is specified).

   * Fix diagnostic to point to correct source line when it immediately
     follows an `INCLUDE' statement.

   * Support more compiler options in `gcc'/`g77' when compiling
     Fortran files.  These options include `-p', `-pg', `-aux-info',
     `-P', correct setting of version-number macros for preprocessing,
     full recognition of `-O0', and automatic insertion of
     configuration-specific linker specs.

   * Add new intrinsics that interface to existing routines in `libf2c':
     `ABORT', `DERF', `DERFC', `ERF', `ERFC', `EXIT', `FLUSH',
     `GETARG', `GETENV', `IARGC', `SIGNAL', and `SYSTEM'.  Note that
     `ABORT', `EXIT', `FLUSH', `SIGNAL', and `SYSTEM' are intrinsic
     subroutines, not functions (since they have side effects), so to
     get the return values from `SIGNAL' and `SYSTEM', append a final
     argument specifying an `INTEGER' variable or array element (e.g.
     `CALL SYSTEM('rm foo',ISTAT)').

   * Add new intrinsic group named `unix' to contain the new intrinsics,
     and by default enable this new group.

   * Move `LOC()' intrinsic out of the `vxt' group to the new `unix'
     group.

   * Improve `g77' so that `g77 -v' by itself (or with certain other
     options, including `-B', `-b', `-i', `-nostdlib', and `-V')
     reports lots more useful version info, and so that long-form
     options `gcc' accepts are understood by `g77' as well (even in
     truncated, unambiguous forms).

   * Add new `g77' option `--driver=name' to specify driver when
     default, `gcc', isn't appropriate.

   * Add support for `#' directives (as output by the preprocessor) in
     the compiler, and enable generation of those directives by the
     preprocessor (when compiling `.F' files) so diagnostics and
     debugging info are more useful to users of the preprocessor.

   * Produce better diagnostics, more like `gcc', with info such as `In
     function `foo':' and `In file included from...:'.

   * Support `gcc''s `-fident' and `-fno-ident' options.

   * When `-Wunused' in effect, don't warn about local variables used as
     statement-function dummy arguments or `DATA' implied-`DO' iteration
     variables, even though, strictly speaking, these are not uses of
     the variables themselves.

   * When `-W -Wunused' in effect, don't warn about unused dummy
     arguments at all, since there's no way to turn this off for
     individual cases (`g77' might someday start warning about
     these)--applies to `gcc' versions 2.7.0 and later, since earlier
     versions didn't warn about unused dummy arguments.

   * New option `-fno-underscoring' that inhibits transformation of
     names (by appending one or two underscores) so users may experiment
     with implications of such an environment.

   * Minor improvement to `gcc/f/info' module to make it easier to build
     `g77' using the native (non-`gcc') compiler on certain machines
     (but definitely not all machines nor all non-`gcc' compilers).
     Please do not report bugs showing problems compilers have with
     macros defined in `gcc/f/target.h' and used in places like
     `gcc/f/expr.c'.

   * Add warning to be printed for each invocation of the compiler if
     the target machine `INTEGER', `REAL', or `LOGICAL' size is not 32
     bits, since `g77' is known to not work well for such cases (to be
     fixed in Version 0.6--*note Actual Bugs We Haven't Fixed Yet:
     Actual Bugs.).

   * Lots of new documentation (though work is still needed to put it
     into canonical GNU format).

   * Build `libf2c' with `-g0', not `-g2', in effect (by default), to
     produce smaller library without lots of debugging clutter.

In 0.5.15:
==========

   * Fix bad code generation involving `X**I' and temporary, internal
     variables generated by `g77' and the back end (such as for `DO'
     loops).

   * Fix crash given `CHARACTER A;DATA A/.TRUE./'.

   * Replace crash with diagnostic given `CHARACTER A;DATA A/1.0/'.

   * Fix crash or other erratic behavior when null character constant
     (`''') is encountered.

   * Fix crash or other erratic behavior involving diagnosed code.

   * Fix code generation for external functions returning type `REAL'
     when the `-ff2c' option is in force (which it is by default) so
     that `f2c' compatibility is indeed provided.

   * Disallow `COMMON I(10)' if `I' has previously been specified with
     an array declarator.

   * New `-ffixed-line-length-N' option, where N is the maximum length
     of a typical fixed-form line, defaulting to 72 columns, such that
     characters beyond column N are ignored, or N is `none', meaning no
     characters are ignored.  does not affect lines with `&' in column
     1, which are always processed as if `-ffixed-line-length-none' was
     in effect.

   * No longer generate better code for some kinds of array references,
     as `gcc' back end is to be fixed to do this even better, and it
     turned out to slow down some code in some cases after all.

   * In `COMMON' and `EQUIVALENCE' areas with any members given initial
     values (e.g. via `DATA'), uninitialized members now always
     initialized to binary zeros (though this is not required by the
     standard, and might not be done in future versions of `g77').
     Previously, in some `COMMON'/`EQUIVALENCE' areas (essentially
     those with members of more than one type), the uninitialized
     members were initialized to spaces, to cater to `CHARACTER' types,
     but it seems no existing code expects that, while much existing
     code expects binary zeros.

In 0.5.14:
==========

   * Don't emit bad code when low bound of adjustable array is
     nonconstant and thus might vary as an expression at run time.

   * Emit correct code for calculation of number of trips in `DO' loops
     for cases where the loop should not execute at all.  (This bug
     affected cases where the difference between the begin and end
     values was less than the step count, though probably not for
     floating-point cases.)

   * Fix crash when extra parentheses surround item in `DATA'
     implied-`DO' list.

   * Fix crash over minor internal inconsistencies in handling
     diagnostics, just substitute dummy strings where necessary.

   * Fix crash on some systems when compiling call to `MVBITS()'
     intrinsic.

   * Fix crash on array assignment `TYPEDDD(...)=...', where DDD is a
     string of one or more digits.

   * Fix crash on `DCMPLX()' with a single `INTEGER' argument.

   * Fix various crashes involving code with diagnosed errors.

   * Support `-I' option for `INCLUDE' statement, plus `gcc''s
     `header.gcc' facility for handling systems like MS-DOS.

   * Allow `INCLUDE' statement to be continued across multiple lines,
     even allow it to coexist with other statements on the same line.

   * Incorporate Bellcore fixes to `libf2c' through 1995-03-15--this
     fixes a bug involving infinite loops reading EOF with empty
     list-directed I/O list.

   * Remove all the `g77'-specific auto-configuration scripts, code,
     and so on, except for temporary substitutes for bsearch() and
     strtoul(), as too many configure/build problems were reported in
     these areas.  People will have to fix their systems' problems
     themselves, or at least somewhere other than `g77', which expects
     a working ANSI C environment (and, for now, a GNU C compiler to
     compile `g77' itself).

   * Complain if initialized common redeclared as larger in subsequent
     program unit.

   * Warn if blank common initialized, since its size can vary and hence
     related warnings that might be helpful won't be seen.

   * New `-fbackslash' option, on by default, that causes `\' within
     `CHARACTER' and Hollerith constants to be interpreted a la GNU C.
     Note that this behavior is somewhat different from `f2c''s, which
     supports only a limited subset of backslash (escape) sequences.

   * Make `-fugly-args' the default.

   * New `-fugly-init' option, on by default, that allows
     typeless/Hollerith to be specified as initial values for variables
     or named constants (`PARAMETER'), and also allows
     character<->numeric conversion in those contexts--turn off via
     `-fno-ugly-init'.

   * New `-finit-local-zero' option to initialize local variables to
     binary zeros.  This does not affect whether they are `SAVE'd, i.e.
     made automatic or static.

   * New `-Wimplicit' option to warn about implicitly typed variables,
     arrays, and functions.  (Basically causes all program units to
     default to `IMPLICIT NONE'.)

   * `-Wall' now implies `-Wuninitialized' as with `gcc' (i.e. unless
     `-O' not specified, since `-Wuninitialized' requires `-O'), and
     implies `-Wunused' as well.

   * `-Wunused' no longer gives spurious messages for unused `EXTERNAL'
     names (since they are assumed to refer to block data program
     units, to make use of libraries more reliable).

   * Support `%LOC()' and `LOC()' of character arguments.

   * Support null (zero-length) character constants and expressions.

   * Support `f2c''s `IMAG()' generic intrinsic.

   * Support `ICHAR()', `IACHAR()', and `LEN()' of character
     expressions that are valid in assignments but not normally as
     actual arguments.

   * Support `f2c'-style `&' in column 1 to mean continuation line.

   * Allow `NAMELIST', `EXTERNAL', `INTRINSIC', and `VOLATILE' in
     `BLOCK DATA', even though these are not allowed by the standard.

   * Allow `RETURN' in main program unit.

   * Changes to Hollerith-constant support to obey Appendix C of the
     standard:

        - Now padded on the right with zeros, not spaces.

        - Hollerith "format specifications" in the form of arrays of
          non-character allowed.

        - Warnings issued when non-space truncation occurs when
          converting to another type.

        - When specified as actual argument, now passed by reference to
          `INTEGER' (padded on right with spaces if constant too small,
          otherwise fully intact if constant wider the `INTEGER' type)
          instead of by value.

     *Warning:* `f2c' differs on the interpretation of `CALL FOO(1HX)',
     which it treats exactly the same as `CALL FOO('X')', but which the
     standard and `g77' treat as `CALL FOO(%REF('X   '))' (padded with
     as many spaces as necessary to widen to `INTEGER'), essentially.

   * Changes and fixes to typeless-constant support:

        - Now treated as a typeless double-length `INTEGER' value.

        - Warnings issued when overflow occurs.

        - Padded on the left with zeros when converting to a larger
          type.

        - Should be properly aligned and ordered on the target machine
          for whatever type it is turned into.

        - When specified as actual argument, now passed as reference to
          a default `INTEGER' constant.

   * `%DESCR()' of a non-`CHARACTER' expression now passes a pointer to
     the expression plus a length for the expression just as if it were
     a `CHARACTER' expression.  For example, `CALL FOO(%DESCR(D))',
     where `D' is `REAL*8', is the same as `CALL FOO(D,%VAL(8)))'.

   * Name of multi-entrypoint master function changed to incorporate
     the name of the primary entry point instead of a decimal value, so
     the name of the master function for `SUBROUTINE X' with alternate
     entry points is now `__g77_masterfun_x'.

   * Remove redundant message about zero-step-count `DO' loops.

   * Clean up diagnostic messages, shortening many of them.

   * Fix typo in `g77' man page.

   * Clarify implications of constant-handling bugs in `f/BUGS'.

   * Generate better code for `**' operator with a right-hand operand of
     type `INTEGER'.

   * Generate better code for `SQRT()' and `DSQRT()', also when
     `-ffast-math' specified, enable better code generation for `SIN()'
     and `COS()'.

   * Generate better code for some kinds of array references.

   * Speed up lexing somewhat (this makes the compilation phase
     noticeably faster).

