


GAWK(1)                  Utility Commands                 GAWK(1)


NNAAMMEE
       gawk - pattern scanning and processing language

SSYYNNOOPPSSIISS
       ggaawwkk [ POSIX or GNU style options ] --ff _p_r_o_g_r_a_m_-_f_i_l_e [ ---- ]
       file ...
       ggaawwkk [ POSIX or GNU style options ] [  ----  ]  _p_r_o_g_r_a_m_-_t_e_x_t
       file ...

DDEESSCCRRIIPPTTIIOONN
       _G_a_w_k  is  the GNU Project's implementation of the AWK pro-
       gramming language.  It conforms to the definition  of  the
       language  in  the POSIX 1003.2 Command Language And Utili-
       ties Standard.  This version  in  turn  is  based  on  the
       description  in  _T_h_e  _A_W_K  _P_r_o_g_r_a_m_m_i_n_g  _L_a_n_g_u_a_g_e,  by Aho,
       Kernighan, and Weinberger, with  the  additional  features
       found in the System V Release 4 version of UNIX _a_w_k.  _G_a_w_k
       also provides more recent Bell Labs  _a_w_k  extensions,  and
       some GNU-specific extensions.

       The  command  line consists of options to _g_a_w_k itself, the
       AWK program text (if not supplied via  the  --ff  or  ----ffiillee
       options),  and values to be made available in the AARRGGCC and
       AARRGGVV pre-defined AWK variables.

OOPPTTIIOONN FFOORRMMAATT
       _G_a_w_k options may be either the traditional POSIX one  let-
       ter options, or the GNU style long options.  POSIX options
       start with a single ``-'', while long options  start  with
       ``--''.   Long  options are provided for both GNU-specific
       features and for POSIX mandated features.

       Following the POSIX standard,  _g_a_w_k-specific  options  are
       supplied  via  arguments  to  the  --WW option.  Multiple --WW
       options may be supplied Each --WW option has a corresponding
       long option, as detailed below.  Arguments to long options
       are either joined with the option by an ==  sign,  with  no
       intervening  spaces,  or  they may be provided in the next
       command line argument.  Long options may  be  abbreviated,
       as long as the abbreviation remains unique.

OOPPTTIIOONNSS
       _G_a_w_k accepts the following options.

       --FF _f_s
       ----ffiieelldd--sseeppaarraattoorr _f_s
              Use  _f_s for the input field separator (the value of
              the FFSS predefined variable).

       --vv _v_a_r==_v_a_l
       ----aassssiiggnn _v_a_r==_v_a_l
              Assign the value _v_a_l, to the variable  _v_a_r,  before
              execution  of  the  program  begins.  Such variable
              values are available to the BBEEGGIINN block of  an  AWK



Free Software Foundation   Dec 19 1996                          1





GAWK(1)                  Utility Commands                 GAWK(1)


              program.

       --ff _p_r_o_g_r_a_m_-_f_i_l_e
       ----ffiillee _p_r_o_g_r_a_m_-_f_i_l_e
              Read  the AWK program source from the file _p_r_o_g_r_a_m_-
              _f_i_l_e, instead of from the first command line  argu-
              ment.  Multiple --ff (or ----ffiillee) options may be used.

       --mmff _N_N_N
       --mmrr _N_N_N
              Set various memory limits to the value _N_N_N.  The  ff
              flag  sets  the maximum number of fields, and the rr
              flag sets the maximum record size.  These two flags
              and  the  --mm option are from the Bell Labs research
              version of UNIX _a_w_k.  They  are  ignored  by  _g_a_w_k,
              since _g_a_w_k has no pre-defined limits.

       --WW ttrraaddiittiioonnaall
       --WW ccoommppaatt
       ----ttrraaddiittiioonnaall
       ----ccoommppaatt
              Run  in _c_o_m_p_a_t_i_b_i_l_i_t_y mode.  In compatibility mode,
              _g_a_w_k behaves identically to UNIX _a_w_k; none  of  the
              GNU-specific extensions are recognized.  The use of
              ----ttrraaddiittiioonnaall is preferred over the other forms  of
              this  option.   See GGNNUU EEXXTTEENNSSIIOONNSS, below, for more
              information.

       --WW ccooppyylleefftt
       --WW ccooppyyrriigghhtt
       ----ccooppyylleefftt
       ----ccooppyyrriigghhtt
              Print the short version of the GNU copyright infor-
              mation  message  on  the standard output, and exits
              successfully.

       --WW hheellpp
       --WW uussaaggee
       ----hheellpp
       ----uussaaggee
              Print a relatively short summary of  the  available
              options  on the standard output.  (Per the _G_N_U _C_o_d_-
              _i_n_g _S_t_a_n_d_a_r_d_s, these options  cause  an  immediate,
              successful exit.)

       --WW lliinntt
       ----lliinntt Provide  warnings about constructs that are dubious
              or non-portable to other AWK implementations.

       --WW lliinntt--oolldd
       ----lliinntt--oolldd
              Provide warnings  about  constructs  that  are  not
              portable to the original version of Unix _a_w_k.




Free Software Foundation   Dec 19 1996                          2





GAWK(1)                  Utility Commands                 GAWK(1)


       --WW ppoossiixx
       ----ppoossiixx
              This  turns on _c_o_m_p_a_t_i_b_i_l_i_t_y mode, with the follow-
              ing additional restrictions:

              +o \\xx escape sequences are not recognized.

              +o Only space and tab act as field  separators  when
                FFSS is set to a single space, newline does not.

              +o The  synonym ffuunncc for the keyword ffuunnccttiioonn is not
                recognized.

              +o The operators **** and ****== cannot be used in  place
                of ^^ and ^^==.

              +o The fffflluusshh(()) function is not available.

       --WW rree--iinntteerrvvaall
       ----rree--iinntteerrvvaall
              Enable  the  use of _i_n_t_e_r_v_a_l _e_x_p_r_e_s_s_i_o_n_s in regular
              expression  matching  (see   RReegguullaarr   EExxpprreessssiioonnss,
              below).   Interval  expressions were not tradition-
              ally available in the AWK language. The POSIX stan-
              dard  added  them, to make _a_w_k and _e_g_r_e_p consistent
              with each other.  However, their use is  likely  to
              break  old AWK programs, so _g_a_w_k only provides them
              if they are requested with  this  option,  or  when
              ----ppoossiixx is specified.

       --WW ssoouurrccee _p_r_o_g_r_a_m_-_t_e_x_t
       ----ssoouurrccee _p_r_o_g_r_a_m_-_t_e_x_t
              Use  _p_r_o_g_r_a_m_-_t_e_x_t as AWK program source code.  This
              option allows the easy intermixing of library func-
              tions  (used  via  the  --ff and ----ffiillee options) with
              source code entered on the  command  line.   It  is
              intended primarily for medium to large AWK programs
              used in shell scripts.

       --WW vveerrssiioonn
       ----vveerrssiioonn
              Print version information for this particular  copy
              of  _g_a_w_k  on  the  standard output.  This is useful
              mainly for knowing if the current copy of  _g_a_w_k  on
              your  system is up to date with respect to whatever
              the Free Software Foundation is distributing.  This
              is  also  useful when reporting bugs.  (Per the _G_N_U
              _C_o_d_i_n_g _S_t_a_n_d_a_r_d_s, these options cause an immediate,
              successful exit.)

       ----     Signal  the end of options. This is useful to allow
              further arguments to  the  AWK  program  itself  to
              start with a ``-''.  This is mainly for consistency
              with the argument parsing convention used  by  most



Free Software Foundation   Dec 19 1996                          3





GAWK(1)                  Utility Commands                 GAWK(1)


              other POSIX programs.

       In  compatibility  mode,  any other options are flagged as
       illegal, but are otherwise ignored.  In normal  operation,
       as long as program text has been supplied, unknown options
       are passed on to the AWK program in  the  AARRGGVV  array  for
       processing.   This  is particularly useful for running AWK
       programs via the ``#!'' executable interpreter  mechanism.

AAWWKK PPRROOGGRRAAMM EEXXEECCUUTTIIOONN
       An  AWK  program  consists of a sequence of pattern-action
       statements and optional function definitions.

              _p_a_t_t_e_r_n   {{ _a_c_t_i_o_n _s_t_a_t_e_m_e_n_t_s }}
              ffuunnccttiioonn _n_a_m_e((_p_a_r_a_m_e_t_e_r _l_i_s_t)) {{ _s_t_a_t_e_m_e_n_t_s }}

       _G_a_w_k first reads the  program  source  from  the  _p_r_o_g_r_a_m_-
       _f_i_l_e(s)  if specified, from arguments to ----ssoouurrccee, or from
       the first non-option argument on the command line.  The --ff
       and  ----ssoouurrccee  options  may  be used multiple times on the
       command line.  _G_a_w_k will read the program text as  if  all
       the  _p_r_o_g_r_a_m_-_f_i_l_es  and command line source texts had been
       concatenated  together.   This  is  useful  for   building
       libraries of AWK functions, without having to include them
       in each new AWK program that uses them.  It also  provides
       the  ability  to  mix  library functions with command line
       programs.

       The environment variable AAWWKKPPAATTHH specifies a  search  path
       to use when finding source files named with the --ff option.
       If this variable does  not  exist,  the  default  path  is
       ""..:://uussrr//llooccaall//sshhaarree//aawwkk"".  (The actual directory may vary,
       depending upon how _g_a_w_k was built and  installed.)   If  a
       file  name given to the --ff option contains a ``/'' charac-
       ter, no path search is performed.

       _G_a_w_k executes AWK programs in the following order.  First,
       all  variable  assignments specified via the --vv option are
       performed.  Next, _g_a_w_k compiles the program into an inter-
       nal  form.   Then,  _g_a_w_k  executes  the  code in the BBEEGGIINN
       block(s) (if any), and then proceeds  to  read  each  file
       named  in  the AARRGGVV array.  If there are no files named on
       the command line, _g_a_w_k reads the standard input.

       If a filename on the command line has the form _v_a_r==_v_a_l  it
       is treated as a variable assignment. The variable _v_a_r will
       be assigned the value _v_a_l.  (This happens after any  BBEEGGIINN
       block(s) have been run.)  Command line variable assignment
       is most useful for dynamically  assigning  values  to  the
       variables  AWK  uses  to  control how input is broken into
       fields and records. It  is  also  useful  for  controlling
       state  if  multiple  passes  are needed over a single data
       file.




Free Software Foundation   Dec 19 1996                          4





GAWK(1)                  Utility Commands                 GAWK(1)


       If the value of a particular  element  of  AARRGGVV  is  empty
       (""""), _g_a_w_k skips over it.

       For  each  record  in  the  input, _g_a_w_k tests to see if it
       matches any _p_a_t_t_e_r_n in the AWK program.  For each  pattern
       that  the  record  matches,  the associated _a_c_t_i_o_n is exe-
       cuted.  The patterns are tested in the order they occur in
       the program.

       Finally,  after  all the input is exhausted, _g_a_w_k executes
       the code in the EENNDD block(s) (if any).

VVAARRIIAABBLLEESS,, RREECCOORRDDSS AANNDD FFIIEELLDDSS
       AWK variables are dynamic; they come into  existence  when
       they  are  first  used.  Their values are either floating-
       point numbers or strings, or both, depending upon how they
       are used. AWK also has one dimensional arrays; arrays with
       multiple dimensions may be simulated.  Several pre-defined
       variables  are  set  as  a  program  runs;  these  will be
       described as needed and summarized below.

   RReeccoorrddss
       Normally, records are separated by newline characters. You
       can  control how records are separated by assigning values
       to the built-in variable RRSS.  If RRSS is any single  charac-
       ter, that character separates records.  Otherwise, RRSS is a
       regular expression.  Text in the input that  matches  this
       regular  expression will separate the record.  However, in
       compatibility mode, only the first character of its string
       value is used for separating records.  If RRSS is set to the
       null string, then records are separated  by  blank  lines.
       When  RRSS  is set to the null string, the newline character
       always acts as a field separator, in addition to  whatever
       value FFSS may have.

   FFiieellddss
       As  each input record is read, _g_a_w_k splits the record into
       _f_i_e_l_d_s, using the value of the FFSS variable  as  the  field
       separator.   If FFSS is a single character, fields are sepa-
       rated by that character.  If FFSS is the null  string,  then
       each  individual character becomes a separate field.  Oth-
       erwise, FFSS is expected to be a  full  regular  expression.
       In  the special case that FFSS is a single space, fields are
       separated by runs of spaces and/or tabs  and/or  newlines.
       (But see the discussion of ----ppoossiixx, below).  Note that the
       value of IIGGNNOORREECCAASSEE  (see  below)  will  also  affect  how
       fields  are split when FFSS is a regular expression, and how
       records are separated when RRSS is a regular expression.

       If the FFIIEELLDDWWIIDDTTHHSS variable is set to  a  space  separated
       list  of  numbers,  each  field  is expected to have fixed
       width, and _g_a_w_k will split up the record using the  speci-
       fied widths.  The value of FFSS is ignored.  Assigning a new
       value to FFSS overrides the use of FFIIEELLDDWWIIDDTTHHSS, and restores



Free Software Foundation   Dec 19 1996                          5





GAWK(1)                  Utility Commands                 GAWK(1)


       the default behavior.

       Each  field  in  the input record may be referenced by its
       position, $$11, $$22, and so on.  $$00 is the whole record.  The
       value  of a field may be assigned to as well.  Fields need
       not be referenced by constants:

              nn == 55
              pprriinntt $$nn

       prints the fifth field in the input record.  The  variable
       NNFF  is  set  to  the  total  number of fields in the input
       record.

       References to non-existent fields (i.e. fields after  $$NNFF)
       produce the null-string. However, assigning to a non-exis-
       tent field (e.g., $$((NNFF++22)) == 55) will increase the value  of
       NNFF,  create any intervening fields with the null string as
       their value, and cause the value of $$00 to  be  recomputed,
       with the fields being separated by the value of OOFFSS.  Ref-
       erences to negative numbered fields cause a  fatal  error.
       Decrementing  NNFF  causes the values of fields past the new
       value to be lost, and the value of $$00  to  be  recomputed,
       with the fields being separated by the value of OOFFSS.

   BBuuiilltt--iinn VVaarriiaabblleess
       _G_a_w_k's built-in variables are:


       AARRGGCC        The number of command line arguments (does not
                   include  options  to  _g_a_w_k,  or  the   program
                   source).

       AARRGGIINNDD      The  index  in  AARRGGVV of the current file being
                   processed.

       AARRGGVV        Array of command line arguments. The array  is
                   indexed  from  0  to  AARRGGCC  -  1.  Dynamically
                   changing the contents of AARRGGVV can control  the
                   files used for data.

       CCOONNVVFFMMTT     The  conversion format for numbers, ""%%..66gg"", by
                   default.

       EENNVVIIRROONN     An array containing the values of the  current
                   environment.   The  array  is  indexed  by the
                   environment variables, each element being  the
                   value  of that variable (e.g., EENNVVIIRROONN[[""HHOOMMEE""]]
                   might be //hhoommee//aarrnnoolldd).  Changing  this  array
                   does  not  affect the environment seen by pro-
                   grams which _g_a_w_k spawns via redirection or the
                   ssyysstteemm(())  function.   (This  may  change  in a
                   future version of _g_a_w_k.)




Free Software Foundation   Dec 19 1996                          6





GAWK(1)                  Utility Commands                 GAWK(1)


       EERRRRNNOO       If a system error occurs either doing a  redi-
                   rection  for  ggeettlliinnee,  during a read for ggeett--
                   lliinnee, or during a  cclloossee(()),  then  EERRRRNNOO  will
                   contain a string describing the error.

       FFIIEELLDDWWIIDDTTHHSS A  white-space  separated list of fieldwidths.
                   When set, _g_a_w_k parses the input into fields of
                   fixed width, instead of using the value of the
                   FFSS variable as the field separator.  The fixed
                   field  width  facility  is still experimental;
                   the semantics may change as _g_a_w_k evolves  over
                   time.

       FFIILLEENNAAMMEE    The  name  of  the  current input file.  If no
                   files are specified on the command  line,  the
                   value of FFIILLEENNAAMMEE is ``-''.  However, FFIILLEENNAAMMEE
                   is undefined inside the BBEEGGIINN block.

       FFNNRR         The input record number in the  current  input
                   file.

       FFSS          The input field separator, a space by default.
                   See FFiieellddss, above.

       IIGGNNOORREECCAASSEE  Controls the case-sensitivity of  all  regular
                   expression  and  string operations. If IIGGNNOORREE--
                   CCAASSEE has a non-zero value, then string compar-
                   isons  and  pattern  matching  in rules, field
                   splitting with FFSS, record separating with  RRSS,
                   regular expression matching with ~~ and !!~~, and
                   the  ggeennssuubb(()),   ggssuubb(()),   iinnddeexx(()),   mmaattcchh(()),
                   sspplliitt(()),  and ssuubb(()) pre-defined functions will
                   all ignore case when doing regular  expression
                   operations.   Thus, if IIGGNNOORREECCAASSEE is not equal
                   to zero, //aaBB// matches all of the strings ""aabb"",
                   ""aaBB"",  ""AAbb"",  and ""AABB"".  As with all AWK vari-
                   ables, the  initial  value  of  IIGGNNOORREECCAASSEE  is
                   zero,  so  all  regular  expression and string
                   operations are normally case-sensitive.  Under
                   Unix,  the  full  ISO 8859-1 Latin-1 character
                   set is used when ignoring case.  NNOOTTEE:: In ver-
                   sions  of  _g_a_w_k  prior to 3.0, IIGGNNOORREECCAASSEE only
                   affected regular expression operations. It now
                   affects string comparisons as well.

       NNFF          The  number  of  fields  in  the current input
                   record.

       NNRR          The total number of input records seen so far.

       OOFFMMTT        The  output  format  for  numbers,  ""%%..66gg"", by
                   default.

       OOFFSS         The  output  field  separator,  a   space   by



Free Software Foundation   Dec 19 1996                          7





GAWK(1)                  Utility Commands                 GAWK(1)


                   default.

       OORRSS         The output record separator, by default a new-
                   line.

       RRSS          The input record separator, by default a  new-
                   line.

       RRTT          The  record  terminator.   _G_a_w_k sets RRTT to the
                   input text that matched the character or regu-
                   lar expression specified by RRSS.

       RRSSTTAARRTT      The  index  of  the first character matched by
                   mmaattcchh(()); 0 if no match.

       RRLLEENNGGTTHH     The length of the string matched  by  mmaattcchh(());
                   -1 if no match.

       SSUUBBSSEEPP      The  character  used to separate multiple sub-
                   scripts in array elements, by default  ""\\003344"".

   AArrrraayyss
       Arrays  are  subscripted with an expression between square
       brackets ([[ and ]]).  If the expression  is  an  expression
       list  (_e_x_p_r,  _e_x_p_r  ...)   then  the  array subscript is a
       string consisting of the  concatenation  of  the  (string)
       value  of  each  expression, separated by the value of the
       SSUUBBSSEEPP variable.  This facility is used to simulate multi-
       ply dimensioned arrays. For example:

              ii == ""AA"";; jj == ""BB"";; kk == ""CC""
              xx[[ii,, jj,, kk]] == ""hheelllloo,, wwoorrlldd\\nn""

       assigns  the string ""hheelllloo,, wwoorrlldd\\nn"" to the element of the
       array xx which is indexed by the string ""AA\\003344BB\\003344CC"".  All
       arrays in AWK are associative, i.e. indexed by string val-
       ues.

       The special operator iinn may be used  in  an  iiff  or  wwhhiillee
       statement  to see if an array has an index consisting of a
       particular value.

              iiff ((vvaall iinn aarrrraayy))
                   pprriinntt aarrrraayy[[vvaall]]

       If the array has multiple subscripts, use ((ii,, jj)) iinn aarrrraayy.

       The iinn construct may also be used in a ffoorr loop to iterate
       over all the elements of an array.

       An element may be deleted from an array using  the  ddeelleettee
       statement.   The  ddeelleettee  statement  may  also  be used to
       delete the entire contents of an array, just by specifying
       the array name without a subscript.



Free Software Foundation   Dec 19 1996                          8





GAWK(1)                  Utility Commands                 GAWK(1)


   VVaarriiaabbllee TTyyppiinngg AAnndd CCoonnvveerrssiioonn
       Variables  and  fields may be (floating point) numbers, or
       strings, or both. How the value of a  variable  is  inter-
       preted  depends  upon  its  context.  If used in a numeric
       expression, it will be treated as a number, if used  as  a
       string it will be treated as a string.

       To  force  a  variable to be treated as a number, add 0 to
       it; to force it to be treated as a string, concatenate  it
       with the null string.

       When  a  string must be converted to a number, the conver-
       sion is accomplished using _a_t_o_f(3).  A number is converted
       to  a  string  by  using  the value of CCOONNVVFFMMTT as a format
       string for _s_p_r_i_n_t_f(3), with the numeric value of the vari-
       able as the argument.  However, even though all numbers in
       AWK are floating-point, integral values  are  _a_l_w_a_y_s  con-
       verted as integers.  Thus, given

              CCOONNVVFFMMTT == ""%%22..22ff""
              aa == 1122
              bb == aa """"

       the variable bb has a string value of ""1122"" and not ""1122..0000"".

       _G_a_w_k performs comparisons as follows: If two variables are
       numeric,  they  are compared numerically.  If one value is
       numeric and the  other  has  a  string  value  that  is  a
       ``numeric string,'' then comparisons are also done numeri-
       cally.  Otherwise, the numeric value  is  converted  to  a
       string  and a string comparison is performed.  Two strings
       are compared, of course, as  strings.   According  to  the
       POSIX standard, even if two strings are numeric strings, a
       numeric comparison is performed.  However, this is clearly
       incorrect, and _g_a_w_k does not do this.

       Note  that string constants, such as ""5577"", are _n_o_t numeric
       strings, they are string constants.  The idea of ``numeric
       string''  only applies to fields, ggeettlliinnee input, FFIILLEENNAAMMEE,
       AARRGGVV elements, EENNVVIIRROONN elements and  the  elements  of  an
       array  created  by  sspplliitt(()) that are numeric strings.  The
       basic idea is that _u_s_e_r _i_n_p_u_t, and only user  input,  that
       looks numeric, should be treated that way.

       Uninitialized  variables  have the numeric value 0 and the
       string value "" (the null, or empty, string).

PPAATTTTEERRNNSS AANNDD AACCTTIIOONNSS
       AWK is a line oriented language. The pattern comes  first,
       and  then  the action. Action statements are enclosed in {{
       and }}.  Either the pattern may be missing, or  the  action
       may  be  missing, but, of course, not both. If the pattern
       is missing, the action will be executed for  every  single
       record of input.  A missing action is equivalent to



Free Software Foundation   Dec 19 1996                          9





GAWK(1)                  Utility Commands                 GAWK(1)


              {{ pprriinntt }}

       which prints the entire record.

       Comments  begin  with  the  ``#''  character, and continue
       until the end of the line.  Blank lines  may  be  used  to
       separate  statements.   Normally,  a statement ends with a
       newline, however, this is not the case for lines ending in
       a  ``,'',  {{, ??, ::, &&&&, or ||||.  Lines ending in ddoo or eellssee
       also have their statements automatically continued on  the
       following  line.   In other cases, a line can be continued
       by ending it with a ``\'', in which case the newline  will
       be ignored.

       Multiple  statements  may be put on one line by separating
       them with a ``;''.  This applies to  both  the  statements
       within the action part of a pattern-action pair (the usual
       case), and to the pattern-action statements themselves.

   PPaatttteerrnnss
       AWK patterns may be one of the following:

              BBEEGGIINN
              EENNDD
              //_r_e_g_u_l_a_r _e_x_p_r_e_s_s_i_o_n//
              _r_e_l_a_t_i_o_n_a_l _e_x_p_r_e_s_s_i_o_n
              _p_a_t_t_e_r_n &&&& _p_a_t_t_e_r_n
              _p_a_t_t_e_r_n |||| _p_a_t_t_e_r_n
              _p_a_t_t_e_r_n ?? _p_a_t_t_e_r_n :: _p_a_t_t_e_r_n
              ((_p_a_t_t_e_r_n))
              !! _p_a_t_t_e_r_n
              _p_a_t_t_e_r_n_1,, _p_a_t_t_e_r_n_2

       BBEEGGIINN and EENNDD are two special kinds of patterns which  are
       not  tested  against  the  input.  The action parts of all
       BBEEGGIINN patterns are merged as if  all  the  statements  had
       been  written  in  a single BBEEGGIINN block. They are executed
       before any of the input is read. Similarly,  all  the  EENNDD
       blocks  are  merged,  and  executed  when all the input is
       exhausted (or when an eexxiitt statement is executed).   BBEEGGIINN
       and EENNDD patterns cannot be combined with other patterns in
       pattern expressions.  BBEEGGIINN and EENNDD patterns  cannot  have
       missing action parts.

       For  //_r_e_g_u_l_a_r  _e_x_p_r_e_s_s_i_o_n// patterns, the associated state-
       ment is executed for each input record  that  matches  the
       regular  expression.   Regular expressions are the same as
       those in _e_g_r_e_p(1), and are summarized below.

       A _r_e_l_a_t_i_o_n_a_l _e_x_p_r_e_s_s_i_o_n  may  use  any  of  the  operators
       defined  below in the section on actions.  These generally
       test whether certain fields match certain regular  expres-
       sions.




Free Software Foundation   Dec 19 1996                         10





GAWK(1)                  Utility Commands                 GAWK(1)


       The  &&&&, ||||, and !!  operators are logical AND, logical OR,
       and logical NOT, respectively, as in C.   They  do  short-
       circuit evaluation, also as in C, and are used for combin-
       ing more primitive pattern expressions. As  in  most  lan-
       guages,  parentheses  may  be  used to change the order of
       evaluation.

       The ??:: operator is like the same operator  in  C.  If  the
       first pattern is true then the pattern used for testing is
       the second pattern, otherwise it is the third. Only one of
       the second and third patterns is evaluated.

       The  _p_a_t_t_e_r_n_1,,  _p_a_t_t_e_r_n_2 form of an expression is called a
       _r_a_n_g_e _p_a_t_t_e_r_n.  It matches all input records starting with
       a  record  that  matches  _p_a_t_t_e_r_n_1, and continuing until a
       record that matches _p_a_t_t_e_r_n_2, inclusive. It does not  com-
       bine with any other sort of pattern expression.

   RReegguullaarr EExxpprreessssiioonnss
       Regular  expressions are the extended kind found in _e_g_r_e_p.
       They are composed of characters as follows:

       _c          matches the non-metacharacter _c.

       _\_c         matches the literal character _c.

       ..          matches any character _i_n_c_l_u_d_i_n_g newline.

       ^^          matches the beginning of a string.

       $$          matches the end of a string.

       [[_a_b_c_._._.]]   character list, matches any of  the  characters
                  _a_b_c_._._..

       [[^^_a_b_c_._._.]]  negated  character  list, matches any character
                  except _a_b_c_._._..

       _r_1||_r_2      alternation: matches either _r_1 or _r_2.

       _r_1_r_2       concatenation: matches _r_1, and then _r_2.

       _r++         matches one or more _r's.

       _r**         matches zero or more _r's.

       _r??         matches zero or one _r's.

       ((_r))        grouping: matches _r.

       _r{{_n}}
       _r{{_n,,}}
       _r{{_n,,_m}}     One or two  numbers  inside  braces  denote  an
                  _i_n_t_e_r_v_a_l _e_x_p_r_e_s_s_i_o_n.  If there is one number in



Free Software Foundation   Dec 19 1996                         11





GAWK(1)                  Utility Commands                 GAWK(1)


                  the braces, the preceding regexp _r is  repeated
                  _n times.  If there are two numbers separated by
                  a comma, _r is repeated _n to _m times.  If  there
                  is  one  number  followed by a comma, then _r is
                  repeated at least _n times.
                  Interval  expressions  are  only  available  if
                  either ----ppoossiixx or ----rree--iinntteerrvvaall is specified on
                  the command line.

       \\yy         matches the empty string at either  the  begin-
                  ning or the end of a word.

       \\BB         matches the empty string within a word.

       \\<<         matches  the empty string at the beginning of a
                  word.

       \\>>         matches the empty string at the end of a  word.

       \\ww         matches any word-constituent character (letter,
                  digit, or underscore).

       \\WW         matches any character  that  is  not  word-con-
                  stituent.

       \\``         matches  the empty string at the beginning of a
                  buffer (string).

       \\''         matches the  empty  string  at  the  end  of  a
                  buffer.

       The  escape  sequences  that are valid in string constants
       (see below) are also legal in regular expressions.

       _C_h_a_r_a_c_t_e_r _c_l_a_s_s_e_s are a  new  feature  introduced  in  the
       POSIX  standard.   A character class is a special notation
       for describing lists of characters that  have  a  specific
       attribute,  but where the actual characters themselves can
       vary from country to country and/or from character set  to
       character  set.   For  example,  the  notion of what is an
       alphabetic character differs in the USA and in France.

       A character class is only valid in  a  regexp  _i_n_s_i_d_e  the
       brackets  of  a character list.  Character classes consist
       of [[::, a keyword denoting the class, and ::]].  Here are the
       character classes defined by the POSIX standard.

       [[::aallnnuumm::]]
              Alphanumeric characters.

       [[::aallpphhaa::]]
              Alphabetic characters.





Free Software Foundation   Dec 19 1996                         12





GAWK(1)                  Utility Commands                 GAWK(1)


       [[::bbllaannkk::]]
              Space or tab characters.

       [[::ccnnttrrll::]]
              Control characters.

       [[::ddiiggiitt::]]
              Numeric characters.

       [[::ggrraapphh::]]
              Characters that are both printable and visible.  (A
              space is printable, but not visible, while an aa  is
              both.)

       [[::lloowweerr::]]
              Lower-case alphabetic characters.

       [[::pprriinntt::]]
              Printable  characters (characters that are not con-
              trol characters.)

       [[::ppuunncctt::]]
              Punctuation characters  (characters  that  are  not
              letter,  digits, control characters, or space char-
              acters).

       [[::ssppaaccee::]]
              Space characters (such as space, tab, and formfeed,
              to name a few).

       [[::uuppppeerr::]]
              Upper-case alphabetic characters.

       [[::xxddiiggiitt::]]
              Characters that are hexadecimal digits.

       For  example, before the POSIX standard, to match alphanu-
       meric  characters,   you   would   have   had   to   write
       //[[AA--ZZaa--zz00--99]]//.  If your character set had other alphabetic
       characters in it, this would not  match  them.   With  the
       POSIX  character classes, you can write //[[[[::aallnnuumm::]]]]//, and
       this will match _a_l_l the alphabetic and numeric  characters
       in your character set.

       Two  additional  special sequences can appear in character
       lists.  These apply to non-ASCII character sets, which can
       have  single  symbols (called _c_o_l_l_a_t_i_n_g _e_l_e_m_e_n_t_s) that are
       represented with more than one character, as well as  sev-
       eral  characters  that  are  equivalent  for _c_o_l_l_a_t_i_n_g, or
       sorting, purposes.  (E.g., in French, a plain ``e'' and  a
       grave-accented e` are equivalent.)

       Collating Symbols
              A  collating symbols is a multi-character collating



Free Software Foundation   Dec 19 1996                         13





GAWK(1)                  Utility Commands                 GAWK(1)


              element enclosed in [[..  and ..]].  For example, if cchh
              is  a collating element, then [[[[..cchh..]]]]  is a regexp
              that matches this collating element, while [[cchh]]  is
              a regexp that matches either cc or hh.

       Equivalence Classes
              An  equivalence class is a locale-specific name for
              a list of characters that are equivalent. The  name
              is  enclosed in [[== and ==]].  For example, the name ee
              might be used to represent all  of  ``e,''  ``e`,''
              and  ``e`.''  In this case, [[[[==ee]]]] is a regexp that
              matches any of
               .BR e ,
               .BR e' , or
               .BR e` .

       These features are very valuable in  non-English  speaking
       locales.  The library functions that _g_a_w_k uses for regular
       expression matching currently only recognize POSIX charac-
       ter  classes;  they  do not recognize collating symbols or
       equivalence classes.

       The \\yy, \\BB, \\<<, \\>>, \\ww, \\WW, \\``, and \\'' operators are  spe-
       cific  to _g_a_w_k; they are extensions based on facilities in
       the GNU regexp libraries.

       The various command line options control how  _g_a_w_k  inter-
       prets characters in regexps.

       No options
              In  the  default case, _g_a_w_k provide all the facili-
              ties of POSIX regexps and the GNU regexp  operators
              described above.  However, interval expressions are
              not supported.

       ----ppoossiixx
              Only POSIX regexps are supported, the GNU operators
              are  not  special.  (E.g., \\ww matches a literal ww).
              Interval expressions are allowed.

       ----ttrraaddiittiioonnaall
              Traditional Unix _a_w_k regexps are matched.  The  GNU
              operators are not special, interval expressions are
              not available, and neither are the POSIX  character
              classes   ([[[[::aallnnuumm::]]]]   and  so  on).   Characters
              described by octal and hexadecimal escape sequences
              are  treated literally, even if they represent reg-
              exp metacharacters.

       ----rree--iinntteerrvvaall
              Allow interval  expressions  in  regexps,  even  if
              ----ttrraaddiittiioonnaall has been provided.





Free Software Foundation   Dec 19 1996                         14





GAWK(1)                  Utility Commands                 GAWK(1)


   AAccttiioonnss
       Action statements are enclosed in braces, {{ and }}.  Action
       statements consist of the usual  assignment,  conditional,
       and looping statements found in most languages. The opera-
       tors,  control  statements,  and  input/output  statements
       available are patterned after those in C.

   OOppeerraattoorrss
       The  operators  in AWK, in order of decreasing precedence,
       are


       ((...))       Grouping

       $$           Field reference.

       ++++ ----       Increment and decrement, both prefix and post-
                   fix.

       ^^           Exponentiation  (****  may also be used, and ****==
                   for the assignment operator).

       ++ -- !!       Unary plus, unary minus, and logical negation.

       ** // %%       Multiplication, division, and modulus.

       ++ --         Addition and subtraction.

       _s_p_a_c_e       String concatenation.

       << >>
       <<== >>==
       !!== ====       The regular relational operators.

       ~~ !!~~        Regular   expression   match,  negated  match.
                   NNOOTTEE:: Do not use a constant regular expression
                   (//ffoooo//)  on  the  left-hand side of a ~~ or !!~~.
                   Only use one  on  the  right-hand  side.   The
                   expression //ffoooo// ~~ _e_x_p has the same meaning as
                   (((($$00 ~~ //ffoooo//)) ~~ _e_x_p)).   This  is  usually  _n_o_t
                   what was intended.

       iinn          Array membership.

       &&&&          Logical AND.

       ||||          Logical OR.

       ??::          The  C  conditional  expression.  This has the
                   form _e_x_p_r_1 ?? _e_x_p_r_2 :: _e_x_p_r_3. If _e_x_p_r_1 is  true,
                   the  value  of the expression is _e_x_p_r_2, other-
                   wise it is _e_x_p_r_3.  Only one of _e_x_p_r_2 and _e_x_p_r_3
                   is evaluated.




Free Software Foundation   Dec 19 1996                         15





GAWK(1)                  Utility Commands                 GAWK(1)


       == ++== --==
       **== //== %%== ^^== Assignment.  Both  absolute  assignment ((_v_a_r ==
                   _v_a_l_u_e))  and  operator-assignment  (the   other
                   forms) are supported.

   CCoonnttrrooll SSttaatteemmeennttss
       The control statements are as follows:

              iiff ((_c_o_n_d_i_t_i_o_n)) _s_t_a_t_e_m_e_n_t [ eellssee _s_t_a_t_e_m_e_n_t ]
              wwhhiillee ((_c_o_n_d_i_t_i_o_n)) _s_t_a_t_e_m_e_n_t
              ddoo _s_t_a_t_e_m_e_n_t wwhhiillee ((_c_o_n_d_i_t_i_o_n))
              ffoorr ((_e_x_p_r_1;; _e_x_p_r_2;; _e_x_p_r_3)) _s_t_a_t_e_m_e_n_t
              ffoorr ((_v_a_r iinn _a_r_r_a_y)) _s_t_a_t_e_m_e_n_t
              bbrreeaakk
              ccoonnttiinnuuee
              ddeelleettee _a_r_r_a_y[[_i_n_d_e_x]]
              ddeelleettee _a_r_r_a_y
              eexxiitt [ _e_x_p_r_e_s_s_i_o_n ]
              {{ _s_t_a_t_e_m_e_n_t_s }}

   II//OO SSttaatteemmeennttss
       The input/output statements are as follows:


       cclloossee((_f_i_l_e))           Close file (or pipe, see below).

       ggeettlliinnee               Set  $$00  from next input record; set
                             NNFF, NNRR, FFNNRR.

       ggeettlliinnee <<_f_i_l_e         Set $$00 from next record of _f_i_l_e; set
                             NNFF.

       ggeettlliinnee _v_a_r           Set  _v_a_r from next input record; set
                             NNRR, FFNNRR.

       ggeettlliinnee _v_a_r <<_f_i_l_e     Set _v_a_r from next record of _f_i_l_e.

       nneexxtt                  Stop processing  the  current  input
                             record.  The  next  input  record is
                             read and processing starts over with
                             the  first  pattern  in the AWK pro-
                             gram. If the end of the  input  data
                             is  reached,  the  EENNDD  block(s), if
                             any, are executed.

       nneexxttffiillee              Stop processing  the  current  input
                             file.   The  next  input record read
                             comes  from  the  next  input  file.
                             FFIILLEENNAAMMEE and AARRGGIINNDD are updated, FFNNRR
                             is reset to 1, and processing starts
                             over  with  the first pattern in the
                             AWK program. If the end of the input
                             data  is  reached, the EENNDD block(s),
                             if any, are executed.  NNOOTTEE:: Earlier



Free Software Foundation   Dec 19 1996                         16





GAWK(1)                  Utility Commands                 GAWK(1)


                             versions  of gawk used nneexxtt ffiillee, as
                             two words. While this usage is still
                             recognized,  it  generates a warning
                             message  and  will   eventually   be
                             removed.

       pprriinntt                 Prints the current record.  The out-
                             put record is  terminated  with  the
                             value of the OORRSS variable.

       pprriinntt _e_x_p_r_-_l_i_s_t       Prints expressions.  Each expression
                             is separated by the value of the OOFFSS
                             variable.  The output record is ter-
                             minated with the value  of  the  OORRSS
                             variable.

       pprriinntt _e_x_p_r_-_l_i_s_t >>_f_i_l_e Prints  expressions  on  _f_i_l_e.  Each
                             expression is separated by the value
                             of  the  OOFFSS  variable.  The  output
                             record is terminated with the  value
                             of the OORRSS variable.

       pprriinnttff _f_m_t_, _e_x_p_r_-_l_i_s_t Format and print.

       pprriinnttff _f_m_t_, _e_x_p_r_-_l_i_s_t >>_f_i_l_e
                             Format and print on _f_i_l_e.

       ssyysstteemm((_c_m_d_-_l_i_n_e))      Execute  the  command  _c_m_d_-_l_i_n_e, and
                             return the exit status.   (This  may
                             not  be  available on non-POSIX sys-
                             tems.)

       fffflluusshh(([_f_i_l_e]))        Flush any  buffers  associated  with
                             the  open  output file or pipe _f_i_l_e.
                             If _f_i_l_e is  missing,  then  standard
                             output  is  flushed.  If _f_i_l_e is the
                             null string, then  all  open  output
                             files  and  pipes have their buffers
                             flushed.

       Other input/output  redirections  are  also  allowed.  For
       pprriinntt and pprriinnttff, >>>>_f_i_l_e appends output to the _f_i_l_e, while
       || _c_o_m_m_a_n_d writes on a pipe.  In a similar fashion, _c_o_m_m_a_n_d
       ||  ggeettlliinnee  pipes  into ggeettlliinnee.  The ggeettlliinnee command will
       return 0 on end of file, and -1 on an error.

   TThhee _p_r_i_n_t_f SSttaatteemmeenntt
       The AWK versions of the  pprriinnttff  statement  and  sspprriinnttff(())
       function (see below) accept the following conversion spec-
       ification formats:

       %%cc     An ASCII character.  If the argument used for %%cc is
              numeric,  it is treated as a character and printed.
              Otherwise, the argument is assumed to be a  string,



Free Software Foundation   Dec 19 1996                         17





GAWK(1)                  Utility Commands                 GAWK(1)


              and  the  only  first  character  of that string is
              printed.

       %%dd
       %%ii     A decimal number (the integer part).

       %%ee
       %%EE     A   floating   point    number    of    the    form
              [[--]]dd..ddddddddddddee[[++--]]dddd.   The  %%EE format uses EE instead
              of ee.

       %%ff     A floating point number of the form  [[--]]dddddd..dddddddddddd.

       %%gg
       %%GG     Use %%ee or %%ff conversion, whichever is shorter, with
              nonsignificant zeros  suppressed.   The  %%GG  format
              uses %%EE instead of %%ee.

       %%oo     An unsigned octal number (again, an integer).

       %%ss     A character string.

       %%xx
       %%XX     An  unsigned  hexadecimal  number (an integer).  %%XX
              format uses AABBCCDDEEFF instead of aabbccddeeff.

       %%%%     A single %% character; no argument is converted.

       There are optional, additional  parameters  that  may  lie
       between the %% and the control letter:

       --      The  expression should be left-justified within its
              field.

       _s_p_a_c_e  For numeric  conversions,  prefix  positive  values
              with  a  space,  and  negative  values with a minus
              sign.

       ++      The plus sign, used before the width modifier  (see
              below),  says  to  always supply a sign for numeric
              conversions, even if the data to  be  formatted  is
              positive. The ++ overrides the space modifier.

       ##      Use  an ``alternate form'' for certain control let-
              ters.  For %%oo, supply a leading zero.  For %%xx,  and
              %%XX, supply a leading 00xx or 00XX for a nonzero result.
              For %%ee, %%EE, and %%ff, the result will always  contain
              a  decimal  point.   For %%gg, and %%GG, trailing zeros
              are not removed from the result.

       00      A leading 00 (zero) acts as a flag,  that  indicates
              output  should  be  padded  with  zeroes instead of
              spaces.  This applies even  to  non-numeric  output
              formats.   This  flag  only  has an effect when the



Free Software Foundation   Dec 19 1996                         18





GAWK(1)                  Utility Commands                 GAWK(1)


              field width is wider than the value to be  printed.

       _w_i_d_t_h  The field should be padded to this width. The field
              is normally padded with spaces.  If the 00 flag  has
              been used, it is padded with zeroes.

       .._p_r_e_c  A  number  that specifies the precision to use when
              printing.  For the %%ee, %%EE,  and  %%ff  formats,  this
              specifies  the number of digits you want printed to
              the right of the decimal point.  For the %%gg, and %%GG
              formats, it specifies the maximum number of signif-
              icant digits.  For the %%dd, %%oo, %%ii, %%uu, %%xx,  and  %%XX
              formats,  it specifies the minimum number of digits
              to print.  For a string, it specifies  the  maximum
              number of characters from the string that should be
              printed.

       The dynamic _w_i_d_t_h and _p_r_e_c  capabilities  of  the  ANSI  C
       pprriinnttff(())  routines  are supported.  A ** in place of either
       the wwiiddtthh or pprreecc specifications will cause  their  values
       to be taken from the argument list to pprriinnttff or sspprriinnttff(()).

   SSppeecciiaall FFiillee NNaammeess
       When doing I/O redirection from  either  pprriinntt  or  pprriinnttff
       into  a  file, or via ggeettlliinnee from a file, _g_a_w_k recognizes
       certain special  filenames  internally.   These  filenames
       allow  access  to  open  file  descriptors  inherited from
       _g_a_w_k's parent process (usually the shell).  Other  special
       filenames  provide access to information about the running
       ggaawwkk process.  The filenames are:

       //ddeevv//ppiidd    Reading this file returns the  process  ID  of
                   the  current  process,  in decimal, terminated
                   with a newline.

       //ddeevv//ppppiidd   Reading this file returns the  parent  process
                   ID  of the current process, in decimal, termi-
                   nated with a newline.

       //ddeevv//ppggrrppiidd Reading this file returns the process group ID
                   of the current process, in decimal, terminated
                   with a newline.

       //ddeevv//uusseerr   Reading this file returns a single record ter-
                   minated  with a newline.  The fields are sepa-
                   rated with spaces.  $$11 is  the  value  of  the
                   _g_e_t_u_i_d(2)  system call, $$22 is the value of the
                   _g_e_t_e_u_i_d(2) system call, $$33 is the value of the
                   _g_e_t_g_i_d(2)  system call, and $$44 is the value of
                   the _g_e_t_e_g_i_d(2) system call.  If there are  any
                   additional  fields,  they  are  the  group IDs
                   returned by _g_e_t_g_r_o_u_p_s(2).  Multiple groups may
                   not be supported on all systems.




Free Software Foundation   Dec 19 1996                         19





GAWK(1)                  Utility Commands                 GAWK(1)


       //ddeevv//ssttddiinn  The standard input.

       //ddeevv//ssttddoouutt The standard output.

       //ddeevv//ssttddeerrrr The standard error output.

       //ddeevv//ffdd//_n   The   file   associated  with  the  open  file
                   descriptor _n.

       These are particularly  useful  for  error  messages.  For
       example:

              pprriinntt ""YYoouu bblleeww iitt!!"" >> ""//ddeevv//ssttddeerrrr""

       whereas you would otherwise have to use

              pprriinntt ""YYoouu bblleeww iitt!!"" || ""ccaatt 11>>&&22""

       These  file  names may also be used on the command line to
       name data files.

   NNuummeerriicc FFuunnccttiioonnss
       AWK has the following pre-defined arithmetic functions:


       aattaann22((_y,, _x))   returns the arctangent of _y_/_x in radians.

       ccooss((_e_x_p_r))     returns the cosine  of  _e_x_p_r,  which  is  in
                     radians.

       eexxpp((_e_x_p_r))     the exponential function.

       iinntt((_e_x_p_r))     truncates to integer.

       lloogg((_e_x_p_r))     the natural logarithm function.

       rraanndd(())        returns a random number between 0 and 1.

       ssiinn((_e_x_p_r))     returns  the sine of _e_x_p_r, which is in radi-
                     ans.

       ssqqrrtt((_e_x_p_r))    the square root function.

       ssrraanndd(([_e_x_p_r])) uses _e_x_p_r as a new seed for the random  num-
                     ber  generator.  If no _e_x_p_r is provided, the
                     time of day will be used.  The return  value
                     is  the  previous seed for the random number
                     generator.

   SSttrriinngg FFuunnccttiioonnss
       _G_a_w_k has the following pre-defined string functions:


       ggeennssuubb((_r,, _s,, _h [,, _t]))   search the  target  string  _t  for



Free Software Foundation   Dec 19 1996                         20





GAWK(1)                  Utility Commands                 GAWK(1)


                               matches  of the regular expression
                               _r.  If _h  is  a  string  beginning
                               with  gg  or  GG,  then  replace all
                               matches of _r with _s.  Otherwise, _h
                               is a number indicating which match
                               of _r to replace.  If no _t is  sup-
                               plied, $$00 is used instead.  Within
                               the  replacement   text   _s,   the
                               sequence  \\_n,  where  _n is a digit
                               from 1 to 9, may be used to  indi-
                               cate  just  the  text that matched
                               the _n'th parenthesized  subexpres-
                               sion.  The  sequence \\00 represents
                               the entire matched text,  as  does
                               the character &&.  Unlike ssuubb(()) and
                               ggssuubb(()),  the  modified  string  is
                               returned  as  the  result  of  the
                               function, and the original  target
                               string is _n_o_t changed.

       ggssuubb((_r,, _s [,, _t]))        for  each  substring  matching the
                               regular expression _r in the string
                               _t,  substitute  the  string _s, and
                               return  the  number  of  substitu-
                               tions.   If _t is not supplied, use
                               $$00.  An && in the replacement  text
                               is replaced with the text that was
                               actually matched.  Use \\&& to get a
                               literal  &&.  See _A_W_K _L_a_n_g_u_a_g_e _P_r_o_-
                               _g_r_a_m_m_i_n_g for a  fuller  discussion
                               of  the  rules  for  &&''ss and back-
                               slashes in the replacement text of
                               ssuubb(()), ggssuubb(()), and ggeennssuubb(()).

       iinnddeexx((_s,, _t))             returns  the index of the string _t
                               in the string _s, or 0 if _t is  not
                               present.

       lleennggtthh(([_s]))             returns  the  length of the string
                               _s, or the length of $$00 if _s is not
                               supplied.

       mmaattcchh((_s,, _r))             returns  the  position  in _s where
                               the regular expression  _r  occurs,
                               or 0 if _r is not present, and sets
                               the values of RRSSTTAARRTT and  RRLLEENNGGTTHH.

       sspplliitt((_s,, _a [,, _r]))       splits the string _s into the array
                               _a on the regular expression _r, and
                               returns the number of fields. If _r
                               is omitted, FFSS  is  used  instead.
                               The  array  _a  is  cleared  first.
                               Splitting behaves  identically  to
                               field  splitting, described above.



Free Software Foundation   Dec 19 1996                         21





GAWK(1)                  Utility Commands                 GAWK(1)


       sspprriinnttff((_f_m_t,, _e_x_p_r_-_l_i_s_t)) prints _e_x_p_r_-_l_i_s_t according to _f_m_t,
                               and  returns the resulting string.

       ssuubb((_r,, _s [,, _t]))         just like  ggssuubb(()),  but  only  the
                               first    matching   substring   is
                               replaced.

       ssuubbssttrr((_s,, _i [,, _n]))      returns the  at  most  _n-character
                               substring  of _s starting at _i.  If
                               _n is omitted, the  rest  of  _s  is
                               used.

       ttoolloowweerr((_s_t_r))            returns  a copy of the string _s_t_r,
                               with all the upper-case characters
                               in  _s_t_r translated to their corre-
                               sponding lower-case  counterparts.
                               Non-alphabetic characters are left
                               unchanged.

       ttoouuppppeerr((_s_t_r))            returns a copy of the string  _s_t_r,
                               with all the lower-case characters
                               in _s_t_r translated to their  corre-
                               sponding  upper-case counterparts.
                               Non-alphabetic characters are left
                               unchanged.

   TTiimmee FFuunnccttiioonnss
       Since  one of the primary uses of AWK programs is process-
       ing log files that contain time  stamp  information,  _g_a_w_k
       provides  the  following  two functions for obtaining time
       stamps and formatting them.


       ssyyssttiimmee(()) returns the current time of day as the number of
                 seconds  since  the Epoch (Midnight UTC, January
                 1, 1970 on POSIX systems).

       ssttrrffttiimmee(([_f_o_r_m_a_t [,, _t_i_m_e_s_t_a_m_p]]))
                 formats _t_i_m_e_s_t_a_m_p according to the specification
                 in  _f_o_r_m_a_t_.  The _t_i_m_e_s_t_a_m_p should be of the same
                 form as returned by ssyyssttiimmee(()).  If _t_i_m_e_s_t_a_m_p  is
                 missing,  the  current  time of day is used.  If
                 _f_o_r_m_a_t is missing, a default  format  equivalent
                 to  the output of _d_a_t_e(1) will be used.  See the
                 specification for  the  ssttrrffttiimmee(())  function  in
                 ANSI C for the format conversions that are guar-
                 anteed to be available.  A public-domain version
                 of  _s_t_r_f_t_i_m_e(3)  and a man page for it come with
                 _g_a_w_k; if that version was used  to  build  _g_a_w_k,
                 then  all  of  the conversions described in that
                 man page are available to _g_a_w_k_.

   SSttrriinngg CCoonnssttaannttss
       String  constants  in  AWK  are  sequences  of  characters



Free Software Foundation   Dec 19 1996                         22





GAWK(1)                  Utility Commands                 GAWK(1)


       enclosed  between  double quotes (""). Within strings, cer-
       tain _e_s_c_a_p_e _s_e_q_u_e_n_c_e_s are recognized, as in C. These are:


       \\\\   A literal backslash.

       \\aa   The ``alert'' character; usually the ASCII BEL  char-
            acter.

       \\bb   backspace.

       \\ff   form-feed.

       \\nn   newline.

       \\rr   carriage return.

       \\tt   horizontal tab.

       \\vv   vertical tab.

       \\xx_h_e_x _d_i_g_i_t_s
            The  character represented by the string of hexadeci-
            mal digits following the \\xx.  As in ANSI C, all  fol-
            lowing  hexadecimal digits are considered part of the
            escape sequence.  (This feature should tell us  some-
            thing  about  language  design  by committee.)  E.g.,
            ""\\xx11BB"" is the ASCII ESC (escape) character.

       \\_d_d_d The character represented by the 1-, 2-,  or  3-digit
            sequence  of  octal  digits. E.g. ""\\003333"" is the ASCII
            ESC (escape) character.

       \\_c   The literal character _c.

       The escape sequences may also be used inside constant reg-
       ular expressions (e.g., //[[ \\tt\\ff\\nn\\rr\\vv]]// matches whitespace
       characters).

       In compatibility mode, the characters represented by octal
       and  hexadecimal  escape  sequences  are treated literally
       when used in regexp constants. Thus, //aa\\5522bb// is equivalent
       to //aa\\**bb//.

FFUUNNCCTTIIOONNSS
       Functions in AWK are defined as follows:

              ffuunnccttiioonn _n_a_m_e((_p_a_r_a_m_e_t_e_r _l_i_s_t)) {{ _s_t_a_t_e_m_e_n_t_s }}

       Functions  are  executed  when they are called from within
       expressions in either patterns or actions.  Actual parame-
       ters supplied in the function call are used to instantiate
       the formal parameters declared in  the  function.   Arrays
       are  passed  by  reference,  other variables are passed by



Free Software Foundation   Dec 19 1996                         23





GAWK(1)                  Utility Commands                 GAWK(1)


       value.

       Since functions were not originally part of the  AWK  lan-
       guage, the provision for local variables is rather clumsy:
       They are declared as extra  parameters  in  the  parameter
       list.  The  convention is to separate local variables from
       real parameters by extra spaces in the parameter list. For
       example:

              ffuunnccttiioonn  ff((pp,, qq,,     aa,, bb))   ## aa && bb aarree llooccaall
              {{
                   ..........
              }}

              //aabbcc//     {{ ...... ;; ff((11,, 22)) ;; ...... }}

       The  left  parenthesis  in  a function call is required to
       immediately follow the function name, without  any  inter-
       vening  white space.  This is to avoid a syntactic ambigu-
       ity with the  concatenation  operator.   This  restriction
       does not apply to the built-in functions listed above.

       Functions may call each other and may be recursive.  Func-
       tion parameters used as local variables are initialized to
       the  null string and the number zero upon function invoca-
       tion.

       If ----lliinntt has been provided, _g_a_w_k will warn about calls to
       undefined functions at parse time, instead of at run time.
       Calling an undefined function  at  run  time  is  a  fatal
       error.

       The word ffuunncc may be used in place of ffuunnccttiioonn.

EEXXAAMMPPLLEESS
       Print and sort the login names of all users:

            BBEEGGIINN     {{ FFSS == ""::"" }}
                 {{ pprriinntt $$11 || ""ssoorrtt"" }}

       Count lines in a file:

                 {{ nnlliinneess++++ }}
            EENNDD  {{ pprriinntt nnlliinneess }}

       Precede each line by its number in the file:

            {{ pprriinntt FFNNRR,, $$00 }}

       Concatenate and line number (a variation on a theme):

            {{ pprriinntt NNRR,, $$00 }}





Free Software Foundation   Dec 19 1996                         24





GAWK(1)                  Utility Commands                 GAWK(1)


SSEEEE AALLSSOO
       _e_g_r_e_p(1),  _g_e_t_p_i_d(2),  _g_e_t_p_p_i_d(2),  _g_e_t_p_g_r_p(2), _g_e_t_u_i_d(2),
       _g_e_t_e_u_i_d(2), _g_e_t_g_i_d(2), _g_e_t_e_g_i_d(2), _g_e_t_g_r_o_u_p_s(2)

       _T_h_e _A_W_K _P_r_o_g_r_a_m_m_i_n_g _L_a_n_g_u_a_g_e,  Alfred  V.  Aho,  Brian  W.
       Kernighan, Peter J. Weinberger, Addison-Wesley, 1988. ISBN
       0-201-07981-X.

       _A_W_K _L_a_n_g_u_a_g_e _P_r_o_g_r_a_m_m_i_n_g, Edition 1.0,  published  by  the
       Free Software Foundation, 1995.

PPOOSSIIXX CCOOMMPPAATTIIBBIILLIITTYY
       A  primary  goal  for _g_a_w_k is compatibility with the POSIX
       standard, as well as with the latest version of UNIX  _a_w_k.
       To  this end, _g_a_w_k incorporates the following user visible
       features which are not described in the AWK book, but  are
       part of the Bell Labs version of _a_w_k, and are in the POSIX
       standard.

       The --vv option for assigning variables before program  exe-
       cution  starts  is  new.   The book indicates that command
       line variable assignment happens when _a_w_k would  otherwise
       open  the  argument  as  a  file, which is after the BBEEGGIINN
       block is executed.  However, in  earlier  implementations,
       when  such  an  assignment appeared before any file names,
       the assignment would happen _b_e_f_o_r_e  the  BBEEGGIINN  block  was
       run.   Applications  came  to  depend on this ``feature.''
       When _a_w_k was changed  to  match  its  documentation,  this
       option was added to accommodate applications that depended
       upon the old behavior.  (This feature was agreed  upon  by
       both the AT&T and GNU developers.)

       The --WW option for implementation specific features is from
       the POSIX standard.

       When processing arguments, _g_a_w_k uses  the  special  option
       ``----''  to  signal the end of arguments.  In compatibility
       mode, it will warn about, but otherwise ignore,  undefined
       options.   In  normal operation, such arguments are passed
       on to the AWK program for it to process.

       The AWK book does not define the return value of  ssrraanndd(()).
       The POSIX standard has it return the seed it was using, to
       allow keeping track of random number sequences.  Therefore
       ssrraanndd(()) in _g_a_w_k also returns its current seed.

       Other  new  features  are:  The use of multiple --ff options
       (from MKS _a_w_k); the EENNVVIIRROONN array; the \\aa, and  \\vv  escape
       sequences  (done  originally  in  _g_a_w_k  and  fed back into
       AT&T's); the ttoolloowweerr(()) and  ttoouuppppeerr(())  built-in  functions
       (from  AT&T);  and the ANSI C conversion specifications in
       pprriinnttff (done first in AT&T's version).





Free Software Foundation   Dec 19 1996                         25





GAWK(1)                  Utility Commands                 GAWK(1)


GGNNUU EEXXTTEENNSSIIOONNSS
       _G_a_w_k has a number of extensions to POSIX  _a_w_k.   They  are
       described  in  this section.  All the extensions described
       here can be disabled by invoking _g_a_w_k  with  the  ----ttrraaddii--
       ttiioonnaall option.

       The  following features of _g_a_w_k are not available in POSIX
       _a_w_k.

              +o The \\xx escape sequence.  (Disabled with ----ppoossiixx.)

              +o The  fffflluusshh(()) function.  (Disabled with ----ppoossiixx.)

              +o The ssyyssttiimmee(()),,  ssttrrffttiimmee(()),,  and  ggeennssuubb(())  func-
                tions.

              +o The special file names available for I/O redirec-
                tion are not recognized.

              +o The AARRGGIINNDD, EERRRRNNOO, and RRTT variables are not  spe-
                cial.

              +o The  IIGGNNOORREECCAASSEE variable and its side-effects are
                not available.

              +o The FFIIEELLDDWWIIDDTTHHSS variable  and  fixed-width  field
                splitting.

              +o The use of RRSS as a regular expression.

              +o The  ability  to  split out individual characters
                using the null string as the value of FFSS, and  as
                the third argument to sspplliitt(()).

              +o No  path  search is performed for files named via
                the --ff option.  Therefore the AAWWKKPPAATTHH environment
                variable is not special.

              +o The  use of nneexxttffiillee to abandon processing of the
                current input file.

              +o The use of ddeelleettee _a_r_r_a_y to delete the entire con-
                tents of an array.

       The  AWK  book  does  not  define  the return value of the
       cclloossee(()) function.  _G_a_w_k's cclloossee(()) returns the  value  from
       _f_c_l_o_s_e(3),  or  _p_c_l_o_s_e(3),  when  closing  a file or pipe,
       respectively.

       When _g_a_w_k is invoked with the ----ttrraaddiittiioonnaall option, if the
       _f_s argument to the --FF option is ``t'', then FFSS will be set
       to the tab character.  Note  that  typing  ggaawwkk  --FF\\tt  ......
       simply  causes the shell to quote the ``t,'', and does not
       pass ``\t'' to the --FF option.  Since this is a rather ugly



Free Software Foundation   Dec 19 1996                         26





GAWK(1)                  Utility Commands                 GAWK(1)


       special case, it is not the default behavior.  This behav-
       ior also does not occur if ----ppoossiixx has been specified.  To
       really  get  a tab character as the field separator, it is
       best to use quotes: ggaawwkk --FF''\\tt'' .......

HHIISSTTOORRIICCAALL FFEEAATTUURREESS
       There are two features of historical  AWK  implementations
       that  _g_a_w_k  supports.   First,  it is possible to call the
       lleennggtthh(()) built-in function not only with no argument,  but
       even without parentheses!  Thus,

              aa == lleennggtthh     ## HHoollyy AAllggooll 6600,, BBaattmmaann!!

       is the same as either of

              aa == lleennggtthh(())
              aa == lleennggtthh(($$00))

       This  feature  is  marked  as  ``deprecated'' in the POSIX
       standard, and _g_a_w_k will issue a warning about its  use  if
       ----lliinntt is specified on the command line.

       The other feature is the use of either the ccoonnttiinnuuee or the
       bbrreeaakk statements outside the body of a wwhhiillee, ffoorr,  or  ddoo
       loop.   Traditional  AWK implementations have treated such
       usage as equivalent to the nneexxtt statement.  _G_a_w_k will sup-
       port this usage if ----ttrraaddiittiioonnaall has been specified.

EENNVVIIRROONNMMEENNTT VVAARRIIAABBLLEESS
       If  PPOOSSIIXXLLYY__CCOORRRREECCTT  exists  in the environment, then _g_a_w_k
       behaves exactly as if ----ppoossiixx had been  specified  on  the
       command  line.   If  ----lliinntt  has been specified, _g_a_w_k will
       issue a warning message to this effect.

       The AAWWKKPPAATTHH environment variable can be used to provide  a
       list of directories that _g_a_w_k will search when looking for
       files named via the --ff and ----ffiillee options.

BBUUGGSS
       The --FF option is not  necessary  given  the  command  line
       variable assignment feature; it remains only for backwards
       compatibility.

       If your system actually has support for  //ddeevv//ffdd  and  the
       associated //ddeevv//ssttddiinn, //ddeevv//ssttddoouutt, and //ddeevv//ssttddeerrrr files,
       you may get different output from _g_a_w_k than you would  get
       on  a  system  without  those files.  When _g_a_w_k interprets
       these files internally,  it  synchronizes  output  to  the
       standard  output  with  output  to //ddeevv//ssttddoouutt, while on a
       system with those files, the output is actually to differ-
       ent open files.  Caveat Emptor.

       Syntactically  invalid  single  character programs tend to
       overflow the parse stack, generating  a  rather  unhelpful



Free Software Foundation   Dec 19 1996                         27





GAWK(1)                  Utility Commands                 GAWK(1)


       message.   Such  programs  are  surprisingly  difficult to
       diagnose in the completely general case, and the effort to
       do so really is not worth it.

VVEERRSSIIOONN IINNFFOORRMMAATTIIOONN
       This man page documents _g_a_w_k, version 3.0.2.

AAUUTTHHOORRSS
       The  original  version of UNIX _a_w_k was designed and imple-
       mented  by  Alfred  Aho,  Peter  Weinberger,   and   Brian
       Kernighan  of AT&T Bell Labs. Brian Kernighan continues to
       maintain and enhance it.

       Paul Rubin and Jay Fenlason, of the Free Software  Founda-
       tion,  wrote _g_a_w_k, to be compatible with the original ver-
       sion of _a_w_k distributed in  Seventh  Edition  UNIX.   John
       Woods  contributed  a number of bug fixes.  David Trueman,
       with contributions from Arnold Robbins, made _g_a_w_k compati-
       ble  with  the new version of UNIX _a_w_k.  Arnold Robbins is
       the current maintainer.

       The initial DOS port was done by  Conrad  Kwok  and  Scott
       Garfinkle.   Scott  Deifik  is the current DOS maintainer.
       Pat Rankin did the port to VMS, and Michal Jaegermann  did
       the  port  to  the Atari ST.  The port to OS/2 was done by
       Kai Uwe Rommel, with contributions and  help  from  Darrel
       Hankerson.  Fred Fish supplied support for the Amiga.

BBUUGG RREEPPOORRTTSS
       If  you find a bug in _g_a_w_k, please send electronic mail to
       bbuugg--ggnnuu--uuttiillss@@pprreepp..aaii..mmiitt..eedduu,  _w_i_t_h  a  carbon  copy   to
       aarrnnoolldd@@ggnnuu..aaii..mmiitt..eedduu.  Please include your operating sys-
       tem and its revision, the version of _g_a_w_k, what C compiler
       you  used  to compile it, and a test program and data that
       are as small as possible for reproducing the problem.

       Before sending a bug report, please do two things.  First,
       verify  that  you  have  the latest version of _g_a_w_k.  Many
       bugs (usually subtle ones) are fixed at each release,  and
       if yours is out of date, the problem may already have been
       solved.  Second, please read this man page and the  refer-
       ence  manual carefully to be sure that what you think is a
       bug really is, instead of just a quirk in the language.

       Whatever  you  do,  do  NNOOTT   post   a   bug   report   in
       ccoommpp..llaanngg..aawwkk.   While  the  _g_a_w_k  developers occasionally
       read this newsgroup, posting bug reports there is an unre-
       liable  way  to report bugs. Instead, please use the elec-
       tronic mail addresses given above.

AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Brian Kernighan of Bell Labs provided valuable  assistance
       during testing and debugging.  We thank him.




Free Software Foundation   Dec 19 1996                         28





GAWK(1)                  Utility Commands                 GAWK(1)


CCOOPPYYIINNGG PPEERRMMIISSSSIIOONNSS
       Copyright (C)) 1996 Free Software Foundation, Inc.

       Permission  is  granted  to  make  and distribute verbatim
       copies of this manual page provided the  copyright  notice
       and this permission notice are preserved on all copies.

       Permission is granted to copy and distribute modified ver-
       sions of this manual page under the conditions for  verba-
       tim  copying,  provided  that the entire resulting derived
       work is distributed under the terms of a permission notice
       identical to this one.

       Permission  is granted to copy and distribute translations
       of this manual page into another language, under the above
       conditions for modified versions, except that this permis-
       sion notice may be stated in a translation approved by the
       Foundation.







































Free Software Foundation   Dec 19 1996                         29


