             
/*
**  External Function And Variable Prototypes.
**
**  Copyright 1993-97 by Paul D. Burgin. All rights reserved.
*/

/* Public data. */
extern unsigned char		i_buffer[2];
extern unsigned char 		palette;
extern boolean				four_colours;
extern unsigned char 		new_palette;
extern boolean				new_four_colours;
extern int					cursortype;
extern boolean				graphinit;
extern signed char			vmode;
extern unsigned int			screen_base;
extern unsigned char		screen_size;
extern unsigned int			screen_end;
extern signed char			new_vmode;
extern unsigned int			new_screen_base;
extern unsigned char		new_screen_size;
extern unsigned int			last_text_base;
extern boolean				video_enabled;
extern boolean 				mapmode1;
extern hw_type				arch;
extern unsigned char far	*memory;
extern unsigned char far	*rom2;
extern unsigned char far	*hiram;
extern boolean				digital_joysticks;
extern unsigned int			refresh_count;
extern unsigned int			button_counter;
extern boolean				lower_case;
extern const unsigned int 	vdg_sizes[];
extern union REGS			regs;
extern unsigned char		back_ary[2];
extern unsigned char		fore_ary[2];
extern unsigned char		vmode_ary[2][2][6];
extern unsigned char		border_ary[2][2];
extern boolean				new_int9_set;
extern boolean				mouse_disabled;
extern boolean				mouse_installed;
extern boolean				cassette_disabled;
extern boolean				ask_filenames;
extern f_m					file_mode;
extern unsigned char		filemem[9];
extern unsigned char		cartname[9];
extern unsigned char		cartfname[];
extern unsigned int			cartstart;
extern unsigned int			cartend;
extern boolean				rom2loaded;
extern unsigned char		key_scan_counter;
extern unsigned int			key_scan_reset;
extern unsigned char		keyin;
extern unsigned char		last_shift;
extern char					bootparallel, numparallel;
extern char					bootserial, numserial;
extern boolean				hasjoystick;
extern boolean				crlf;
extern unsigned int			comspeed;
extern enum port			lpt;
extern boolean				printfile;
extern boolean				realjoy;
extern boolean				printsimple;
extern unsigned int			joy_x, joy_y;
extern unsigned char		hardjoy_resolution;
extern unsigned int			irq_rate;
extern unsigned int			irq_cycles;
extern double				should_be_seconds;
extern boolean				drag_usedkey;
extern boolean				rightkey, endkey, pgdnkey, upkey;
extern unsigned char		snapshot_name[];
extern boolean				snapshot_in_progress;
extern unsigned char		*last_filename;
extern const char			for_reading_text[];
extern const char			for_writing_text[];
extern unsigned char		path_editor[];
extern unsigned char		path_assembler[];
extern unsigned char		name_editfile[];
extern unsigned char		last_moto[];
extern unsigned char		swapping;
extern unsigned char		checksum;
extern unsigned char		key_buf;
extern unsigned char		presets[11][PRESET_LEN+2];
extern enum text_modes		text_mode;
extern boolean				in_debug;
extern boolean				await_breakpoint;
extern boolean				debug_disp;
extern unsigned char		*norm_screen;
extern unsigned char		*debug_screen;
extern unsigned char		*info_screen;
extern enum winuse			left_window;
extern unsigned int			temp_breakpoint, intern_break, breakpoint[6];
extern enum brktyp			breaktype;
extern unsigned int			break_op;
extern unsigned int			diss_pcr;
extern unsigned int			breakvalue;
extern unsigned int			fill_start, fill_end;
extern unsigned char		fill_value;
extern boolean				edit_ascii;
extern unsigned int			dump_address;
extern boolean				install_breakpoints;
extern unsigned int			snap_length;
extern boolean				compress;
extern boolean				snapboot;
extern boolean				snap_load_options, snap_opt_default;
extern boolean				load_debug_state, load_ds_default;
extern unsigned char		version, version_default;
extern boolean				load_extensions, load_ext_default;
extern unsigned char		so_backlog_cnt, backlog_cnt;
extern boolean				ignore_illegal_opcodes;
extern unsigned char		keywords[26][11];
extern portability			write_port;
extern unsigned char		regstr[];

/* Public functions. */
extern void					reset_hardware(void);
extern void 				quit(unsigned char *text,
								unsigned char exit_type);
extern unsigned char		far_get_mem8(unsigned int address);
extern unsigned int			far_get_mem16(unsigned int address);
extern void					far_set_mem8(unsigned int address,
								unsigned char value);
extern boolean 				load_dgn_file(unsigned char file_name[],
								unsigned char dgn_dest);
extern void 				close_files(boolean forced);
extern void 				write_byte(void);
extern void 				read_bit(void);
extern void					read_byte(void);
extern void					create_matrix(void);
extern void 				update_cursor(void);
extern void					refresh_video(void);
extern void					refresh_palette(void);
extern void					set_vmode(unsigned char ff22);
extern void					execute_vmode(boolean forced_mode);
extern void					setup_screen(void);
extern void 				video_out(unsigned char vid_char,
								unsigned int vid_address);
extern void					update_joysticks(unsigned int where_to);
extern void					update_fire_buttons(void);
extern boolean				mouse_okay(void);
extern unsigned char 		get_sampias(unsigned int address);
extern void 				set_sampias(unsigned char value,
								unsigned int address);
extern unsigned char		emu_service(boolean use_registers);
extern unsigned int			getkey(void);
extern unsigned char 		getch2(boolean just_getch);
extern void					service_emu_keys(void);
extern boolean				emu_keys(unsigned char localkey);
extern void					old_scan_keys(void);
extern void					init_snap_info(void);
extern boolean				load_snapshot(unsigned char *sname, boolean *eb);
extern boolean				save_snapshot(unsigned char *sname);
extern void					complete_snapshot(void);
extern void					far_set_cc_reg(register unsigned char cc_input);
extern int					textview(char *tname, char *tmessage, int tcolour);
extern void					set_directory(unsigned char which_dir);
extern void					temp_textmode(void);
extern void					restore_vmode(void);
extern void					help_screen(void);
extern void					inf_screen(void);
extern void					view_manual(void);
extern void					shell_escape(unsigned char shell_function);
extern unsigned char		selection_box(unsigned char num_lines,
								unsigned char width,
								unsigned char num_opt,
								boolean yes_no, boolean allow_ls,
								boolean raw_return,
								unsigned char default_opt, ...);
extern boolean				input_box(unsigned char *dest_ptr,
								unsigned char num_lines,
								unsigned char width, ...);
extern unsigned int			new_screen_end(void);
extern void					edit_key(boolean edit_first);
extern void					file_menu(void);
extern boolean				load_motorola(unsigned char *moto_name);
extern void					debugger(void);
extern void					new_window(win_type win_where);
extern void					border(unsigned char breadth, unsigned char depth);
extern void					put_title(boolean startup);
extern void					change_printfile(boolean now_to_file);
extern void					set_comspeed(unsigned int new_comspeed);
extern boolean				change_lpt(enum port new_port);
extern unsigned char		get_artifact(void);
extern void					set_artifact(unsigned char art_action);
extern boolean				value_box(unsigned char *vtit,
								unsigned int *vadd,
								unsigned char *vfm,
								boolean from_debugger);
extern void					opt_screen(void);
extern void					video_menu(void);
extern void					function_opt(void);
extern void					toggle_2or4_colours(void);
extern void					toggle_pixel_width(void);
extern void					beep(void);
extern void					check(void);
extern unsigned char		*strext(unsigned char *checkname);
extern void					firq(void);
