/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pkt.c
**     SYSTEM   NAME:       PKT
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v2.00
**     CREATION DATE:       1990/4/12
**
** DESCRIPTION: Utility functions for PDS
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PKTUTI.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTUTI.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 14:34:24   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTUTI.C_V   1.0   25 Oct 1990 14:34:24   etstjan  $";
#endif
#include <stdio.h>
#include <error.h>
#include "pktinc.h"

static char *PktRequest1[] = {
    "PdsGetInfo",                              /* defined by PDS (basic) */
    "PdsAccessType",
    "PdsReleaseType",
    "PdsSendPkt",
    "PdsTerminate",
    "PdsGetAddress",
    "PdsResetInterface",
    "PktInit"                        
};

static char *PktRequest20[] = {
    "PdsSetRcvMode",                             /* defined by PDS (extended) */
    "PdsGetRcvMode",
    "PdsSetMulticast",
    "PdsGetMulticast",
    "PdsGetStatistics",
    "PdsSetAddress"
};

static char *PktErrMess[] = {
    "Invalid type handle",                  /* Defined by PDS */
    "IF Class not found",
    "IF Type not found",
    "IF Number not found",
    "Invalid packet type",
    "No multicast support",
    "Can't Terminate",
    "Invalid receivermode",
    "Insufficient memory",
    "Type already in use",
    "Bad command",
    "Can't send",
    "Can't set address",
    "Invalid address",
    "PKT not Initialized",                  /* Defined by LT */
    "No PDS at PktInt"
};


int PktError(int PktInt, int Request, int Err)
{
    if (Err)
    {
        char *pReq;
        char *pErrMess;

        if ((Request >= 1) && (Request <= 7))
            pReq = PktRequest1[Request-1];
        else
            if ((Request >= 20) && (Request <= 25))
                pReq = PktRequest20[Request-20];
            else
                pReq = "Unknown";
        if ((Err >= 1) && (Err <= 14))
            pErrMess = PktErrMess[Err-1];
        else
            pErrMess = "Unknown";
        ERR_ERR( ERR_NPD,
                 (Err==PKT_BAD_MODE) ? ERR_WARNING : ERR_CRITICAL,
                 "Packet driver 0x%02x: (%d:%s) returned %d:%s",
                      PktInt, Request, pReq, Err, pErrMess);
    }
    return Err;
}


/**************************************************************
** NAME:        PktGetHandle
** SYNOPSIS:    int PktGetHandle(int PktInt)
** DESCRIPTION: Retrieves a handle needed for the packet
**              driver.
** RETURNS:     a handle.
**************************************************************/
int PktGetHandle(int PktInt)
{
    int i;
    PKTDEV *pDev = PktDevTable[PktInt-PKTINTOFFS];

    for (i=0;i<PKTMAXHANDLES;i++)
        if (pDev->usHandleTable[i])
        {
            ERR_DEB( ERR_NPD, 5, "PktGetHandle found handle %d at %d",
                pDev->usHandleTable[i], i);
            return pDev->usHandleTable[i];
        }
    return 0;
}



