//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVWIN.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Windows support interface            |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

//WINDOW PALETTES

#ifndef _PVWIN_H
#define _PVWIN_H
#define wpSTANDARD 0x0001
#define wpEDITOR   0x0002
#define wpTOOL     0x0003
#define wpHELP     0x0004
#define wpALERT    0x0005

class Twindow;

class Tclose_icon: public Tmenu_bar
{
  public:
    Tclose_icon( Twindow *w );
    virtual uint exec( void );

  protected:
    virtual void set_palette( void );
#ifndef NOMOUSE
    virtual void event_handler( Tevent &ev );
#endif
    virtual Tmenu_item *shortcut_ptr( uint ascii );

  private:
    Twindow *window;
    inline Tmenu *init( Twindow *w );
};

class Twindow : public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    uint palette; //<R/W>
    uint shortcut; //<R/W> window's keyboard shortcut
    char *title; //<R>
    Tset local_commands; //<R/W>
    Tcommands commands; //<R>
    int xl_min; //<R/W>
    int yl_min; //<R/W>
    int xl_max; //<R/W>
    int yl_max; //<R/W>
    int x_saved; //holds x while iconized/maximized
    int y_saved; //holds y while iconized/maximized
    int xl_saved; //holds xl while iconized/maximized
    int yl_saved; //holds yl while iconized/maximized
    int icon_x;
    int icon_y;
    Tmenu_bar *close_icon;
    Ticon *minimize_icon;
    Ticon *maximize_icon;
    Ticon *resize_icon;
    Twindow( char *t, int _xl, int _yl );
    virtual ~Twindow( void );
    virtual void set_state( uint _state_word, boolean enable );
    virtual void set_flags( uint _flags_word, boolean enable );
    virtual void pop_up( void );
    virtual void drag( int newx, int newy );
    virtual void resize( int newxl, int newyl );
    virtual boolean valid( uint command );
    virtual void put_in( Titem *v, int _x, int _y );
    virtual boolean cenabled( uint cmd );
    virtual boolean cdisabled( uint cmd );
    virtual void cenable( uint cmd );
    virtual void cdisable( uint cmd );
    virtual void cstate( uint cmd, boolean enable );
    void set_title( char *t );
    virtual void title2str( char *t, int max_len );
    virtual void construct_frame( char *fr );
    virtual void construct_system_menu( void );
    Titem *frame( char *t );
    Titem *frame( void );
    void endfr( void );

  protected:
    uint on_top_flag;
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void set_palette( void );
    virtual void draw( void );
    virtual void initialize( void );
    virtual void get_focused( void );
    virtual boolean release_focus( void );
    virtual void event_handler( Tevent &ev );
    virtual void direct_resize( int newxl, int newyl );

  private:
    boolean frame_beg_flag;
    Titem *beg_frame_item;
    Titem *end_frame_item;
    int local_tools;
    void do_system_menu( void );
};

class Tscroll_window: public Twindow
{
  public:
    Tvscroll_bar *vbar;
    Thscroll_bar *hbar;
    Tscroll_window( uint &hbeg_print, uint &hcount,
                    uint &vbeg_print, uint &vcount,
                    int delta_h,
                    char *t, Titem *item );

};

class Tfile_window : public Tscroll_window
{
  public:
    Tfile_window( uint &hbeg_print, uint &hcount,
                  uint &vbeg_print, uint &vcount,
                  int delta_h,
                  char *t, Titem *item );
    virtual void title2str( char *t, int max_len );
};
#endif

#ifdef _DECLARE_PVWIN
  Tset win_nums;
#else
  extern Tset win_nums;
#endif

//PREFIXES

void _pstandard( void );           char __palette( void );
void _peditor( void );
void _ptool( void );
void _phelp( void );
void _palert( void );
void _context( int context );      int __context( void );
