 REM Sic.bas v5.1a - Symbolic Instruction Code; module 1 of 3.
 REM The public domain DOS programming interpreter.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' program variables
 REDIM Arrays(0 TO 26, 0 TO 128) AS DOUBLE
 REDIM Strngs(0 TO 26) AS STRING
 REDIM Variables(0 TO 26) AS DOUBLE

 ' For/next variables: to, step, except
 REDIM ForNext(1 TO 26, 1 TO 3) AS DOUBLE

 ' stores line number gosub started from
 REDIM GosubReturn(1 TO 10) AS INTEGER

 ' program code
 REDIM Program(1 TO Max.Lines) AS STRING

 ' file areas
 REDIM Field.Array(1 TO 35) AS STRING
 REDIM File.Fields(1 TO 35) AS STRING

 ' increase stack for recursion
 STACK 4096

 ' initialize some variables
 Max.Gosubs = 10
 Program.Name = "<none>"
 Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;,'" + CHR$(34)
 White.Space = CHR$(32) + CHR$(9)

 ' store basic dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 BASIC.DTA.SEG = OutregsX.ES
 BASIC.DTA.OFF = OutregsX.BX

 ' increase files to 35
 InregsX.AX = &H6200
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSP.Segment = OutregsX.BX
 DEF SEG = PSP.Segment
 Command.Line = &H80
 Command.Tail = Command.Line + 80
 FOR Var = 1 TO 40
    POKE Command.Tail + Var - 1, &HFF
 NEXT
 FOR Var = 1 TO 20
    File.Handle = PEEK(&H18 + Var - 1)
    POKE Command.Tail + Var - 1, File.Handle
 NEXT
 POKE &H32, 40
 POKE &H34, Command.Tail
 DEF SEG

 ' run program from command line
 Program.Resume = False
 Filename = COMMAND$
 IF LEN(Filename) THEN
    Program.Resume = True
    IF DIR$(Filename) <> Nul THEN
       CALL New.Program
       CALL Read.Program
       CALL Run.Program
    END IF
    END
 END IF

 ' run program from stdin
 CALL Read.Stdin

 ' enter the Sic engine
 COLOR White, Black ' display logon banner
 PRINT "SIC v" + Version + ": Programming interpreter."
 PRINT "Enter 'quit' to return to system."

Error.Resume:
 ' check which function started Sic
 IF Program.Resume THEN
    CALL End.Program
    END
 END IF

 ' enter the Sic programming interface
 DO ' loop until quit entered
    ON ERROR GOTO Error.Routine ' reset error routine
    COLOR Yellow, Black
    LINE INPUT ">", Out2
    CALL Enter.Program.Line
    IF Assign = False THEN
       SELECT CASE UCASE$(Out2)
       CASE "ANALYZE"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
	     CALL Analyze.Program
	  END IF
       CASE "FILES"
	  CALL List.Files
       CASE "HELP"
	  CALL List.Help
       CASE "INDENT"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
             CALL Indent.Program
          END IF
       CASE "KILL"
	  CALL Kill.Program
       CASE "LIST"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
	     CALL List.Program
	  END IF
       CASE "LOAD"
	  CALL Load.Program
       CASE "NEW"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
	     CALL Save.Current
	     CALL New.Program
	     Program.Name = "<none>"
             COLOR White, Black
	     PRINT "Program cleared."
	  END IF
       CASE "QUIT"
	  CALL Quit.Program
       CASE "RENUMBER"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
	     CALL Renumber.Program
	  END IF
       CASE "RUN"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
             COLOR White, Black
	     PRINT "Starting program: " + Program.Name
	     CALL Run.Program
             COLOR White, Black
	     PRINT "Program run ended."
	  END IF
       CASE "SAVE"
	  IF Program.Name = "<none>" THEN
             COLOR White, Black
	     PRINT "No program loaded."
	  ELSE
	     CALL Save.Program
	  END IF
       CASE "WHATIS"
	  CALL Whatis.Command
       CASE ELSE
          COLOR White, Black
	  PRINT "Type 'Help' for information."
       END SELECT
    END IF
 LOOP
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 ErrorLine = Program.Line
 ErrorValue = ERR
 CALL Display.Error
 CALL Key.Prompt
 RESUME Error.Resume

Indent.Data:
 DATA "SELECTIF CASE", 1
 DATA "DO WHILE", 1
 DATA "DO", 1
 DATA "IF", 1
 DATA "SELECT CASE", 1
 DATA "DO UNTIL", 1
 DATA "FORIF", 1
 DATA "FOR", 1
 DATA "WHILE", 1
 DATA "LOOP UNTIL", 1
 DATA "LOOPIF", 1
 DATA "ENDIF", -1
 DATA "END IF", -1
 DATA "NEXTIF", -1
 DATA "NEXT", -1
 DATA "LOOP WHILE", -1
 DATA "SELECT END", -1
 DATA "WEND", -1
 DATA "END LOOPIF", -1
 DATA "LOOP", -1
 DATA "SELECTIF END", -1
 DATA "ELSE", -2
 DATA "CASE", -2
 DATA "EOF", 0

Analyze.Data1:
 DATA "IF", "ENDIF"
 DATA "DO", "LOOP"
 DATA "FOR", "NEXT"
 DATA "WHILE", "WEND"
 DATA "FORIF", "NEXTIF"
 DATA "LOOPIF", "END LOOPIF"
 DATA "SELECT CASE", "SELECT END"
 DATA "SELECTIF CASE", "SELECTIF END"

Analyze.Data2:
 DATA "IF", "ENDIF", "ELSE", "ELSEIF"
 DATA "SELECT CASE", "SELECT END", "CASE ELSE", "CASE"
 DATA "SELECTIF CASE", "SELECTIF END", "CASEIF ELSE", "CASEIF"

Analyze.Data3:
 DATA "DO", "LOOP", "EXIT DO", "CONTINUE DO"
 DATA "FOR", "NEXT", "EXIT FOR", "CONTINUE FOR"
 DATA "WHILE", "WEND", "EXIT WHILE", "CONTINUE WHILE"
 DATA "FORIF","NEXTIF", "EXIT FORIF", "CONTINUE FORIF"
 DATA "LOOPIF", "END LOOPIF", "EXIT LOOPIF", "CONTINUE LOOPIF"

SUB Analyze.Program
 COLOR White, Black
 CALL Count.Lines(Last.Line)
 PRINT "Pass 1: counting matching structures."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 2: counting matching imbedded structures."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	     Nested.Count = Nested.Count + 1
	  ELSE
	     IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
		Nested.Count = Nested.Count + 1
	     END IF
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 3: multipass structure match."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = 1
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
		      Nested.Count = Nested.Count + 1
		   END IF
		   IF LEFT$(Temp2$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
		      Nested.Count = Nested.Count - 1
		      IF Nested.Count = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count = Nested.Count - 1
			 IF Nested.Count = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Nested.Count <> False THEN
		PRINT "Analyze error, pass 3: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 4: multipass imbedded struture match."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Total.Nested1 = 1
             Total.Nested2 = 0
             Nested.Count1 = 1
             Nested.Count2 = 0
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
                      Total.Nested1 = Total.Nested1 + 1
                      Nested.Count1 = Nested.Count1 + 1
		   END IF
		   IF LEFT$(Temp2$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
                      Nested.Count1 = Nested.Count1 - 1
                      IF Nested.Count1 = 0 THEN
                         EXIT FOR
                      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
                         Nested.Count1 = Nested.Count1 - 1
                         IF Nested.Count1 = 0 THEN
                            EXIT FOR
                         END IF
		      END IF
		   END IF
		   IF LEFT$(Temp2$, LEN(Imbedded1$)) = Imbedded1$ THEN
                      Total.Nested2 = Total.Nested2 + 1
                      Nested.Count2 = Nested.Count2 + 1
                      IF Nested.Count2 > Nested.Count1 THEN
                         PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                         EXIT SUB
                      END IF
                      Nested.Count2 = Nested.Count2 - 1
                   ELSE
		      IF LEFT$(Temp2$, LEN(Imbedded2$)) = Imbedded2$ THEN
                         Total.Nested2 = Total.Nested2 + 1
                         Nested.Count2 = Nested.Count2 + 1
                         IF Nested.Count2 > Nested.Count1 THEN
                            PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                            EXIT SUB
                         END IF
                         Nested.Count2 = Nested.Count2 - 1
		      END IF
		   END IF
		END IF
	     NEXT
             IF Total.Nested2 > Total.Nested1 THEN
                PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
                EXIT SUB
             END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 5: single pass imbedded control structure match."
 RESTORE Analyze.Data3
 FOR Data.Count = 1 TO 5
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Analysis completed. Program syntax correct."
END SUB

SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

SUB Display.Error
 SELECT CASE ErrorValue
 CASE 1
    PRINT "Internal error #001: Next without For."
 CASE 2
    PRINT "Error #002: Line"; ErrorLine; ": Syntax error."
 CASE 3
    PRINT "Internal error #003: Return without Gosub."
 CASE 4
    PRINT "Internal error #004: Out of Data."
 CASE 5
    PRINT "Error #005: Line"; ErrorLine; ": Illegal function call."
 CASE 6
    PRINT "Error #006: Line"; ErrorLine; ": Overflow."
 CASE 7
    PRINT "Error #007: Line"; ErrorLine; ": Out of memory."
 CASE 8
    PRINT "Internal error #008: Label not defined."
 CASE 9
    PRINT "Error #009: Line"; ErrorLine; ": Subscript out of range."
 CASE 10
    PRINT "Internal error #010: Duplicate definition."
 CASE 11
    PRINT "Error #011: Line"; ErrorLine; ": Division by zero."
 CASE 12
    PRINT "Internal error #012: Illegal in direct mode."
 CASE 13
    PRINT "Internal error #013: Type mismatch."
 CASE 14
    PRINT "Error #014: Line"; ErrorLine; ": Out of string space."
 CASE 15
    PRINT "Error #015: Line"; ErrorLine; ": Invalid Pset statement."
 CASE 16
    PRINT "Error #016: Line"; ErrorLine; ": String formula too complex."
 CASE 17
    PRINT "Reserved error #017: Cannot continue."
 CASE 18
    PRINT "Internal error #018: Function not defined."
 CASE 19
    PRINT "Error #019: Line"; ErrorLine; ": No Resume."
 CASE 20
    PRINT "Error #020: Line"; ErrorLine; ": Resume without error."
 CASE 21
    PRINT "Error #021: Line"; ErrorLine; ": Syntax error specifying filename to open."
 CASE 22
    PRINT "Error #022: Line"; ErrorLine; ": Syntax error specifying filename to close."
 CASE 23
    PRINT "Error #023: Line"; ErrorLine; ": Syntax error specifying filename field."
 CASE 24
    PRINT "Error #024: Line"; ErrorLine; ": Device timeout."
 CASE 25
    PRINT "Error #025: Line"; ErrorLine; ": Device fault."
 CASE 26
    PRINT "Internal error #026: For without Next."
 CASE 27
    PRINT "Error #027: Line"; ErrorLine; ": Out of paper."
 CASE 28
    PRINT "Error #028: Line"; ErrorLine; ": Invalid Line statement."
 CASE 29
    PRINT "Internal error #029: While without Wend."
 CASE 30
    PRINT "Internal error #030: Wend without While."
 CASE 31
    PRINT "Error #031: Line"; ErrorLine; ": Syntax error writing to file."
 CASE 32
    PRINT "Error #032: Line"; ErrorLine; ": Syntax error printing to file."
 CASE 33
    PRINT "Internal error #033: Duplicate label."
 CASE 34
    PRINT "Error #034: Line"; ErrorLine; ": Syntax error inputing from file."
 CASE 35
    PRINT "Internal error #035: Subprogram not defined."
 CASE 36
    PRINT "Error #034: Line"; ErrorLine; ": Syntax error line inputing from file."
 CASE 37
    PRINT "Internal error #036: Argument-count mismatch."
 CASE 38
    PRINT "Error #038: Line"; ErrorLine; ": Array not defined."
 CASE 39
    PRINT "Error #039: Line"; ErrorLine; ": Invalid Circle statement."
 CASE 40
    PRINT "Error #040: Line"; ErrorLine; ": Variable required."
 CASE 41
    PRINT "Error #041: Line"; ErrorLine; ": Invalid Lset statement."
 CASE 42
    PRINT "Error #042: Line"; ErrorLine; ": Invalid Rset statement."
 CASE 43
    PRINT "Error #043: Line"; ErrorLine; ": Invalid Put statement."
 CASE 44
    PRINT "Error #044: Line"; ErrorLine; ": Invalid Get statement."
 CASE 45
    PRINT "Error #045: Line"; ErrorLine; ": Invalid Read statement."
 CASE 46
    PRINT "Error #046: Line"; ErrorLine; ": Invalid Draw statement."
 CASE 47
    PRINT "Error #047: Line"; ErrorLine; ": Invalid Play statement."
 CASE 48
    PRINT "Error #048: Line"; ErrorLine; ": Invalid Paint statement."
 CASE 49
    PRINT "Error #049: Line"; ErrorLine; ": Invalid Get/Put statement."
 CASE 50
    PRINT "Error #050: Line"; ErrorLine; ": Field overflow."
 CASE 51
    PRINT "Internal compiler error #051."
 CASE 52
    PRINT "Error #052: Line"; ErrorLine; ": Bad file name or number."
 CASE 53
    PRINT "Error #053: Line"; ErrorLine; ": File not found."
 CASE 54
    PRINT "Error #054: Line"; ErrorLine; ": Bad file mode."
 CASE 55
    PRINT "Error #055: Line"; ErrorLine; ": File already open."
 CASE 56
    PRINT "Error #056: Line"; ErrorLine; ": Field statement active."
 CASE 57
    PRINT "Error #057: Line"; ErrorLine; ": Device I/O error."
 CASE 58
    PRINT "Error #058: Line"; ErrorLine; ": File already exists."
 CASE 59
    PRINT "Error #059: Line"; ErrorLine; ": Bad record length."
 CASE 60
    PRINT "Error #060: Line"; ErrorLine; ": Invalid Bsave/Bload statement. Filename: " + Filename$
 CASE 61
    PRINT "Error #061: Line"; ErrorLine; ": Disk full."
 CASE 62
    PRINT "Error #062: Line"; ErrorLine; ": Input past end of file."
 CASE 63
    PRINT "Error #063: Line"; ErrorLine; ": Bad record number."
 CASE 64
    PRINT "Error #064: Line"; ErrorLine; ": Bad file name: "; LCASE$(Filename); "."
 CASE 65
    PRINT "Error #065: Line"; ErrorLine; ": Invalid Data statement."
 CASE 66
    PRINT "Error #066: Line"; ErrorLine; ": Out of data."
 CASE 67
    PRINT "Error #067: Line"; ErrorLine; ": Too many files."
 CASE 68
    PRINT "Error #068: Line"; ErrorLine; ": Device unavailable."
 CASE 69
    PRINT "Error #069: Line"; ErrorLine; ": Communication buffer overflow."
 CASE 70
    PRINT "Error #070: Line"; ErrorLine; ": File permission denied."
 CASE 71
    PRINT "Error #071: Line"; ErrorLine; ": Disk not ready."
 CASE 72
    PRINT "Error #072: Line"; ErrorLine; ": Disk-media error."
 CASE 73
    PRINT "Internal error #073: Feature unavailable."
 CASE 74
    PRINT "Error #074: Line"; ErrorLine; ": Rename across disks."
 CASE 75
    PRINT "Error #075: Line"; ErrorLine; ": Path/File access error."
 CASE 76
    PRINT "Error #076: Line"; ErrorLine; ": Path not found."
 CASE 77
    PRINT "Error #077: Line"; ErrorLine; ": Invalid View statement."
 CASE 78
    PRINT "Error #078: Line"; ErrorLine; ": Invalid Window statement."
 CASE 79
    PRINT "User defined error #079: Line"; ErrorLine; "."
 CASE 80
    PRINT "Internal error #080: Feature removed."
 CASE 81
    PRINT "Error #081: Line"; ErrorLine; ": Invalid name."
 CASE 82
    PRINT "Reserved error #082: Table not found." ' isam
 CASE 83
    PRINT "Reserved error #083: Index not found." ' isam
 CASE 84
    PRINT "Reserved error #084: Invalid column." ' isam
 CASE 85
    PRINT "Reserved error #085: No current record." ' isam
 CASE 86
    PRINT "Reserved error #086: Duplicate value for unique index." ' isam
 CASE 87
    PRINT "Reserved error #087: Invalid operation on null index." ' isam
 CASE 88
    PRINT "Reserved error #088: Database needs repair." ' isam
 CASE 89
    PRINT "Reserved error #089: Insufficient ISAM buffers." ' isam
 CASE 90
    PRINT "User defined error #090: Line"; ErrorLine
 CASE 91
    PRINT "Error #091: Line"; ErrorLine; ": Unknown statement."
 CASE 92
    PRINT "Error #092: Line"; ErrorLine; ": Whatis: "; Strng; "."
 CASE 93
    PRINT "User defined error #093: Line"; ErrorLine; "."
 CASE 94
    PRINT "User defined error #094: Line"; ErrorLine; "."
 CASE 95
    PRINT "User defined error #095: Line"; ErrorLine; "."
 CASE 96
    PRINT "User defined error #096: Line"; ErrorLine; "."
 CASE 97
    PRINT "Error #097: Line"; ErrorLine; ": Mismatched for/next."
 CASE 98
    PRINT "Error #098: Line"; ErrorLine; ": Mismatched do/loop."
 CASE 99
    PRINT "Error #099: Line"; ErrorLine; ": Missing line number."
 CASE 100
    PRINT "Error #100: Line"; ErrorLine; ": Unmatched gosub."
 CASE 101
    PRINT "Error #101: Error accessing file "; LCASE$(Filename); "."
 CASE 102
    PRINT "Error #102: Line"; ErrorLine; ": Mismatched select/select end."
 CASE 103
    PRINT "Error #103: Line"; ErrorLine; ": Mismatched forif/nextif."
 CASE 104
    PRINT "Error #104: Line"; ErrorLine; ": Mismatched loopif/endloopif."
 CASE 105
    PRINT "Error #105: Line"; ErrorLine; ": Mismatched selectif/selectif end."
 CASE 106
    PRINT "User defined error #106: Line"; ErrorLine; "."
 CASE 107
    PRINT "User defined error #107: Line"; ErrorLine; "."
 CASE 108
    PRINT "User defined error #108: Line"; ErrorLine; "."
 CASE 109
    PRINT "User defined error #109: Line"; ErrorLine; "."
 CASE 110
    PRINT "Error #110: Line"; ErrorLine; ": Unknown swap statement."
 CASE ELSE
    PRINT "Error #000: Error "; ErrorValue; "."
 END SELECT
END SUB

SUB End.Program
 SCREEN 0
 WIDTH 80, 25
 COLOR Plain, Black
 LOCATE , , , 8, 8
 IF LineFeed THEN
    PRINT
 END IF
 WHILE INKEY$ <> Nul
 WEND
END SUB

SUB Enter.Program.Line
 Assign = False
 FOR Blanks = 1 TO LEN(White.Space)
    Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
    IF Imbedded THEN
       Line.Number = VAL(LEFT$(Out2, Imbedded - 1))
       IF Line.Number >= 1 AND Line.Number <= Max.Lines THEN
	  Assign = True
	  Program(Line.Number) = MID$(Out2, Imbedded + 1)
	  IF Program.Name = "<none>" THEN
	     Program.Name = "<untitled>"
	  END IF
	  EXIT SUB
       END IF
    ELSE
       Line.Number = INT(VAL(Out2))
       IF Line.Number > False AND Line.Number <= Max.Lines THEN
	  Assign = True
	  Program(Line.Number) = Nul
	  IF Program.Name = "<none>" THEN
	     Program.Name = "<untitled>"
	  END IF
	  EXIT SUB
       END IF
    END IF
 NEXT
END SUB

SUB Execute.Command (Shell.Statement$)
 DIM DTAfile AS DTAtype

 ' store shell dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' start DOS command shell
 IF LEN(Shell.Statement$) THEN
    Shell.Command$ = "COMMAND.COM /E:4096 /C " + Shell.Statement$
    SHELL Shell.Command$
 ELSE
    SHELL
 END IF

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

SUB Indent.Program
 COLOR White, Black
 PRINT "Indent spaces";
 INPUT Increment
 Indent = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Number$ = SPACE$(5 - LEN(STR$(Program.Line)))
    Out2 = Program(Program.Line)
    Out2 = STRIM$(Out2)
    IF LEN(Out2) THEN
       Temp1$ = STRIM$(Out2)
       Temp1$ = UCASE$(Temp1$)
       Next.Indent = False
       RESTORE Indent.Data
       DO
	  READ Keyword$, KeyIndent
	  IF Keyword$ = "EOF" THEN
	     EXIT DO
	  END IF
	  IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
	     Next.Indent = KeyIndent
	     EXIT DO
	  END IF
       LOOP
       SELECT CASE Next.Indent
       CASE 1
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
	  Indent = Indent + 1
       CASE -1
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
	     EXIT FOR
	  END IF
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
       CASE -2
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
	     EXIT FOR
	  END IF
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
	  Indent = Indent + 1
       CASE ELSE
	  Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
       END SELECT
       Out2 = Number$ + Out2
       Program(Program.Line) = Out2
    END IF
 NEXT
 PRINT "Program indented."
END SUB

SUB Key.Prompt
 COLOR Yellow, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Input.Char$ = Nul
 DO
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       EXIT DO
    END IF
 LOOP
 PRINT
END SUB

SUB Kill.Program
 CLOSE
 DO
    COLOR White, Black
    PRINT "Program name to kill";
    INPUT Program.File$
    IF LEN(Program.File$) = False THEN
       EXIT DO
    END IF
    Program.File$ = STRIM$(LEFT$(Program.File$, 8))
    Filename = Program.File$ + ".sic"
    IF DIR$(Filename) = Nul THEN
       PRINT "File "; CHR$(34); Filename; CHR$(34); " does not exist."
    ELSE
       COLOR White, Black
       PRINT "Kill "; CHR$(34); Filename; CHR$(34); ". ";
       CALL More.Prompt("Are you sure(y/n)?", "yn", Output.Char$)
       IF Output.Char$ = "y" THEN
	  KILL Filename
	  PRINT "Program killed."
       ELSE
	  PRINT "Program not killed."
       END IF
       EXIT DO
    END IF
 LOOP
END SUB

SUB List.Files
 ' declare file search variables
 DIM DTAfile AS DTAtype

 ' declare file date and time work variables
 DIM File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
 DIM Hour AS SINGLE, Minute AS SINGLE, Seconds AS SINGLE
 DIM Day AS SINGLE, Month AS SINGLE, Year AS SINGLE
 DIM File.Date AS STRING * 10, File.Time AS STRING * 8

 ' declare file size work variables
 DIM File.Size AS DOUBLE, Total.Bytes AS DOUBLE

 ' display header
 GOSUB Title.Header

 ' reset some variables
 Total.Files = False
 Total.Bytes = Dfalse
 Line.Count = False
 Continuous.Display = False
 ASCIZ = "*.SIC" + CHR$(0)

 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find first filename
 InregsX.AX = &H4E00
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIZ)
 InregsX.DX = VARPTR(ASCIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 DO
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF

    ' store file attribute
    Attribute% = ASC(DTAfile.FileAttr)
    Attr$ = NUL
    IF (Attribute% AND &H1) = &H1 THEN
       Attr$ = Attr$ + "R"
    END IF
    IF (Attribute% AND &H2) = &H2 THEN
       Attr$ = Attr$ + "H"
    END IF
    IF (Attribute% AND &H4) = &H4 THEN
       Attr$ = Attr$ + "S"
    END IF

    ' store filename
    Filename = DTAfile.ASCIZfilename
    Filename = LEFT$(Filename, INSTR(Filename, CHR$(0)) - 1)
    Filename = LEFT$(Filename, INSTR(Filename, ".") - 1)

    ' count files
    Total.Files = Total.Files + 1

    ' store file size
    File.Size = Dfalse
    File.Size = File.Size + ASC(MID$(DTAfile.FileSize, 4, 1))
    File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 3, 1))
    File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 2, 1))
    File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 1, 1))

    ' count bytes
    Total.Bytes = Total.Bytes + File.Size

    ' construct file date and time for display
    File.Work.Time = ASC(MID$(DTAfile.FileTime, 2, 1))
    File.Work.Time = File.Work.Time * &H100 + ASC(MID$(DTAfile.FileTime, 1, 1))
    File.Work.Date = ASC(MID$(DTAfile.FileDate, 2, 1))
    File.Work.Date = File.Work.Date * &H100 + ASC(MID$(DTAfile.FileDate, 1, 1))
    Hour = INT(File.Work.Time / 2048)
    Minute = INT((File.Work.Time AND &H7E0) / 32)
    Seconds = INT((File.Work.Time AND &H1F) / 2)
    Year = INT(File.Work.Date / 512)
    Month = INT((File.Work.Date AND &H1E0) / 32)
    Day = INT(File.Work.Date AND &H1F)
    Year = Year + 1980
    File.Date = RIGHT$(STR$(Month + 100), 2) + "-" + RIGHT$(STR$(Day + 100), 2) + "-" + MID$(STR$(Year), 2)
    File.Time = RIGHT$(STR$(Hour + 100), 2) + ":" + RIGHT$(STR$(Minute + 100), 2) + ":" + RIGHT$(STR$(Seconds + 100), 2)

    ' make filename
    Filename = LCASE$(Filename)
    MID$(Filename, 1, 1) = UCASE$(MID$(Filename, 1, 1))
    Display.Line$ = Filename + SPACE$(8 - LEN(Filename))
    Display.Line$ = Display.Line$ + " " + File.Date + " " + File.Time
    FileSize$ = FORMATD$(File.Size, "#,##0")
    Display.Line$ = Display.Line$ + " " + RTRIM$(FileSize$)

    ' display filename
    COLOR Yellow, Black
    PRINT Display.Line$;

    ' check attribute
    IF LEN(Attr$) THEN
       COLOR Red, Black
       PRINT " ";Attr$;
    END IF
    PRINT

    ' check page length
    IF Continuous.Display = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count >= 21 THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "y"
	     GOSUB Title.Header
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous.Display = True
	  END SELECT
       END IF
    END IF

    ' find next filename
    InregsX.AX = &H4F00
    CALL InterruptX(&H21, InregsX, OutregsX)
 LOOP

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' print totals
 COLOR White, Black
 PRINT "--------                     ----"
 Total.Line$ = FORMATD$(Total.Files, "#,##0") + " Files"
 Total.Line$ = Total.Line$ + SPACE$(29 - LEN(Total.Line$))
 Temp# = Total.Bytes
 TempA = False
 DO
    IF Temp# >= 1024 THEN
       Temp# = Temp# / 1024
       TempA = TempA + 1
       IF TempA = 4 THEN
	  EXIT DO
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 Temp$ = FORMATD$(Temp#, "#,##0.0;;")
 SELECT CASE TempA
 CASE 0
    Strng = Temp$ + " B"
 CASE 1
    Strng = Temp$ + " KB"
 CASE 2
    Strng = Temp$ + " MB"
 CASE 3
    Strng = Temp$ + " GB"
 CASE 4
    Strng = Temp$ + " TB"
 CASE ELSE
    Strng = Temp$
 END SELECT
 Total.Line$ = Total.Line$ + Strng
 PRINT Total.Line$
 EXIT SUB

Title.Header:
 COLOR White, Black
 PRINT "Filename Date       Time     Size"
 PRINT "-------- ---------- -------- ----"
 RETURN
END SUB

SUB List.Help
 DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]general documentation"
    PRINT "[3]formatting information"
    PRINT "[4]screen mode tables"
    PRINT "[5]error code values"
    PRINT "[6]syntax documentation"
    PRINT "[7]boolean syntax/charts"
    CALL More.Prompt("Enter(1-7, Q to quit)?", "1234567q", Output.Char$)
    SELECT CASE Output.Char$
    CASE "1"
       COLOR Yellow, Black
       PRINT "ANALYZE  --  checks program structure."
       PRINT "FILES    --  display programs."
       PRINT "INDENT   --  formats current program."
       PRINT "KILL     --  delete program."
       PRINT "LIST     --  display current program."
       PRINT "LOAD     --  read program from disk."
       PRINT "NEW      --  erase current program."
       PRINT "QUIT     --  exit SIC interpreter."
       PRINT "RENUMBER --  renumber program."
       PRINT "RUN      --  start current program."
       PRINT "SAVE     --  store current program."
       PRINT "WHATIS   --  enter immediate mode."
    CASE "2"
       Filename = "sic.doc"
       CALL List.Help.File
    CASE "3"
       Filename = "sicform.doc"
       CALL List.Help.File
    CASE "4"
       Filename = "sicscrn.doc"
       CALL List.Help.File
    CASE "5"
       Filename = "error.doc"
       CALL List.Help.File
    CASE "6"
       Filename = "syntax.doc"
       CALL List.Help.File
    CASE "7"
       Filename = "boolean.doc"
       CALL List.Help.File
    CASE "q"
       EXIT DO
    END SELECT
 LOOP
END SUB

SUB List.Help.File
 CLOSE
 IF DIR$(Filename) = Nul THEN
    PRINT "Helpfile "; CHR$(34); Filename; CHR$(34); " not found."
    EXIT SUB
 END IF
 OPEN Filename FOR INPUT AS #1
 Continuous = False
 Line.Count = False
 DO WHILE NOT EOF(1)
    COLOR Yellow, Black
    LINE INPUT #1, Input.Line$
    PRINT Input.Line$
    IF Continuous = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count >= 21 THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous = True
	  END SELECT
       END IF
    END IF
 LOOP
 CALL Key.Prompt
END SUB

SUB List.Program
 COLOR White, Black
 PRINT "Program: "; Program.Name
 Continuous.Display = False
 Line.Counter = 1
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = Program(Program.Line)
    IF LEN(Out2) THEN
       IF Continuous.Display = False THEN
	  Line.Counter = Line.Counter + 1
	  IF Line.Counter = 24 THEN
	     Line.Counter = False
	     CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	     SELECT CASE Output.Char$
	     CASE "n"
		EXIT FOR
	     CASE "c"
		Continuous.Display = True
	     END SELECT
	  END IF
       END IF
       COLOR Yellow, Black
       Strng = MID$(STR$(Program.Line), 2) + " " + Out2
       PRINT Strng
    END IF
 NEXT
 COLOR White, Black
 PRINT "Program list ended."
END SUB

SUB Load.Program
 CALL Save.Current
 COLOR White, Black
 PRINT "Program name to load";
 INPUT Program.File$
 IF Program.File$ = Nul THEN
    EXIT SUB
 END IF
 IF RIGHT$(STRIM$(UCASE$(Program.File$)), 4) = ".SIC" THEN
    Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
 END IF
 Program.File$ = STRIM$(LEFT$(Program.File$, 8))
 Filename = Program.File$ + ".sic"
 CALL New.Program
 Program.Name = "<none>"
 CALL Read.Program
 Program.Name = LCASE$(Program.File$)
 COLOR White, Black
 PRINT "Program loaded."
END SUB

SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

SUB New.Program
 FOR Program.Line = 1 TO Max.Lines
    Program(Program.Line) = Nul
 NEXT
END SUB

SUB Quit.Program
 CALL Save.Current
 CALL Key.Prompt
 CALL End.Program
 END
END SUB

SUB Read.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 DO WHILE NOT EOF(1)
    LINE INPUT #1, Out2
    Imbedded = INSTR(Out2, MID$(White.Space, 1, 1))
    IF Imbedded THEN
       Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
       IF Line.Number > False AND Line.Number <= Max.Lines THEN
	  Program(Line.Number) = MID$(Out2, Imbedded + 1)
       END IF
    ELSE
       Imbedded = INSTR(Out2, MID$(White.Space, 2, 1))
       IF Imbedded THEN
	  Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
	  IF Line.Number > False AND Line.Number <= Max.Lines THEN
	     Program(Line.Number) = MID$(Out2, Imbedded + 1)
	  END IF
       END IF
    END IF
 LOOP
 CLOSE
END SUB

SUB Read.Stdin

 ' check standard input
 InregsX.AX=&H600
 InregsX.DX=&H0FF
 CALL InterruptX(&H21, InregsX, OutregsX)
 If (OutregsX.Flags And &H40)=&H40 Then
    Exit Sub
 Endif

 Program.Resume = 1
 CALL New.Program

 ' loop while reading input
 DO

    ' read character from standard input
    Char$=Chr$(OutregsX.AX And &HFF)
    If Asc(Char$)=0 Then
       InregsX.AX=&H600
       InregsX.DX=&H0FF
       CALL InterruptX(&H21, InregsX, OutregsX)
       Char$=Chr$(0)+Chr$(OutregsX.AX And &HFF)
    Endif

    ' determine character type
    SELECT CASE ASC(Char$)
    CASE 0, 10, 26
    CASE 13
       Imbedded = INSTR(Out2, MID$(White.Space, 1, 1))
       IF Imbedded THEN
	  Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
	  IF Line.Number > False AND Line.Number <= Max.Lines THEN
	     Program(Line.Number) = MID$(Out2, Imbedded + 1)
	  END IF
       ELSE
	  Imbedded = INSTR(Out2, MID$(White.Space, 2, 1))
	  IF Imbedded THEN
	     Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
	     IF Line.Number > False AND Line.Number <= Max.Lines THEN
		Program(Line.Number) = MID$(Out2, Imbedded + 1)
	     END IF
	  END IF
       END IF
       Out2 = Nul
    CASE ELSE
       Out2 = Out2 + Char$
    END SELECT

    ' check standard input
    InregsX.AX=&H600
    InregsX.DX=&H0FF
    CALL InterruptX(&H21, InregsX, OutregsX)
    If (OutregsX.Flags And &H40)=&H40 Then
       Exit Do
    Endif
 LOOP

 ' run stdin program
 CALL Run.Program
 END
END SUB

SUB Renumber.Program
 COLOR White, Black
 PRINT "Increment value";
 INPUT Increment
 CALL Count.Lines(Last.Line)
 REDIM Renumber.List(1 TO Max.Lines) AS INTEGER
 Filename = "renumber.sc1"
 CALL Store.Program
 New.Line.Number = False
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       New.Line.Number = New.Line.Number + Increment
       IF New.Line.Number > Max.Lines THEN
          COLOR White, Black
	  PRINT "Renumber list exceeds"; STR$(Max.Lines); " lines."
	  ERASE Renumber.List
	  EXIT SUB
       END IF
       Renumber.List(New.Line.Number) = Line.Number
    END IF
 NEXT
 PRINT "Renumbering program.."
 FOR Line.Number = 1 TO Last.Line
    New.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = STRIM$(Old.Program.Line$)
    IF Old.Program.Line$ <> Nul THEN
       Line.Renumbered = True
       IF UCASE$(LEFT$(Old.Program.Line$, 7)) = "RESTORE" THEN
	  Line.Renumbered = False
	  Imbedded = INSTR(UCASE$(New.Program.Line$), "RESTORE")
	  New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded + 6)
	  Number$ = MID$(Old.Program.Line$, 8)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
	  FOR New.Line.Number = 1 TO Max.Lines
	     IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
		Program(Line.Number) = New.Program.Line$ + STR$(New.Line.Number)
		Line.Renumbered = True
		EXIT FOR
	     END IF
	  NEXT
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 4)) = "GOTO" THEN
	  Line.Renumbered = False
	  Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO")
	  New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded + 3)
	  Number$ = MID$(Old.Program.Line$, 5)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
	  FOR New.Line.Number = 1 TO Max.Lines
	     IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
		Program(Line.Number) = New.Program.Line$ + STR$(New.Line.Number)
		Line.Renumbered = True
		EXIT FOR
	     END IF
	  NEXT
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 13)) = "ON ERROR GOTO" THEN
	  Line.Renumbered = False
	  Imbedded = INSTR(UCASE$(New.Program.Line$), "ON ERROR GOTO")
	  New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded + 12)
	  Number$ = MID$(Old.Program.Line$, 14)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
	  FOR New.Line.Number = 1 TO Max.Lines
	     IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
		Program(Line.Number) = New.Program.Line$ + STR$(New.Line.Number)
		Line.Renumbered = True
		EXIT FOR
	     END IF
	  NEXT
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 6)) = "RESUME" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" THEN
	     IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME SAME" THEN
		IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME NEXT" THEN
		   Line.Renumbered = False
		   Imbedded = INSTR(UCASE$(New.Program.Line$), "RESUME")
		   New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded + 5)
		   Number$ = MID$(Old.Program.Line$, 7)
		   Number$ = STRIM$(Number$)
		   Old.Line.Number = INT(VAL(Number$))
		   FOR New.Line.Number = 1 TO Max.Lines
		      IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
			 Program(Line.Number) = New.Program.Line$ + STR$(New.Line.Number)
			 Line.Renumbered = True
			 EXIT FOR
		      END IF
		   NEXT
		END IF
	     END IF
	  END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 5)) = "GOSUB" THEN
	  Line.Renumbered = False
	  Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB")
	  New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded + 4)
	  Number$ = MID$(Old.Program.Line$, 6)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
	  FOR New.Line.Number = 1 TO Max.Lines
	     IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
		Program(Line.Number) = New.Program.Line$ + STR$(New.Line.Number)
		Line.Renumbered = True
		EXIT FOR
	     END IF
	  NEXT
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 2)) = "ON" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 8)) <> "ON ERROR" THEN
	     Line.Renumbered = False
	     Imbedded = INSTR(UCASE$(Old.Program.Line$), "GOTO")
	     Imbed.Count = Imbedded
	     WHILE Imbed.Count
		Imbedded = Imbed.Count
		Imbed.Count = INSTR(Imbedded + 1, UCASE$(Old.Program.Line$), "GOTO")
	     WEND
	     IF Imbedded THEN
		Imbedded2 = INSTR(UCASE$(New.Program.Line$), "GOTO")
		Imbed.Count = Imbedded2
		WHILE Imbed.Count
		   Imbedded2 = Imbed.Count
		   Imbed.Count = INSTR(Imbedded2 + 1, UCASE$(New.Program.Line$), "GOTO")
		WEND
		New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded2 + 3)
		Number$ = MID$(Old.Program.Line$, Imbedded + 4)
		DO
		   Imbedded = INSTR(Number$, ",")
		   IF Imbedded THEN
		      New.Number$ = LEFT$(Number$, Imbedded - 1)
		      Number$ = MID$(Number$, Imbedded + 1)
		   ELSE
		      New.Number$ = Number$
		      Number$ = Nul
		   END IF
		   Line.Renumbered = False
		   Old.Line.Number = INT(VAL(New.Number$))
		   FOR New.Line.Number = 1 TO Max.Lines
		      IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
			 New.Program.Line$ = New.Program.Line$ + STR$(New.Line.Number) + ","
			 Line.Renumbered = True
			 EXIT FOR
		      END IF
		   NEXT
		   IF Number$ = Nul THEN
		      EXIT DO
		   END IF
		   IF Line.Renumbered = False THEN
		      EXIT DO
		   END IF
		LOOP
		IF RIGHT$(New.Program.Line$, 1) = "," THEN
		   New.Program.Line$ = LEFT$(New.Program.Line$, LEN(New.Program.Line$) - 1)
		END IF
		Program(Line.Number) = New.Program.Line$
	     ELSE
		Imbedded = INSTR(UCASE$(Old.Program.Line$), "GOSUB")
		Imbed.Count = Imbedded
		WHILE Imbed.Count
		   Imbedded = Imbed.Count
		   Imbed.Count = INSTR(Imbedded + 1, UCASE$(Old.Program.Line$), "GOSUB")
		WEND
		IF Imbedded THEN
		   Imbedded2 = INSTR(UCASE$(New.Program.Line$), "GOSUB")
		   Imbed.Count = Imbedded2
		   WHILE Imbed.Count
		      Imbedded2 = Imbed.Count
		      Imbed.Count = INSTR(Imbedded2 + 1, UCASE$(New.Program.Line$), "GOSUB")
		   WEND
		   New.Program.Line$ = LEFT$(New.Program.Line$, Imbedded2 + 4)
		   Number$ = MID$(Old.Program.Line$, Imbedded + 5)
		   DO
		      Imbedded = INSTR(Number$, ",")
		      IF Imbedded THEN
			 New.Number$ = LEFT$(Number$, Imbedded - 1)
			 Number$ = MID$(Number$, Imbedded + 1)
		      ELSE
			 New.Number$ = Number$
			 Number$ = Nul
		      END IF
		      Line.Renumbered = False
		      Old.Line.Number = INT(VAL(New.Number$))
		      FOR New.Line.Number = 1 TO Max.Lines
			 IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
			    New.Program.Line$ = New.Program.Line$ + STR$(New.Line.Number) + ","
			    Line.Renumbered = True
			    EXIT FOR
			 END IF
		      NEXT
		      IF Number$ = Nul THEN
			 EXIT DO
		      END IF
		      IF Line.Renumbered = False THEN
			 EXIT DO
		      END IF
		   LOOP
		   IF RIGHT$(New.Program.Line$, 1) = "," THEN
		      New.Program.Line$ = LEFT$(New.Program.Line$, LEN(New.Program.Line$) - 1)
		   END IF
		   Program(Line.Number) = New.Program.Line$
		END IF
	     END IF
	  END IF
       END IF
       IF Line.Renumbered = False THEN
          COLOR White, Black
	  PRINT "Error renumbering program."
	  Filename = "renumber.sc1"
	  CALL Read.Program
          COLOR White, Black
	  PRINT "Program reloaded."
	  ERASE Renumber.List
	  EXIT SUB
       END IF
    END IF
 NEXT
 PRINT "Resequencing line numbers.."
 Filename = "renumber.sc1"
 CALL Store.Program
 CLOSE
 OPEN "renumber.sc1" FOR INPUT AS #1
 CALL New.Program
 WHILE NOT EOF(1)
    LINE INPUT #1, New.Program.Line$
    Old.Line.Number = INT(VAL(LEFT$(New.Program.Line$, INSTR(New.Program.Line$, " ") - 1)))
    FOR New.Program.Line = 1 TO Max.Lines
       IF Renumber.List(New.Program.Line) = Old.Line.Number THEN
	  Program(New.Program.Line) = MID$(New.Program.Line$, INSTR(New.Program.Line$, " ") + 1)
	  EXIT FOR
       END IF
    NEXT
 WEND
 CLOSE
 COLOR White, Black
 PRINT "Program renumbered."
 ERASE Renumber.List
END SUB

SUB Run.Program
 CLOSE
 DataLine = 1
 DataNumber = False
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 Screen.Mode = False
 Visible = 1
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO 128
       Arrays(Count1, Count2) = Dfalse
    NEXT
    FOR Count2 = 1 TO 3
       ForNext(Count1, Count2) = Dfalse
    NEXT
 NEXT
 Program.Line = False
 CALL Count.Lines(Last.Line)
Statement.Loop:
 Program.Line = Program.Line + 1
 IF Program.Line > Last.Line THEN
    GOTO Statement.End
 END IF
 Out2 = STRIM$(Program(Program.Line))
 IF LEN(Out2) THEN
    DO
       IF RIGHT$(Out2, 1) = "_" THEN
	  Program.Line = Program.Line + 1
	  Out2 = LEFT$(Out2, LEN(Out2) - 1) + STRIM$(Program(Program.Line))
       ELSE
	  EXIT DO
       END IF
       Out2 = STRIM$(Out2)
    LOOP
    CALL Enter.Equate
 END IF
 GOTO Statement.Loop
Statement.End:
 CALL End.Program
 Program.Line = Max.Lines
END SUB

SUB Save.Current
 IF Program.Name <> "<none>" THEN
    CALL More.Prompt("Save current program(y/n)?", "yn", Output.Char$)
    IF Output.Char$ = "y" THEN
       CALL Save.Program
    END IF
 END IF
END SUB

SUB Save.Program
 DO
    DO
       COLOR White, Black
       PRINT "Program name to save";
       IF Program.Name <> "<untitled>" THEN
          COLOR White, Black
	  PRINT "("; Program.Name; ")";
       END IF
       INPUT Name.Store$
       IF Name.Store$ = Nul THEN
	  IF Program.Name <> "<untitled>" THEN
	     EXIT DO
	  END IF
       ELSE
	  Program.Name = STRIM$(LEFT$(Name.Store$, 8))
	  EXIT DO
       END IF
    LOOP
    Program.Name = LCASE$(Program.Name)
    COLOR White, Black
    PRINT "Save program as "; CHR$(34); Program.Name; CHR$(34);
    CALL More.Prompt("(y/n/q)?", "ynq", Output.Char$)
    SELECT CASE Output.Char$
    CASE "y"
       Output.Char$ = "y"
       Filename = Program.Name + ".sic"
       IF DIR$(Filename) <> Nul THEN
	  PRINT "Program already exists. ";
	  CALL More.Prompt("Overwrite(y/n)?", "yn", Output.Char$)
       END IF
       IF Output.Char$ = "y" THEN
	  CALL Store.Program
          COLOR White, Black
	  PRINT "Program "; CHR$(34); Program.Name; CHR$(34); " saved to disk."
	  EXIT DO
       END IF
    CASE "q"
       COLOR White, Black
       PRINT "Program not saved to disk."
       EXIT DO
    END SELECT
 LOOP
END SUB

SUB Store.Program
 CLOSE
 OPEN Filename FOR OUTPUT AS #1
 CALL Count.Lines(Last.Line)
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       PRINT #1, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
    END IF
 NEXT
 CLOSE
END SUB

' declare trim function
FUNCTION STRIM$ (Var$)
 XVar$ = Var$
 FOR Count = 1 TO LEN(White.Space)
    DO
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = MID$(XVar$, 2)
       ELSE
	  EXIT DO
       END IF
    LOOP
    DO
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
       ELSE
	  EXIT DO
       END IF
    LOOP
 NEXT
 STRIM$ = XVar$
END FUNCTION

SUB Whatis.Command
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO 128
       Arrays(Count1, Count2) = Dfalse
    NEXT
    FOR Count2 = 1 TO 3
       ForNext(Count1, Count2) = Dfalse
    NEXT
 NEXT
 DO
    Program.Line = False
    COLOR White, Black
    PRINT ":";
    LINE INPUT Out2
    IF UCASE$(Out2) = "QUIT" THEN
       EXIT DO
    END IF
    CALL Enter.Equate
    IF LineFeed THEN
       PRINT
    END IF
 LOOP
 CALL End.Program
 COLOR White, Black
 PRINT "Whatis run ended."
END SUB
