REM Sicsub1.bas v5.1a - Symbolic Instruction Code; module 2 of 3.
REM The public domain DOS programming interpreter.

' get standard include declarations
REM $INCLUDE: 'SIC.INC'

 ' declares all Sic statements on left side of equation,
 ' each statement listed contains its own subroutine.
 ' listed in rows of ten.
Program.Data:
 DATA "'","ENDIF","END IF","STOP","REM","MID$","LEFT$","RIGHT$","PRINT #","DPRINT"
 DATA "LPRINT","SPRINT","UPRINT","INPUT;","FORIF","FOR","NEXTIF","NEXT","CONTINUE FORIF","CONTINUE FOR"
 DATA "EXIT FORIF","EXIT FOR","DO UNTIL","LOOP WHILE","EXIT DO","CONTINUE DO","GOTO","GOSUB","RETURN","DO WHILE"
 DATA "DO","OFF","IF","ELSEIF","CASEIF ELSE","CASEIF","SELECT CASE","SELECT END","BEEP","SOUND"
 DATA "COLOR","LOCATE","CLS","SCREEN","WIDTH","WRITE #","LINE INPUT;","LINE INPUT #","INPUT #","WEND"
 DATA "WHILE","CONTINUE WHILE","EXIT WHILE","ELSE","LOOP UNTIL","LOOPIF","END LOOPIF","EXIT LOOPIF","LOOP","RANDOMIZE"
 DATA "POKE","INT86","DEFSEG","ABSOLUTE","OUT","WAIT","SLEEP","PAUSE","SELECTIF CASE","SELECTIF END"
 DATA "CASE ELSE","CASE","CONTINUE LOOPIF","END","CLEAR","SYSTEM","SWAP","ERROR","ON ERROR GOTO","ON ERROR RESUME PREVIOUS"
 DATA "ON ERROR RESUME SAME","ON ERROR RESUME NEXT","ON ERROR STOP","RESUME PREVIOUS","RESUME SAME","RESUME NEXT","RESUME","ON","DATE$","TIME$"
 DATA "CHDRIVE","CD","CHDIR","MD","MKDIR","RD","RMDIR","KILL","DELETE","RENAME"
 DATA "NAME","SHELL","CHAIN","LET","CLOSE #","OPEN #","FIELD #","WRITE","PRINT","INPUT"
 DATA "LINE INPUT","LSET #","RSET #","PUT #","GET #","READ #","DATA","READ","RESTORE","CIRCLE STEP"
 DATA "LINE STEP","PSET","PRESET","PAINT","DRAW","PLAY","GET","PUT","BSAVE","BLOAD"
 DATA "VIEW SCREEN","VIEW","WINDOW SCREEN","WINDOW","CIRCLE","LINE"
 DATA "EOF"

REM $DYNAMIC
SUB Enter.Equate
 ON LOCAL ERROR GOTO Equate.Error
 Out2 = STRIM$(Out2)
 IF Out2 = Nul THEN
    EXIT SUB
 END IF
 Store.Input$ = Out2
 GOSUB Assignment
 IF Assign THEN
    EXIT SUB
 END IF
 Out2 = Store.Input$
 RESTORE Program.Data
 Program.Number = False
 DO
    Program.Number = Program.Number + 1
    READ C$
    IF C$ = "EOF" THEN
       ERROR 91
       EXIT DO
    END IF
    D$ = UCASE$(LEFT$(Out2, LEN(C$)))
    IF C$ = D$ THEN
       SELECT CASE Program.Number
       CASE 1
	  ' Rem
       CASE 2
	  ' Endif
       CASE 3
	  ' End if
       CASE 4
	  Program.Line = Max.Lines
       CASE 5
	  ' Rem
       CASE 6
	  GOSUB Assign.Mid.String
       CASE 7
	  GOSUB Assign.Left.String
       CASE 8
	  GOSUB Assign.Right.String
       CASE 9
	  GOSUB Print.Expression.File
       CASE 10
	  GOSUB Dprint.Expression
       CASE 11
	  GOSUB Lprint.Expression
       CASE 12
	  GOSUB Sprint.Expression
       CASE 13
	  GOSUB Uprint.Expression
       CASE 14
	  GOSUB Input.Expression.X
       CASE 15
	  GOSUB Forif.Loop
       CASE 16
	  GOSUB Loop.Expression
       CASE 17
	  GOSUB Loopif.Terminate
       CASE 18
	  GOSUB Loop.Terminate
       CASE 19
	  GOSUB Continue.Forif
       CASE 20
	  GOSUB Continue.For
       CASE 21
	  GOSUB Exitif.For
       CASE 22
	  GOSUB Exit.For
       CASE 23
	  ' Do.Until
       CASE 24
	  GOSUB End.Do.While
       CASE 25
	  GOSUB Exit.Do
       CASE 26
	  GOSUB Continue.Do
       CASE 27
	  GOSUB Branch.To
       CASE 28
	  GOSUB Gosub.Branch
       CASE 29
	  GOSUB Return.Branch
       CASE 30
	  GOSUB Do.While
       CASE 31
	  ' Do
       CASE 32
	  Program.Line = Max.Lines
       CASE 33
	  GOSUB If.Branch
       CASE 34
	  GOSUB Else.Branch
       CASE 35
	  GOSUB Selectif.End
       CASE 36
	  GOSUB Selectif.End
       CASE 37
	  GOSUB Select.Case
       CASE 38
	  ' Select End
       CASE 39
	  BEEP
       CASE 40
	  GOSUB Sound.Speaker
       CASE 41
	  GOSUB Change.Color
       CASE 42
	  GOSUB Locate.Cursor
       CASE 43
	  GOSUB CLS.Screen
       CASE 44
	  GOSUB Change.Screen
       CASE 45
	  GOSUB Change.Width
       CASE 46
	  GOSUB Write.Expression.File
       CASE 47
	  GOSUB Line.Input.Expression.X
       CASE 48
	  GOSUB Line.Input.Exp.File
       CASE 49
	  GOSUB Input.Expression.File
       CASE 50
	  GOSUB End.While
       CASE 51
	  GOSUB Do.Wend
       CASE 52
	  GOSUB Continue.While
       CASE 53
	  GOSUB Exit.While
       CASE 54
	  GOSUB Else.Branch
       CASE 55
	  GOSUB End.Do.Until
       CASE 56
	  GOSUB Loopif.Start
       CASE 57
	  GOSUB Endloop.If
       CASE 58
	  GOSUB Exitloop.If
       CASE 59
	  GOSUB End.Do
       CASE 60
	  GOSUB Seed.Random
       CASE 61
	  GOSUB Poke.Value
       CASE 62
	  GOSUB Int86.Function
       CASE 63
	  GOSUB Defseg.Function
       CASE 64
	  GOSUB Absolute.Function
       CASE 65
	  GOSUB Output.Port
       CASE 66
	  GOSUB Wait.Port
       CASE 67
	  GOSUB Sleep.Second
       CASE 68
	  GOSUB Pause.Second
       CASE 69
	  GOSUB Selectif.Case
       CASE 70
	  ' Select End
       CASE 71
	  GOSUB Select.End
       CASE 72
	  GOSUB Select.End
       CASE 73
	  GOSUB Continue.Loopif
       CASE 74
	  Program.Line = Max.Lines
       CASE 75
	  Program.Line = Max.Lines
       CASE 76
	  Program.Line = Max.Lines
       CASE 77
	  GOSUB Swap.Data
       CASE 78
	  Out2 = MID$(Out2, 6)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  ERROR CINT(Temp3#)
       CASE 79
	  Out2 = MID$(Out2, 14)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  ErrorType = CINT(Temp3#)
       CASE 80
	  ErrorType = -1
       CASE 81
	  ErrorType = -2
       CASE 82
	  ErrorType = -3
       CASE 83
	  ErrorType = False
       CASE 84
	  Program.Line = ErrorLine - 1
	  DO
	     IF LEN(STRIM$(Program(Program.Line))) THEN
		Program.Line = Program.Line - 1
		EXIT DO
	     END IF
	     Program.Line = Program.Line - 1
	     IF Program.Line < 1 THEN
		Program.Line = Max.Lines
		EXIT DO
	     END IF
	  LOOP
       CASE 85
	  Program.Line = ErrorLine - 1
       CASE 86
	  Program.Line = ErrorLine + 1
	  DO
	     IF LEN(STRIM$(Program(Program.Line))) THEN
		Program.Line = Program.Line - 1
		EXIT DO
	     END IF
	     Program.Line = Program.Line + 1
	     IF Program.Line > Last.Line THEN
		EXIT DO
	     END IF
	  LOOP
       CASE 87
	  Out2 = MID$(Out2, 7)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Program.Line = CINT(Temp3#) - 1
       CASE 88
	  GOSUB Multi.Branch
       CASE 89
	  GOSUB Set.Date
       CASE 90
	  GOSUB Set.Time
       CASE 91
	  GOSUB Change.Drive
       CASE 92
	  GOSUB CD.Directory1
       CASE 93
	  GOSUB CD.Directory2
       CASE 94
	  GOSUB MD.Directory1
       CASE 95
	  GOSUB MD.Directory2
       CASE 96
	  GOSUB RD.Directory1
       CASE 97
	  GOSUB RD.Directory2
       CASE 98
	  GOSUB Kill.File1
       CASE 99
	  GOSUB Kill.File2
       CASE 100
	  GOSUB Name.Expression1
       CASE 101
	  GOSUB Name.Expression2
       CASE 102
	  GOSUB Shell.Program
       CASE 103
	  GOSUB Chain.Program
       CASE 104
	  GOSUB Assign.Keyword
       CASE 105
	  GOSUB Close.File
       CASE 106
	  GOSUB Open.File
       CASE 107
	  GOSUB Open.Field
       CASE 108
	  GOSUB Write.Expression
       CASE 109
	  GOSUB Print.Expression
       CASE 110
	  GOSUB Input.Expression
       CASE 111
	  GOSUB Line.Input.Expression
       CASE 112
	  GOSUB Lset.Field
       CASE 113
	  GOSUB Rset.Field
       CASE 114
	  GOSUB Put.Record
       CASE 115
	  GOSUB Get.Record
       CASE 116
	  GOSUB Read.Record
       CASE 117
	  ' Data
       CASE 118
	  GOSUB Read.Data
       CASE 119
	  GOSUB Restore.Data
       CASE 120
	  GOSUB Draw.Circle.Step
       CASE 121
	  GOSUB Draw.Line.Step
       CASE 122
	  GOSUB Draw.Pixel
       CASE 123
	  GOSUB Draw.PixelX
       CASE 124
	  GOSUB Paint.Area
       CASE 125
	  GOSUB Draw.Expression
       CASE 126
	  GOSUB Play.Expression
       CASE 127
	  GOSUB Get.Graphics
       CASE 128
	  GOSUB Put.Graphics
       CASE 129
	  GOSUB BSave.Image
       CASE 130
	  GOSUB BLoad.Image
       CASE 131
	  GOSUB View.Screen1
       CASE 132
	  GOSUB View.Screen2
       CASE 133
	  GOSUB Window.Screen1
       CASE 134
	  GOSUB Window.Screen2
       CASE 135
	  GOSUB Draw.Circle
       CASE 136
	  GOSUB Draw.Line
       END SELECT
       EXIT SUB
    END IF
 LOOP
Equate.Exit:
 EXIT SUB

Assign.Keyword:
 Temp1$ = UCASE$(MID$(Out2, 4))
 Temp1$ = STRIM$(Temp1$)
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 IF LEFT$(Temp1$, 3) = "MID" THEN
    GOTO Assign.Mid.String
 END IF
 IF LEFT$(Temp1$, 4) = "LEFT" THEN
    GOTO Assign.Left.String
 END IF
 IF LEFT$(Temp1$, 5) = "RIGHT" THEN
    GOTO Assign.Right.String
 END IF

Assignment:
 Assign = False
 Temp1$ = UCASE$(LEFT$(Out2, 1))
 IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
    Variable = ASC(Temp1$) - 64
    Temp1$ = MID$(Out2, 2)
    Temp2$ = UCASE$(LEFT$(Temp1$, 1))
    IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
       Temp2$ = MID$(Out2, 3)
       Y$ = UCASE$(LEFT$(Temp2$, 1))
       IF Y$ >= "A" AND Y$ <= "Z" THEN
	  Y$ = MID$(Out2, 4)
	  Z$ = UCASE$(LEFT$(Y$, 1))
	  Z$ = STRIM$(Z$)
	  IF LEFT$(Z$, 1) = "=" THEN
	     Y$ = MID$(Y$, 2)
	     Y$ = STRIM$(Y$)
	     Z$ = UCASE$(LEFT$(Out2, 3))
	     CALL Assignment4(Y$, Z$)
	     IF Assign THEN
		RETURN
	     END IF
	  END IF
       ELSE
	  IF Y$ = "=" THEN
	     Y$ = MID$(Out2, 4)
	     Y$ = STRIM$(Y$)
	     Z$ = UCASE$(LEFT$(Out2, 2))
	     CALL Assignment3(Y$, Z$)
	     IF Assign THEN
		RETURN
	     END IF
	  END IF
       END IF
    END IF
    Temp1$ = STRIM$(Temp1$)
    CALL Assignment1(Temp1$, Variable)
    IF Assign THEN
       RETURN
    END IF
    IF LEFT$(Temp1$, 1) = "$" THEN
       Temp1$ = MID$(Temp1$, 2)
       Temp1$ = STRIM$(Temp1$)
       IF LEFT$(Temp1$, 1) = "=" THEN
	  Assign = True
	  Out2 = MID$(Temp1$, 2)
	  Out2 = STRIM$(Out2)
	  CALL Equate(Temp3#)
	  Strngs(Variable) = Out3
       END IF
       RETURN
    END IF
    IF LEFT$(Temp1$, 1) = "(" THEN
       Out2 = MID$(Temp1$, 2)
       Out2 = STRIM$(Out2)
       Last.Token = False
       Token.Index = 1
       CALL Get.Token
       CALL Parse1(Temp3#)
       Element = CINT(Temp3#)
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       CALL Assignment2(Temp1$, Variable, Element)
    END IF
 END IF
 RETURN

Assign.Mid.String:
 Out2 = MID$(Out2, 4)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Length = CINT(Temp3#)
	  Out2 = MID$(Out2, Token.Index)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     MID$(Strngs(Variable), Start, Length) = Out3
	  END IF
       END IF
    END IF
 END IF
 RETURN

Assign.Left.String:
 Out2 = MID$(Out2, 5)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
	  Out2 = MID$(Out2, Token.Index)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     MID$(Strngs(Variable), 1, Start) = Out3
	  END IF
       END IF
    END IF
 END IF
 RETURN

Assign.Right.String:
 Out2 = MID$(Out2, 6)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
	  Out2 = MID$(Out2, Token.Index)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Length = LEN(Strngs(Variable)) - Start + 1
	     IF Length > False THEN
		MID$(Strngs(Variable), Length, Start) = Out3
	     END IF
	  END IF
       END IF
    END IF
 END IF
 RETURN

Print.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 6)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 6)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = 1
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  PRINT STR$(Temp3#),
       ELSE
	  PRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
	  PRINT STR$(Temp3#);
       ELSE
	  PRINT Out3;
       END IF
    CASE ELSE
       Token.Index = Token.Index - 1
       IF Last.Token THEN
	  PRINT STR$(Temp3#);
       ELSE
	  PRINT Out3;
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Print.Expression.File:
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Out2 = MID$(Out2, Token.Index)
       Out2 = STRIM$(Out2)
       Last.Token = False
       Out3 = Nul
       Out4 = Nul
       Temp# = False
       Token.Index = 1
       LineFeed = False
       IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
	  LineFeed = True
       END IF
       Temp1$ = STRIM$(Temp1$)
       WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
	  Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
	  Temp1$ = STRIM$(Temp1$)
       WEND
       IF Temp1$ = Nul THEN
	  PRINT #File.Num%, CHR$(13) + CHR$(10);
	  RETURN
       END IF
       DO
	  Last.Token = False
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  SELECT CASE Strng
	  CASE ","
	     IF Last.Token THEN
		PRINT #File.Num%, STR$(Temp3#),
	     ELSE
		PRINT #File.Num%, Out3,
	     END IF
	  CASE ";"
	     IF Last.Token THEN
		PRINT #File.Num%, STR$(Temp3#);
	     ELSE
		PRINT #File.Num%, Out3;
	     END IF
	  CASE ELSE
	     Token.Index = Token.Index - 1
	     IF Last.Token THEN
		PRINT #File.Num%, STR$(Temp3#);
	     ELSE
		PRINT #File.Num%, Out3;
	     END IF
	  END SELECT
	  IF Token.Index > LEN(Out2) THEN
	     EXIT DO
	  END IF
       LOOP
       IF LineFeed = False THEN
	  PRINT #File.Num%, CHR$(13); CHR$(10);
       END IF
       RETURN
    END IF
 END IF
 ERROR 32
 RETURN

Dprint.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       PRINT FORMATD$(NOW#, Out3),
    CASE ";"
       PRINT FORMATD$(NOW#, Out3);
    CASE ELSE
       Token.Index = Token.Index - 1
       PRINT FORMATD$(NOW#, Out3);
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Lprint.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    LPRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = True
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  LPRINT STR$(Temp3#),
       ELSE
	  LPRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
	  LPRINT STR$(Temp3#);
       ELSE
	  LPRINT Out3;
       END IF
    CASE ELSE
       Token.Index = Token.Index - 1
       IF Last.Token THEN
	  LPRINT STR$(Temp3#);
       ELSE
	  LPRINT Out3;
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    LPRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Sprint.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  PRINT CHR$(Temp3#),
       ELSE
	  PRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
	  PRINT CHR$(Temp3#);
       ELSE
	  PRINT Out3;
       END IF
    CASE ELSE
       Token.Index = Token.Index - 1
       IF Last.Token THEN
	  PRINT CHR$(Temp3#);
       ELSE
	  PRINT Out3;
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Uprint.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    Number# = Temp3#
    CALL Get.Token
    CALL Parse1(Temp3#)
    Strng = MID$(Out2, Token.Index, 1)
    Token.Index = Token.Index + 1
    SELECT CASE Strng
    CASE ","
       PRINT FORMATD$(Number#, Out3),
    CASE ";"
       PRINT FORMATD$(Number#, Out3);
    CASE ELSE
       PRINT FORMATD$(Number#, Out3);
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Line.Input.Expression.X:
 Add.Cursor = False
 Temp1$ = MID$(Out2, 12)
 GOTO Line.Input.Function
Line.Input.Expression:
 Add.Cursor = True
 Temp1$ = MID$(Out2, 11)
Line.Input.Function:
 Temp1$ = STRIM$(Temp1$)
 Token.Index = 1
 Out2 = Temp1$
 Last.Token = True
 Quotes = False
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    IF Quotes THEN
       PRINT Out3;
       Temp1$ = MID$(Out2, Token.Index)
    END IF
 END IF
 Temp1$ = STRIM$(Temp1$)
 Temp1$ = UCASE$(Temp1$)
 SELECT CASE LEN(Temp1$)
 CASE 1
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       LINE INPUT ; ""; Temp2$
       Variables(Variable) = VAL(Temp2$)
    END IF
 CASE 2
    Temp1$ = LEFT$(Temp1$, 1)
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       LINE INPUT ; ""; Temp2$
       Strngs(Variable) = Temp2$
    END IF
 CASE 3
    IF RIGHT$(Temp1$, 2) = "()" THEN
       Temp1$ = LEFT$(Temp1$, 1)
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	  Variable = ASC(Temp1$) - 64
	  LINE INPUT ; ""; Temp2$
	  FOR L = 1 TO LEN(Temp2$)
	     Arrays(Variable, L) = ASC(MID$(Temp2$, L, 1))
	     IF L = 128 THEN
		EXIT FOR
	     END IF
	  NEXT
       END IF
    END IF
 CASE ELSE
    Out2 = MID$(Temp1$, 2)
    Temp1$ = LEFT$(Temp1$, 1)
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       CALL Equate(Temp3#)
       Element = CINT(Temp3#)
       IF Element > False AND Element <= 128 THEN
	  LINE INPUT ; ""; Temp2$
	  Arrays(Variable, Element) = VAL(Temp2$)
       END IF
    END IF
 END SELECT
 IF Add.Cursor THEN
    PRINT
 END IF
 RETURN

Line.Input.Exp.File:
 Out2 = MID$(Out2, 13)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       SELECT CASE LEN(Temp1$)
       CASE 1
	  IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	     Variable = ASC(Temp1$) - 64
	     LINE INPUT #File.Num%, Temp2$
	     IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
		Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
	     END IF
	     IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
		Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
	     END IF
	     Variables(Variable) = VAL(Temp2$)
	  END IF
       CASE 2
	  Temp1$ = LEFT$(Temp1$, 1)
	  IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	     Variable = ASC(Temp1$) - 64
	     LINE INPUT #File.Num%, Temp2$
	     IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
		Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
	     END IF
	     IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
		Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
	     END IF
	     Strngs(Variable) = Temp2$
	  END IF
       CASE 3
	  IF RIGHT$(Temp1$, 2) = "()" THEN
	     Temp1$ = LEFT$(Temp1$, 1)
	     IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
		Variable = ASC(Temp1$) - 64
		LINE INPUT #File.Num%, Temp2$
		IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
		   Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
		END IF
		IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
		   Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
		END IF
		FOR L = 1 TO LEN(Temp2$)
		   Arrays(Variable, L) = ASC(MID$(Temp2$, L, 1))
		   IF L = 128 THEN
		      EXIT FOR
		   END IF
		NEXT
	     END IF
	  END IF
       CASE ELSE
	  Out2 = MID$(Temp1$, 2)
	  Temp1$ = LEFT$(Temp1$, 1)
	  IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	     Variable = ASC(Temp1$) - 64
	     CALL Equate(Temp3#)
	     Element = CINT(Temp3#)
	     IF Element > False AND Element <= 128 THEN
		LINE INPUT #File.Num%, Temp2$
		IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
		   Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
		END IF
		IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
		   Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
		END IF
		Arrays(Variable, Element) = VAL(Temp2$)
	     END IF
	  END IF
       END SELECT
       RETURN
    END IF
 END IF
 ERROR 36
 RETURN

Input.Expression.X:
 Add.Cursor = False
 Temp1$ = MID$(Out2, 7)
 GOTO Input.Function
Input.Expression:
 Add.Cursor = True
 Temp1$ = MID$(Out2, 6)
Input.Function:
 Temp1$ = STRIM$(Temp1$)
 Token.Index = 1
 Out2 = Temp1$
 Last.Token = True
 Quotes = False
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    IF Quotes THEN
       IF Strng = ";" THEN
	  PRINT Out3;
       ELSE
	  IF Strng = "," THEN
	     PRINT Out3; "?";
	  END IF
       END IF
       Out2 = MID$(Temp1$, Token.Index)
    ELSE
       Out2 = Temp1$
       PRINT "?";
    END IF
 ELSE
    Out2 = Temp1$
    PRINT "?";
 END IF
 LINE INPUT ; ""; User.Input$
 Stored.Input$ = User.Input$
 Stored.Token.Index = 1
 Stored.Out2$ = STRIM$(UCASE$(Out2))
 DO
    Token.Index = Stored.Token.Index
    Out2 = Stored.Out2$
    Last.Token = False
    CALL Get.Token
    Stored.Token.Index = Token.Index
    Stored.Out2$ = Out2
    Temp1$ = STRIM$(Strng)
    IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
       Variable = ASC(LEFT$(Temp1$, 1)) - 64
       Out2 = Stored.Input$
       Last.Token = False
       Token.Index = 1
       Temp3# = Dfalse
       DO
	  CALL Get.Token
	  IF Token = 1 THEN
	     IF Strng = "," THEN
		Out3 = LEFT$(Out2, Token.Index - 2)
		EXIT DO
	     END IF
	  END IF
	  IF Token.Index > LEN(Out2) THEN
	     Out3 = Out2
	     EXIT DO
	  END IF
       LOOP
       Temp3# = VAL(Out3)
       Stored.Input$ = MID$(Out2, Token.Index)
       Token.Index = Stored.Token.Index
       Out2 = Stored.Out2$
       SELECT CASE LEN(Temp1$)
       CASE 1
	  IF MID$(Out2, Token.Index, 1) = "(" THEN
	     IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
		FOR Element = 1 TO LEN(Out3)
		   Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
		   IF Element = 128 THEN
		      EXIT FOR
		   END IF
		NEXT
	     ELSE
		CALL Get.Token
		CALL Parse1(Temp4#)
		Stored.Token.Index = Token.Index
		Stored.Out2$ = Out2
		Element = CINT(Temp4#)
		IF Element > False AND Element <= 128 THEN
		   Arrays(Variable, Element) = Temp3#
		END IF
	     END IF
	  ELSE
	     Variables(Variable) = Temp3#
	  END IF
       CASE 2
	  IF MID$(Temp1$, 2, 1) = "$" THEN
	     Strngs(Variable) = Out3
	  END IF
       END SELECT
    END IF
    IF Stored.Token.Index > LEN(Stored.Out2$) THEN
       EXIT DO
    END IF
 LOOP
 IF Add.Cursor THEN
    PRINT
 END IF
 RETURN

Input.Expression.File:
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Out2 = MID$(Out2, Token.Index)
       Out2 = STRIM$(Out2)
       DO
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  IF Strng = "," THEN
	     CALL Get.Token
	  END IF
	  Temp1$ = STRIM$(Strng)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
	     Variable = ASC(LEFT$(Temp1$, 1)) - 64
	     SELECT CASE LEN(Temp1$)
	     CASE 1
		IF MID$(Out2, Token.Index, 1) = "(" THEN
		   IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
		      INPUT #FileNum%, Out3
		      FOR Element = 1 TO LEN(Out3)
			 Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
			 IF Element = 128 THEN
			    EXIT FOR
			 END IF
		      NEXT
		   ELSE
		      CALL Get.Token
		      CALL Parse1(Temp4#)
		      Element = CINT(Temp4#)
		      INPUT #File.Num%, Temp3#
		      IF Element > False AND Element <= 128 THEN
			 Arrays(Variable, Element) = Temp3#
		      END IF
		   END IF
		ELSE
		   INPUT #File.Num, Temp3#
		   Variables(Variable) = Temp3#
		END IF
	     CASE 2
		IF MID$(Temp1$, 2, 1) = "$" THEN
		   INPUT #File.Num%, Out3
		   IF LEFT$(Out3, 1) = CHR$(34) THEN
		      Out3 = MID$(Out3, 2)
		   END IF
		   IF RIGHT$(Out3, 1) = CHR$(34) THEN
		      Out3 = LEFT$(Out3, LEN(Out3) - 1)
		   END IF
		   Strngs(Variable) = Out3
		END IF
	     END SELECT
	  END IF
	  IF Token.Index > LEN(Out2) THEN
	     EXIT DO
	  END IF
	  Out2 = MID$(Out2, Token.Index)
       LOOP
       RETURN
    END IF
 END IF
 ERROR 34
 RETURN

Write.Expression:
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 6)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 6)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    RETURN
 END IF
 Printer.LF = 1
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Position = False
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ",", ";"
       IF Position THEN
	  PRINT ",";
       END IF
       IF Last.Token THEN
	  PRINT STRIM$(STR$(Temp3#));
       ELSE
	  PRINT CHR$(34) + Out3 + CHR$(34);
       END IF
       Position = True
    CASE ELSE
       IF Position THEN
	  PRINT ",";
       END IF
       Token.Index = Token.Index - 1
       IF Last.Token THEN
	  PRINT STRIM$(STR$(Temp3#));
       ELSE
	  PRINT CHR$(34) + Out3 + CHR$(34);
       END IF
       Position = True
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 RETURN

Write.Expression.File:
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Out2 = MID$(Out2, Token.Index)
       Out2 = STRIM$(Out2)
       Last.Token = False
       Out3 = Nul
       Out4 = Nul
       Token.Index = 1
       LineFeed = False
       IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
	  LineFeed = True
       END IF
       Temp1$ = STRIM$(Out2)
       WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
	  Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
	  Temp1$ = STRIM$(Temp1$)
       WEND
       IF Temp1$ = Nul THEN
	  PRINT #File.Num%, CHR$(13) + CHR$(10);
	  RETURN
       END IF
       Position = False
       DO
	  Last.Token = False
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  SELECT CASE Strng
	  CASE ",", ";"
	     IF Position THEN
		PRINT #File.Num%, ",";
	     END IF
	     IF Last.Token THEN
		PRINT #File.Num%, STRIM$(STR$(Temp3#));
	     ELSE
		PRINT #File.Num%, CHR$(34) + Out3 + CHR$(34);
	     END IF
	     Position = True
	  CASE ELSE
	     IF Position THEN
		PRINT #File.Num%, ",";
	     END IF
	     Token.Index = Token.Index - 1
	     IF Last.Token THEN
		PRINT #File.Num%, STRIM$(STR$(Temp3#));
	     ELSE
		PRINT #File.Num%, CHR$(34) + Out3 + CHR$(34);
	     END IF
	     Position = True
	  END SELECT
	  IF Token.Index > LEN(Out2) THEN
	     EXIT DO
	  END IF
       LOOP
       IF LineFeed = False THEN
	  PRINT #File.Num%, CHR$(13); CHR$(10);
       END IF
       RETURN
    END IF
 END IF
 ERROR 31
 RETURN

Forif.Loop:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 IF Strng = "," THEN
    Forif$ = MID$(Out2, Token.Index)
    Token.Index = 1
    CALL Get.Token
    CALL Equate(Temp4#)
    IF Temp4# THEN
       Out2 = UCASE$(Forif$)
       Out2 = STRIM$(Out2)
       Temp1$ = UCASE$(LEFT$(Out2, 1))
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	  Element = ASC(Temp1$) - 64
	  Out2 = MID$(Out2, 2)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     FinishFor = Dfalse
	     StepTo = 1#
	     ExceptStep = Dfalse
	     CALL Equate(StartFor#)
	     Variables(Element) = StartFor#
	     ForNext(Element, 1) = FinishFor
	     ForNext(Element, 2) = StepTo
	     ForNext(Element, 3) = ExceptStep
	     IF StartFor# = ExceptStep THEN
		IF StartFor# = FinishFor THEN
		   GOTO Loopif.Ignore
		ELSE
		   GOSUB Loopif.Ignore
		   Program.Line = Program.Line - 1
		   RETURN
		END IF
	     END IF
	     IF StepTo > Dfalse THEN
		IF StartFor# > FinishFor THEN
		   GOTO Loopif.Ignore
		END IF
	     END IF
	     IF StepTo < Dfalse THEN
		IF StartFor# < FinishFor THEN
		   GOTO Loopif.Ignore
		END IF
	     END IF
	     RETURN
	  END IF
       END IF
    ELSE
       GOTO Loopif.Ignore
    END IF
    RETURN
 END IF
 ERROR 103
 RETURN

Loopif.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedif.Ignore
    IF Imbedded THEN
       GOTO Loopif.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 103
 RETURN

Imbeddedif.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 103
 RETURN

Loopif.Terminate:
 For.Loop = Program.Line
Nextif.For:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbeddedif.For
    IF Imbedded THEN
       GOTO Nextif.For
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Out2 = MID$(Temp1$, 6)
       Out2 = STRIM$(Out2)
       Token.Index = 1
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Strng = "," THEN
	  Forif$ = MID$(Out2, Token.Index)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Equate(Temp4#)
	  IF Temp4# THEN
	     Out2 = UCASE$(Forif$)
	     Out2 = STRIM$(Out2)
	     Temp1$ = UCASE$(LEFT$(Out2, 1))
	     IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
		Element = ASC(Temp1$) - 64
		Variable# = Variables(Element)
		FinishFor = ForNext(Element, 1)
		ForStep = ForNext(Element, 2)
		ExceptStep = ForNext(Element, 3)
		Variable# = Variable# + ForStep
		Variables(Element) = Variable#
		IF ExceptStep <> Dfalse THEN
		   IF Variable# = ExceptStep THEN
		      Program.Line = For.Loop - 1
		      RETURN
		   END IF
		END IF
		IF ForStep > Dfalse THEN
		   IF Variable# <= FinishFor THEN
		      Program.Line = Count1
		   ELSE
		      Program.Line = For.Loop
		   END IF
		   RETURN
		ELSE
		   IF ForStep < Dfalse THEN
		      IF Variable# >= FinishFor THEN
			 Program.Line = Count1
		      ELSE
			 Program.Line = For.Loop
		      END IF
		      RETURN
		   END IF
		END IF
	     END IF
	  ELSE
	     Program.Line = Count1
	  END IF
	  RETURN
       END IF
       ERROR 103
       RETURN
    END IF
 NEXT
 ERROR 103
 RETURN

Imbeddedif.For:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 103
 RETURN

Continue.Forif:
 Nested = 1
 Out2 = MID$(Out2, 15)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 103
 RETURN

Exitif.For:
 Nested = 1
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 103
 RETURN

Loop.Expression:
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Temp1$ = UCASE$(LEFT$(Out2, 1))
 IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
    Element = ASC(Temp1$) - 64
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    IF LEFT$(Out2, 1) = "=" THEN
       Out2 = MID$(Out2, 2)
       Out2 = STRIM$(Out2)
       FinishFor = Dfalse
       StepTo = 1#
       ExceptStep = Dfalse
       CALL Equate(StartFor#)
       Variables(Element) = StartFor#
       ForNext(Element, 1) = FinishFor
       ForNext(Element, 2) = StepTo
       ForNext(Element, 3) = ExceptStep
       IF StartFor# = ExceptStep THEN
	  IF StartFor# = FinishFor THEN
	     GOTO Loop.Ignore
	  ELSE
	     GOSUB Loop.Ignore
	     Program.Line = Program.Line - 1
	     RETURN
	  END IF
       END IF
       IF StepTo > Dfalse THEN
	  IF StartFor# > FinishFor THEN
	     GOTO Loop.Ignore
	  END IF
       END IF
       IF StepTo < Dfalse THEN
	  IF StartFor# < FinishFor THEN
	     GOTO Loop.Ignore
	  END IF
       END IF
       RETURN
    END IF
 END IF
 ERROR 97
 RETURN

Loop.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Ignore
    IF Imbedded THEN
       GOTO Loop.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 97
 RETURN

Imbedded.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 3)) <> "FOR" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 97
 RETURN

Loop.Terminate:
 For.Loop = Program.Line
Next.For:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.For
    IF Imbedded THEN
       GOTO Next.For
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       Temp1$ = STRIM$(MID$(Temp1$, 4))
       Temp1$ = UCASE$(LEFT$(Temp1$, 1))
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	  Element = ASC(Temp1$) - 64
	  Variable# = Variables(Element)
	  FinishFor = ForNext(Element, 1)
	  ForStep = ForNext(Element, 2)
	  ExceptStep = ForNext(Element, 3)
	  Variable# = Variable# + ForStep
	  Variables(Element) = Variable#
	  IF ExceptStep <> Dfalse THEN
	     IF Variable# = ExceptStep THEN
		Program.Line = For.Loop - 1
		RETURN
	     END IF
	  END IF
	  IF ForStep > Dfalse THEN
	     IF Variable# <= FinishFor THEN
		Program.Line = Count1
	     ELSE
		Program.Line = For.Loop
	     END IF
	     RETURN
	  ELSE
	     IF ForStep < Dfalse THEN
		IF Variable# >= FinishFor THEN
		   Program.Line = Count1
		ELSE
		   Program.Line = For.Loop
		END IF
		RETURN
	     END IF
	  END IF
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

Imbedded.For:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 4)) <> "NEXT" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 97
 RETURN

Continue.For:
 Nested = 1
 Out2 = MID$(Out2, 13)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

Exit.For:
 Nested = 1
 Out2 = MID$(Out2, 9)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

End.Do.While:
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dtrue THEN
    GOTO End.Do
 END IF
 RETURN
End.Do.Until:
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
    GOTO End.Do
 END IF
 RETURN
End.Do:
 Loop.Line = Program.Line
Next.Do:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.Loop
    IF Imbedded THEN
       GOTO Next.Do
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       IF UCASE$(LEFT$(Temp1$, 8)) = "DO WHILE" THEN
	  Out2 = MID$(Temp1$, 9)
	  Out2 = STRIM$(Out2)
	  CALL Equate(Temp3#)
	  IF Temp3# = Dfalse THEN
	     Program.Line = Loop.Line
	  ELSE
	     Program.Line = Count1
	  END IF
	  RETURN
       ELSE
	  IF UCASE$(LEFT$(Temp1$, 8)) = "DO UNTIL" THEN
	     Out2 = MID$(Temp1$, 9)
	     Out2 = STRIM$(Out2)
	     CALL Equate(Temp3#)
	     IF Temp3# <> Dfalse THEN
		Program.Line = Loop.Line
	     ELSE
		Program.Line = Count1
	     END IF
	     RETURN
	  ELSE
	     Program.Line = Count1
	     RETURN
	  END IF
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Loopif.Start:
 Unless.Branch = False
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# THEN
    IF Unless.Branch = False THEN
       RETURN
    ELSE
       IF Unless.Value = Dfalse THEN
	  RETURN
       END IF
    END IF
 END IF
 Nested = 1
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Endloop.If:
 Loop.Line = Program.Line
Next.Ifdo:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.Loopif
    IF Imbedded THEN
       GOTO Next.Ifdo
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Out2 = MID$(Temp1$, 7)
       Out2 = STRIM$(Out2)
       CALL Equate(Temp3#)
       IF Temp3# = Dfalse THEN
	  Program.Line = Loop.Line
       ELSE
	  Program.Line = Count1
       END IF
       RETURN
    END IF
 NEXT
 ERROR 104
 RETURN

Exitloop.If:
 Nested = 1
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Imbedded.Loopif:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 10)) <> "END LOOPIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 104
 RETURN

Continue.Loopif:
 Nested = 1
 Out2 = MID$(Out2, 16)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Imbedded.Loop:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 4)) <> "LOOP" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Continue.Do:
 Nested = 1
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Exit.Do:
 Nested = 1
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Branch.To:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 Branch.Loop = CINT(Temp3#)
 IF Branch.Loop > False AND Branch.Loop <= Last.Line THEN
    Temp1$ = STRIM$(Program(Branch.Loop))
    IF Temp1$ <> Nul THEN
       Program.Line = Branch.Loop - 1
       RETURN
    END IF
 END IF
 ERROR 99
 RETURN

Gosub.Branch:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 Branch.Loop = CINT(Temp3#)
 IF Branch.Loop > False AND Branch.Loop <= Last.Line THEN
    Temp1$ = STRIM$(Program(Branch.Loop))
    IF Temp1$ <> Nul THEN
       Nested.Gosub = Nested.Gosub + 1
       IF Nested.Gosub = Max.Gosubs THEN
	  Max.Gosubs = Max.Gosubs + 10
	  REDIM PRESERVE GosubReturn(1 TO Max.Gosubs) AS INTEGER
       END IF
       GosubReturn(Nested.Gosub) = Program.Line
       Program.Line = Branch.Loop - 1
       RETURN
    END IF
 END IF
 ERROR 99
 RETURN

Return.Branch:
 IF Nested.Gosub > False THEN
    Program.Line = GosubReturn(Nested.Gosub)
    Nested.Gosub = Nested.Gosub - 1
    RETURN
 END IF
 ERROR 100
 RETURN

Do.While:
 Out2 = MID$(Out2, 9)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
Do.Branch:
    FOR Count1 = Program.Line + 1 TO Last.Line
       GOSUB Imbedded.Do
       IF Imbedded THEN
	  GOTO Do.Branch
       END IF
       Temp1$ = Program(Count1)
       Temp1$ = STRIM$(Temp1$)
       IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
	  Program.Line = Count1
	  RETURN
       END IF
    NEXT
    ERROR 98
 END IF
 RETURN

Imbedded.Do:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 2)) <> "DO" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Multi.Branch:
 Branch$ = Out2
 Branch.Index = False
 Out2 = MID$(Out2, 3)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 Branch.Index = CINT(Temp3#)
 Out2 = Branch$
 Out2 = MID$(Out2, 3)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Branch.Number = False THEN
    RETURN
 END IF
 IF Branch.Type = 1 THEN
    IF Branch.Number > False AND Branch.Number <= Last.Line THEN
       Temp1$ = STRIM$(Program(Branch.Number))
       IF Temp1$ <> Nul THEN
	  Program.Line = Branch.Number - 1
	  RETURN
       END IF
    END IF
 ELSE
    IF Branch.Type = 2 THEN
       IF Branch.Number > False AND Branch.Number <= Last.Line THEN
	  Temp1$ = STRIM$(Program(Branch.Number))
	  IF Temp1$ <> Nul THEN
	     Nested.Gosub = Nested.Gosub + 1
	     IF Nested.Gosub = Max.Gosubs THEN
		Max.Gosubs = Max.Gosubs + 10
		REDIM PRESERVE GosubReturn(1 TO Max.Gosubs) AS INTEGER
	     END IF
	     GosubReturn(Nested.Gosub) = Program.Line
	     Program.Line = Branch.Number - 1
	     RETURN
	  END IF
       END IF
    END IF
 END IF
 ERROR 99
 RETURN

If.Branch:
 Unless.Branch = False
 Out2 = MID$(Out2, 3)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# THEN
    IF Unless.Branch = False THEN
       RETURN
    ELSE
       IF Unless.Value = Dfalse THEN
	  RETURN
       END IF
    END IF
 END IF
Endif.Branch:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Endif
    IF Imbedded THEN
       GOTO Endif.Branch
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "ELSEIF" THEN
       Program.Line = Count1
       Out2 = UCASE$(MID$(Temp1$, 5))
       GOTO If.Branch
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "ELSE" THEN
       Program.Line = Count1
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 99
 RETURN

Else.Branch:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Endif
    IF Imbedded THEN
       GOTO Else.Branch
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 99
 RETURN

Imbedded.Endif:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 2)) <> "IF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "IF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 99
 RETURN

Do.Wend:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
While.Branch:
    FOR Count1 = Program.Line + 1 TO Last.Line
       GOSUB Imbedded.Wend
       IF Imbedded THEN
	  GOTO While.Branch
       END IF
       Temp1$ = Program(Count1)
       Temp1$ = STRIM$(Temp1$)
       IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
	  Program.Line = Count1
	  RETURN
       END IF
    NEXT
    ERROR 98
 END IF
 RETURN

Imbedded.Wend:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 5)) <> "WHILE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

End.While:
 Loop.Line = Program.Line
Next.While:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.While
    IF Imbedded THEN
       GOTO Next.While
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Out2 = MID$(Temp1$, 6)
       Out2 = STRIM$(Out2)
       CALL Equate(Temp3#)
       IF Temp3# = Dfalse THEN
	  Program.Line = Loop.Line
       ELSE
	  Program.Line = Count1
       END IF
       RETURN
    END IF
 NEXT
 ERROR 98
 RETURN

Imbedded.While:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 4)) <> "WEND" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Continue.While:
 Nested = 1
 Out2 = MID$(Out2, 15)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Exit.While:
 Nested = 1
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Sound.Speaker:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Tone = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Duration = CINT(Temp4#)
    SOUND Tone, Duration
 END IF
 RETURN

Change.Color:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Foreground = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    BackGround = CINT(Temp4#)
    COLOR Foreground, BackGround
 ELSE
    COLOR Foreground
 END IF
 RETURN

Change.Screen:
 Screen.Color = False
 Color.Set = False
 Active.Page = False
 Active.Set = False
 Visual.Page = False
 Visual.Set = False
 Out2 = MID$(Temp1$, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Screen.Mode = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Screen.Color = CINT(Temp4#)
    IF Last.Token THEN
       Color.Set = True
    END IF
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Active.Page = CINT(Temp4#)
       IF Last.Token THEN
	  Active.Set = True
       END IF
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Visual.Page = CINT(Temp4#)
	  IF Last.Token THEN
	     Visual.Set = True
	  END IF
       END IF
    END IF
 END IF
 IF Color.Set AND Active.Set AND Visual.Set THEN
    SCREEN Screen.Mode, Screen.Color, Active.Page, Visual.Page
 ELSE
    IF Color.Set AND Active.Set THEN
       SCREEN Screen.Mode, Screen.Color, Active.Page
    ELSE
       IF Color.Set AND Visual.Set THEN
	  SCREEN Screen.Mode, Screen.Color, , Visual.Page
       ELSE
	  IF Active.Set AND Visual.Set THEN
	     SCREEN Screen.Mode, , Active.Page, Visual.Page
	  ELSE
	     IF Color.Set THEN
		SCREEN Screen.Mode, Screen.Color
	     ELSE
		IF Active.Set THEN
		   SCREEN Screen.Mode, , Active.Page
		ELSE
		   IF Visual.Set THEN
		      SCREEN Screen.Mode, , , Visual.Page
		   ELSE
		      SCREEN Screen.Mode
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
 END IF
 RETURN

Change.Width:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 ScreenWidth = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    ScreenHeight = CINT(Temp4#)
    WIDTH ScreenWidth, ScreenHeight
 END IF
 RETURN

Locate.Cursor:
 Out2 = MID$(Temp1$, 7)
 Out2 = STRIM$(Out2)
 Xcoor = CSRLIN
 Ycoor = POS(0)
 IF LEN(Out2) THEN
    Token.Index = 1
    IF MID$(Out2, Token.Index, 1) = "," THEN
       CALL Get.Token
    ELSE
       CALL Get.Token
       CALL Parse1(Temp4#)
       Xcoor = CINT(Temp4#)
    END IF
    IF Strng = "," THEN
       IF MID$(Out2, Token.Index, 1) = "," THEN
	  CALL Get.Token
       ELSE
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Ycoor = CINT(Temp4#)
       END IF
       IF Strng = "," THEN
	  IF MID$(Out2, Token.Index, 1) = "," THEN
	     CALL Get.Token
	  ELSE
	     CALL Get.Token
	     CALL Parse1(Temp4#)
	     Visible = CINT(Temp4#)
	  END IF
	  IF Strng = "," THEN
	     CALL Get.Token
	     CALL Parse1(Temp4#)
	     StartScan = CINT(Temp4#)
	     EndScan = StartScan
	     IF Strng = "," THEN
		CALL Get.Token
		CALL Parse1(Temp4#)
		EndScan = CINT(Temp4#)
	     END IF
	     LOCATE Xcoor, Ycoor, Visible, StartScan, EndScan
	     EXIT SUB
	  END IF
       END IF
    END IF
 END IF
 LOCATE Xcoor, Ycoor, Visible
 RETURN

Seed.Random:
 Out2 = MID$(Temp1$, 10)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 RANDOMIZE CLNG(Temp3#)
 RETURN

Select.End:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Select
    IF Imbedded THEN
       GOTO Select.End
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 10)) = "SELECT END" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 102
 RETURN

Selectif.End:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedif.Select
    IF Imbedded THEN
       GOTO Selectif.End
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) = "SELECTIF END" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 105
 RETURN

Select.Case:
 Last.Token = False
 Out2 = MID$(Out2, 12)
 CALL Equate(Temp3#)
 IF Last.Token THEN
    CaseValue = Temp3#
 ELSE
    CaseStrng = Out3
 END IF
 Previous.Token = Last.Token
Next.Select.Case:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Select
    IF Imbedded THEN
       GOTO Next.Select.Case
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 10)) = "SELECT END" THEN
       Program.Line = Count1
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 9)) = "CASE ELSE" THEN
       Program.Line = Count1
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "CASE" THEN
       Out2 = MID$(Temp1$, 5)
       Out2 = STRIM$(Out2)
       Token.Index = 1
       DO
	  Last.Token = False
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  SELECT CASE Last.Token
	  CASE -1
	     IF CaseValue = Temp4# THEN
		Program.Line = Count1
		RETURN
	     END IF
	  CASE 0
	     IF CaseStrng = Out3 THEN
		Program.Line = Count1
		RETURN
	     END IF
	  CASE 1
	     IF ValueIs THEN
		Program.Line = Count1
		RETURN
	     END IF
	  CASE 2
	     IF Previous.Token THEN
		IF CaseValue >= CaseValue1 AND CaseValue <= CaseValue2 THEN
		   Program.Line = Count1
		   RETURN
		END IF
	     ELSE
		IF CaseStrng >= CaseValueS1 AND CaseStrng <= CaseValueS2 THEN
		   Program.Line = Count1
		   RETURN
		END IF
	     END IF
	  END SELECT
	  IF Last.Token = 1 THEN
	     Token.Index = Token.Index - 2
	  END IF
	  IF Token.Index > LEN(Out2) THEN
	     EXIT DO
	  END IF
       LOOP
    END IF
 NEXT
 ERROR 102
 RETURN

Selectif.Case:
 Out2 = MID$(Out2, 14)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 IF Strng = "," THEN
    Selectif$ = MID$(Out2, Token.Index)
    Token.Index = 1
    CALL Get.Token
    CALL Equate(Temp4#)
    IF Temp4# THEN
       Out2 = UCASE$(Selectif$)
       Out2 = STRIM$(Out2)
       Last.Token = False
       CALL Equate(Temp3#)
       IF Last.Token THEN
	  CaseValue = Temp3#
       ELSE
	  CaseStrng = Out3
       END IF
       Previous.Token = Last.Token
Next.Selectif.Case:
       FOR Count1 = Program.Line + 1 TO Last.Line
	  GOSUB Imbeddedif.Select
	  IF Imbedded THEN
	     GOTO Next.Selectif.Case
	  END IF
	  Temp1$ = Program(Count1)
	  Temp1$ = STRIM$(Temp1$)
	  IF UCASE$(LEFT$(Temp1$, 12)) = "SELECTIF END" THEN
	     Program.Line = Count1
	     RETURN
	  END IF
	  IF UCASE$(LEFT$(Temp1$, 11)) = "CASEIF ELSE" THEN
	     Program.Line = Count1
	     RETURN
	  END IF
	  IF UCASE$(LEFT$(Temp1$, 6)) = "CASEIF" THEN
	     Out2 = MID$(Temp1$, 7)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     DO
		Last.Token = False
		CALL Get.Token
		CALL Parse1(Temp4#)
		SELECT CASE Last.Token
		CASE -1
		   IF CaseValue = Temp4# THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 0
		   IF CaseStrng = Out3 THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 1
		   IF ValueIs THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 2
		   IF Previous.Token THEN
		      IF CaseValue >= CaseValue1 AND CaseValue <= CaseValue2 THEN
			 Program.Line = Count1
			 RETURN
		      END IF
		   ELSE
		      IF CaseStrng >= CaseValueS1 AND CaseStrng <= CaseValueS2 THEN
			 Program.Line = Count1
			 RETURN
		      END IF
		   END IF
		END SELECT
		IF Last.Token = 1 THEN
		   Token.Index = Token.Index - 2
		END IF
		IF Token.Index > LEN(Out2) THEN
		   EXIT DO
		END IF
	     LOOP
	  END IF
       NEXT
    ELSE
       GOTO Selectif.Ignore
    END IF
    RETURN
 END IF
 ERROR 105
 RETURN

Selectif.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedselectif.Ignore
    IF Imbedded THEN
       GOTO Selectif.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) = "SELECTIF END" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 105
 RETURN

Imbeddedselectif.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 13)) <> "SELECTIF CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "SELECTIF CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "SELECTIF END" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 103
 RETURN

Imbedded.Select:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 11)) <> "SELECT CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 11)) = "SELECT CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "SELECT END" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 102
 RETURN

Imbeddedif.Select:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 13)) <> "SELECTIF CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 13)) = "SELECTIF CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 12)) = "SELECTIF END" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 105
 RETURN

Poke.Value:
 Out2 = MID$(Temp1$, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Poke.Address = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Poke.Byte = CINT(Temp4#)
    POKE Poke.Address, Poke.Byte
 END IF
 RETURN

Int86.Function:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Int86.Value = CINT(Temp4#)
 InregsX.AX = AX
 InregsX.BX = BX
 InregsX.CX = CX
 InregsX.DX = DX
 InregsX.BP = BP
 InregsX.SI = SI
 InregsX.DI = DI
 InregsX.Flags = FL
 InregsX.DS = DS
 InregsX.ES = ES
 CALL InterruptX(Int86.Value, InregsX, OutregsX)
 AX = OutregsX.AX
 BX = OutregsX.BX
 CX = OutregsX.CX
 DX = OutregsX.DX
 BP = OutregsX.BP
 SI = OutregsX.SI
 DI = OutregsX.DI
 FL = OutregsX.Flags
 DS = OutregsX.DS
 ES = OutregsX.ES
 RETURN

Defseg.Function:
 Out2 = MID$(Temp1$, 7)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) = False THEN
    DEF SEG
 ELSE
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    DEF SEG = CINT(Temp4#)
 END IF
 RETURN

Absolute.Function:
 Out2 = MID$(Temp1$, 9)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    CALL Absolute(CINT(Temp4#))
 END IF
 RETURN

Output.Port:
 Out2 = MID$(Temp1$, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Port.Address = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Port.Byte = CINT(Temp4#)
    OUT Port.Address, Port.Byte
 END IF
 RETURN

Wait.Port:
 Out2 = MID$(Temp1$, 5)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Port.Address = CINT(Temp4#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       And.Value = CINT(Temp4#)
       Xor.Value = False
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Xor.Value = CINT(Temp4#)
       END IF
       WAIT Port.Address, And.Value, Xor.Value
    END IF
 END IF
 RETURN

Sleep.Second:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 SLEEP CLNG(Temp3#)
 RETURN

Pause.Second:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Pause.Time! = CLNG(Temp3#)
 Time.Now! = TIMER
 DO
    Elapsed.Time! = TIMER - Time.Now!
    IF Elapsed.Time! < False THEN
       Elapsed.Time! = Elapsed.Time! + 86400!
    END IF
    IF Elapsed.Time! > Pause.Time! THEN
       EXIT DO
    END IF
 LOOP
 RETURN

Swap.Data:
 Temp1$ = MID$(Out2, 5)
 Temp1$ = STRIM$(Temp1$)
 Temp2$ = UCASE$(LEFT$(Temp1$, 1))
 IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
    Variable1 = ASC(Temp2$) - 64
    Temp1$ = MID$(Temp1$, 2)
    Temp1$ = STRIM$(Temp1$)
    IF LEFT$(Temp1$, 1) = "," THEN
       Temp1$ = MID$(Temp1$, 2)
       Temp1$ = STRIM$(Temp1$)
       Temp2$ = UCASE$(LEFT$(Temp1$, 1))
       IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
	  Variable2 = ASC(Temp2$) - 64
	  Temp1$ = MID$(Temp1$, 2)
	  Temp1$ = STRIM$(Temp1$)
	  IF Temp1$ = Nul THEN
	     SWAP Variables(Variable1), Variables(Variable2)
	     RETURN
	  ELSE
	     IF LEFT$(Temp1$, 1) = "(" THEN
		Out2 = MID$(Temp1$, 2)
		Out2 = STRIM$(Out2)
		Last.Token = False
		Token.Index = 1
		CALL Get.Token
		CALL Parse1(Temp3#)
		Element = CINT(Temp3#)
		SWAP Variables(Variable1), Arrays(Variable2, Element)
		RETURN
	     END IF
	  END IF
       END IF
    ELSE
       IF LEFT$(Temp1$, 1) = "(" THEN
	  Out2 = MID$(Temp1$, 2)
	  Out2 = STRIM$(Out2)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Element1 = CINT(Temp3#)
	  Temp1$ = MID$(Out2, Token.Index)
	  Temp1$ = STRIM$(Temp1$)
	  IF LEFT$(Temp1$, 1) = "," THEN
	     Out2 = MID$(Temp1$, 2)
	     Out2 = UCASE$(Out2)
	     Temp1$ = MID$(Temp1$, 2)
	     Temp1$ = STRIM$(Temp1$)
	     Temp2$ = UCASE$(LEFT$(Temp1$, 1))
	     IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		Variable2 = ASC(Temp2$) - 64
		Temp1$ = MID$(Temp1$, 2)
		Temp1$ = STRIM$(Temp1$)
		IF Temp1$ = Nul THEN
		   SWAP Arrays(Variable1, Element1), Variables(Variable2)
		   RETURN
		ELSE
		   IF LEFT$(Temp1$, 1) = "(" THEN
		      Out2 = MID$(Temp1$, 2)
		      Out2 = STRIM$(Out2)
		      Last.Token = False
		      Token.Index = 1
		      CALL Get.Token
		      CALL Parse1(Temp3#)
		      Element2 = CINT(Temp3#)
		      SWAP Arrays(Variable1, Element1), Arrays(Variable2, Element2)
		      RETURN
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF LEFT$(Temp1$, 1) = "$" THEN
	     Temp1$ = MID$(Temp1$, 2)
	     Temp1$ = STRIM$(Temp1$)
	     IF LEFT$(Temp1$, 1) = "," THEN
		Temp1$ = MID$(Temp1$, 2)
		Temp1$ = STRIM$(Temp1$)
		Temp2$ = UCASE$(LEFT$(Temp1$, 1))
		IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		   Variable2 = ASC(Temp2$) - 64
		   Temp1$ = MID$(Temp1$, 2)
		   Temp1$ = STRIM$(Temp1$)
		   IF Temp1$ = "$" THEN
		      SWAP Strngs(Variable1), Strngs(Variable2)
		      RETURN
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
 END IF
 ERROR 110
 RETURN

Equate.Error:
 ErrorLine = Program.Line
 ErrorValue = ERR
 SELECT CASE ErrorType
 CASE -1
    DO
       Program.Line = Program.Line - 1
       IF LEN(STRIM$(Program(Program.Line))) THEN
	  Program.Line = Program.Line - 1
	  RESUME Equate.Exit
       END IF
       IF Program.Line <= False THEN
	  EXIT DO
       END IF
    LOOP
 CASE -2
    Program.Line = Program.Line - 1
    RESUME Equate.Exit
 CASE -3
    DO
       Program.Line = Program.Line + 1
       IF LEN(STRIM$(Program(Program.Line))) THEN
	  Program.Line = Program.Line - 1
	  RESUME Equate.Exit
       END IF
       IF Program.Line >= Last.Line THEN
	  EXIT DO
       END IF
    LOOP
 CASE 0
    ' nul
 CASE IS > 0
    Program.Line = ErrorType
    IF LEN(STRIM$(Program(Program.Line))) THEN
       Program.Line = Program.Line - 1
       RESUME Equate.Exit
    END IF
 END SELECT
 IF POS(0) > 1 THEN
    PRINT
 END IF
 Printer.LF = False
 Printing = False
 Program.Line = Max.Lines
 ErrorValue = ERR
 CALL Display.Error
 CALL Key.Prompt
 RESUME Equate.Exit
 RETURN

Set.Date:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 IF LEFT$(Out2, 1) = "=" THEN
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Last.Token = False THEN
       DATE$ = Out3
    END IF
 END IF
 RETURN

Set.Time:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 IF LEFT$(Out2, 1) = "=" THEN
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Last.Token = False THEN
       TIME$ = Out3
    END IF
 END IF
 RETURN

Change.Drive:
 Out2 = MID$(Temp1$, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    CHDRIVE Out3
 END IF
 RETURN

CD.Directory1:
 Out2 = MID$(Temp1$, 3)
 GOTO Change.Directory
CD.Directory2:
 Out2 = MID$(Temp1$, 6)
Change.Directory:
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    CHDIR Out3
 END IF
 RETURN

MD.Directory1:
 Out2 = MID$(Temp1$, 3)
 GOTO Make.Directory
MD.Directory2:
 Out2 = MID$(Temp1$, 6)
Make.Directory:
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    MKDIR Out3
 END IF
 RETURN

RD.Directory1:
 Out2 = MID$(Temp1$, 3)
 GOTO Remove.Directory
RD.Directory2:
 Out2 = MID$(Temp1$, 6)
Remove.Directory:
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    RMDIR Out3
 END IF
 RETURN

Kill.File1:
 Out2 = MID$(Temp1$, 5)
 GOTO Delete.File
Kill.File2:
 Out2 = MID$(Temp1$, 7)
Delete.File:
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    KILL Out3
 END IF
 RETURN

Name.Expression1:
 Out2 = MID$(Temp1$, 7)
 GOTO Rename.File
Name.Expression2:
 Out2 = MID$(Temp1$, 5)
Rename.File:
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Program.File$ = Out3
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Last.Token = False THEN
	  NAME Program.File$ AS Out3
	  RETURN
       END IF
    END IF
 END IF
 RETURN

Shell.Program:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 DOS.Command$ = Nul
 IF Last.Token = False THEN
    DOS.Command$ = Out3
 END IF
 CALL Execute.Command(DOS.Command$)
 RETURN

Chain.Program:
 Out2 = MID$(Temp1$, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Program.File$ = Out3
    Start.Line = False
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Start.Line = CINT(Temp4#) - 1
    END IF
    IF Program.File$ <> Nul THEN
       Program.File$ = STRIM$(LEFT$(Program.File$, 8))
       Filename = Program.File$ + ".sic"
       CALL New.Program
       Program.Name = "<none>"
       CALL Read.Program
       Program.Name = LCASE$(Program.File$)
       Nested.Gosub = False
       Max.Gosubs = 10
       Visible = 1
       REDIM GosubReturn(1 TO 10) AS INTEGER
       FOR Count1 = 1 TO 26
	  FOR Count2 = 1 TO 3
	     ForNext(Count1, Count2) = Dfalse
	  NEXT
       NEXT
       Program.Line = Start.Line
    END IF
 END IF
 RETURN

Close.File:
 Temp1$ = MID$(Out2, 6)
 IF STRIM$(Temp1$) = Nul THEN
    CLOSE
    RETURN
 END IF
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    CLOSE #File.Num%
    RETURN
 END IF
 ERROR 22
 RETURN

Open.File:
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Last.Token = False THEN
	  Program.File$ = Out3
	  IF Strng = "," THEN
	     CALL Get.Token
	     CALL Parse1(Temp4#)
	     IF Last.Token = False THEN
		Program.Type$ = Out3
		IF Strng = "," THEN
		   CALL Get.Token
		   CALL Parse1(Temp4#)
		   Program.Length = CINT(Temp4#)
		ELSE
		   Program.Length = 128
		END IF
		SELECT CASE UCASE$(Program.Type$)
		CASE "I"
		   OPEN Program.File$ FOR INPUT SHARED AS #File.Num% LEN = Program.Length
		CASE "O"
		   OPEN Program.File$ FOR OUTPUT SHARED AS #File.Num% LEN = Program.Length
		CASE "A"
		   OPEN Program.File$ FOR APPEND SHARED AS #File.Num% LEN = Program.Length
		CASE "R"
		   OPEN Program.File$ FOR RANDOM SHARED AS #File.Num% LEN = Program.Length
		   File.Fields(File.Num%) = STRING$(Program.Length, CHR$(0))
		   FIELD #File.Num%, Program.Length AS File.Fields(File.Num%)
		CASE "B"
		   OPEN Program.File$ FOR BINARY SHARED AS #File.Num% LEN = Program.Length
		   File.Fields(File.Num%) = STRING$(Program.Length, CHR$(0))
		CASE ELSE
		   ERROR 21
		END SELECT
		RETURN
	     END IF
	  END IF
       END IF
    END IF
 END IF
 ERROR 21
 RETURN

Open.Field:
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Field.Array(File.Num%) = Temp1$
       RETURN
    END IF
 END IF
 ERROR 23
 RETURN

Lset.Field:
 Field.Type = 1
 GOTO Set.Field
Rset.Field:
 Field.Type = 2
Set.Field:
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Field.Set = False
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       Temp2$ = LEFT$(Temp1$, 1)
       Temp1$ = MID$(Temp1$, 2)
       IF LEFT$(Temp1$, 1) = "$" THEN
	  Temp1$ = MID$(Temp1$, 2)
	  Temp1$ = STRIM$(Temp1$)
	  IF LEFT$(Temp1$, 1) = "," THEN
	     IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		Variable = ASC(Temp2$) - 64
		CALL Get.Token
		CALL Parse1(Temp4#)
		CALL Get.Token
		CALL Parse1(Temp4#)
		IF Last.Token = False THEN
		   Field.Value$ = Out3
		   Out2 = Field.Array(File.Num%)
		   Out2 = STRIM$(Out2)
		   Out2 = UCASE$(Out2)
		   Token.Index = 1
		   Start% = 1
		   DO
		      CALL Get.Token
		      CALL Parse1(Temp3#)
		      Length% = CINT(Temp3#)
		      FieldVariable = False
		      IF Strng = "AS" THEN
			 Out2 = MID$(Out2, Token.Index + 1)
			 Out2 = STRIM$(Out2)
			 IF LEFT$(Out2, 1) >= "A" AND LEFT$(Out2, 1) <= "Z" THEN
			    IF MID$(Out2, 2, 1) = "$" THEN
			       FieldVariable = ASC(LEFT$(Out2, 1)) - 64
			       Out2 = MID$(Out2, 4)
			    END IF
			 END IF
			 Token.Index = 1
		      END IF
		      IF Strng = "," THEN
			 Out2 = MID$(Out2, Token.Index + 1)
			 Token.Index = 1
		      END IF
		      IF FieldVariable = Variable THEN
			 Field.Set = True
			 Temp$ = STRING$(Length%, CHR$(0))
			 IF Field.Type = 1 THEN
			    LSET Temp$ = Field.Value$
			 ELSE
			    RSET Temp$ = Field.Value$
			 END IF
			 MID$(File.Fields(File.Num%), Start%, Length%) = Temp$
		      END IF
		      IF FieldVariable THEN
			 Start% = Start% + Length%
		      END IF
		      IF Token.Index > LEN(Out2) THEN
			 EXIT DO
		      END IF
		   LOOP
		END IF
	     END IF
	  END IF
       END IF
    END IF
 END IF
 IF Field.Set = False THEN
    IF Field.Type = 1 THEN
       ERROR 41
    ELSE
       ERROR 42
    END IF
 END IF
 RETURN

Put.Record:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Record.Number! = CSNG(Temp4#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  IF Last.Token = False THEN
	     IF Record.Number! = 0! THEN
		PUT #File.Num%, , Out3
	     ELSE
		PUT #File.Num%, Record.Number!, Out3
	     END IF
	  ELSE
	     IF Record.Number! = 0! THEN
		PUT #File.Num%, , Temp4#
	     ELSE
		PUT #File.Num%, Record.Number!, Temp4#
	     END IF
	  END IF
	  RETURN
       ELSE
	  PUT #File.Num%, Record.Number!
	  RETURN
       END IF
    ELSE
       PUT #File.Num%
       RETURN
    END IF
 END IF
 ERROR 43
 RETURN

Get.Record:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Record.Number! = CSNG(Temp4#)
       IF Strng = "," THEN
	  Temp1$ = MID$(Out2, Token.Index)
	  Temp1$ = STRIM$(Temp1$)
	  Temp1$ = UCASE$(Temp1$)
	  Temp2$ = LEFT$(Temp1$, 1)
	  Temp1$ = MID$(Temp1$, 2)
	  IF LEFT$(Temp1$, 1) = "$" THEN
	     IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		Variable = ASC(Temp2$) - 64
		IF Record.Number! = 0! THEN
		   GET #File.Num%, , Strngs(Variable)
		ELSE
		   GET #File.Num%, Record.Number!, Strngs(Variable)
		END IF
		RETURN
	     END IF
	  END IF
       ELSE
	  GET #File.Num%, Record.Number!
	  RETURN
       END IF
    ELSE
       GET #File.Num%
       RETURN
    END IF
 END IF
 ERROR 44
 RETURN

Read.Record:
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Field.Read = False
 File.Num% = CINT(Temp3#)
 IF File.Num% >= 1 AND File.Num% <= 35 THEN
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       Temp2$ = LEFT$(Temp1$, 1)
       Temp1$ = MID$(Temp1$, 2)
       IF Temp1$ = "$" THEN
	  IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
	     Variable = ASC(Temp2$) - 64
	     Out2 = Field.Array(File.Num%)
	     Out2 = STRIM$(Out2)
	     Out2 = UCASE$(Out2)
	     Token.Index = 1
	     Start% = 1
	     DO
		CALL Get.Token
		CALL Parse1(Temp3#)
		Length% = CINT(Temp3#)
		FieldVariable = False
		IF Strng = "AS" THEN
		   Out2 = MID$(Out2, Token.Index + 1)
		   Out2 = STRIM$(Out2)
		   IF LEFT$(Out2, 1) >= "A" AND LEFT$(Out2, 1) <= "Z" THEN
		      IF MID$(Out2, 2, 1) = "$" THEN
			 FieldVariable = ASC(LEFT$(Out2, 1)) - 64
			 Out2 = MID$(Out2, 4)
		      END IF
		   END IF
		   Token.Index = 1
		END IF
		IF Strng = "," THEN
		   Out2 = MID$(Out2, Token.Index + 1)
		   Token.Index = 1
		END IF
		IF FieldVariable = Variable THEN
		   Field.Read = True
		   Temp$ = MID$(File.Fields(File.Num%), Start%, Length%)
		   Strngs(Variable) = Temp$
		END IF
		IF FieldVariable THEN
		   Start% = Start% + Length%
		END IF
		IF Token.Index > LEN(Out2) THEN
		   EXIT DO
		END IF
	     LOOP
	  END IF
       END IF
    END IF
 END IF
 IF Field.Read = False THEN
    ERROR 45
 END IF
 RETURN

Read.Data:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 DO
    Last.Token = False
    CALL Get.Token
    Temp1$ = STRIM$(Strng)
    Temp1$ = UCASE$(Temp1$)
    IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
       Variable = ASC(LEFT$(Temp1$, 1)) - 64
       SELECT CASE LEN(Temp1$)
       CASE 1
	  IF MID$(Out2, Token.Index, 1) = "(" THEN
	     IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
		CALL Read.Data.Element(More.Data)
		IF More.Data THEN
		   ERROR 66
		END IF
		IF Last.Token = False THEN
		   FOR Element = 1 TO LEN(Out3)
		      Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
		      IF Element = 128 THEN
			 EXIT FOR
		      END IF
		   NEXT
		END IF
	     ELSE
		CALL Get.Token
		CALL Parse1(Temp4#)
		Element = CINT(Temp4#)
		CALL Read.Data.Element(More.Data)
		IF More.Data THEN
		   ERROR 66
		END IF
		IF Last.Token THEN
		   IF Element > False AND Element <= 128 THEN
		      Arrays(Variable, Element) = DataValue
		   END IF
		END IF
	     END IF
	  ELSE
	     CALL Read.Data.Element(More.Data)
	     IF More.Data THEN
		ERROR 66
	     END IF
	     IF Last.Token THEN
		Variables(Variable) = DataValue
	     END IF
	  END IF
       CASE 2
	  IF MID$(Temp1$, 2, 1) = "$" THEN
	     CALL Read.Data.Element(More.Data)
	     IF More.Data THEN
		ERROR 66
	     END IF
	     IF Last.Token = False THEN
		Strngs(Variable) = Out3
	     END IF
	  END IF
       END SELECT
    END IF
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 RETURN

Restore.Data:
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = True THEN
    Line.Number% = CINT(Temp3#)
    IF Line.Number% >= 1 AND Line.Number% <= Last.Line THEN
       Out2 = Program(Line.Number%)
       Out2 = STRIM$(Out2)
       Out2 = UCASE$(Out2)
       IF LEFT$(Out2, 5) = "DATA " THEN
	  DataLine = Line.Number%
	  RETURN
       END IF
    END IF
 END IF
 ERROR 65
 RETURN

Draw.Circle.Step:
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Radius = False
 Radius.Set = False
 Color.Code = False
 Color.Set = False
 Start.Circle = False
 Start.Set = False
 End.Circle = False
 End.Set = False
 Aspect = False
 Aspect.Set = False
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Radius = CINT(Temp3#)
       IF Last.Token THEN
	  Radius.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Color.Code = CINT(Temp3#)
	  IF Last.Token THEN
	     Color.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Start.Circle = CINT(Temp3#)
	     IF Last.Token THEN
		Start.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		End.Circle = CINT(Temp3#)
		IF Last.Token THEN
		   End.Set = True
		END IF
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Aspect = CINT(Temp3#)
		   IF Last.Token THEN
		      Aspect.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF Xcoor1.Set AND Ycoor1.Set AND Radius.Set THEN
	  IF Start.Set AND End.Set THEN
	     IF Color.Set THEN
		IF Aspect.Set THEN
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle, Aspect%
		ELSE
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle
		END IF
	     ELSE
		IF Aspect.Set THEN
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle, Aspect
		ELSE
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle
		END IF
	     END IF
	  ELSE
	     IF Start.Set OR End.Set THEN
		ERROR 39
	     ELSE
		IF Color.Set THEN
		   IF Aspect.Set THEN
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, , , Aspect
		   ELSE
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code
		   END IF
		ELSE
		   IF Aspect.Set THEN
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, , , , Aspect
		   ELSE
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius
		   END IF
		END IF
	     END IF
	  END IF
	  RETURN
       END IF
    END IF
 END IF
 ERROR 39
 RETURN

Draw.Circle:
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Radius = False
 Radius.Set = False
 Color.Code = False
 Color.Set = False
 Start.Circle = False
 Start.Set = False
 End.Circle = False
 End.Set = False
 Aspect = False
 Aspect.Set = False
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Radius = CINT(Temp3#)
       IF Last.Token THEN
	  Radius.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Color.Code = CINT(Temp3#)
	  IF Last.Token THEN
	     Color.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Start.Circle = CINT(Temp3#)
	     IF Last.Token THEN
		Start.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		End.Circle = CINT(Temp3#)
		IF Last.Token THEN
		   End.Set = True
		END IF
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Aspect = CINT(Temp3#)
		   IF Last.Token THEN
		      Aspect.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF Xcoor1.Set AND Ycoor1.Set AND Radius.Set THEN
	  IF Start.Set AND End.Set THEN
	     IF Color.Set THEN
		IF Aspect.Set THEN
		   CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle, Aspect%
		ELSE
		   CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle
		END IF
	     ELSE
		IF Aspect.Set THEN
		   CIRCLE (Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle, Aspect
		ELSE
		   CIRCLE (Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle
		END IF
	     END IF
	  ELSE
	     IF Start.Set OR End.Set THEN
		ERROR 39
	     ELSE
		IF Color.Set THEN
		   IF Aspect.Set THEN
		      CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, , , Aspect
		   ELSE
		      CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code
		   END IF
		ELSE
		   IF Aspect.Set THEN
		      CIRCLE (Xcoor1, Ycoor1), Radius, , , , Aspect
		   ELSE
		      CIRCLE (Xcoor1, Ycoor1), Radius
		   END IF
		END IF
	     END IF
	  END IF
	  RETURN
       END IF
    END IF
 END IF
 ERROR 39
 RETURN

Draw.Line.Step:
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Xcoor2 = False
 Xcoor2.Set = False
 Ycoor2 = False
 Ycoor2.Set = False
 Color.Code = False
 Color.Set = False
 Box.Set = False
 Filled.Set = False
 Style = False
 Style.Set = False
 Step.Set = False
 Out2 = MID$(Out2, 10)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "STEP" THEN
	  Step.Set = True
	  Token.Index = Token.Index + 4
	  DO UNTIL MID$(Out2, Token.Index, 1) = " "
	     IF Token.Index > LEN(Out2) THEN
		EXIT DO
	     END IF
	     Token.Index = Token.Index + 1
	  LOOP
       END IF
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Last.Token THEN
	  Xcoor2.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Last.Token THEN
	     Ycoor2.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Temp1$ = MID$(Out2, Token.Index)
		Temp1$ = STRIM$(Temp1$)
		Temp1$ = UCASE$(Temp1$)
		IF LEFT$(Temp1$, 2) = "BF" OR LEFT$(Temp1$, 2) = "FB" THEN
		   Token.Index = Token.Index + 2
		   Box.Set = True
		   Filled.Set = True
		ELSE
		   IF LEFT$(Temp1$, 1) = "B" THEN
		      Token.Index = Token.Index + 1
		      Box.Set = True
		   ELSE
		      IF LEFT$(Temp1$, 1) = "F" THEN
			 Token.Index = Token.Index + 1
			 Filled.Set = True
		      END IF
		   END IF
		END IF
		IF Box.Set OR Filled.Set THEN
		   DO UNTIL MID$(Out2, Token.Index, 1) = " " OR MID$(Out2, Token.Index, 1) = ","
		      IF Token.Index > LEN(Out2) THEN
			 EXIT DO
		      END IF
		      Token.Index = Token.Index + 1
		   LOOP
		END IF
		CALL Get.Token
		CALL Parse1(Temp3#)
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Style = CINT(Temp3#)
		   IF Last.Token THEN
		      Style.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    IF Xcoor1.Set = False OR Ycoor1.Set = False THEN
       ERROR 28
    END IF
    IF Xcoor2.Set = False OR Ycoor2.Set = False THEN
       ERROR 28
    END IF
    IF Step.Set = False THEN
       IF Box.Set AND Filled.Set THEN
	  IF Color.Set AND Style.Set THEN
	     LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF, Style
	  ELSE
	     IF Color.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF
	     ELSE
		IF Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF, Style
		ELSE
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B, Style
	     ELSE
		IF Color.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B
		ELSE
		   IF Style.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B, Style
		   ELSE
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Filled.Set THEN
		ERROR 28
	     ELSE
		IF Color.Set AND Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, , Style
		ELSE
		   IF Color.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		   ELSE
		      IF Style.Set THEN
			 LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
		      ELSE
			 LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       IF Box.Set AND Filled.Set THEN
	  IF Color.Set AND Style.Set THEN
	     LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	  ELSE
	     IF Color.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF
	     ELSE
		IF Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF, Style
		ELSE
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B, Style
	     ELSE
		IF Color.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B
		ELSE
		   IF Style.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B, Style
		   ELSE
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Filled.Set THEN
		ERROR 28
	     ELSE
		IF Color.Set AND Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, , Style
		ELSE
		   IF Color.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code
		   ELSE
		      IF Style.Set THEN
			 LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , , Style
		      ELSE
			 LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2)
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    RETURN
 END IF
 ERROR 28
 RETURN

Draw.Line:
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Xcoor2 = False
 Xcoor2.Set = False
 Ycoor2 = False
 Ycoor2.Set = False
 Color.Code = False
 Color.Set = False
 Box.Set = False
 Filled.Set = False
 Style = False
 Style.Set = False
 Step.Set = False
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "STEP" THEN
	  Step.Set = True
	  Token.Index = Token.Index + 4
	  DO UNTIL MID$(Out2, Token.Index, 1) = " "
	     IF Token.Index > LEN(Out2) THEN
		EXIT DO
	     END IF
	     Token.Index = Token.Index + 1
	  LOOP
       END IF
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Last.Token THEN
	  Xcoor2.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Last.Token THEN
	     Ycoor2.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Temp1$ = MID$(Out2, Token.Index)
		Temp1$ = STRIM$(Temp1$)
		Temp1$ = UCASE$(Temp1$)
		IF LEFT$(Temp1$, 2) = "BF" OR LEFT$(Temp1$, 2) = "FB" THEN
		   Token.Index = Token.Index + 2
		   Box.Set = True
		   Filled.Set = True
		ELSE
		   IF LEFT$(Temp1$, 1) = "B" THEN
		      Token.Index = Token.Index + 1
		      Box.Set = True
		   ELSE
		      IF LEFT$(Temp1$, 1) = "F" THEN
			 Token.Index = Token.Index + 1
			 Filled.Set = True
		      END IF
		   END IF
		END IF
		IF Box.Set OR Filled.Set THEN
		   DO UNTIL MID$(Out2, Token.Index, 1) = " " OR MID$(Out2, Token.Index, 1) = ","
		      IF Token.Index > LEN(Out2) THEN
			 EXIT DO
		      END IF
		      Token.Index = Token.Index + 1
		   LOOP
		END IF
		CALL Get.Token
		CALL Parse1(Temp3#)
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Style = CINT(Temp3#)
		   IF Last.Token THEN
		      Style.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    IF Xcoor2.Set = False OR Ycoor2.Set = False THEN
       ERROR 28
    END IF
    IF Step.Set = False THEN
       IF Xcoor1.Set AND Ycoor1.Set THEN
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE -(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE -(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE -(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE -(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE -(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE -(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE -(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE -(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE -(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE -(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE -(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE -(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       IF Xcoor1.Set AND Ycoor1.Set THEN
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE -STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE -STEP(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE -STEP(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE -STEP(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE -STEP(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE -STEP(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE -STEP(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE -STEP(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE -STEP(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    RETURN
 END IF
 ERROR 28
 RETURN

Draw.Pixel:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 X% = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Y% = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       C% = CINT(Temp3#)
       PSET (X%, Y%), C%
       RETURN
    ELSE
       PSET (X%, Y%)
       RETURN
    END IF
 END IF
 ERROR 15
 RETURN

Draw.PixelX:
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 X% = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Y% = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       C% = CINT(Temp3#)
       PRESET (X%, Y%), C%
       RETURN
    ELSE
       PRESET (X%, Y%)
       RETURN
    END IF
 END IF
 ERROR 15
 RETURN

Draw.Expression:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    DRAW Out3
    RETURN
 END IF
 ERROR 46
 RETURN

Play.Expression:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    PLAY Out3
    RETURN
 END IF
 ERROR 47
 RETURN

Paint.Area:
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Paint.Type = False
 Paint.Style$ = Nul
 Border.Color = False
 Border.Set = False
 BackGround.Style$ = Nul
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       IF Last.Token = False THEN
	  Paint.Type = True
	  Paint.Style$ = Out3
       ELSE
	  Paint.Type = CINT(Temp3#)
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Border.Color = CINT(Temp3#)
	  IF Last.Token THEN
	     Border.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     BackGround.Style$ = Out3
	  END IF
       END IF
    END IF
    IF Xcoor1.Set AND Ycoor1.Set THEN
       IF Paint.Type = True THEN
	  IF Border.Set THEN
	     IF LEN(BackGround.Style$) THEN
		PAINT (Xcoor1, Ycoor1), Paint.Style$, Border.Color, BackGround.Style$
	     ELSE
		PAINT (Xcoor1, Ycoor1), Paint.Style$, Border.Color
	     END IF
	  ELSE
	     IF LEN(BackGround.Style$) THEN
		PAINT (Xcoor1, Ycoor1), Paint.Style$, , BackGround.Style$
	     ELSE
		PAINT (Xcoor1, Ycoor1), Paint.Style$
	     END IF
	  END IF
       ELSE
	  IF Paint.Type > False THEN
	     IF Border.Set THEN
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
		   RETURN
		ELSE
		   PAINT (Xcoor1, Ycoor1), Paint.Type, Border.Color
		END IF
	     ELSE
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
		   RETURN
		ELSE
		   PAINT (Xcoor1, Ycoor1), Paint.Type
		END IF
	     END IF
	  ELSE
	     IF Border.Set THEN
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
		   RETURN
		ELSE
		   PAINT (Xcoor1, Ycoor1), , Border.Color
		END IF
	     ELSE
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
		   RETURN
		ELSE
		   PAINT (Xcoor1, Ycoor1)
		END IF
	     END IF
	  END IF
       END IF
       RETURN
    END IF
 END IF
 ERROR 48
 RETURN

Get.Graphics:
 SELECT CASE Screen.Mode
 CASE 1
    Plane.Bits = 2
    Planes = 1
 CASE 2, 11
    Plane.Bits = 1
    Planes = 1
 CASE 7, 8, 9, 12
    Plane.Bits = 1
    Planes = 4
 CASE 10
    Plane.Bits = 1
    Planes = 2
 CASE 13
    Plane.Bits = 8
    Planes = 1
 CASE ELSE
    ERROR 49
 END SELECT
 Xcoor1 = False
 Ycoor1 = False
 Xcoor2 = False
 Ycoor2 = False
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  Array.Size = 4 + INT(((Xcoor2 - Xcoor1 + 1) * (Plane.Bits) + 7) / 8) * Planes * ((Ycoor2 - Ycoor1) + 1)
	  Elements = INT((Array.Size + 1) / 2)
	  REDIM Graphics.Screen(1 TO Elements) AS INTEGER
	  GET (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Graphics.Screen
	  RETURN
       END IF
    END IF
 END IF
 ERROR 49
 RETURN

Put.Graphics:
 Xcoor1 = False
 Ycoor1 = False
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "PSET" THEN
	  PUT (Xcoor1, Ycoor1), Graphics.Screen, PSET
	  RETURN
       ELSE
	  IF LEFT$(Temp1$, 6) = "PRESET" THEN
	     PUT (Xcoor1, Ycoor1), Graphics.Screen, PRESET
	     RETURN
	  ELSE
	     IF LEFT$(Temp1$, 3) = "AND" THEN
		PUT (Xcoor1, Ycoor1), Graphics.Screen, AND
		RETURN
	     ELSE
		IF LEFT$(Temp1$, 2) = "OR" THEN
		   PUT (Xcoor1, Ycoor1), Graphics.Screen, OR
		   RETURN
		ELSE
		   IF LEFT$(Temp1$, 3) = "XOR" THEN
		      PUT (Xcoor1, Ycoor1), Graphics.Screen, XOR
		      RETURN
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       PUT (Xcoor1, Ycoor1), Graphics.Screen
       RETURN
    END IF
 END IF
 ERROR 49
 RETURN

BSave.Image:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Filename$ = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Filename$ = Out3 + ".sc2"
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Offset = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Length = CINT(Temp3#)
	  BSAVE Filename$, Offset, Length
	  RETURN
       END IF
    END IF
 END IF
 ERROR 60
 RETURN

BLoad.Image:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Filename$ = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Filename$ = Out3 + ".sc2"
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Offset = CINT(Temp3#)
       BLOAD Filename$, Offset
    ELSE
       BLOAD Filename$
    END IF
    RETURN
 END IF
 ERROR 60
 RETURN

CLS.Screen:
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    CLS.Type = INT(VAL(Out2))
    SELECT CASE CLS.Type
    CASE 0
       CLS 0
    CASE 1
       CLS 1
    CASE 2
       CLS 2
    END SELECT
 END IF
 CLS
 RETURN

View.Screen1:
 View.Type = True
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 GOTO View.Screen
View.Screen2:
 View.Type = False
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
View.Screen:
 Xcoor1 = False
 Xcoor2 = False
 Ycoor1 = False
 Ycoor2 = False
 Color.Code = False
 Color.Set = False
 Border.Color = False
 Border.Set = False
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		Border.Color = CINT(Temp3#)
		IF Last.Token THEN
		   Border.Set = True
		END IF
	     END IF
	  END IF
	  IF View.Type THEN
	     IF Color.Set AND Border.Set THEN
		VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
	     ELSE
		IF Color.Set THEN
		   VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
		ELSE
		   IF Border.Set THEN
		      VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , Border.Color
		   ELSE
		      VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Color.Set AND Border.Set THEN
		VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
	     ELSE
		IF Color.Set THEN
		   VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		ELSE
		   IF Border.Set THEN
		      VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , Border.Color
		   ELSE
		      VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		   END IF
		END IF
	     END IF
	  END IF
	  RETURN
       END IF
    END IF
 END IF
 ERROR 77
 RETURN

Window.Screen1:
 Window.Type = True
 Out2 = MID$(Out2, 14)
 Out2 = STRIM$(Out2)
 GOTO Window.Screen
Window.Screen2:
 Window.Type = False
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
Window.Screen:
 Xcoor1 = False
 Xcoor2 = False
 Ycoor1 = False
 Ycoor2 = False
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Window.Type THEN
	     WINDOW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
	  ELSE
	     WINDOW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
	  END IF
	  RETURN
       END IF
    END IF
 END IF
 ERROR 78
 RETURN
END SUB
