REM Sicsub2.bas v5.1a - Symbolic Instruction Code; module 3 of 3.
REM The public domain DOS programming interpreter.

' get standard include declarations
REM $INCLUDE: 'SIC.INC'

' routine accepts an operation and performs on two values, string or numeric
SUB Arith (Token.Parsed$, Temp#, Temp2#)
 IF Last.Token THEN
    SELECT CASE Token.Parsed$
    CASE "-"
       Temp# = Temp# - Temp2#
    CASE "+"
       Temp# = Temp# + Temp2#
    CASE "/"
       Temp# = Temp# / Temp2#
    CASE "\"
       Temp# = Temp# \ Temp2#
    CASE "*"
       Temp# = Temp# * Temp2#
    CASE "^"
       Temp# = Temp# ^ Temp2#
    CASE "<"
       Temp# = (Temp# < Temp2#)
    CASE ">"
       Temp# = (Temp# > Temp2#)
    CASE "="
       Temp# = (Temp# = Temp2#)
    CASE "<="
       Temp# = (Temp# <= Temp2#)
    CASE ">="
       Temp# = (Temp# >= Temp2#)
    CASE "<>"
       Temp# = (Temp# <> Temp2#)
    CASE "=="
       CaseValue1 = Temp#
       CaseValue2 = Temp2#
       Last.Token = 2
    CASE "|"
       Temp# = Temp# OR Temp2#
    CASE "&"
       Temp# = Temp# AND Temp2#
    CASE "%"
       Temp# = Temp# MOD Temp2#
    CASE "~"
       Temp# = Temp# XOR Temp2#
    CASE "?"
       Temp# = Temp# IMP Temp2#
    CASE ":"
       Temp# = Temp# EQV Temp2#
    CASE "#"
       Temp# = NOT (Temp# OR Temp2#)
    CASE "@"
       Temp# = NOT (Temp# IMP Temp2#)
    CASE "`"
       Temp# = NOT (Temp# AND Temp2#)
    END SELECT
    EXIT SUB
 END IF
 SELECT CASE Token.Parsed$
 CASE "-"
    IF RIGHT$(Out3, LEN(Out4)) = Out4 THEN
       Out3 = LEFT$(Out3, LEN(Out3) - LEN(Out4))
    END IF
 CASE "+"
    Out3 = Out3 + Out4
 CASE "/", "\"
    IF LEN(Out3) AND LEN(Out4) THEN
       Imbedded = INSTR(Out3, Out4)
       WHILE Imbedded
	  Out3 = LEFT$(Out3, Imbedded - 1) + MID$(Out3, Imbedded + LEN(Out4))
	  Imbedded = INSTR(Out3, Out4)
       WEND
    END IF
 CASE "<"
    Last.Token = True
    Temp# = Out3 < Out4
 CASE ">"
    Last.Token = True
    Temp# = Out3 > Out4
 CASE "="
    Last.Token = True
    Temp# = Out3 = Out4
 CASE "<="
    Last.Token = True
    Temp# = Out3 <= Out4
 CASE ">="
    Last.Token = True
    Temp# = Out3 >= Out4
 CASE "<>"
    Last.Token = True
    Temp# = Out3 <> Out4
 CASE "=="
    CaseValueS1 = Out3
    CaseValueS2 = Out4
    Last.Token = 2
 END SELECT
END SUB

SUB Assignment1 (TempS$, TempS3%)
 IF LEFT$(TempS$, 2) = "--" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) - 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "++" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) + 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "**" THEN
    Assign = True
    Variables(TempS3%) = Variables(TempS3%) ^ 2#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "//" THEN
    Assign = True
    Variables(TempS3%) = SQR(Variables(TempS3%))
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "-=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) - Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "+=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) + Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "/=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) / Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "\=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) \ Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "*=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) * Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) ^ Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^-=" THEN
    Assign = True
    Out2 = MID$(TempS$, 4)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) ^ (-Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "%=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) MOD Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "|=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) OR Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "&=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) AND Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "~=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) XOR Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "?=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) IMP Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = ":=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Variables(TempS3%) EQV Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "#=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = NOT (Variables(TempS3%) OR Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "@=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = NOT (Variables(TempS3%) IMP Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "`=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = NOT (Variables(TempS3%) AND Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 1) = "=" THEN
    Assign = True
    Out2 = MID$(TempS$, 2)
    Out2 = STRIM$(Out2)
    CALL Equate(Temp4#)
    Variables(TempS3%) = Temp4#
    EXIT SUB
 END IF
END SUB

SUB Assignment2 (TempS$, TempS1%, TempS2%)
 IF LEFT$(TempS$, 2) = "--" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "++" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + 1#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "**" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ 2#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "//" THEN
    Assign = True
    Arrays(TempS1%, TempS2%) = SQR(Arrays(TempS1%, TempS2%))
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "-=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) - Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "+=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) + Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "/=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) / Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "\=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) \ Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "*=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) * Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "^-=" THEN
    Assign = True
    Out2 = MID$(TempS$, 4)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) ^ (-Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "%=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) MOD Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "|=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) OR Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "&=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) AND Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "~=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) XOR Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "?=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) IMP Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = ":=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Arrays(TempS1%, TempS2%) EQV Temp4#
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "#=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) OR Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "@=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) IMP Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 2) = "`=" THEN
    Assign = True
    Out2 = MID$(TempS$, 3)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = NOT (Arrays(TempS1%, TempS2%) AND Temp4#)
    EXIT SUB
 END IF
 IF LEFT$(TempS$, 1) = "=" THEN
    Assign = True
    Out2 = MID$(TempS$, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Arrays(TempS1%, TempS2%) = Temp4#
    EXIT SUB
 END IF
END SUB

REM $STATIC
SUB Assignment3 (TempS1$, TempS2$)
 SELECT CASE TempS2$
 CASE "AX"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    AX = Temp4#
    EXIT SUB
 CASE "BX"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    BX = Temp4#
    EXIT SUB
 CASE "CX"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    CX = Temp4#
    EXIT SUB
 CASE "DX"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    DX = Temp4#
    EXIT SUB
 CASE "BP"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    BP = Temp4#
    EXIT SUB
 CASE "SI"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    SI = Temp4#
    EXIT SUB
 CASE "DI"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    DI = Temp4#
    EXIT SUB
 CASE "FL"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    FL = Temp4#
    EXIT SUB
 CASE "DS"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    DS = Temp4#
    EXIT SUB
 CASE "ES"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    ES = Temp4#
    EXIT SUB
 END SELECT
END SUB

SUB Assignment4 (TempS1$, TempS2$)
 SELECT CASE TempS2$
 CASE "ERR"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    ErrorValue = CINT(Temp4#)
    EXIT SUB
 CASE "ERL"
    Assign = True
    Out2 = TempS1$
    CALL Equate(Temp4#)
    ErrorLine = CINT(Temp4#)
    EXIT SUB
  END SELECT
END SUB

SUB Equate (Temp#)
 ' entry to expression parser,
 ' each following parser is higher precedence,
 ' this routine called by higher precedence routines recursively.

 REM precedence of operators:
 REM   !, +, - Not, Unary plus, Unary Minus
 REM   ^       Power
 REM   *, /    Multiplication, Division
 REM   \       Integer division
 REM   %       Modulo
 REM   +, -    Addition, Subtraction
 REM   =, <, >, <>, >=, <=  Relational
 REM   |, &, ~, ?, :   Logical (or, and, xor, imp, eqv)

 Last.Token = False
 Out3 = Nul ' reset string storage
 Out4 = Nul ' reset string concatenate storage
 Temp# = False ' reset result
 Token.Index = 1 ' reset pointer to expression token
 CALL Get.Token ' read next token
 CALL Parse1(Temp#) ' entry to parse the expression
 WHILE LEN(Strng)
    CALL Parse1(X#) ' parse leftover tokens
 WEND
END SUB

 ' returns next token in string form,
 ' increments pointer to next token,
 ' determines token type.
SUB Get.Token
 Strng = Nul ' reset token
 Token = False ' reset token type
 ' locate space
 FOR Blanks = 1 TO LEN(White.Space)
    WHILE MID$(Out2, Token.Index, 1) = MID$(White.Space, Blanks, 1)
       Token.Index = Token.Index + 1
    WEND
 NEXT
 ' locate symbols
 CALL Get.Token2(Token.Exists)
 IF Token.Exists THEN
    EXIT SUB
 END IF
 ' locate expression symbol
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF LEN(Token.Element$) THEN
    IF INSTR(Token.List, Token.Element$) THEN
       Token = 1 ' store token type
       Strng = Token.Element$ ' store token
       Token.Index = Token.Index + 1 ' increment pointer
       EXIT SUB
    END IF
 END IF
 ' locate expression is number
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF Token.Element$ >= "0" AND Token.Element$ <= "9" THEN
    ' increment token until token is other than number
    DO
       IF LEN(Token.Element$) = False THEN
          EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
          EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
 END IF
 ' locate expression is number beginning with decimal
 Token.Element$ = MID$(Out2, Token.Index, 1)
 IF Token.Element$ = "." THEN
    ' increment token until token is other than number
    DO
       IF LEN(Token.Element$) = False THEN
          EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
          EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
 END IF
 ' locate expression is alphabetic
 Token.Element$ = UCASE$(MID$(Out2, Token.Index, 1))
 IF Token.Element$ >= "A" AND Token.Element$ <= "Z" THEN
    ' increment token until token is other than alphabetic
    DO
       IF LEN(Token.Element$) = False THEN
          EXIT DO
       END IF
       IF INSTR(Token.List, Token.Element$) THEN
          EXIT DO
       END IF
       Strng = Strng + Token.Element$
       Token.Index = Token.Index + 1
       Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 3 ' store token type
    EXIT SUB
 END IF
 Token.Index = Token.Index + 1
END SUB

SUB Get.Token2 (Token.Exists)
 Token.Exists = False
 Stored.Token$ = Out2
 ' locate space
 FOR Blanks = 1 TO LEN(White.Space)
    WHILE MID$(Stored.Token$, Token.Index + 1, 1) = MID$(White.Space, Blanks, 1)
       Stored.Token$ = LEFT$(Stored.Token$, Token.Index) + MID$(Stored.Token$, Token.Index + 2)
    WEND
 NEXT
 ' locate expression symbols
 Next.Token$ = MID$(Stored.Token$, Token.Index, 2)
 SELECT CASE Next.Token$
 CASE ">=", "=>"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = ">=" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "<=", "=<"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "<=" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "<>", "><"
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "<>" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 CASE "=="
    GOSUB Remove.Spaces
    Token = 1 ' store token type
    Strng = "==" ' store token
    Token.Index = Token.Index + 2 ' increment pointer
    Token.Exists = True
 END SELECT
 EXIT SUB
Remove.Spaces:
 ' locate space
 FOR Blanks = 1 TO LEN(White.Space)
    WHILE MID$(Out2, Token.Index + 1, 1) = MID$(White.Space, Blanks, 1)
       Out2 = LEFT$(Out2, Token.Index) + MID$(Out2, Token.Index + 2)
    WEND
 NEXT
 RETURN
END SUB

SUB Parse.Alphabetic1 (Temp#)
 SELECT CASE UCASE$(Strng) ' test variable symbol
 CASE "A" TO "Z"
    Element = ASC(UCASE$(Strng)) - 64
    Element.Type$ = MID$(Out2, Token.Index, 1)
    IF Element.Type$ = "(" OR Element.Type$ = "[" OR Element.Type$ = "{" THEN
       CALL Get.Token
       CALL Get.Token
       CALL Parse1(Temp#)
       Temp# = Arrays(Element, CINT(Temp#))
       Last.Token = True
    ELSE
       Temp# = Variables(Element) ' get variable value
       Last.Token = True
    END IF
 CASE ELSE
    IF Allow.Alpha THEN
       Out3 = Strng
    ELSE
       ERROR 92
    END IF
 END SELECT
END SUB

SUB Parse.Alphabetic2 (Temp#)
 SELECT CASE UCASE$(Strng)
 ' interrupt functions
 CASE "AX"
    Temp# = CDBL(AX)
    Last.Token = True
 CASE "BX"
    Temp# = CDBL(BX)
    Last.Token = True
 CASE "CX"
    Temp# = CDBL(CX)
    Last.Token = True
 CASE "DX"
    Temp# = CDBL(DX)
    Last.Token = True
 CASE "BP"
    Temp# = CDBL(BP)
    Last.Token = True
 CASE "SI"
    Temp# = CDBL(SI)
    Last.Token = True
 CASE "DI"
    Temp# = CDBL(DI)
    Last.Token = True
 CASE "FL"
    Temp# = CDBL(FL)
    Last.Token = True
 CASE "DS"
    Temp# = CDBL(DS)
    Last.Token = True
 CASE "ES"
    Temp# = CDBL(ES)
    Last.Token = True
 ' functions w/o parameters
 CASE "PI" ' calculate PI
    Temp# = ATN(1#) * 4#
    Last.Token = True
 CASE "EX" ' calculate E
    Temp# = EXP(1#)
    Last.Token = True
 ' special case functions
 CASE "IS"
    CALL Get.Token
    Strng2$ = Strng
    CALL Get.Token
    CALL Parse1(Temp4#)
    Out4 = Out3
    Temp3# = CaseValue
    Out3 = CaseStrng
    Strng = Strng2$
    CALL Arith(Strng, Temp3#, Temp4#)
    ValueIs = Temp3#
    Last.Token = 1
 CASE "OR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# OR Temp#
    Last.Token = True
 CASE ELSE
    IF MID$(Strng, 2, 1) = "$" THEN
       SELECT CASE UCASE$(LEFT$(Strng, 1))
       CASE "A" TO "Z"
	  Element = ASC(UCASE$(LEFT$(Strng, 1))) - 64
	  Out3 = Strngs(Element)
	  Last.Token = False
       END SELECT
    ELSE
       IF Allow.Alpha THEN
	  Out3 = Strng
       ELSE
	  ERROR 92
       END IF
    END IF
 END SELECT
END SUB

SUB Parse.Alphabetic3 (Temp#)
 DIM DTAfile AS DTAtype
 SELECT CASE UCASE$(Strng)
 ' special purpose functions
 CASE "ISNT"
    CALL Get.Token
    Strng2$ = Strng
    CALL Get.Token
    CALL Parse1(Temp4#)
    Out4 = Out3
    Temp3# = CaseValue
    Out3 = CaseStrng
    Strng = Strng2$
    CALL Arith(Strng, Temp3#, Temp4#)
    ValueIs = NOT Temp3#
    Last.Token = 1
 CASE "SCREEN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Xcoor# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SCREEN(Xcoor#, Temp#)
    Last.Token = True
 ' functions w/o parameters
 CASE "FALSE"
    Temp# = Dfalse
    Last.Token = True
 CASE "TRUE"
    Temp# = Dtrue
    Last.Token = True
 CASE "TIMER"
    Temp# = TIMER
    Last.Token = True
 CASE "FREEFILE"
    File.Num% = FREEFILE
    IF File.Num% >= 1 AND File.Num% <= 35 THEN
       Temp# = CDBL(File.Num%)
    ELSE
       Temp# = Dfalse
    END IF
    Last.Token = True
 CASE "RND"
    Temp# = RND
    Last.Token = True
 CASE "POS"
    Temp# = POS(0)
    Last.Token = True
 CASE "CSRLIN"
    Temp# = CSRLIN
    Last.Token = True
 CASE "ERR"
    Temp# = CLNG(ErrorValue)
    Last.Token = True
 CASE "ERL"
    Temp# = CLNG(ErrorLine)
    Last.Token = True
 CASE "ARRAYSIZE"
    Temp# = CDBL(Array.Size)
    Last.Token = True
 ' boolean functions
 CASE "AND"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# AND Temp#
    Last.Token = True
 CASE "MOD"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# MOD Temp#
    Last.Token = True
 CASE "NOR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# OR Temp#)
    Last.Token = True
 CASE "NON"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# IMP Temp#)
    Last.Token = True
 CASE "XAN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT (Number# AND Temp#)
    Last.Token = True
 CASE "XOR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# XOR Temp#
    Last.Token = True
 CASE "IMP"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# IMP Temp#
    Last.Token = True
 CASE "EQV"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = Number# EQV Temp#
    Last.Token = True
 CASE "NOT"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = NOT Temp#
    Last.Token = True
 ' date/time functions
 CASE "CLOCK"
    Temp# = NOW#
    Last.Token = True
 CASE "DATE$"
    Out3 = DATE$
    Last.Token = False
 CASE "TIME$"
    Out3 = TIME$
    Last.Token = False
 ' input functions
 CASE "INKEY$"
    IF Program.Resume <= False THEN
       Out3 = INKEY$
    ELSE
       Out3 = Nul
    END IF
    Last.Token = False
 CASE "INPUT$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Chars% = CINT(Temp#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp#)
       File.Num% = CINT(Temp#)
       Out3 = INPUT$(Chars%, File.Num%)
    ELSE
       LOCATE , , Visible
       IF Program.Resume <= False THEN
          Out3 = INPUT$(Chars%)
       ELSE
          Out3 = Nul
       END IF
    END IF
    Last.Token = False
 ' conversion/calculation functions
 CASE "BIN$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = Nul
    IF Temp# >= False THEN
       Digits = False
       DO
	  IF 2 ^ (Digits + 1) > Temp# THEN
	     EXIT DO
	  END IF
	  Digits = Digits + 1
       LOOP
       FOR Power = Digits TO 0 STEP -1
	  IF Temp# - 2 ^ Power >= False THEN
	     Temp# = Temp# - 2 ^ Power
	     Out3 = Out3 + "1"
	  ELSE
	     Out3 = Out3 + "0"
	  END IF
       NEXT
    END IF
    Last.Token = False
 CASE "CHR$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = CHR$(CINT(Temp#))
    Last.Token = False
 CASE "HEX$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = HEX$(CINT(Temp#))
    Last.Token = False
 CASE "OCT$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = OCT$(CINT(Temp#))
    Last.Token = False
 CASE "STR$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = STR$(CINT(Temp#))
    Last.Token = False
 CASE "LCASE$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LCASE$(Out3)
    Last.Token = False
 CASE "UCASE$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = UCASE$(Out3)
    Last.Token = False
 CASE "LTRIM$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LTRIM$(Out3)
    Last.Token = False
 CASE "RTRIM$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = RTRIM$(Out3)
    Last.Token = False
 CASE "TRIM$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = STRIM$(Out3)
    Last.Token = False
 CASE "STRIP$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = STRIM$(Out3)
    WHILE INSTR(Out3," ")
       Variable=INSTR(Out3," ")
       Out3=LEFT$(Out3,Variable-1)+MID$(Out3,Variable+1)
    WEND
    Last.Token = False
 CASE "SPACE$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = STRING$(Temp#, " ")
    Last.Token = False
 CASE "FORMAT$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    value# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = FORMATD$(value#, Out3)
    Last.Token = False
 CASE "MID$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp4# = Temp#
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp#)
       Length# = Temp#
       Out3 = MID$(Out3, Temp4#, Length#)
    ELSE
       Out3 = MID$(Out3, Temp4#)
    END IF
    Last.Token = False
 CASE "REMID$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp4# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    Length# = Temp#
    Out3 = LEFT$(Out3, Temp4# - 1) + MID$(Out3, Temp4# + Length#)
    Last.Token = False
 CASE "DEMID$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    String1$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    IF LEN(String1$) AND LEN(Out3) THEN
       Imbedded = INSTR(String1$, Out3)
       WHILE Imbedded
	  String1$ = LEFT$(String1$, Imbedded - 1) + MID$(String1$, Imbedded + 1)
	  Imbedded = INSTR(String1$, Out3)
       WEND
    END IF
    Out3 = String1$
    Last.Token = False
 CASE "REPLACE$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    String1$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    String2$ = Out3
    CALL Get.Token
    CALL Parse1(Temp#)
    String3$ = Out3
    IF String1$ = Nul OR String2$ = Nul OR String2$ = String3$ THEN
       Out3 = String1$
       EXIT SUB
    END IF
    Temp1 = 1
    DO
       IF String1$ = Nul THEN
	  EXIT DO
       END IF
       Var1 = INSTR(Temp1, String1$, String2$)
       IF Var1 = False THEN
	  EXIT DO
       END IF
       String1$ = LEFT$(String1$, Var1 - 1) + String3$ + MID$(String1$, Var1 + LEN(String2$))
       Temp1 = Temp1 + LEN(String3$)
    LOOP
    Out3 = String1$
    Last.Token = False
 CASE "LEFT$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = LEFT$(Out3, Temp#)
    Last.Token = False
 CASE "RIGHT$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = RIGHT$(Out3, Temp#)
    Last.Token = False
 CASE "STRING$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number# = Temp#
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Out3 = STRING$(Number#, Temp#)
    ELSE
       Out3 = STRING$(Number#, Out3)
    END IF
    Last.Token = False
 CASE "PROGRAM$"
    Out3 = Program.Name
    Last.Token = False
 CASE "PMAP"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Number% = CINT(Temp#)
    CALL Get.Token
    CALL Parse1(Temp#)
    Map.Type% = CINT(Temp#)
    Temp# = PMAP(Number%, Map.Type%)
    Last.Token = True
 CASE "VARSEG"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Var.Seg2 = Temp#
       Temp# = VARSEG(Var.Seg2)
    ELSE
       Length = LEN(Out3)
       REDIM Var.Seg3(1 TO Length) AS INTEGER
       FOR Count = 1 TO Length
	  Var.Seg3(Count) = ASC(MID$(Out3, Count, 1))
       NEXT
       Temp# = VARSEG(Var.Seg3(1))
    END IF
    Last.Token = True
 CASE "VARPTR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Var.Seg2 = Temp#
       Temp# = VARPTR(Var.Seg2)
    ELSE
       Length = LEN(Out3)
       REDIM Var.Seg3(1 TO Length) AS INTEGER
       FOR Count = 1 TO Length
	  Var.Seg3(Count) = ASC(MID$(Out3, Count, 1))
       NEXT
       Temp# = VARPTR(Var.Seg3(1))
    END IF
    Last.Token = True
 CASE "VARPTR$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Var.Seg1 = Out3
    Out3 = VARPTR$(Var.Seg1)
    Last.Token = False
 CASE "BUFFER"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Case.Value = Temp#
    SELECT CASE Case.Value
    CASE 1
       Temp# = Var.Seg2
       Last.Token = True
    CASE 2
       Out3 = Nul
       Length = UBOUND(Var.Seg3)
       FOR Count = 1 TO Length
	  Out3 = Out3 + CHR$(Var.Seg3(Count))
       NEXT
       Last.Token = False
    CASE 3
       Elements = INT((Array.Size + 1) / 2)
       FOR Count = 1 TO Elements
	  Graphics.Screen(Count) = Var.Seg3(Count)
       NEXT
       Last.Token = True
    END SELECT
 CASE "GRPHSEG"
    Elements = INT((Array.Size + 1) / 2)
    REDIM Var.Seg3(1 TO Elements) AS INTEGER
    FOR Count = 1 TO Elements
       Var.Seg3(Count) = Graphics.Screen(Count)
    NEXT
    Temp# = VARSEG(Var.Seg3(1))
    Last.Token = True
 CASE "GRPHPTR"
    Elements = INT((Array.Size + 1) / 2)
    REDIM Var.Seg3(1 TO Elements) AS INTEGER
    FOR Count = 1 TO Elements
       Var.Seg3(Count) = Graphics.Screen(Count)
    NEXT
    Temp# = VARPTR(Var.Seg3(1))
    Last.Token = True
 CASE "PLAY"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = PLAY(Temp#)
    Last.Token = True
 CASE "ABS"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ABS(Temp#)
    Last.Token = True
 CASE "ASC"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ASC(Out3)
    Last.Token = True
 CASE "ATN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = ATN(Temp#)
    Last.Token = True
 CASE "COS"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = COS(Temp#)
    Last.Token = True
 CASE "COT"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = COS(Temp#) / SIN(Temp#)
    Last.Token = True
 CASE "CSC"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1 / SIN(Temp#)
    Last.Token = True
 CASE "EXP"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = EXP(Temp#)
    Last.Token = True
 CASE "FBN" ' calculate xth fibonachi value
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Fibo.A# = 1
    Fibo.B# = 1
    IF Temp# >= 1 THEN
       FOR Fibo.Number# = 1 TO Temp# - 1
	   Fibo.Temp# = Fibo.B#
	   Fibo.B# = Fibo.A# + Fibo.B#
	   Fibo.A# = Fibo.Temp#
	NEXT
     END IF
     Temp# = Fibo.B#
     Last.Token = True
 CASE "FCT"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Factorial# = 1
    Factorial.Count# = INT(Temp#)
    IF Factorial.Count# >= 1 THEN
       FOR Factorial.Count# = 1 TO Temp#
          Factorial# = Factorial# * Factorial.Count#
       NEXT
    END IF
    Temp# = Factorial#
    Last.Token = True
 CASE "FIX"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = FIX(Temp#)
    Last.Token = True
 CASE "INP"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = INP(CINT(Temp#))
    Last.Token = True
 CASE "INSTR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Temp4# = Temp#
       CALL Get.Token
       CALL Parse1(Temp#)
       Stored.String$ = Out3
       CALL Get.Token
       CALL Parse1(Temp#)
    ELSE
       Temp4# = 1#
       Stored.String$ = Out3
       CALL Get.Token
       CALL Parse1(Temp#)
    END IF
    Temp# = INSTR(Temp4#, Stored.String$, Out3)
    Last.Token = True
 CASE "FRE"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       value# = Temp#
       Temp# = FRE(value#)
    ELSE
       Temp# = FRE(Out3)
    END IF
    Last.Token = True
 CASE "INT"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = INT(Temp#)
    Last.Token = True
 CASE "LEN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LEN(Out3)
    Last.Token = True
 CASE "LOG"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = LOG(Temp#)
    Last.Token = True
 CASE "PRM" ' calculate xth prime
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Prime.Number# = INT(Temp#)
    Prime# = 1
    IF Prime.Number# > False THEN
       Prime.Counter# = False
       DO
	  Prime# = Prime# + 1
	  Prime.Flag = False
	  FOR L# = 2 TO INT(SQR(Prime#))
	     IF Prime# / L# = INT(Prime# / L#) THEN
		Prime.Flag = True
		EXIT FOR
	     END IF
	  NEXT
	  IF Prime.Flag = False THEN
	     Prime.Counter# = Prime.Counter# + 1
	  END IF
	  IF Prime.Counter# = Prime.Number# THEN
	     EXIT DO
	  END IF
       LOOP
    END IF
    Temp# = Prime#
    Last.Token = True
 CASE "SEC"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 1 / COS(Temp#)
    Last.Token = True
 CASE "SGN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SGN(Temp#)
    Last.Token = True
 CASE "SIN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SIN(Temp#)
    Last.Token = True
 CASE "SQR" ' compare token
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = SQR(Temp#)
    Last.Token = True
 CASE "TAN"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = TAN(Temp#)
    Last.Token = True
 CASE "VAL"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = VAL(Out3)
    Last.Token = True
 CASE "PEEK"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = PEEK(Temp#)
    Last.Token = True
 CASE "MKI$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKI$(Temp#)
    Last.Token = False
 CASE "MKS$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKS$(Temp#)
    Last.Token = False
 CASE "MKD$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Out3 = MKD$(Temp#)
    Last.Token = False
 CASE "CVI"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVI(Out3)
    Last.Token = True
 CASE "CVS"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVS(Out3)
    Last.Token = True
 CASE "CVD"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = CVD(Out3)
    Last.Token = True
 CASE "EOF"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = EOF(CINT(Temp3#))
    Last.Token = True
 CASE "LOC"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = LOC(CINT(Temp3#))
    Last.Token = True
 CASE "LOF"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    Temp# = LOF(CINT(Temp3#))
    Last.Token = True
 CASE "EOD" ' end-of-data
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    CALL Read.Data.Element(More.Data)
    IF More.Data = False THEN
       DataNumber = DataNumber - 1
    END IF
    Temp# = CLNG(More.Data)
    Last.Token = True
 CASE "TOD" ' type-of-data
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    CALL Read.Data.Element(More.Data)
    IF More.Data = False THEN
       DataNumber = DataNumber - 1
       IF Last.Token THEN
	  Temp# = 1#
       ELSE
	  Temp# = 2#
       END IF
    ELSE
       Temp# = Dfalse
    END IF
    Last.Token = True
 CASE "DIR$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF LEN(Out3) THEN
       Out3 = DIR$(Out3)
    ELSE
       Out3 = DIR$
    END IF
    Last.Token = False
 CASE "CURDIR$"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF LEN(Out3) THEN
       Out3 = CURDIR$(Out3)
    ELSE
       Out3 = CURDIR$
    END IF
    Last.Token = False
 CASE "DRV"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3))-64)
    END IF
    Last.Token = True
    InregsX.AX = &H3600
    InregsX.DX = Drive.Number%
    CALL InterruptX(&H21, InregsX, OutregsX)
    Temp# = 0#
    IF OutregsX.AX = &HFFFF THEN
       EXIT SUB
    END IF
    IF OutregsX.AX < False THEN
       Sectors# = CDBL(OutregsX.AX + 65536)
    ELSE
       Sectors# = CDBL(OutregsX.AX)
    END IF
    IF OutregsX.BX < False THEN
       Clusters# = CDBL(OutregsX.BX + 65536)
    ELSE
       Clusters# = CDBL(OutregsX.BX)
    END IF
    IF OutregsX.CX < False THEN
       Bytes# = CDBL(OutregsX.CX + 65536)
    ELSE
       Bytes# = CDBL(OutregsX.CX)
    END IF
    Temp# = Sectors# * Clusters# * Bytes#
 CASE "FILESIZE"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 0#
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
          Last.Token = True
          ASCIZ = Out3 + CHR$(0)
          ' restore directory search dta
          InregsX.AX = &H1A00
          InregsX.DS = VARSEG(DTAfile)
          InregsX.DX = VARPTR(DTAfile)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' find first filename
          InregsX.AX = &H4E00
          InregsX.CX = &H27
          InregsX.DS = VARSEG(ASCIZ)
          InregsX.DX = VARPTR(ASCIZ)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' check findfirst error
          IF (OutregsX.Flags AND &H1) = &H0 THEN
             ' store file size
             Temp# = Dfalse
             Temp# = Temp# + ASC(MID$(DTAfile.FileSize, 4, 1))
             Temp# = Temp# * &H100 + ASC(MID$(DTAfile.FileSize, 3, 1))
             Temp# = Temp# * &H100 + ASC(MID$(DTAfile.FileSize, 2, 1))
             Temp# = Temp# * &H100 + ASC(MID$(DTAfile.FileSize, 1, 1))
          END IF
          ' restore basic dta
          InregsX.AX = &H1A00
          InregsX.DS = BASIC.DTA.SEG
          InregsX.DX = BASIC.DTA.OFF
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
 CASE "FILEATTR"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 0#
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
          Last.Token = True
          ASCIZ = Out3 + CHR$(0)
          Out3 = SPACE$(8)
          ' restore directory search dta
          InregsX.AX = &H1A00
          InregsX.DS = VARSEG(DTAfile)
          InregsX.DX = VARPTR(DTAfile)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' find first filename
          InregsX.AX = &H4E00
          InregsX.CX = &H37
          InregsX.DS = VARSEG(ASCIZ)
          InregsX.DX = VARPTR(ASCIZ)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' store file attribute
          Temp# = ASC(DTAfile.FileAttr)
          Attribute = CINT(Temp#)
          ' check findfirst error
          IF (OutregsX.Flags AND &H1) = &H1 THEN
             Out3=Out3+"E"
          END IF
          IF (OutregsX.Flags AND &H1) = &H0 THEN
             IF (Attribute AND 1) = 1 THEN
                MID$(Out3,1,1) = "R"
             END IF
             IF (Attribute AND 2) = 2 THEN
                MID$(Out3,2,1) = "H"
             END IF
             IF (Attribute AND 4) = 4 THEN
                MID$(Out3,3,1) = "S"
             END IF
             IF (Attribute AND 8) = 8 THEN
                MID$(Out3,4,1) = "V"
             END IF
             IF (Attribute AND &H10) = &H10 THEN
                MID$(Out3,5,1) = "D"
             END IF
             IF (Attribute AND &H20) = &H20 THEN
                MID$(Out3,6,1) = "A"
             END IF
             IF (Attribute AND &H40) = &H40 THEN
                MID$(Out3,7,1) = "U"
             END IF
             IF (Attribute AND &H80) = &H80 THEN
                MID$(Out3,8,1) = "N"
             END IF
          END IF
          ' restore basic dta
          InregsX.AX = &H1A00
          InregsX.DS = BASIC.DTA.SEG
          InregsX.DX = BASIC.DTA.OFF
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
 CASE "FILEDATE"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 0#
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
          ASCIZ = Out3 + CHR$(0)
          Out3 = NUL
          ' restore directory search dta
          InregsX.AX = &H1A00
          InregsX.DS = VARSEG(DTAfile)
          InregsX.DX = VARPTR(DTAfile)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' find first filename
          InregsX.AX = &H4E00
          InregsX.CX = &H27
          InregsX.DS = VARSEG(ASCIZ)
          InregsX.DX = VARPTR(ASCIZ)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' check findfirst error
          IF (OutregsX.Flags AND &H1) = &H0 THEN
             ' store file date
             Work! = ASC(MID$(DTAfile.FileDate, 2, 1))
             Work! = Work! * &H100 + ASC(MID$(DTAfile.FileDate, 1, 1))
             Year! = INT(Work! / 512)
             Month! = INT((Work! AND &H1E0) / 32)
             Day! = INT(Work! AND &H1F)
             Year! = Year! + 1980
             Out3 = RIGHT$(STR$(Month! + 100), 2) + "-" + RIGHT$(STR$(Day! + 100), 2) + "-" + MID$(STR$(Year!), 2)
          END IF
          ' restore basic dta
          InregsX.AX = &H1A00
          InregsX.DS = BASIC.DTA.SEG
          InregsX.DX = BASIC.DTA.OFF
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
 CASE "FILETIME"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    Temp# = 0#
    IF Last.Token = False THEN
       IF LEN(Out3) THEN
          ASCIZ = Out3 + CHR$(0)
          Out3 = NUL
          ' restore directory search dta
          InregsX.AX = &H1A00
          InregsX.DS = VARSEG(DTAfile)
          InregsX.DX = VARPTR(DTAfile)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' find first filename
          InregsX.AX = &H4E00
          InregsX.CX = &H27
          InregsX.DS = VARSEG(ASCIZ)
          InregsX.DX = VARPTR(ASCIZ)
          CALL InterruptX(&H21, InregsX, OutregsX)
          ' check findfirst error
          IF (OutregsX.Flags AND &H1) = &H0 THEN
             Work! = ASC(MID$(DTAfile.FileTime, 2, 1))
             Work! = Work! * &H100 + ASC(MID$(DTAfile.FileTime, 1, 1))
             Hour! = INT(Work! / 2048)
             Minute! = INT((Work! AND &H7E0) / 32)
             Seconds! = INT((Work! AND &H1F) / 2)
             Out3 = RIGHT$(STR$(Hour! + 100), 2) + ":" + RIGHT$(STR$(Minute! + 100), 2) + ":" + RIGHT$(STR$(Seconds! + 100), 2)
          END IF
          ' restore basic dta
          InregsX.AX = &H1A00
          InregsX.DS = BASIC.DTA.SEG
          InregsX.DX = BASIC.DTA.OFF
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF
    END IF
 CASE "VLABEL"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3))-64)
    END IF
    Last.Token = False
    ASCIZ = CHR$(Drive.Number% + 64) + ":\*.*" + CHR$(0)
    Out3 = NUL
    ' restore directory search dta
    InregsX.AX = &H1A00
    InregsX.DS = VARSEG(DTAfile)
    InregsX.DX = VARPTR(DTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' find volume label
    InregsX.AX = &H4E00
    InregsX.CX = &H08
    InregsX.DS = VARSEG(ASCIZ)
    InregsX.DX = VARPTR(ASCIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       Out3 = DTAfile.ASCIZfilename
    END IF
    ' restore basic dta
    InregsX.AX = &H1A00
    InregsX.DS = BASIC.DTA.SEG
    InregsX.DX = BASIC.DTA.OFF
    CALL InterruptX(&H21, InregsX, OutregsX)
 CASE "VSERIAL"
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp#)
    IF Last.Token THEN
       Drive.Number% = CINT(Temp#)
    ELSE
       Drive.Number% = CINT(ASC(UCASE$(Out3))-64)
    END IF
    Last.Token = False
    Out3 = NUL
    ' get volume info
    InregsX.AX = &H6900
    InregsX.BX = Drive.Number%
    InregsX.DS = VARSEG(BPBfile)
    InregsX.DX = VARPTR(BPBfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    ' check flag error
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       ' store volume serial number
       FOR Serial.Digit = 4 TO 1 STEP -1
          IF Serial.Digit = 2 THEN
             Out3 = Out3 + "-"
          END IF
          F = ASC(MID$(BPBfile.Serial, Serial.Digit, 1))
          Out3 = Out3 + RIGHT$(HEX$(F + &H100), 2)
       NEXT
    END IF
 CASE ELSE
    IF Allow.Alpha THEN
       Out3 = Strng
    ELSE
       ERROR 92
    END IF
 END SELECT
END SUB

SUB Parse.Numeric (Temp#)
 SELECT CASE RIGHT$(UCASE$(Strng), 1) ' compare character after number
 CASE "H" ' hexidecimal suffix
    Temp# = VAL("&H" + LEFT$(Strng, LEN(Strng) - 1))
 CASE "O" ' octal suffix
    Temp# = VAL("&O" + LEFT$(Strng, LEN(Strng) - 1))
 CASE "B" ' binary suffix
    Temp# = False
    Binary.Power = False
    FOR Binary.Digit = LEN(Strng) - 1 TO 1 STEP -1
       IF MID$(Strng, Binary.Digit, 1) = "1" THEN
	  Temp# = Temp# + 2 ^ Binary.Power
       END IF
       Binary.Power = Binary.Power + 1
    NEXT
 CASE ELSE
    Temp# = VAL(Strng)
 END SELECT
 CALL Get.Token
 Last.Token = True
END SUB

SUB Parse.Quoted
 Out3 = Nul
 DO UNTIL MID$(Out2, Token.Index, 1) = CHR$(34)
    Out3 = Out3 + MID$(Out2, Token.Index, 1)
    Token.Index = Token.Index + 1
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 CALL Get.Token
 CALL Get.Token
 Last.Token = False
END SUB

 ' logical parser
SUB Parse1 (Temp#)
 CALL Parse2(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "'" ' remark at eol
       Out2 = Nul
    CASE "|", "&", "~", "?", ":", "#", "@", "`"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse2(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' relational parser
SUB Parse2 (Temp#)
 CALL Parse3(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "<", ">", "=", ">=", "<=", "=>", "=<", "<>", "><", "=="
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current string
    CALL Get.Token ' read next token
    CALL Parse3(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' addition/subtraction parser
SUB Parse3 (Temp#)
 CALL Parse4(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "+", "-"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse4(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' modulo parser
SUB Parse4 (Temp#)
 CALL Parse5(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "%"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse5(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' integer division parser
SUB Parse5 (Temp#)
 CALL Parse6(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "\"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse6(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' multiplication/division parser
SUB Parse6 (Temp#)
 CALL Parse7(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "*", "/"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse7(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' power parser
SUB Parse7 (Temp#)
 CALL Parse8(Temp#) ' get next operator precedence
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "^"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    Token.Stored$ = Out3
    CALL Get.Token ' read next token
    CALL Parse8(Temp2#) ' get next operator
    Out4 = Out3
    Out3 = Token.Stored$
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
 LOOP
END SUB

 ' not/unary plus/unary negative parser
SUB Parse8 (Temp#)
 Token.Negate$ = Nul ' reset token storage
 Token.Parsed$ = Strng ' store token
 ' process token
 DO
    SELECT CASE Token.Parsed$
    CASE "!", "-", "+"
       ' Nul
    CASE ELSE
       EXIT DO
    END SELECT
    CALL Get.Token ' read next token
    Token.Negate$ = Token.Negate$ + Token.Parsed$
    Token.Parsed$ = Strng ' store token
 LOOP
 CALL Parse9(Temp#) ' get next operator
 ' process the combined operators in reverse
 FOR Token.Type = LEN(Token.Negate$) TO 1 STEP -1
    SELECT CASE MID$(Token.Negate$, Token.Type, 1) ' get previous token
    CASE "+"
       ' nul calculation for unary plus
    CASE "-"
       Temp# = -Temp# ' perform negate
    CASE "!" ' not
       Temp# = NOT Temp# ' perform not calculation
    END SELECT
 NEXT
END SUB

 ' string/numeric expression parser,
 ' routine returns calculated expression string/value,
 ' calls Parse1 recursively for values inside parenthesis/functions.
SUB Parse9 (Temp#)
 SELECT CASE Token ' determine token type
 CASE 1 ' token is symbol
    SELECT CASE Strng ' determine token
    CASE ",", ";" ' separaters
       ' nul action
    CASE CHR$(34) ' parse string in quotes
       CALL Parse.Quoted
       Quotes = True
    CASE "(" ' calculate opening parenthesis
       CALL Get.Token ' read next token value inside parenthesis
       IF Strng <> ")" THEN
	  DO ' calculate value
	     CALL Parse1(Temp#) ' call parse entry
	  LOOP UNTIL Strng = ")" OR Token = False ' check closing parenthesis
       END IF
       CALL Get.Token ' read next token after parenthesis
    CASE "["
       CALL Get.Token
       IF Strng <> "]" THEN
	  DO
	     CALL Parse1(Temp#)
	  LOOP UNTIL Strng = "]" OR Token = False
       END IF
       CALL Get.Token
    CASE "{"
       CALL Get.Token
       IF Strng <> "}" THEN
	  DO
	     CALL Parse1(Temp#)
	  LOOP UNTIL Strng = "}" OR Token = False
       END IF
       CALL Get.Token
    CASE ")", "]", "}" ' check token is closing parenthesis
       CALL Get.Token ' read next token after parenthesis
    END SELECT
 CASE 2 ' token is numeric value
    CALL Parse.Numeric(Temp#)
 CASE 3 ' token type is alphabetic
    SELECT CASE LEN(Strng) ' check variable type
    CASE 1
       CALL Parse.Alphabetic1(Temp#)
    CASE 2
       SELECT CASE UCASE$(Strng)
       CASE "AS"
	  CALL Get.Token
	  EXIT SUB
       CASE "TO"
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  FinishFor = Temp4#
	  EXIT SUB
       END SELECT
       CALL Parse.Alphabetic2(Temp#)
    CASE ELSE
       SELECT CASE UCASE$(Strng)
       CASE "SPC"
	  IF Printing = False THEN
	     ERROR 92
	  END IF
	  CALL Get.Token
	  CALL Get.Token
	  CALL Parse1(Temp#)
	  SELECT CASE Printer.LF
	  CASE -1
	     LPRINT SPACE$(Temp#);
	  CASE 1
	     PRINT SPC(Temp#);
	  END SELECT
	  CALL Get.Token
	  IF Printer.LF THEN
	     CALL Get.Token
	     CALL Parse1(Temp#)
	  END IF
	  EXIT SUB
       CASE "TAB"
	  IF Printing = False THEN
	     ERROR 92
	  END IF
	  CALL Get.Token
	  CALL Get.Token
	  CALL Parse1(Temp#)
	  SELECT CASE Printer.LF
	  CASE -1
	     LPRINT SPACE$(Temp#);
	  CASE 1
	     PRINT TAB(Temp#);
	  END SELECT
	  CALL Get.Token
	  IF Printer.LF THEN
	     CALL Get.Token
	     CALL Parse1(Temp#)
	  END IF
	  EXIT SUB
       CASE "GOTO"
	  Branch.Type = 1
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  IF Branch.Index > False THEN
	     FOR Index.Count = 1 TO Branch.Index - 1
		IF Strng <> "," THEN
		   Temp4# = Dfalse
		   EXIT FOR
		END IF
		CALL Get.Token
		CALL Parse1(Temp4#)
	     NEXT
	     Branch.Number = CINT(Temp4#)
	  END IF
	  EXIT SUB
       CASE "GOSUB"
	  Branch.Type = 2
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  IF Branch.Index > False THEN
	     FOR Index.Count = 1 TO Branch.Index - 1
		IF Strng <> "," THEN
		   Temp4# = Dfalse
		   EXIT FOR
		END IF
		CALL Get.Token
		CALL Parse1(Temp4#)
	     NEXT
	     Branch.Number = CINT(Temp4#)
	  END IF
	  EXIT SUB
       CASE "THEN"
	  CALL Get.Token
	  EXIT SUB
       CASE "STEP"
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  StepTo = Temp4#
	  EXIT SUB
       CASE "EXCEPT"
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  ExceptStep = Temp4#
	  EXIT SUB
       CASE "UNLESS"
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Unless.Branch = True
	  Unless.Value = Temp4#
	  EXIT SUB
       END SELECT
       CALL Parse.Alphabetic3(Temp#)
    END SELECT
    CALL Get.Token
 END SELECT
END SUB

SUB Read.Data.Element (More.Data)
 More.Data = False
 Stored.Out2$ = Out2
 Stored.Token.Index = Token.Index
 DO
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = UCASE$(Out2)
    IF LEFT$(Out2, 5) <> "DATA " THEN
       GOSUB Read.Next.Data
       DataNumber = False
    END IF
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 5)
    Out2 = STRIM$(Out2)
    Data.Count = False
    Token.Index = 1
    DO
       Last.Token = False
       CALL Get.Token
       CALL Parse1(DataValue)
       IF Data.Count = DataNumber THEN
	  DataNumber = DataNumber + 1
	  Out2 = Stored.Out2$
	  Token.Index = Stored.Token.Index
	  EXIT SUB
       END IF
       IF Token.Index > LEN(Out2) THEN
	  EXIT DO
       END IF
       Data.Count = Data.Count + 1
    LOOP
    DataLine = DataLine + 1
    DataNumber = False
 LOOP
 EXIT SUB

Read.Next.Data:
 DO
    IF DataLine >= Last.Line THEN
       EXIT DO
    END IF
    DataLine = DataLine + 1
    Out2 = Program(DataLine)
    Out2 = STRIM$(Out2)
    Out2 = UCASE$(Out2)
    IF LEFT$(Out2, 5) = "DATA " THEN
       RETURN
    END IF
 LOOP
 More.Data = True
END SUB
