/*
   This provides functions for polling the mouse.  The main routine,
   mouse, has this description.

   To do various functions (input) [output] set 'a' to
    0 - test if loaded [reg.ax = $ffff]
    1 - show cursor
    2 - hide cursor
    3 - get position [b buttons, c x, d y]
    4 - set position (c x,d y)
    5 - press button   (b buttons, c x, d y) [b count]
    6 - release button (b buttons, c x, d y) [b count]
    7 - set x range  (c min, d max)
    8 - set y range  (c min, d max)
    10- text cursor  (b 0=soft 1=hard, c ?, d ?)
    15- mickeys      (c xscale, d yscale?)
*/

#define MOUSEINT 0x33
#include <dos.h>

int mouse(int a,int *b,int *c,int *d)
{
  static union REGS regs;
  regs.x.ax = a;
  regs.x.bx = *b;
  regs.x.cx = *c;
  regs.x.dx = *d;
  int86(MOUSEINT,&regs,&regs);
  *b = regs.x.bx;
  *c = regs.x.cx;
  *d = regs.x.dx;
  return regs.x.ax;
}

int init_mouse() {
  int x=0; return mouse(0,&x,&x,&x);
}

int show_mouse() {
  int b=0; return mouse(1,&b,&b,&b);
}

int hide_mouse() {
  int b=0; return mouse(2,&b,&b,&b);
}

int get_mouse(int *x,int *y) {
  int b=0; mouse(3,&b,x,y); return b;
}

int set_mouse(int x,int y) {
  int b=0; return mouse(4,&b,&x,&y);
}
