;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; a20.asm
;
; Function: Turn a20 line on or off
;    Requires A20 be controlled by keyboard controller
;    Handles: communication with keyboard controller
;
	;MASM MODE
	.386p


	PUBLIC	a20on,a20off
include  segs.asi 
include  a20.asi 
include  iodelay.asi 

seg386data	SEGMENT	
oldstate db 0			; Original state of a20 line and other outputs
seg386data	ENDS	

seg386	SEGMENT	
;
; Enable the a20 line
;
a20on	PROC	
	pushfd			; We're going to restore IF
	cli			; Clear ints
	mov	bl,KBReadOutputPort; Command to read the keyboard I/O port
	call	keyboard_command; Send command
	call	keyboard_read	; Read kb
	mov	[oldstate],al	; Save state
	push	eax		; Save state on stack
	mov	bl,KBWriteOutputPort		; Command to write the keyboard I/O port
	call	keyboard_command; Send command
	pop	eax		; Set A/20 line enable
	or	al,A20ENABLE	;
	call	keyboard_write	; Write new A20 line
	popfd			; Restore IF
	ret

a20on	ENDP	
;
; Reset the a20 line the way it was
;
a20off	PROC	
	pushfd			; We're going to restore IF
	cli			; Interrupts off
	mov	bl,KBWriteOutputPort		; Command to write keyboard I/O port
	call	keyboard_command; Send command
	mov	al,[oldstate]	; Get original state of port
	call	keyboard_write	; Write it
	popfd                   ; Restore IF
	ret
a20off	ENDP	
;
; Read from keyboard
;
keyboard_read	PROC	
	push	ecx		; We're going to wait a while then fail
	mov	ecx,40000h	; if kb never becomes ready
krl:
	in	al,KBCommandPort		; Get KB status port
	IODELAY
	test	al,KBOutputBufferReady; See if output buffer has any data
	jnz	krr		; Yes, go get it
	loop	krl		; Else wait some more
	mov	ah,1		; Failure
	pop	ecx
	ret
krr:
	mov	ecx,32		; We have to wait in case of slow controller
krd:
	IODELAY
	loop	krd
	in	al,KBDataPort		; Get the input data
	xor	ah,ah		; Succeeded
	pop	ecx
	ret
keyboard_read	ENDP	
;
; Write to keyboard
;
keyboard_write	PROC	
	push	ecx
	mov	ah,al		; AH = value to write
	mov	ecx,40000h	; Wait a while then fail if KB never becomes
				; ready
kwl:
	in	al,KBCommandPort		; See if input buffer still full
	IODELAY
	test	al,KBInputBufferReady; Bit for input buffer full
	jz	kwr		; Not full, continue
	loop	kwl		; Else wait some more
	mov	ah,1		; Failure
	pop	ecx
	ret
kwr:
	mov	al,ah		; Write data to keyboard buffer
	out	KBDataPort,al		;
	xor	ah,ah		; Succeeded
	pop	ecx
	ret
keyboard_write	ENDP	
;
; Send a command to keyboard controller
;
keyboard_command	PROC	
	push	ecx
	mov	ecx,40000h	; Wait a while then fail if controller
				; doesn't respond
cw:
	in	al,KBCommandPort		; Get KB status
	IODELAY
	test	al,KBInputBufferReady	; See if input buffer full
	jz	cs1		; No, go send data
	loop	cw		; Else wait some more
	mov	ah,1		; Failure
	pop	ecx
	ret
cs1:
	mov	al,bl		; Command is in BL
	out	KBCommandPort,al		; Output it
	IODELAY
	mov	ecx,40000h	; Wait a while for command to be accepted
cw2:
	in	al,KBCommandPort		; KB status
	IODELAY
	test	al,KBInputBufferReady	; Get out if input buffer empty
	jz	cs2		;
	loop	cw2		; Else wait a while
	mov	ah,1		; Failure
	pop	ecx
	ret
cs2:
	xor	ah,ah		; Success
	pop	ecx
	ret
keyboard_command	ENDP	


seg386	ENDS	
	END
