;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include lib.asi

	PUBLIC	_OSVGATextMode, _OSVGAGraphicsMode, _OSVGAClearScreen
	PUBLIC	_OSVGATextChar, _OSVGAWideTextChar, _OSVGATallTextChar
	PUBLIC	_OSVGAHorizBar, _OSVGAVertBar, _OSVGAFillCorner
_TEXT	SEGMENT	
;
;* void OSVGATextMode(void);
;
_OSVGATextMode	PROC	
	OS	GR_TEXTMODE
	ret
_OSVGATextMode	ENDP	
;
;* void OSVGAGraphicsMode(void);
;
_OSVGAGraphicsMode	PROC	
	OS	GR_GRAPHMODE
	ret
_OSVGAGraphicsMode	ENDP	
;
;* void OSVGAClearScreen(void);
;
_OSVGAClearScreen	PROC	
	OS	GR_CLEARSCREEN
	ret
_OSVGAClearScreen	ENDP	
GetTextParms	PROC	
	ARG	POS : DWORD, CHAR : DWORD, FG : DWORD, BG: DWORD, FONT : DWORD
	push	ds
	pop	gs
	mov	esi,[FONT]
	mov	edi,[POS]
	or	esi,esi
	jnz	short usethis
	mov	esi,[CHAR]
	shl	esi,4
	OS	GR_SYSFONTBASE
	add	esi,eax
usethis:
	mov	bh,[BYTE PTR FG]
	mov	bl,[BYTE PTR BG]
	ret
GetTextParms	ENDP	
;
;* void OSVGATextChar(int pos, int achar, int fg, int bg, unsigned char *font);
;
_OSVGATextChar	PROC	
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_TEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
_OSVGATextChar	ENDP	
;
;* void OSVGAWideTextChar(int pos, int achar, int fg, int bg, unsigned char *font);
;
_OSVGAWideTextChar	PROC	
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_WIDETEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
_OSVGAWideTextChar	ENDP	
;
;* void OSVGATallTextChar(int pos, int achar, int fg,int bg, unsigned char *font);
;
_OSVGATallTextChar	PROC	
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_TALLTEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
_OSVGATallTextChar	ENDP	
;
;* void OSVGAHorizBar(int pos, int fg, int len);
;
_OSVGAHorizBar	PROC	
	ARG	POS : DWORD, FG : DWORD, LEN : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	ecx,[LEN]
	mov	bl,[BYTE PTR FG]
	mov	edi,[POS]
	OS	GR_HORIZBAR
	pop	ebx
	pop	edi
	LEAVE
	ret
_OSVGAHorizBar	ENDP	
;
;* void OSVGAVertBar(int pos, int fg, int width, int len);
;
_OSVGAVertBar	PROC	
	ARG	POS : DWORD, FG : DWORD, VWIDTH : DWORD, LEN : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	edi,[POS]
	mov	bl,[BYTE PTR FG]
	mov	bh,[BYTE PTR VWIDTH]
	mov	ecx,[LEN]
	OS	GR_VERTBAR
	pop	ebx
	pop	edi
	LEAVE
	ret
_OSVGAVertBar	ENDP	
;
;* void OSVGAFillCorner(int pos, int fg, int offset);
;
_OSVGAFillCorner	PROC	
	ARG	pos : DWORD, FG : DWORD, VOFFSET : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	edi,[POS]
	mov	bl,[BYTE PTR FG]
	mov	dl,[BYTE PTR VOFFSET]
	OS	GR_FILLCORNER
	pop	ebx
	pop	edi
	LEAVE
	ret
_OSVGAFillCorner	ENDP	
_TEXT	ENDS	

END