REM file: Newname.bas - Public Domain DOS Utility
REM Version 1.0a created 05/22/1995
REM Version 1.1a created 10/14/1995

REM Compiling with Microsoft BASIC Professional Development System 7.1:
REM    BC NEWNAME/FS/X/O;
REM    LINK NEWNAME,,,QBX/E;

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'fcb2.bi'

' declare functions
DECLARE FUNCTION ParseLine (S$)

' initialize filename buffer
DIM ASCIZ AS STRING * 260, New.ASCIZ AS STRING * 260

' initialize filename variables
DIM Old.Filename AS STRING * 8, Old.Extension AS STRING * 3
DIM New.Filename AS STRING * 8, New.Extension AS STRING * 3

' initialize structures
DIM DTAfile AS DTAtype, FCBfile AS FCBtype2

' initialize drive variables
COMMON SHARED Drive.Number AS INTEGER, Current.Drive AS INTEGER

' declare program dta
DIM BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER

' initialize directory variables
COMMON SHARED Current.Directory AS STRING * 260

' declare registers
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX
COMMON SHARED Inregs AS RegType, Outregs AS RegType

' declare work variables
COMMON SHARED Continuous.Display AS INTEGER, Display.Errors AS INTEGER
COMMON SHARED Rename.Error AS INTEGER, Rename.Directories AS INTEGER
COMMON SHARED Rename.Volume AS INTEGER, Windows.Detected AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
COMMON SHARED Command.Work AS STRING

' increase stack size
STACK STACK

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, X$)
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    ParseLine = False
 END IF
END FUNCTION 

' store basic dta
InregsX.AX = &H2F00
CALL InterruptX(&H21, InregsX, OutregsX)
BASIC.DTA.SEG = OutregsX.ES
BASIC.DTA.OFF = OutregsX.BX

' get current drive
Inregs.AX = &H1900
CALL Interrupt(&H21, Inregs, Outregs)
Current.Drive = Outregs.AX AND &HFF

' check windows dos
InregsX.AX = &H160A
CALL InterruptX(&H2F, InregsX, OutregsX)
IF OutregsX.AX = False THEN
   Temp = (OutregsX.BX And &HFF00) / 256
   IF Temp >= 4 THEN
      Windows.Detected = True
   END IF
Endif

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' check windows dos
IF Windows.Detected THEN
   ' get current directory
   InregsX.AX = &H7147
   InregsX.DX = Current.Drive + 1
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.SI = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' get current directory
   InregsX.AX = &H4700
   InregsX.DX = Current.Drive + 1
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.SI = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' display any errors
CALL DisplayError ("Error accessing drive.")

' check carry flag error
IF (OutregsX.Flags AND &H1) = &H1 THEN
   GOTO End.Copy
END IF

' store directory
IF LEN(Current.Directory) = False THEN
   Current.Directory = "\"
END IF
IF LEFT$(Current.Directory, 1) <> "\" THEN
   Current.Directory = "\" + Current.Directory
END IF
Current.Directory = Current.Directory + CHR$(0)

' store and parse command line
Command.Line = COMMAND$
IF Command.Line = NUL THEN
   Command.Line = UCASE$(ENVIRON$("NEWNAME"))
END IF

' get switches from command line
Continuous.Display = ParseLine ("/C")
Rename.Directories = ParseLine ("/D")
Rename.Volume = ParseLine ("/V")
Display.Errors = ParseLine ("/Z")

' get new filename from command line
Imbedded1 = INSTR(Command.Line, "/N")
New.Extension = NUL
IF Imbedded1 THEN
   New.ASCIZ = MID$(Command.Line, Imbedded1 + 2)
   Imbedded2 = INSTR(New.ASCIZ, ".")
   IF Imbedded2 THEN
      New.Extension = MID$(New.ASCIZ, Imbedded2 + 1)
      New.ASCIZ = LEFT$(New.ASCIZ, Imbedded2 - 1)
   END IF
   New.Filename = New.ASCIZ
   IF RTRIM$(New.Filename) = "*" THEN
      New.Filename = "????????"
   END IF
   Command.Line = LEFT$(Command.Line, Imbedded1 - 1)
ELSE
   GOTO Boot.Usage
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Usage
END IF

' store command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line.Redirect = Command.Line

' make header
IF Continuous.Display = False THEN
   COLOR White, Black
   PRINT "Newname v1.1a: 8.3 File/directory rename utility; "
END IF

' search through all input filenames
DO
   ' get standard input
   Redirected.Input = False
   Standard.Input$ = NUL
   Inregs.AX = &HB00
   CALL Interrupt(&H21, Inregs, Outregs)
   DO WHILE (Outregs.AX AND &HFF) = &HFF
      Redirected.Input = True
      Inregs.AX = &H800
      CALL Interrupt(&H21, Inregs, Outregs)
      Char$ = CHR$(Outregs.AX AND &HFF)
      SELECT CASE ASC(Char$)
      CASE 10, 26
      CASE 13
	 EXIT DO
      CASE ELSE
	 Standard.Input$ = Standard.Input$ + Char$
      END SELECT
      Inregs.AX = &HB00
      CALL Interrupt(&H21, Inregs, Outregs)
   LOOP

   ' check standard input
   IF Redirected.Input THEN
      IF Standard.Input$ = NUL THEN
	 EXIT DO
      END IF
   END IF

   ' store entire command
   Command.Work = Command.Line.Redirect

   DO
      ' store entire command
      Imbedded = INSTR(Command.Line, " ")
      IF Imbedded THEN
         Command.Work = Standard.Input$ + LEFT$(Command.Line, Imbedded - 1)
         Command.Line = MID$(Command.Line, Imbedded + 1)
      ELSE
         Command.Work = Standard.Input$ + Command.Line
         Command.Line = NUL
      END IF

      ' store current drive
      IF MID$(Command.Work, 2, 1) = ":" THEN
         Drive.Number = ASC(LEFT$(Command.Work, 1)) - 65
         Command.Work = MID$(Command.Work, 3)
      ELSE
	 Drive.Number = Current.Drive
      END IF

      ' check windows dos
      IF Windows.Detected THEN
         ' get current directory
         InregsX.AX = &H7147
         InregsX.DX = Drive.Number + 1
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' get current directory
         InregsX.AX = &H4700
         InregsX.DX = Drive.Number + 1
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.SI = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF

      ' display any errors
      CALL DisplayError ("Error accessing drive.")

      ' check carry flag error
      IF (OutregsX.Flags AND &H1) = &H1 THEN
         GOTO End.Copy
      END IF

      ' store current directory
      Directory.Search$ = "\" + LEFT$(ASCIZ, INSTR(ASCIZ, CHR$(0)) - 1)
      Imbedded1 = INSTR(Command.Work, "\")
      Imbedded2 = Imbedded1
      WHILE Imbedded1
         Imbedded2 = Imbedded1
         Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
      WEND
      IF Imbedded2 THEN
         Directory.Search$ = LEFT$(Command.Work, Imbedded2)
         Command.Work = MID$(Command.Work, Imbedded2 + 1)
      END IF
   
      ' get filename spec
      Filename.Search$ = Command.Work
      IF Filename.Search$ = NUL THEN
	 Filename.Search$ = "????????.???"
      END IF
      Command.Work = NUL

      ' change to drive
      Inregs.AX = &HE00
      Inregs.DX = Drive.Number
      CALL Interrupt(&H21, Inregs, Outregs)
   
      ' make directory filename
      ASCIZ = Directory.Search$ + CHR$(0)

      ' check windows dos
      IF Windows.Detected THEN
         ' change to new directory
         InregsX.AX = &H713B
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.DX = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' change to new directory
         InregsX.AX = &H3B00
         InregsX.DS = VARSEG(ASCIZ)
         InregsX.DX = VARPTR(ASCIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF

      ' display any errors
      CALL DisplayError ("Error changing directory.")

      ' check carry flag error
      IF (OutregsX.Flags AND &H1) = &H1 THEN
         GOTO End.Copy
      END IF

      ' make filename
      Imbedded = INSTR(Filename.Search$, ".")
      Old.Extension = NUL
      IF Imbedded THEN
         Old.Extension = MID$(Filename.Search$, Imbedded + 1)
         Old.Filename = LEFT$(Filename.Search$, Imbedded - 1)
      ELSE
	 Old.Filename = Filename.Search$
      END IF

      ' rename files
      Rename.Error = False

      ' store fcb type
      FCBfile.ExtendedFCB = CHR$(&HFF)

      ' store attribute to change
      IF Rename.Volume THEN
         FCBfile.FileAttribute = CHR$(&H8)
      ELSE
	 IF Rename.Directories THEN
            FCBfile.FileAttribute = CHR$(&H37)
	 ELSE
            FCBfile.FileAttribute = CHR$(&H27)
	 END IF
      END IF

      ' store fcb
      FCBfile.DriveNumber = CHR$(Drive.Number + 1)
      FCBfile.Filename = Old.Filename
      FCBfile.Extension = Old.Extension
      FCBfile.NewFilename = New.Filename
      FCBfile.NewExtension = New.Extension

      ' use fcb to rename file
      OutregsX.Flags = &H0
      InregsX.AX = &H1700
      InregsX.DS = VARSEG(FCBfile)
      InregsX.DX = VARPTR(FCBfile)
      CALL InterruptX(&H21, InregsX, OutregsX)

      ' check fcb error flag
      IF (OutregsX.AX AND &HFF) = &HFF THEN
         IF Continuous.Display = False THEN
            IF Display.Errors = False THEN
               COLOR Red, Black
	       PRINT "Error renaming files."
	    END IF
	 END IF
      ELSE
         ' check display flag
         IF Continuous.Display = False THEN
	    ' display search filename
            COLOR Yellow, Black
            IF Rename.Volume = False THEN
               PRINT UCASE$(Directory.Search$); "\";
            END IF
            PRINT UCASE$(RTRIM$(New.Filename));
            IF RTRIM$(New.Extension) <> "" THEN
               PRINT "."; UCASE$(RTRIM$(New.Extension));
            ENDIF
            PRINT
	 END IF
      END IF

      ' check search filename
      IF Command.Line = NUL THEN
	 EXIT DO
      END IF
   LOOP

   ' check search filename
   IF Standard.Input$ = NUL THEN
      EXIT DO
   END IF
LOOP
End.Copy:
' restore basic dta
InregsX.AX = &H1A00
InregsX.DS = BASIC.DTA.SEG
InregsX.DX = BASIC.DTA.OFF
CALL InterruptX(&H21, InregsX, OutregsX)

' restore current drive
Inregs.AX = &HE00
Inregs.DX = Current.Drive
CALL Interrupt(&H21, Inregs, Outregs)

' check windows dos
IF Windows.Detected THEN
   ' restore current directory
   InregsX.AX = &H173B
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.DX = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' restore current directory
   InregsX.AX = &H3B00
   InregsX.DS = VARSEG(Current.Directory)
   InregsX.DX = VARPTR(Current.Directory)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' display end program
IF Continuous.Display = False THEN
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
 ' make header
 COLOR White, Black
 PRINT "Newname v1.1a: 8.3 File/directory rename utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Newname [d:][path]filename.ext [/cdnvz]"
 PRINT "Where:"
 PRINT "   /c  continuous display"
 PRINT "   /d  rename directory"
 PRINT "   /n  new filename in form filename.ext"
 PRINT "   /v  rename volume label"
 PRINT "   /z  supress error messages"
 COLOR Plain, Black
 END

Boot.Error:
 COLOR White, Black
 PRINT "Command line error. Type Newname /? for help."
 COLOR Plain, Black
 END

' critical error trap
Error.Routine:
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR White, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Copy
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
 ' check carry flag error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check display errors flag
    IF Display.Errors = False THEN
       ' display error
       COLOR Red, Black
       PRINT Temp$
    END IF
 END IF
END SUB
