
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1992 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Diese Unit stellt einige Erweiterungen fr das Programm Demo bereit.

  This unit provides some extensions for the Graphics Vision demo program.
}

Unit DemoType;

Interface

uses Objects, Views, GVViews, GVDialog, GVMenus, GVApp, GVStdDlg, GVColor;

const

{ Version }

  Version = '2.0';

var

{ StatusLine Hints }

 StatusHints: PStringList;

{ Resource variables }

 RezFile: TResourceFile;
 RezStream: PStream;

const

{ menu constants }

  cmOpen = 100; cmChDir = 110; cmInfo = 120; cmColor = 130;

  cmGWindow = 200; cmDialog = 210;

  cmEnableMusic = 310; cmNormalTune = 320; cmIndyTune = 330;
  cmPlay = 340;

  cmGButton = 220; cmButton = 230;

  cmLocalMenu = 300;

{ helpcontexts }

  (* 1 menus *)

    hcFile = 10000;
      hcInfo = 13000; hcColor = 15000;

    hcWindow = 20000;
      hcGWindow = 21000; hcDialog = 22000;

    hcMusic = 30000;
      hcEnableMusic = 31000; hcNormalTune = 32000; hcIndyTune = 33000;
      hcPlay = 34000;

  (* 2 dialogs *)

    hcOk=100; hcCancel=110; hcYes=120; hcNo=130;

    hcFOpenInput=140; hcFOpenList=141; hcFOpenOpBut=142;

    hcFChDirInput=150; hcFChDirList=151; hcFChDirChDirBut=152;
    hcFChDirRevBut=153;

    hcColorGroupList=155; hcColorItemList=156; hcSelector=157;

    hcWDlgRadio=160;
     hcWDlgR1=160;
     hcWDlgR2=161;
     hcWDlgR3=162;
     hcWDlgR4=163;
     hcWDlgR5=164;
     hcWDlgR6=165;
    hcWDlgGButton=170; hcWDlgInput=171; hcWDlgTextButton=172;
    hcWDlgCheck=180;
     hcWDlgC1=180;
     hcWDlgC2=181;
     hcWDlgC3=182;
     hcWDlgC4=183;
     hcWDlgC5=184;
     hcWDlgC6=185;
    hcWDlgRegler=190; hcWDlgList=191; hcWDlgNumInput=192;
    hcWDlgMultiCheck=193;
      hcWDlgMC1=193;
      hcWDlgMC2=194;
      hcWDlgMC3=195;
      hcWDlgMC4=196;

  (* 3 windows *)

    hcTextWindow = 1000;

type

{ TProtectedStream object }

  PProtectedStream = ^TProtectedStream;
  TProtectedStream = object(TBufStream)
                       procedure Error (Code, Info: Integer); virtual;
                     end;

{ TDemoStatusLine object }

  PDemoStatusLine = ^TDemoStatusLine;
  TDemoStatusLine = object (TStatusLine)
                      function Hint (AHelpCtx: Word): String; virtual;
                    end;

{ TMyListBox object }

  PMyListBox = ^TMyListBox;
  TMyListBox = object (TListBox)
                 constructor Init (var Bounds: TRect; AScrollBar: PScrollBar);
                 destructor Done; virtual;
               end;

{ Stream registration records }

const

  RDemoStatusLine: TStreamRec = (
     ObjType: 150;
     VmtLink: Ofs(TypeOf(TDemoStatusLine)^);
     Load:    @TDemoStatusLine.Load;
     Store:   @TDemoStatusLine.Store);

  RMyListBox: TStreamRec = (
     ObjType: 151;
     VmtLink: Ofs(TypeOf(TMyListBox)^);
     Load:    @TMyListBox.Load;
     Store:   @TMyListBox.Store);

{ Stream registration procedure }

  procedure RegisterDemo;

{ procedure for setting helpcontexts }

  procedure SetHelpCtx (P: PGGroup; var Rec);

Implementation

(**************************** TProtectedStream object ***********************)

procedure TProtectedStream.Error;
Begin
  Writeln('Error in stream: Code = ', Code, ' Info = ', Info);
  RunError(255);
End;

(*************************** TDemoStatusLine object ************************)

function TDemoStatusLine.Hint;
Begin
  If AHelpCtx = hcNoContext then Hint:=''
  Else Hint := StatusHints^.Get (AHelpCtx);
End;

(***************************** TMyListBox object ***************************)

constructor TMyListBox.Init;
var I: Integer;
    ListData: TListBoxRec;
Begin
  TListBox.Init (Bounds, AScrollBar);
  ListData.List:=New (PStringCollection, Init (10, 5));
  {$IFDEF english}
  With ListData.List^ do Begin
    AtInsert (Count, NewStr ('The ListBox is for'));
    AtInsert (Count, NewStr ('listing a certain'));
    AtInsert (Count, NewStr ('number of'));
    AtInsert (Count, NewStr ('selectable texts'));
    For I:=1 to 20 do AtInsert (Count, NewStr (' '));
    AtInsert (Count, NewStr ('Only to be used by'));
    AtInsert (Count, NewStr ('Mousepad POWER USERS!'));
    AtInsert (Count, NewStr (' '));
    AtInsert (Count, NewStr ('for Matthews by S.M.'));
  End;
  {$ELSE}
  With ListData.List^ do Begin
    AtInsert (Count, NewStr ('Die ListBox dient'));
    AtInsert (Count, NewStr ('dem Auflisten einer'));
    AtInsert (Count, NewStr ('Anzahl von'));
    AtInsert (Count, NewStr ('selektierbaren Texten'));
    For I:=1 to 20 do AtInsert (Count, NewStr (' '));
    AtInsert (Count, NewStr ('Only to be used by'));
    AtInsert (Count, NewStr ('Mousepad POWER USERS!'));
    AtInsert (Count, NewStr (' '));
    AtInsert (Count, NewStr ('for Matthews by S.M.'));
  End;
  {$ENDIF}
  ListData.Index:=1;
  SetData (ListData);
End;

destructor TMyListBox.Done;
Begin
  NewList (nil);
  TListBox.Done;
End;

(************************ Stream registration procedure ********************)

procedure RegisterDemo;
Begin
  RegisterType (RDemoStatusLine);
  RegisterType (RMyListBox);
  RegisterObjects;
  RegisterGVViews;
  RegisterGVDialog;
  RegisterGVMenus;
  RegisterGVApp;
  RegisterGVStdDlg;
  RegisterGVColor;
End;

procedure SetHelpCtx;
var Count: Byte;

 procedure SetHelpP (P: PGView); far;
 Begin
   If (P^.Options and ofSelectable <>0) and not P^.GetState (sfDisabled) then Begin
     P^.HelpCtx:=Word (Ptr (Seg (Rec),Ofs (Rec)+Count)^);
     Inc (Count,2);
   End;
 End;

Begin
  If P=nil then Exit;
  Count:=0;
  P^.ForEach (@SetHelpP);
End;

End.