#include <stdio.h>
#include <dos.h>
#include "titillat.h"

titillator::titillator()
  {
     union REGS in;
     union REGS out;

     titillation[0]=(unsigned char) '|';
     titillation[1]=(unsigned char) '/';
     titillation[2]=(unsigned char) '-';
     titillation[3]=(unsigned char) '\\';
     in.h.ah=(unsigned char) 8;
     in.h.bh=(unsigned char) '\0';
     int86(0x10,&in,&out);         // get original character and attribute
     original_attribute=out.h.ah;
     original_character=out.h.al;
     in.h.ah=(unsigned char) '\3';
     in.h.bh=(unsigned char) '\0';
     int86(0x10,&in,&out);         // get cursor
     cursor_row=out.h.dh;
     cursor_column=out.h.dl;
     cursor_start=out.h.ch;
     cursor_stop=out.h.cl;
     in.h.ah=(unsigned char) '\1';
     in.h.bh=(unsigned char) '\0';
     in.h.ch=(unsigned char) 32;
     in.h.cl=(unsigned char) 32;
     int86(0x10,&in,&out);        // make cursor disappear
     titillation_index=0;
   }

titillator::~titillator()
   {
      union REGS in;
      union REGS out;

      in.h.ah=(unsigned char) '\2';
      in.h.bh=(unsigned char) '\0';
      in.h.dh=cursor_row;
      in.h.dl=cursor_column;
      int86(0x10,&in,&out);        // set cursor position
      in.h.ah=(unsigned char) 9;
      in.h.al=original_character;
      in.h.bh=(unsigned char) '\0';
      in.h.bl=original_attribute;
      in.x.cx=1;
      int86(0x10,&in,&out);        // restore original character
      in.h.ah=(unsigned char) '\1';
      in.h.bh=(unsigned char) '\0';
      in.h.ch=cursor_start;
      in.h.cl=cursor_stop;
      int86(0x10,&in,&out);        // restore cursor to its original state
   }

void titillator::titillate()
    {
      union REGS in;
      union REGS out;

      in.h.ah=(unsigned char) '\2';
      in.h.bh=(unsigned char) '\0';
      in.h.dh=cursor_row;
      in.h.dl=cursor_column;
      int86(0x10,&in,&out);        // set cursor position
      titillation_index++;
      if (titillation_index > 3)
        titillation_index=0;
      in.h.ah=(unsigned char) 10;
      in.h.al=titillation[titillation_index];
      in.h.bh=(unsigned char) '\0';
      in.h.bl=(unsigned char) 15;
      in.x.cx=1;
      int86(0x10,&in,&out);        // output character
    }
