UNIT MUFASYNC;

{    This unit was converted to Turbo Pascal v5.0 and renamed to
     Mufasync to distinguish it from any new versions from the
     author.  Portions of this code have be placed in the public
     domain, and the rest will be copyright to any of Alan Bishop,
     C. J. Dunford, Michael Quinlan, Gene Harris, or Phillip R.
     Burns, but have been made available for public use in
     non-commercial applications.

     Peter Summers  17/8/91      }


(*----------------------------------------------------------------------*)
(*         MUFASYNC.PAS   --- Asynchronous I/O for Turbo Pascal         *)
(*----------------------------------------------------------------------*)
(*                                                                      *)
(*  Routines:                                                           *)
(*                                                                      *)
(*     BIOS_RS232_Init        ---    Use BIOS to initialize port        *)
(*     Async_Isr              ---    Com port interrupt service routine *)
(*     Async_Init             ---    Performs initialization.           *)
(*     Async_Clear_Errors     ---    Clear pending serial port errors   *)
(*     Async_Reset_Port       ---    Resets UART parameters for port    *)
(*     Async_Open             ---    Sets up COM port                   *)
(*     Async_Close            ---    Closes down COM port               *)
(*     Async_Carrier_Detect   ---    Checks for modem carrier detect    *)
(*     Async_Carrier_Drop     ---    Checks for modem carrier drop      *)
(*     Async_Buffer_Check     ---    Checks if character in COM buffer  *)
(*     Async_Term_Ready       ---    Toggles terminal ready status      *)
(*     Async_Find_Delay       ---    Find busy wait count for 1ms delay *)
(*     Async_Receive          ---    Reads character from COM buffer    *)
(*     Async_Receive_With_Timeout                                       *)
(*                            ---    Receives char. with timeout check  *)
(*     Async_Ring_Detect      ---    If ringing detected                *)
(*     Async_Send             ---    Transmits char over COM port       *)
(*     Async_Send_String      ---    Sends string over COM port         *)
(*     Async_Send_String_With_Delays                                    *)
(*                            ---    Sends string with timed delays     *)
(*     Async_Send_Break       ---    Sends break (attention) signal     *)
(*     Async_Percentage_Used  ---    Returns percentage com buffer used *)
(*     Async_Purge_Buffer     ---    Purges receive buffer              *)
(*     Async_Release_Buffers  ---    Free memory for serial port queues *)
(*     Async_Setup_Port       ---    Define port base, IRQ, RS232 addr  *)
(*     Async_Stuff            ---    Insert char into receive buffer    *)
(*     Async_Flush_Output_Buffer                                        *)
(*                            ---    Flush serial port output buffer    *)
(*     Async_Drain_Output_Buffer                                        *)
(*                            ---    Wait for serial output to drain    *)
(*     Async_Port_Address_Given                                         *)
(*                            ---    Check if port address installed    *)
(*     Async_Send_Now         ---    Send character without buffering   *)
(*     Async_Wait_For_Quiet   ---    Wait for port to quiesce           *)
(*                                                                      *)
(*----------------------------------------------------------------------*)
(*                                                                      *)
(*      MUFASYNC.PAS is split into MUFASYN1, MUFASYN2, and MUFASYN3     *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

INTERFACE

USES
   Dos, Crt, MufGlobs, MufTimer, MufMTask;

PROCEDURE BIOS_RS232_Init( ComPort : INTEGER; ComParm : WORD );
PROCEDURE Async_Close( Drop_DTR: BOOLEAN );
PROCEDURE Async_Clear_Errors;
PROCEDURE Async_Reset_Port( ComPort       : INTEGER;
                            BaudRate      : WORD;
                            Parity        : CHAR;
                            WordSize      : INTEGER;
                            StopBits      : INTEGER  );
FUNCTION  Async_Open( ComPort       : INTEGER;
                      BaudRate      : WORD;
                      Parity        : CHAR;
                      WordSize      : INTEGER;
                      StopBits      : INTEGER  ) : BOOLEAN;
PROCEDURE Async_Send( C : Char );
FUNCTION  Async_Receive( VAR C : Char ) : BOOLEAN;
PROCEDURE Async_Receive_With_Timeout( Secs : INTEGER; VAR C : INTEGER );
PROCEDURE Async_Stuff( Ch: CHAR );
PROCEDURE Async_Find_Delay( VAR One_MS_Delay : INTEGER );
PROCEDURE Async_Init( Async_Buffer_Max  : INTEGER;
                      Async_OBuffer_Max : INTEGER;
                      Async_High_Lev1   : INTEGER;
                      Async_High_Lev2   : INTEGER;
                      Async_Low_Lev     : INTEGER );
FUNCTION  Async_Carrier_Detect : BOOLEAN;
FUNCTION  Async_Carrier_Drop : BOOLEAN;
PROCEDURE Async_Term_Ready( Ready_Status : BOOLEAN );
FUNCTION  Async_Buffer_Check : BOOLEAN;
FUNCTION  Async_Line_Error( VAR Error_Flags: BYTE ) : BOOLEAN;
FUNCTION  Async_Ring_Detect : BOOLEAN;
PROCEDURE Async_Send_Break;
PROCEDURE Async_Send_String( S : AnyStr );
PROCEDURE Async_Send_String_With_Delays( S          : AnyStr;
                                         Char_Delay : INTEGER;
                                         EOS_Delay  : INTEGER  );
FUNCTION  Async_Percentage_Used : REAL;
PROCEDURE Async_Purge_Buffer;
FUNCTION  Async_Peek( Nchars : INTEGER ) : CHAR;
PROCEDURE Async_Setup_Port( ComPort       : INTEGER;
                            Base_Address  : INTEGER;
                            IRQ_Line      : INTEGER;
                            Int_Numb      : INTEGER );
PROCEDURE Async_Release_Buffers;
PROCEDURE Async_Flush_Output_Buffer;
PROCEDURE Async_Drain_Output_Buffer( Max_Wait_Time : INTEGER );
FUNCTION  Async_Port_Address_Given( Com_Port : INTEGER ) : BOOLEAN;
PROCEDURE Async_Send_Now( C : Char );
FUNCTION  Async_Wait_For_Quiet( Max_Wait : LONGINT;
                                Wait_Time: LONGINT  ) : BOOLEAN;

IMPLEMENTATION
                                   (* Ensure multitasking defined       *)
{$DEFINE MTASK}

(*$I MUFASYN1.MOD *)
(*$I MUFASYN2.MOD *)
(*$I MUFASYN3.MOD *)

BEGIN (* MUFAsync *)
                                   (* Default communications parameters *)
   Async_Do_CTS         := FALSE;
   Async_Do_DSR         := FALSE;
   Async_Hard_Wired_On  := FALSE;
   Async_Break_Length   := 40;     { in 1/100ths of a second, changed by P.S.
                                     from 500, 2/9/91. }
   Async_Do_XonXoff     := FALSE;  { Changed by P.S.  21/8/91  Keep this off
                                     or some screen address codes will be
                                     interpreted as flow control. }
   Async_OV_XonXoff     := TRUE;
   Async_Buffer_Length  := 4096;
   Async_OBuffer_Length := 1132;
                                   (* Port addresses of each com port *)

   Default_Com_Base[1]  := COM1_Base;
   Default_Com_Base[2]  := COM2_Base;
   Default_Com_Base[3]  := COM3_Base;
   Default_Com_Base[4]  := COM4_Base;

                                   (* IRQ line for each port *)

   Default_Com_Irq [1]  := COM1_Irq;
   Default_Com_Irq [2]  := COM2_Irq;
   Default_Com_Irq [3]  := COM3_Irq;
   Default_Com_Irq [4]  := COM4_Irq;

                                   (* Pick up address of send-a-character *)
                                   (* routine, which is used by INLINE    *)
                                   (* code.                               *)

   Async_Send_Addr := ADDR( Async_Send );

END   (* PibAsync *).
