/******************************************************************************
* MSDOS Interaction library main header file.				      *
*									      *
*					Written by Gershon Elber,  Oct. 1990  *
*******************************************************************************
* History:								      *
*  3 Oct 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#ifndef INTR_LIB_H
#define INTR_LIB_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifdef NO_VOID_PTR
#define VoidPtr		char *
#else
#define VoidPtr		void *
#endif /* NO_VOID_PTR */

#define IntrBType int      			            /* Boolean type. */
#define IntrRType float				     /* Floating point type. */

#define INTR_WNDW_PULL_DOWN   -10000 /* WindowID signals pull down position. */
#define INTR_WNDW_PLACE_CENTER	0	/* WindowID signals screen position. */
#define INTR_WNDW_PLACE_LEFT	-1
#define INTR_WNDW_PLACE_RIGHT	-2

typedef enum {
    INTR_EVNT_NONE = 0,
    INTR_EVNT_SELECT,
    INTR_EVNT_ABORT,
    INTR_EVNT_MIDDLE_BUTTON,
    INTR_EVNT_MOVE,
    INTR_EVNT_KEY,
    INTR_EVNT_REFRESH
} IntrEventType;

typedef enum {			        /* Window type supported by library. */
    INTR_WNDW_NONE = 0,
    INTR_WNDW_GRAPH = 1,
    INTR_WNDW_TEXT = 2,
    INTR_WNDW_ROOT = 4
} IntrWindowType;

typedef enum {			    /* Scroll bar type supported by library. */
    INTR_SCRLBAR_NONE = 0,
    INTR_SCRLBAR_LEFT,
    INTR_SCRLBAR_RIGHT,
    INTR_SCRLBAR_TOP,
    INTR_SCRLBAR_BOTTOM
} IntrScrlBarType;

typedef enum {				      /* Color supported by library. */
    INTR_COLOR_WHITE = 0,
    INTR_COLOR_BLACK,
    INTR_COLOR_RED,
    INTR_COLOR_GREEN,
    INTR_COLOR_BLUE,
    INTR_COLOR_YELLOW,
    INTR_COLOR_CYAN,
    INTR_COLOR_MAGENTA,

    INTR_NUM_COLORS,

    INTR_COLOR_NONE
} IntrColorType;

typedef enum {			    /* Four intensity levels for each color. */
    INTR_INTENSITY_VHIGH = 0,
    INTR_INTENSITY_HIGH,
    INTR_INTENSITY_LOW,
    INTR_INTENSITY_VLOW
} IntrIntensityType;

typedef enum {				 /* Type of input devices supported. */
    INTR_INPT_DEVICE_MOUSE = 1,
    INTR_INPT_DEVICE_JOYSTICK = 2,
    INTR_INPT_DEVICE_KEYBOARD = 4
} IntrInputDeviceType;

typedef enum {					    /* Type of cursor shape. */
    INTR_CURSOR_CROSS,
    INTR_CURSOR_CROSS_LAST,
    INTR_CURSOR_SCROSS,
    INTR_CURSOR_ARROW,
    INTR_CURSOR_BOX,
    INTR_CURSOR_BOX_LAST,
    INTR_CURSOR_CUSTOM,
    INTR_CURSOR_MASK,

    INTR_CURSOR_PUSH,
    INTR_CURSOR_POP
} IntrCursorType;

typedef enum {
    INTR_SAVE_CONV,
    INTR_SAVE_EMS,
    INTR_SAVE_XMS,
    INTR_SAVE_DISK
} IntrSaveMemType;

typedef enum {
    INTR_FILL_SOLID = 1
} IntrFillType;

typedef void (* IntrVoidFunc)(void);
typedef void (* IntrIntFunc)(int);
typedef IntrEventType (* IntrInt2PtrFunc)(int *, int *);

typedef struct {
    int Xmin, Ymin, Xmax, Ymax, _Dx, _Dy;
} IntrBBoxStruct;

typedef struct {
    IntrRType FXmin, FYmin, FXmax, FYmax, _FDx, _FDy;
} IntrFBBoxStruct;

typedef struct IntrCursorShapeStruct {
    IntrCursorType CursorType;
    int Width, Height;	       /* Width/Height information to use if needed. */
    int LastX, LastY;		/* LastX/LastY information to use if needed. */
    IntrBType LastHV;	      /* If TRUE Draw Horiz/Vert line to last coord. */
    void (* CursorRoutine)(int, int);
    IntrBType _CursorVisible;
} IntrCursorShapeStruct;

typedef struct {
    char *TextData;
    IntrBType ReadBottomLine;	  /* If bottom line is used as reading line. */
    IntrColorType TextColor, BottomLineColor;
    int NumOfLines;			     /* Number of lines to be saved. */
    int LineLen;			          /* Maximum length of line. */
    int LinesInBuffer;		                  /* Number of lines active. */
    int FirstDisplayed;			            /* First line displayed. */
    int NumOfDisplayedLines;		  /* Depends on current window size. */
} _IntrWndwTextStruct;

typedef struct _IntrWindowStruct {
    int WindowID;				      /* Window handle I.D.. */
    int WindowFullSize;		/* TRUE if window is using screen full size. */
    IntrWindowType WindowType;
    char *Name, *StatusLeft, *StatusRight; /* Strings describing the window. */
    IntrBType DrawHeader;         /* TRUE will show header (if Name != NULL) */
    IntrBType MappedToScreen;		       /* TRUE if should be visible. */
    IntrBType DrawnOnScreen;	      /* TRUE if was drawn, FALSE otherwise. */
    int FrameWidth;	       /* Window Frame width in screen space coords. */
    IntrBBoxStruct BBox;    /* Window (Interior) dimensions in screen space. */
    IntrBBoxStruct PushBBox;           /* One level BBox size pushing stack. */
    IntrFBBoxStruct FBBox;		      /* Real coordinates of window. */
    IntrScrlBarType HScrlBar, VScrlBar;	     /* If should have a scroll bar. */
    IntrColorType HScrlBarColor, VScrlBarColor;	 /* Window Scroll Bar Color. */
    IntrColorType FrameColor;			      /* Window Frame Color. */
    IntrColorType BackColor;			/* Window Back Ground Color. */
    int ZoomFactor, PanFactorX, PanFactorY;	  /* Window drawing control. */
    IntrCursorShapeStruct Cursor;      /* Cursor to use while window active. */
    _IntrWndwTextStruct *TextInfo;       /* If the window is to handle text. */
    struct IntrPullDownMenuStruct *PDMenu;    /* At most one pull down menu. */
    IntrIntFunc RefreshFunc;			 /* Window refresh function. */
    struct _IntrWindowStruct *Pnext;
} _IntrWindowStruct;

typedef struct IntrPopUpMenuStruct {
    int NumOfEntries;				 /* Number of items in menu. */
    int SizeOfEntry;					    /* Size of item. */
    char *Header;	     			  /* Of menu - name of menu. */
    char **StrEntries;					     /* The entries. */
    struct IntrCursorShapeStruct Cursor; /* Cursor to use while menu active. */
    IntrColorType ForeColor, BackColor, FrameColor, XorColor;/* Menu colors. */
    int FrameWidth, _MenuWidth, _MenuHeight;	    /* Dimensions in pixels. */
    int SelectedIndex;	       /* Index of last item selected when poped up. */
} IntrPopUpMenuStruct;

typedef struct IntrPullDownMenuStruct {
    int NumOfEntries;				 /* Number of items in menu. */
    int SizeOfEntry;					    /* Size of item. */
    int WindowID;	/* Pull Down menus must be associated with a window. */
    char **StrEntries;					     /* The entries. */
    IntrColorType ForeColor, BackColor, FrameColor, XorColor;/* Menu colors. */
    int FrameWidth;				    /* Dimensions in pixels. */
    IntrIntFunc *ActionFuncs;     /* Function called when menu is activated. */
    int DrawnEntryWidth;           /* Width of each drawn entry in the menu. */
    int _ActiveIndex;		      /* -1 if none active, index if active. */
} IntrPullDownMenuStruct;

/******************************************************************************
* Function prototypes.							      *
******************************************************************************/

/* Initialization and closing routines. */
void IntrInit(void);
void IntrClose(void);

/* Generic routines: */
void IntrFatalError(char *Msg);
int IntrPopUpActive(void);

/* Color allocation routines. */
int IntrAllocColor(IntrColorType Color, IntrIntensityType Intensity);
void IntrAllow256Colors(IntrBType Allow256Colors);

/* Window manipulation routines. */
int IntrWndwCreate(char *WindowName,
		   int FrameWidth,
		   IntrBBoxStruct *BBox,
		   IntrColorType FrameColor,
		   IntrColorType BackColor,
		   IntrCursorShapeStruct *Cursor,
		   IntrPullDownMenuStruct *PDMenu,
		   IntrIntFunc RefreshFunc);
void IntrWndwSetRoot(int RootWindowID);
void IntrWndwSelect(int WindowID);
void IntrWndwSelectAll(IntrBType SelectAll);
void IntrWndwRedrawAll(void);
int IntrWndwPick(void);
void IntrWndwPop(int WindowID, IntrBType DoRedraw, IntrBType DoClear);
void IntrWndwPush(int WindowID, IntrBType DoRedraw);
IntrBType IntrWndwIsAllVisible(int WindowID);
void IntrWndwSetResizeBBox(IntrBBoxStruct *BBox);
IntrBType IntrWndwMove(int WindowID, IntrBType Refresh);
IntrBType IntrWndwResize(int WindowID, IntrBType Refresh);
void IntrWndwFullSize(int WindowID, IntrBType Refresh);
void IntrWndwHide(int WindowID, IntrBType Refresh);
void IntrWndwDelete(int WindowID, IntrBType Refresh);
int IntrWndwGetHeaderHeight(char *Header, int FrameWidth);
IntrBBoxStruct *IntrWndwGetBBox(int WindowID);
IntrFBBoxStruct *IntrWndwGetFBBox(int WindowID);
IntrColorType IntrWndwGetFrameColor(int WindowID);
IntrColorType IntrWndwGetBackGroundColor(int WindowID);
IntrCursorShapeStruct *IntrWndwGetCursorShape(int WindowID);
IntrPullDownMenuStruct *IntrWndwGetPullDownMenu(int WindowID);
int IntrWndwGetZoomFactor(int WindowID);
IntrIntFunc IntrWndwGetRefreshFunc(int WindowID);
void IntrWndwGetPanFactors(int WindowID, int *x, int *y);
void IntrWndwSetName(int WindowID, char *Name);
void IntrWndwSetDrawHeader(int WindowID, IntrBType DrawHeader);
void IntrWndwSetBBox(int WindowID, IntrBBoxStruct *BBox);
void IntrWndwSetFBBox(int WindowID, IntrFBBoxStruct *FBBox);
void IntrWndwSetFrameColor(int WindowID, IntrColorType FrameColor);
void IntrWndwSetBackGroundColor(int WindowID, IntrColorType BackColor);
IntrBType IntrWndwIsScrollBarEvent(int WindowID, IntrBType *IsVertical, IntrRType *Value);
int IntrWndwScrollBarWidth(void);
void IntrWndwUpdateScrollBar(int WindowID,
			     IntrBType IsVertical,
		             IntrRType RelativePosition,
                             IntrRType DisplayedFraction);
void IntrWndwSetScrlBar(int WindowID,
			IntrBType IsVertical,
			IntrScrlBarType ScrlBar,
                        IntrColorType ScrlBarColor);
void IntrWndwSetCursorShape(int WindowID, IntrCursorShapeStruct *Cursor);
void IntrWndwSetPullDownMenu(int WindowID, IntrPullDownMenuStruct *PDMenu);
void IntrWndwSetRefreshFunc(int WindowID, IntrIntFunc RefreshFunc);
void IntrWndwUpdatePanning(int WindowID, int x, int y);
void IntrWndwSetPanning(int WindowID, int x, int y);
void IntrWndwUpdateZoom(int WindowID, int Zoom);
void IntrWndwSetZoom(int WindowID, int Zoom);
void IntrWndwSetStatus(int WindowID, char *StatusLeft, char *StatusRight,
							    IntrBType Refresh);

/* Window drawing routines. */
void IntrWndwILine(int x1, int y1, int x2, int y2);
void IntrWndwRLine(IntrRType x1, IntrRType y1, IntrRType x2, IntrRType y2);
void IntrWndwIMoveTo(int x, int y);
void IntrWndwRMoveTo(IntrRType x, IntrRType y);
void IntrWndwILineTo(int x, int y);
void IntrWndwRLineTo(IntrRType x, IntrRType y);
void IntrWndwIMoveRel(int x, int y);
void IntrWndwRMoveRel(IntrRType x, IntrRType y);
void IntrWndwILineRel(int x, int y);
void IntrWndwRLineRel(IntrRType x, IntrRType y);
void IntrWndwIPoly(int n, int *Points, int Fill);
void IntrWndwIBar(int x1, int y1, int x2, int y2);
void IntrWndwRBar(IntrRType x1,
		  IntrRType y1,
		  IntrRType x2,
		  IntrRType y2);
void IntrWndwICircle(int x, int y, int r);
void IntrWndwRCircle(IntrRType x, IntrRType y, IntrRType r);
void IntrWndwIArc(int x, int y, int StAngle, int EndAngle, int r);
void IntrWndwRArc(IntrRType x,
		  IntrRType y,
		  int StAngle,
		  int EndAngle,
		  IntrRType r);
void IntrWndwIText(int x, int y, char *s);
void IntrWndwRText(IntrRType x, IntrRType y, char *s);

/* Text handling in graphic windows. */
void IntrTextInitWindow(int WindowID,
			IntrBType ReadBottomLine,
			IntrColorType TextColor,
                        IntrColorType BottomLineColor,
                        IntrScrlBarType HScrlBar,
                        IntrScrlBarType VScrlBar,
                        int NumOfLines,
                        int LineLen);
void IntrTextSetSmoothScroll(IntrBType SmoothScrolling);
void IntrTextWndwRefresh(int WindowID);
void IntrPrintf(int WindowID, IntrBType UpdateWindow, char *CtrlStr, ...);
void IntrGetLineWindow(int WindowID, char *Buffer, int BufferLen);

/* Cursor control routines. */
void IntrUseMouseDriverCursor(IntrBType UseMouseCursor);
void IntrPushCursorType(void);
void IntrPopCursorType(void);
IntrCursorShapeStruct *IntrGetCursorType(void);
void IntrSetCursorType(IntrCursorShapeStruct *Cursor);
void IntrSetCursorType2(IntrCursorType CursorType,
		        void (* CursorRoutine)(int, int),
		        int Width, int Height, int LastX, int LastY,
		        IntrBType LastHV);
void IntrShowCursor(int x, int y);
void IntrReposCursor(int x, int y);
void IntrUnShowCursor(void);

/* Simple messages mechanism. */
void IntrDrawMessage(char *Str, IntrColorType ForeColor,
						    IntrColorType BackColor);
void IntrEraseMessage(void);

/* Input event handling routines. */
int IntrGetch(void);
int IntrKbHit(void);
void IntrSetIdleFunction(IntrVoidFunc IdleFunction);
void IntrSetAtKeyboard(IntrBType IsATKeyboard);
void IntrSetMouseSensitivity(int Sensitivity);
IntrBType IntrRegisterKeyStroke(int KeyStroke, IntrIntFunc ActionFunc);
void IntrSetInputDevice(int Devices);
void IntrSetHandleInternalEvents(IntrBType HandleEvents,
				 IntrBType PropagateEvents);
void IntrInputFlush(void);
IntrEventType IntrGetEventWaitSA(int *x, int *y);
IntrEventType IntrGetEventWait(int *x, int *y);
IntrEventType IntrGetEventNoWait(int *x, int *y);
IntrEventType IntrGetTextEventWait(void);
IntrEventType IntrGetTextEventNoWait(void);
void IntrPushKbdEvent(int KbdEvent);
IntrBType IntrMapEventToWindow(int WindowID, int x, int y, int *Wx, int *Wy);
IntrBType IntrMapEventToRWindow(int WindowID, int x, int y,
					      IntrRType *Wx, IntrRType *Wy);

/* Routines to control images back saving. */
void IntrSetAsyncEventMode(IntrBType AsyncMode);
void IntrSetSaveBackGround(IntrBType SaveBackGround);
void IntrSetSaveBackMethod(IntrSaveMemType SaveBackMethod);
void IntrSetSaveBackPath(char *Path);

/* Query Interaction routines. */
void IntrQueryContinue(char *Question,
		       IntrColorType FrameColor,
		       IntrColorType BackColor,
		       IntrColorType ForeColor,
		       IntrColorType XorColor,
                       int FrameWidth,
                       IntrCursorShapeStruct *Cursor,
                       int WindowID);
void IntrQueryContinue2(char *Question,
			void (* ExecFunc)(void),
		        IntrColorType FrameColor,
		        IntrColorType BackColor,
		        IntrColorType ForeColor,
                        int FrameWidth,
                        IntrCursorShapeStruct *Cursor,
                        int WindowID);
IntrBType IntrQueryYesNo(char *Question,
		         IntrColorType FrameColor,
		         IntrColorType BackColor,
		         IntrColorType ForeColor,
		         IntrColorType XorColor,
                         int FrameWidth,
                         IntrCursorShapeStruct *Cursor,
                         int WindowID);
char *IntrQueryLine(char *Question,
		    char *Buffer,
                    int BufferSize,
		    IntrColorType FrameColor,
		    IntrColorType BackColor,
		    IntrColorType ForeColor,
                    int FrameWidth,
                    int WindowID);
int IntrQueryList(char *Header,
		  char **StrEntries,
		  int SizeOfEntry,
                  int NumOfEntries,
                  int NumOfDisplayedEntries,
		  IntrColorType FrameColor,
		  IntrColorType BackColor,
		  IntrColorType ForeColor,
		  IntrColorType XorColor,
		  int FrameWidth,
                  IntrCursorShapeStruct *Cursor,
                  int WindowID);

/* Pop Up Menu Interaction routines. */
void IntrPullDownMenuDelete(IntrPullDownMenuStruct *Menu);
IntrPopUpMenuStruct *IntrPopUpMenuCreate(char *Header,
					 char **StrEntries,
					 int SizeOfEntry,
                                         int NumOfEntries,
					 IntrColorType FrameColor,
				         IntrColorType BackColor,
				         IntrColorType ForeColor,
				         IntrColorType XorColor,
			                 int FrameWidth,
                                         IntrCursorShapeStruct *Cursor);
void IntrPopUpMenuDelete(IntrPopUpMenuStruct *Menu);
void IntrPopUpSetEntry(IntrPopUpMenuStruct *PUMenu, char *Entry, int Index);
void IntrPopUpSetHeader(IntrPopUpMenuStruct *PUMenu, char *Header);
void IntrPopUpSetFrameWidth(IntrPopUpMenuStruct *PUMenu, int FrameWidth);
void IntrPopUpSetColors(IntrPopUpMenuStruct *PUMenu,
		        IntrColorType FrameColor,
		        IntrColorType BackColor,
		        IntrColorType ForeColor,
		        IntrColorType XorColor);
int IntrPopUpMenu(IntrPopUpMenuStruct *PUMenu,
                  int WindowID);

/* Pull Down Menu Interaction routines. */
IntrPullDownMenuStruct *IntrPullDownMenuCreate(char **StrEntries,
					       int SizeOfEntry,
                                               int NumOfEntries,
					       IntrIntFunc *ActionFuncs,
				               IntrColorType FrameColor,
				               IntrColorType BackColor,
				               IntrColorType ForeColor,
				               IntrColorType XorColor,
			                       int FrameWidth);
void IntrPullDownSetEntry(IntrPullDownMenuStruct *PDMenu, char *Entry,
								int Index);
void IntrPullDownSetAction(IntrPullDownMenuStruct *PDMenu,
				IntrIntFunc ActionFunc, int Index);
void IntrPullDownSetFrameWidth(IntrPullDownMenuStruct *PDMenu, int FrameWidth);
void IntrPullDownSetColors(IntrPullDownMenuStruct *PDMenu,
		           IntrColorType FrameColor,
		           IntrColorType BackColor,
		           IntrColorType ForeColor,
		           IntrColorType XorColor);

#endif /* INTR_LIB_H */
