/*****************************************************************************
* General definitions of/for GenMat.c module				     *
*****************************************************************************/

#ifndef	GEN_MAT_H
#define GEN_MAT_H

/* And prototypes of the functions: */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void GenUnitMat(MatrixType Mat);
void GenMatTrans(RealType Tx, RealType Ty, RealType Tz, MatrixType Mat);
void GenMatScale(RealType Sx, RealType Sy, RealType Sz, MatrixType Mat);
void GenMatRotX1(RealType Teta, MatrixType Mat);
void GenMatRotX(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void GenMatRotY1(RealType Teta, MatrixType Mat);
void GenMatRotY(RealType CosTeta, RealType SinTeta, MatrixType Mat);
void GenMatRotZ1(RealType Teta, MatrixType Mat);
void GenMatRotZ(RealType CosTeta, RealType SinTeta, MatrixType Mat);

void MultTwo4by4(MatrixType MatRes, MatrixType Mat1, MatrixType Mat2);

void MultVecby4by4(RealType VRes[3], RealType Vec[3], MatrixType Mat);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* GEN_MAT_H */
