void Break_Off(void)

{
    freopen("NUL:","w",stdout);
        /* capture stdout to stop ^c from apearing */

    _asm push    ds
    _asm push    cs
    _asm pop    ds
    _asm mov    dx, offset Int_23h_Handler
    _asm mov    ah,25h  ; DOS Function 25 - set interrupt vector
    _asm mov    al,23h  ; change interrupt 23H
    _asm int    21h
    _asm pop    ds
    return;

    Int_23h_Handler:
    _asm iret

    /* dos will reset this interrupt after any executable terminates
        so this does not have to be reset by this program */   
}

/**************************************************************************/
long int Disk_Space_Check( drive )

byte drive;

{
    int hold_seg,hold_off;
    int a=0,b=0,c=0;

    _asm push    ds
    _asm mov    ah,35h  ; DOS Function 35 - get interrupt vector
    _asm mov    al,24h  ; Read interrupt 24H
    _asm int    21h
    _asm mov    hold_off,ds
    _asm mov    hold_seg,dx

    _asm pop    ds
    _asm mov    dx, offset Int_24h_Handler
    _asm push    ds
    _asm push    cs
    _asm pop    ds
    _asm mov    ah,25h  ; DOS Function 25 - set interrupt vector
    _asm mov    al,24h  ; Change interrupt 24H
    _asm int    21h
    _asm pop    ds

        /* find disk space */
    _asm   mov  ah,36h
    _asm   mov  dl,drive
    _asm   int  21h
    _asm   mov  a,ax
    _asm   mov  b,bx
    _asm   mov  c,cx

        /* restore critical interrupt */ 
    _asm push    ds
    _asm mov    dx, hold_seg
    _asm mov    ds, hold_off
    _asm mov    ah,25h  ; DOS Function 25 - set interrupt vector
    _asm mov    al,24h  ; Change interrupt 24H
    _asm int    21h
    _asm pop    ds

        /* check for success */
    if ( a == -1 )
        return( -1 );
    return( (long)a*b*c );

    Int_24h_Handler:
    _asm mov al,3
    _asm iret
}

/***************************************************************************/
void Error_Box(line1,line2)

char line1[],line2[];

{
    char title[] = "Error - Error - Error - Error";
    char foot[] = "Press any key to continue.";
    char blank[] = " ";
    char *lines[7];    

    lines[0] = title;
    lines[1] = blank;
    lines[2] = line1;
    lines[3] = line2;
    lines[4] = blank;
    lines[5] = foot;
    lines[6] = NULL;

    Display_Text_Box(lines,CENTER,CENTER,error_palette);
    Pause_Until_Serious_Action();
    Remove_Window();
}

/***************************************************************************/
void Critical_Error(error)

error_type error;

{
    Clean_Up();
    if (current_file != NULL){
        fprintf(stderr,"file- %s\n",current_file);
        if (line_count)
            fprintf(stderr,"line- %u\n",line_count);
    }
    switch(error){
        case SYNTAX:
            fputs("Syntax Error.",stderr);
            break;
        case VALUE:
            fputs("Illegal or Missing Value.",stderr);
            break;
        case POSITION:
            fputs("Unexpected menu structure.",stderr);
            break;
        case MEMORY:
            fputs("Memory allocation error.",stderr);
            break;
        case FILE_OPEN:
            fputs("Unable to open file.",stderr);
            break;
        case DISPLAY:
            fputs("Unable to display menu script.",stderr);
            break;
        case ENVIROMENT:
            fputs("Improper 't' enviroment variable",stderr);
            break;
    }
    fputc('\n',stderr);
    exit(LEAVE_MENU);
}

/**************************************************************************/
boolean Get_DM_Var( place, temp, space )

char *place, *temp;
byte space;

{
    byte i = 0;
    
    for (i=0;i<var_number;i++){
        if (Compare(place,vars[i].name)){
            strncpy(temp,vars[i].value,space);
            return(YES);
        }
    }
    return(NO);
}

/**************************************************************************/
void Transcribe_String(old,new)

char *old,*new;

{
    byte space = MAX_LINE;

    *new = '\0';

    for (;;){
            /* check for variables */
        while (*old == '%'){
            if ( !Get_DM_Var(old,new,space)){
                Find_Env_Var(old,new,space);
                if (*new == VAR_NOT_FOUND){
                    break;    /* leave the while loop if it's not a variable */
                }
            }

      /* move past variable */
            while (*new != '\0'){
                space--;
                new++;
            }

            old++;
            while (*old != '%'){
                old++;
            }
            old++;

            if (!space)  /* stop if no room left in allocated space */
                return;
        }

        if (*old == '\0' || !(--space) ){
            *new = '\0';
            return;
        }
        *new = *old;
        new++;
        old++;
    }
}

/***************************************************************************/
boolean Fcompare( string1,string2 )

char *string1, far *string2;

{
        /* skip first '%' */
    string1++;

    while (*string2 != '='){
        if( (*string1++ | 32) != (*string2++ | 32) )
            return(NO);
    }
        /* does it have a closing '%' ? */
    if (*string1 == '%')
        return(YES);
    return(NO);
}

/***************************************************************************/
void Find_Env_Var( var, string, space )

char *var, *string;
byte space;

{
    char far *cptr = env_start;

    while (!Fcompare(var,cptr)){
        while (*cptr != '\0')
            cptr++;
        if (*(++cptr) == '\0'){
            *string = VAR_NOT_FOUND;
            return;
        }
    }
    while (*cptr++ != '=');
    
    while (*cptr != '\0'){
        *string++ = *cptr++;
        if (--space == 0)
            break;
    }
    *string  = '\0';
    return;
}

/****************************************************************************/
void Monochrome_Defaults()

{
    color_monitor    = NO;
    default_palette  = 8;
    header_palette   = 9;
    error_palette    = 9;
    message_palette  = 9;
    backdrop_color   = 7;
    footer_color     = 15;
    footer_highlight = 4;
}

/***************************************************************************/
void Get_Video_Info( parameter )

char *parameter;

{
    // color defaults
    color_monitor    = YES;
    video_start = (int far * ) 0xb8000000;
    default_palette  = 0;
    header_palette   = 1;
    error_palette    = 2;
    message_palette  = 3;
    backdrop_color   = 19;
    footer_color     = 31;
    footer_highlight = 113;

    // put the screen to the 0 video page of whatever mode we are in.
    _asm mov ax, 0500h
    _asm int 10h

    // now let's find out what video mode we are in.
    _asm mov ax, 0F00h
    _asm int 10h
    _asm mov video_mode,al;
	if (video_mode >= 7){
        // monochrome defaults
        video_start = (int far * ) 0xb0000000;
        color_monitor    = NO;
        default_palette  = 8;
        header_palette   = 9;
        error_palette    = 9;
        message_palette  = 9;
        backdrop_color   = 7;
        footer_color     = 15;
        footer_highlight = 4;
    }

    // now determine the screen size
    max_screen_y = *((char far *) 0x00400084L);
    max_screen_x = *((char far *) 0x0040004AL);
    if (max_screen_y == 0){
        max_screen_x = 80;
        max_screen_y = 24;
    }

    // now record the cursor shape
    _asm mov ah,03   
    _asm mov bh,00    ;look in page 0
    _asm int 10h
    _asm mov cursor_top,ch
    _asm mov cursor_bottom,cl
}

/***************************************************************************/
void Set_Up_Enviroment()

/* this routine changes the enviroment var's as needed and gets the path
  of the temporary batch file from there */

{
	long int psp_segment;
	long int env_segment;

	int far *ptr;
	char far *cptr;

	_asm mov ax,6200h
	_asm int 21h
	_asm mov psp_segment,bx;

		/* go to the oldest enviroment space */

	while (ptr !=(ptr = (int far *) ((psp_segment << 16) + 0x16)));
	psp_segment = *ptr;
	ptr = (int far *) ((psp_segment << 16) + 0x2c);
    env_segment = *ptr;
    cptr = env_start = (char far *) (env_segment <<16);

    while (!Fcompare( "%t%", cptr )){
		while (*cptr != '\0')
			cptr++;
		if (*(++cptr) == '\0'){
			Critical_Error(ENVIROMENT);
		}
	}

	while (*cptr != '\0')
		cptr++;
	cptr--;

	if (*(cptr-3) != '.')
		Critical_Error(ENVIROMENT);
	if (*cptr == 'T') 
		first_run = NO;

	else{
		first_run = YES;
		*cptr-- = 'T';
		*cptr-- = 'A';
		*cptr = 'B';
   }
}

/***************************************************************************/
void Set_Up_Mouse()

{
    int max_x,max_y;    

    max_x = (max_screen_x -1 ) * 8;
    max_y = max_screen_y * 8;

    _asm sub ax,ax           /* intitalize mouse */
    _asm int 33h

    _asm mov dx,max_x    /* Pixels horizontally */
    _asm mov ax,7        /* mouse driver function 7 -- set max x range */
    _asm sub cx,cx       /* Minimum range */
    _asm int 33h

    _asm mov dx,max_y    /* Pixels veritcally */
    _asm mov ax,8        /* mouse driver function 8 -- set max y range */
    _asm sub cx,cx       /* Minimum range */
    _asm int 33h

    _asm mov ax,4        /* set current mouse position  0,0 */
    _asm sub bx,bx            
    _asm sub cx,cx            
    _asm sub dx,dx
    _asm int 33h

    Hide_Mouse();
}

/***************************************************************************/
void Set_Up_Screen()

{
	char    ch;
	char 	old_bat[MAX_FILE_NAME];
    FILE   *Old_Bat;

	Hide_Cursor();
	Draw_Backdrop();
	Draw_Header();
    Draw_Footer();
    Draw_Back_Boxes();

	win_index = 255;         /* we are now at the -1st menu */

                             /* this sets win[].item */
	if (!Windowfy_Menu(first_menu))
		Critical_Error(DISPLAY);

	if ( !first_run ){
		Find_Env_Var("%t%",old_bat,MAX_LINE);
		if ( ( Old_Bat = fopen(old_bat, "r" ) ) != NULL ){
			if ( do_return ){
					/* advance to the pertinent information */
				while ( ch = fgetc(Old_Bat) != ':' )
					if ( ch == '\n' || ch == EOF)
						break;
				for (;;){
                       // get item number
					ch = (char) (fgetc(Old_Bat) - 64);
					current_item = Number_To_Item( (byte)ch );
					if (current_item->first_line == NULL)
						break;
					Win[win_index].item = current_item;
					Display_Menu(current_item);

                       // do it if possible
					ch = (char) (fgetc(Old_Bat) - 64);
                       // now 42, that's a magic number */
					if ( (byte)ch > SPECIAL+30 )
						break;
					Win[win_index].event = (byte)ch;
					if ( ch != DO_ITEM)
						current_item = special_item[ch-SPECIAL];
					if ( current_item == NULL )
						break;
					if ( !Windowfy_Menu( Find_Menu( current_item->first_line ) ) )
						break;
				}
			}
			fclose(Old_Bat);   
			remove(old_bat);
		}
	}

		/* start doing shadows now */
		/* allocate the shadow buffer if necessary */
	if (shadow = draw_shadow){
		shad_buf = (byte *) malloc ( max_screen_x + max_screen_y );
	}

        /*make sure that the current item is proper */
	current_item = Win[win_index].item;
	Display_Menu(NULL);
 	Select(current_item);
}
