{

rusn-sel.pas - rusnews selectarts and friends

}

procedure selectarts;

var
  i: integer;
  donepagesel: boolean;
  donegroupsel: boolean;
  topline,botline: integer;
  selsubjs: array[1..maxlpp] of string;
  inkey,lastinkey: char;
  highestletteronscreen: char;

function issellet(ch: char): boolean;

begin
  issellet := islower(ch) and (ch<=highestletteronscreen);
end;

procedure writeselln(lineno: integer);

var
  ycoord: integer;
  printsubj: string;
  i: integer;

begin
  if selected[lineno] then
    xhighvideo
  else
    xlowvideo;
  ycoord := lineno-topline+1+selheaderlines+1;
  if lineno-topline<26 then
    writexy(1,ycoord,chr(ord('a')+lineno-topline))
  else
    writexy(1,ycoord,chr(ord('0')+lineno-topline-26));

  writexy(3,ycoord,copy(fromsp^[lineno],1,20));

{$ifdef testsort}
  writexy(3,ycoord,'               ');
  writexy(3,ycoord,filenamesp^[lineno]);
{$endif}

  xgotoxy(24,ycoord);
  xwriteiw(sizeink[lineno],4);
  printsubj := '';
  for i := 1 to (indents[lineno] and $f) do
    printsubj := printsubj+'>';
  printsubj := printsubj+selsubjs[lineno-topline+1];
  if printsubj='' then
    writexy(29,ycoord,'-')
  else
    writexy(29,ycoord,copy(printsubj,1,50));
  xlowvideo;
  xgotoxy(1,sellpp+selheaderlines+4);
end;

procedure showselscreen;

var
  i: integer;
  prevsubj: string;
  percent: integer;

begin
  prevsubj := '';
  xclrscr;
  xgotoxy(1,1);
  xwritessis(currgroup,' Articles: ',numarts,'                      ');
  botline := topline-1;
  for i := topline to min(topline+sellpp-1,numarts) do
    begin
      if subjseq(basesubjs[i],prevsubj) then
        selsubjs[i-topline+1] := ''
      else
        selsubjs[i-topline+1] := basesubjs[i];
      prevsubj := basesubjs[i];
      writeselln(i);
      botline := i;
    end;
  if numarts>600 then
    percent := (10*botline) div (numarts div 10)
  else if numarts>300 then
    percent := (20*botline) div (numarts div 5)
  else
    percent := (100*botline) div numarts;
  if percent>100 then
    percent := 100;   {handle roundoffs more gracefully!}
  xgotoxy(1,sellpp+selheaderlines+3);
  xwritelnsssisis('?=help  ',time,'   ',percent,'% through this group   ',
   numarts-botline,' more on later screen(s)');
  xclreol;
  xgotoxy(1,sellpp+selheaderlines+4);
  highestletteronscreen := chr(ord('a')+(botline-topline+1)-1);
end;

procedure togglekey(inkey: char);

var
  inkeyint: integer;
  artnum: integer;

begin
  inkeyint := ord(inkey)-ord('a');
  artnum := inkeyint+topline;
  if artnum<=botline then
    begin
      selected[artnum] := not selected[artnum];
      writeselln(artnum);
    end;
end;

procedure selreversepage;

var
  artnum: integer;

begin
  for artnum := topline to botline do
    begin
      selected[artnum] := not selected[artnum];
      writeselln(artnum);
    end;
end;

procedure selclearall;

var
  artnum: integer;

begin
  for artnum := 1 to numarts do
    selected[artnum] := false;
end;

procedure dostar(inkey: char);

var
  inkeyint: integer;
  artnum: integer;
  currsubj: string;

begin
  inkeyint := ord(inkey)-ord('a');
  artnum := inkeyint+topline;
  currsubj := basesubjs[artnum];
  while (artnum<=numarts) and subjseq(currsubj,basesubjs[artnum]) do
    begin
      if not selected[artnum] then
        begin
          selected[artnum] := true;
          if artnum<=botline then
            writeselln(artnum);
        end;
      inc(artnum);
    end;
end;

procedure dodash(inkey: char);

var
  inkeyint: integer;
  artnum: integer;
  currsubj: string;
  newkey: char;
  newkeyint: integer;

begin
  inkeyint := ord(inkey)-ord('a');
  xclreolxy(1,lpp);
  xwritess(inkey,'-');
  newkey := xreadkey;
  if issellet(newkey) then
    begin
      newkeyint := ord(newkey)-ord('a');
      if (newkeyint<botline-topline+1) and (newkeyint>=inkeyint) then
        for artnum := topline+inkeyint to topline+newkeyint do
          if not selected[artnum] then
            begin
              selected[artnum] := true;
              writeselln(artnum);
            end;
    end;
  xclreolxy(1,lpp);
end;

procedure backpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if topline=1 then
        topline := numarts-((numarts-1) mod sellpp)
      else
        dec(topline,sellpp);
      showselscreen;
    end;
end;

procedure forwardpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if botline=numarts then
        topline := 1
      else
        inc(topline,sellpp);
      showselscreen;
    end;
end;

procedure firstpage;

begin
  if topline<>1 then
    begin
      topline := 1;
      showselscreen;
    end;
end;

procedure lastpage;

begin
  if botline<>numarts then
    begin
      topline := numarts-((numarts-1) mod sellpp);
      showselscreen;
    end;
end;

procedure browsehighlightedarts;

var
  anyselected: boolean;
  currart: integer;

begin
  anyselected := false;
  for currart := topline to botline do
    if selected[currart] then
      anyselected := true;
  if anyselected then
    begin
      viewarts(topline,botline,false);
      for currart := topline to botline do
        selected[currart] := false;
      if currgroup<>'' then
        showselscreen;
    end;
end;

procedure writehighlightedarts;

var
  currart: integer;
  ch: char;

begin
  warn('not implemented yet - sorry');
end;

procedure gotonewgroup;

var
  possgroup: string;

begin
  possgroup := '';
  pickagroup(possgroup);
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      showselscreen;
    end
  else
    begin
      selclearall;
      alreadyingroup := true;
      currgroup := possgroup;
      donegroupsel := true;
    end;
end;

{
procedure gotonewgroup;

var
  possgroup: string;
  howto: char;

begin
  xclreolxy(1,lpp);
  xwrites('Goto group (or initials): ');
  xreadlns(possgroup,cols-30);
  if (possgroup='') then
    xclreolxy(1,lpp)
  else
    if joinedtogroup(possgroup) then
      begin
        selclearall;
        alreadyingroup := true;
        currgroup := possgroup;
        donegroupsel := true;
        howto := 
         onekey('<j>ump normally, <a>ll articles (default=j) ','ja '+#13);
        if (howto=' ') or (howto=#13) then
          howto := 'j';
        xclreolxy(1,lpp);
        if howto='a' then
          readallarts := true;
      end
    else
      warn('could not find a group to match');
end;
}


procedure selprevgroup;

var
  prevgroup: string;
  foundgroup: string;

begin
  selclearall;
  prevgroup := '..invalid..';
  foundgroup := prevgroup;
  reset(joinf);
  repeat
    prevgroup := foundgroup;
    readln(joinf,foundgroup);
    foundgroup := getfirstw(foundgroup);
  until foundgroup=currgroup;
{}{should check eof - I guess}
  if prevgroup<>'..invalid..' then
    begin
      currgroup := prevgroup;
      donegroupsel := true;
      alreadyingroup := true;
    end;
{}{need more error checking here...}
{}{also, it just goes back 1 group - not to the one with something to read!}
end;

procedure selcatch;

begin
  donegroupsel := true;
  highestread := highestart;
end;

procedure selspace;

var
  artnum: integer;
  anyselected: boolean;

begin
  if makespacelikex and (botline=numarts) then
    begin
      anyselected := false;
      for artnum := 1 to numarts do
        if selected[artnum] then
          anyselected := true;
      if anyselected then
        selcatch
      else
        donepagesel := true;
    end
  else
    donepagesel := true;
end;

procedure selantikill(veryfirsttime: boolean);

var
  i: integer;
  anynew: boolean;

begin
  anynew := false;
  for i := 1 to numarts do
    if ((indents[i] and 128)<>0) and not selected[i] then
      begin
        anynew := true;
        selected[i] := true;
      end;

  if anynew and warnautoantikill then
    begin
      if veryfirsttime then
        showselscreen;
      warn('at least one article antikilled');
    end;

  if anynew then
    if not veryfirsttime then
      showselscreen;
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  if autoantikill then
    selantikill(false);
  showselscreen;
end;

procedure selquit;

var
  doit: boolean;
  i: integer;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  y/n ','yn')='y');
  if doit then
    begin
      alreadyingroup := true;
      currgroup := '';
      donegroupsel := true;
      for i := 1 to numarts do
        selected[i] := false;
    end
  else
    showselscreen;
end;

procedure selhelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (930323)');
  writexy(1,4,'letter - toggle whether or not to read that article');
  writexy(1,5,'c-f - highlight c through and including f');
  writexy(1,6,'g*  - highlight g and all with same subject');
  writexy(1,7,'space, enter - go to next screen (or browse on last screen)');
  writexy(1,8,'N   - go to next group (but browse first)');
  writexy(1,9,'X   - like N, but mark _all_ articles as read after');
  writexy(1,10,'P   - go to previous group');
  writexy(1,11,'@   - reverse all selections on this page');
  writexy(1,12,'~   - clear all selections (all pages)');
  writexy(1,13,'^L  - refresh screen    ^R - reread kill and antikill files');
  writexy(1,14,'<   - go back a page (wraps)      ^ - first page');
  writexy(1,15,'>   - go forward a page (wraps)   $ - last page');
  writexy(1,16,'Z   - browse articles on this page (not marked as read)');
  writexy(1,17,'W   - write selected articles (this or all pages) (not yet)');
  writexy(1,18,'G   - goto group; can shorten each word (eg. c.b.waf)');
  writexy(1,19,'!   - shell escape        + - select antikilled articles');
  writexy(1,20,'?   - help                Q - quit');
  writexy(1,22,'press any key to return ');
  ch := xreadkey;
  showselscreen;
end;

begin
  for i := 1 to numarts do
    selected[i] := false;

  donegroupsel := (numarts=0);
  lastinkey := ' ';
  topline := 1;

  if not donegroupsel and autoantikill then
    selantikill(true);

  while not donegroupsel and (currgroup<>'') do
    begin
      donepagesel := false;
      showselscreen;
      while not donegroupsel and not donepagesel and (currgroup<>'') do
        begin
          inkey := xreadkey;
          if inkey=#13 then
            if makereturnlikeasterisk then
              inkey := '*';
          if inkey='?' then selhelppage
          else if issellet(inkey) then togglekey(inkey)
          else if inkey='<' then backpage
          else if inkey='>' then forwardpage
          else if inkey='^' then firstpage
          else if inkey='$' then lastpage
          else if inkey=' ' then selspace
          else if inkey=#13 then selspace
          else if (inkey='*') and issellet(lastinkey) then dostar(lastinkey)
          else if (inkey='-') and issellet(lastinkey) then dodash(lastinkey)
          else if inkey='Z' then browsehighlightedarts
          else if inkey='W' then writehighlightedarts
          else if inkey='G' then gotonewgroup
          else if inkey='N' then donegroupsel := true
          else if inkey='@' then selreversepage
          else if inkey='~' then begin selclearall; showselscreen; end
          else if inkey='X' then selcatch
          else if inkey='P' then selprevgroup
          else if inkey=^L  then showselscreen
          else if inkey=^R  then rereadkillfiles
          else if inkey='!' then begin shellout; showselscreen; end
          else if inkey='+' then selantikill(false)
          else if inkey='Q' then selquit;
          lastinkey := inkey;
        end;
      if botline<numarts then
        inc(topline,sellpp)
      else
        donegroupsel := true;
    end;
end;
