/*
 * wafday.c 12.29.90 version 1.1
 * written by George L. Tirebiter (george@moocow.uucp)
 *
 * wafday will read the contents of your /waffle/admin/callers log and
 * show you which days of the week get the most activity.  this assumes
 * that you haven't modified the order of information in the file.
 *
 * wafday also reports any garbage records (i.e., those that don't seem to
 * have the day-of-week where it thinks they should be).  please note that
 * this program was written as an exercise to learn "C".
 *
 * as of version 1.0, wafday was written to compile under turbo-c 2.0.
 *
 */

#include <stdio.h>
#include <ctype.h>

#define SIZE		80

char words[16][SIZE], line[SIZE]; int numwords;

main (int argc, char *argv[])
  {
  FILE *fp;
  char buf[SIZE];
  int i, k = 0; long count[7], total, garbage;

  static char *DAYS[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
  "Thursday", "Friday", "Saturday" , NULL };

  total = garbage = 0L;

  for (i=0;i<=6;i++) count[i]=0L;

  if (argc==1) { printf ("usage: wafday <waffle caller-file>\n"); exit (1); }

  if (( fp = fopen (argv[1], "r")) == NULL)
    { printf ("wafday: couldn't open %s\n", argv[1]); exit (2); }

  while (fgets (buf, SIZE, fp))
	{
	seperate (buf);

	if ((k = match (words[numwords-2], DAYS, 3 )) == -1)
	  {
	  garbage ++;
	  break;
	  }

	count[k]++; total++;
	}

  fclose(fp);

  printf ("Of the %ld entries in the file \"%s\",\n\n", total, argv[1]);

  for (i=0;i<=6;i++)
    printf ("%4ld (%04.2f%%) calls were made on %s.\n",
    count[i], ((float)count[i] * 100.0) / total, DAYS[i]);

  if (garbage) printf ("\n(There were %d bad records.)\n", garbage);
  }

/*
 * match() looks at the first n characters of t[] until it finds a \0.
 * returns -1 if it can't find s in t[], otherwise the location of s in t.
 *
 */

match (char *s, char *t[], int n)
  {
  int i=0;

 while (t[i])
    {
	if (!strnicmp (s, t[i], n))
	  return (i);
    i++;
	}

  return -1;
  }

/*
 * seperate() breaks string up into words[] based on spaces.
 *
 */

seperate (char *string)
  {
  int i; char *d;

  for (i=0;i<=15;i++)
    *words[i] = 0;

  numwords = 0;

  while (*string)
	{
	d = words[numwords];

    while (*string && *string != ' ')
	  *d++ = *string++;

	while (*string == ' ')
	  string++;

	*d = 0;

	if (++numwords >=16)
	  break;
	}

  numwords--;
  }
