		TITLE CPRINTAT.ASM 
		page ,132


;------------------------------------------------------------------------------

DYNS			STRUC

OLD_BP			DW	?
RETN			DW	?

STR_PTR			DW  ?		; these are passed parameters:
ROW	        	DW	?		; starting row, col
COL	        	DW	?
ATTRIB  		DW	?		; desired attribute
DYNS			ENDS


;------------------------------------------------------------------------------

PGROUP		GROUP	PROG

PROG		SEGMENT	BYTE PUBLIC 'PROG'
			PUBLIC	CPRINTAT
			ASSUME	CS:PGROUP


TRUE			EQU	1
FALSE			EQU	0



FIRST_CALL		DB	TRUE
VIDEO_RAM_SEG	DW	?
CRT_STATUS_PORT	DW	?


CPRINTAT	PROC	NEAR

			PUSH	BP
			MOV		BP, SP
			PUSH	ES
			CMP		CS:FIRST_CALL, TRUE    ; is this the first call by this prog?
			JNE		CPRINTAT_10
			CALL 	GET_VIDEO_MODE      ; yes - then get video details

CPRINTAT_10:

			MOV		AX, CS:VIDEO_RAM_SEG
			MOV		ES, AX              
				
			MOV		DX, CS:CRT_STATUS_PORT

			MOV		AX, [BP].ROW
			SUB		AX, 1               ; adjust for home of 1,1
			MOV     CL, 80              ; determine offset of starting position
			MUL		CL          		; from video ram segment
			MOV		CX, [BP].COL        ; CX = COL
			SUB		CX, 1               ; adjust for home of 1,1
			ADD		AX, CX		
			SHL		AX, 1				; offset = ((row x 80) + col) * 2
			MOV		DI, AX              ; DI will index video ram

			
			MOV		AX, [BP].ATTRIB
			XCHG	AH, AL              ; AH = attribute


			MOV		BX, [BP].STR_PTR     ; BX = pointer to string
			MOV		SI, 00               ; SI will index string


CPRINTAT_20:
			MOV		AL, BYTE PTR DS:[BX + SI]   ; get byte
			CMP		AL, 0
			JE		CPRINTAT_30
			PUSH	AX                          ; save byte and attribute
WAIT_1:
			IN		AL, DX                      ; wait for retrace to end
			TEST	AL, 1
			JNZ		WAIT_1
			CLI
WAIT_2:
			IN		AL, DX                      ; wait for retrace to start
			TEST	AL, 1
			JZ		WAIT_2
			POP		AX                          ; recover byte
			MOV		ES:[DI], AL                 ; plug 'em
			STI
			INC		DI							; once for character byte
			PUSH	AX
WAIT_3:
			IN		AL, DX
			TEST	AL, 1
			JNZ		WAIT_3
			CLI
WAIT_4:
			IN		AL, DX
			TEST	AL, 1
			JZ		WAIT_4
			POP		AX
			MOV		ES:[DI], AH			    	; enter attribute byte
			STI
			INC		DI							; once for attribute byte
			INC		SI                          ; ++string
			JMP		CPRINTAT_20				

CPRINTAT_30:

			POP		ES
			POP		BP
			RET		

CPRINTAT	ENDP



GET_VIDEO_MODE PROC NEAR

	MOV 	AX, 40H                 ; ES = BIOS data segment
	MOV 	ES, AX
	MOV 	AX, ES:[63H]            ; base address of CRT controller
	ADD 	AX, 6                   ; addresss of CRT status port
	MOV		CS:CRT_STATUS_PORT, AX
	MOV		CS:VIDEO_RAM_SEG, 0B000H   ; address of mono video ram
	MOV		AH, 15          		; check if graphics display
	INT		10H
	CMP	AL, 3
	JNE		GOT_MODE
	ADD		CS:VIDEO_RAM_SEG, 800H    	; if so then adjust video ram address

GOT_MODE:

	MOV		CS:FIRST_CALL, FALSE
	RET

GET_VIDEO_MODE ENDP



PROG	ENDS
		END
