;
; *** Listing 11-27 ***
;
; Determines whether two zero-terminated strings differ
; ignoring case-only differences, and if so where, using
; LODS, with an XLAT-based table look-up to convert to
; uppercase.
;
	jmp	Skip
;
TestString1	label	byte
	db	'THIS IS A TEST STRING THAT IS '
	db	'Z'
	db	'TERMINATED WITH A ZERO BYTE...',0
TestString2	label	byte
	db	'This is a test string that is '
	db	'a'
	db	'terminated with a zero byte...',0
;
; Table of conversions between characters and their
; uppercase equivalents. (Could be just 128 bytes long if
; only 7-bit ASCII characters are used.)
;
ToUpperTable	label	word
CHAR=0
	rept	256
if (CHAR lt 'a') or (CHAR gt 'z')
	db	CHAR	;not a lowercase character
else
	db	CHAR and not 20h
			;convert in the range 'a'-'z' to
			; uppercase
endif
CHAR=CHAR+1
	endm
;
; Compares two zero-terminated strings, ignoring differences
; that are only uppercase/lowercase differences.
;
; Input:
;	DS:SI = first zero-terminated string
;	ES:DI = second zero-terminated string
;
; Output:
;	DS:SI = pointer to first case-insensitive differing
;		location in first string, or 0 if the byte
;		wasn't found
;	ES:DI = pointer to first case-insensitive differing
;		location in second string, or 0 if the byte
;		wasn't found
;
; Registers altered: AX, BX, DX, SI, DI
;
; Direction flag cleared
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
CompareStringsNoCase:
	cld
	mov	bx,offset ToUpperTable
CompareStringsLoop:
	lodsw		;get the next 2 bytes
	mov	dx,es:[di] ; from each string
	inc	di	;point to the next word in the
	inc	di	; second string
	xlat		;convert the first byte in the
			; first string to uppercase
	xchg	dl,al	;set aside the first byte &
	xlat		; convert the first byte in the
			; second string to uppercase
	cmp	al,dl	;do the first bytes match?
	jnz	CompareStringsDifferent1 ;the strings differ
	and	al,al	;is this the terminating zero?
	jz	CompareStringsSame
			;yes, we're done, with a match
	mov	al,ah
	xlat		;convert the second byte from the
			; first string to uppercase
	xchg	dh,al	;set aside the second byte &
	xlat		; convert the second byte from the
			; second string to uppercase
	cmp	al,dh	;do the second bytes match?
	jnz	CompareStringsDifferent ;the strings differ
	and	ah,ah	;is this the terminating zero?
	jnz	CompareStringsLoop
			;no, do the next 2 bytes
CompareStringsSame:
	sub	si,si	;return 0 pointers indicating that
	mov	di,si	; the strings are identical
	ret
CompareStringsDifferent1:
	dec	si	;point back to the second byte of
	dec	di	; the word we just compared
CompareStringsDifferent:
	dec	si	;point back to the first byte of the
	dec	di	; word we just compared
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset TestString1 ;point to one string
	mov	di,seg TestString2
	mov	es,di
	mov	di,offset TestString2 ;point to other string
	call	CompareStringsNoCase	;and compare the
					; strings without
					; regard for case
	call	ZTimerOff
