;
; *** Listing 14-12 ***
;
; Demonstrates scanning a table with REPNZ SCASW in
; order to generate an index to be used with a jump table.
;
	jmp	Skip
;
; Branches to the routine corresponding to the key code in
; AX. Simply returns if no match is found.
;
; Input:
;	AX = 16-bit key code, as returned by the BIOS
;
; Output: none
;
; Registers altered: CX, DI, ES
;
; Direction flag cleared
;
; Table of 16-bit key codes this routine handles.
;
KeyLookUpTable	label	word
	dw	1e41h, 3042h, 2e43h, 2044h	;A-D
	dw	1245h, 2146h, 2247h, 2347h	;E-H
	dw	1749h, 244ah, 254bh, 264ch	;I-L
	dw	324dh, 314eh, 184fh, 1950h	;M-P
	dw	1051h, 1352h, 1f53h, 1454h	;Q-T
	dw	1655h, 2f56h, 1157h, 2d58h	;U-X
	dw	1559h, 2c5ah			;Y-Z
KEY_LOOK_UP_TABLE_LENGTH_IN_WORDS equ (($-KeyLookUpTable)/2)
;
; Table of addresses to which to jump when the corresponding
; key codes in KeyLookUpTable are found. All the entries
; point to the same routine, since this is for illustrative
; purposes only, but they could easily be changed to point
; to any label in the code segment.
;
KeyJumpTable	label	word
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z, HandleA_Z, HandleA_Z
	dw	HandleA_Z, HandleA_Z
;
VectorOnKey	proc	near
	mov	di,cs
	mov	es,di
	mov	di,offset KeyLookUpTable
			;point ES:DI to the table of keys
			; we handle, which is in the same
			; code segment as this routine
	mov	cx,KEY_LOOK_UP_TABLE_LENGTH_IN_WORDS
			;# of words to scan
	cld
	repnz	scasw	;look up the key
	jnz	VectorOnKeyDone	;it's not in the table, so
				; we're done
	jmp	cs:[KeyJumpTable+di-2-offset KeyLookUpTable]
			;jump to the routine for this key
			; Note that:
			;   DI-2-offset KeyLookUpTable
			; is the offset in KeyLookUpTable of
			; the key we found, with the -2
			; needed to compensate for the
			; 2-byte (1-word) overrun of SCASW
HandleA_Z:
VectorOnKeyDone:
	ret
VectorOnKey	endp
;
Skip:
	call	ZTimerOn
	mov	ax,1e41h
	call	VectorOnKey	;look up 'A'
	mov	ax,1749h
	call	VectorOnKey	;look up 'I'
	mov	ax,1f53h
	call	VectorOnKey	;look up 'S'
	mov	ax,2c5ah
	call	VectorOnKey	;look up 'Z'
	mov	ax,0
	call	VectorOnKey	;finally, look up a key
				; code that's not in the
				; table
	call	ZTimerOff
