'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |       PBClone  Copyright (c) 1990-1993  Thomas G. Hanlin III         |
'   |                                                                      |
'   +----------------------------------------------------------------------+

' This is another simple demo of the PBClone routines, BarMenu in specific.
' It offers you a choice between five options via a bar-type menu.
' Typically, this would be converted to an .EXE file using these steps:
'    BC MENUDEMO/O;
'    LINK MENUDEMO/EX,,NUL,PBCLONE;

   DECLARE SUB BarMenu (PickList$(), Row%, LCol%, RCol%, Attr%, HiAttr%, PromptSt$)
   DECLARE SUB CalcAttr (BYVAL Fore%, BYVAL Back%, Attr%)

   DEFINT A-Z

   DIM PickList$ (1 TO 10)

   COLOR 7, 0
   CLS

   PickList$(1) = "Alpha"
   PickList$(2) = "Beta"
   PickList$(3) = "Gamma"
   PickList$(4) = "Delta"
   PickList$(5) = "Epsilon"
   PickList$(6) = "Zeta"
   PickList$(7) = "eTa"
   PickList$(8) = "tHeta"
   PickList$(9) = "Iota"
   PickList$(10) = "Kappa"

   LOCATE 3, 1, 0
   PRINT "This is a brief demo of the BarMenu routine.  As you might guess, it provides"
   PRINT "support for bar-style menus.  You can use the left and right arrows, space"
   PRINT "and backspace, or tab and back-tab to move the highlight.  If you prefer,"
   PRINT "you can just press the first capitalized letter in the name of your choice."
   PRINT "The <ESC> key aborts without picking anything."

   CalcAttr 7, 1, Attr
   CalcAttr 15, 1, HiAttr
   Row = 1
   BarMenu PickList$(), Row, 0, 0, Attr, HiAttr, "Pick One: "

   LOCATE 10, 1
   IF Row THEN
      PRINT "You picked item"; STR$(Row); ", which is ";
      PRINT CHR$(34); PickList$(Row); CHR$(34)
   ELSE
      PRINT "You pressed <ESC>, so no item was selected."
   END IF
