#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*     Metabolite concentrations     */
/*             dialog box            */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE4, EdConc )

BOOL FAR PASCAL EdConc(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int first, last, lots, i, j, k;
 static BOOL circle;
 int len;
 HWND hCtrl;
 char buff[128];

 switch(Message)
 {
  case WM_INITDIALOG:
  /* copy metname to its mirror									*/
  _fmemcpy( (void __far *) x,
            (void __far *) xu,
		    (size_t) MAX_MET * sizeof( double ) );

  case WM_USER+1:
   /* initialize working variables                            */
   if (totmet >= 10 ) last = 10;
   else               last = totmet;
   if (totmet > 10 )  lots = TRUE;
   else               lots = FALSE;
   first = 0;
   circle = FALSE;

   /* initialize static controls with metabolite names			*/
   for( j=first, i=IDT_M0; j<last; j++, i++ )
    SetDlgItemText( hDlg, i, (LPSTR) metname[j]);

   /* update edit boxes											*/
   for( j=first, i=IDE_M0; j<last; j++, i++ )
   {
    gcvt( x[j], 16, buff );
    SetDlgItemText( hDlg, i, (LPSTR) buff);
   }

   /* show from first to last	 (static and edit controls)			*/
   for( j=first, i=IDT_M0, k=IDE_M0; j<last; j++, i++, k++ )
   {
    hCtrl = GetDlgItem( hDlg, k );
    ShowWindow( hCtrl, SW_SHOW );
    hCtrl = GetDlgItem( hDlg, i );
    ShowWindow( hCtrl, SW_SHOW );
   }
   /* hide from last to 9											*/
   for( j=last; j<10; j++, i++, k++ )
   {
    hCtrl = GetDlgItem( hDlg, k );
    ShowWindow( hCtrl, SW_HIDE );
    hCtrl = GetDlgItem( hDlg, i );
    ShowWindow( hCtrl, SW_HIDE );
   }

   /* show MORE if more than 10 metabolites						*/
   hCtrl = GetDlgItem( hDlg, ID_MORE );
   if (lots) ShowWindow( hCtrl, SW_SHOW );
   else      ShowWindow( hCtrl, SW_HIDE );
   break;

  case WM_COMMAND:
   switch(wParam)
   {
    case ID_MORE:
	 /* get the concentrations from the edit boxes			*/
     for( i=IDE_M0, j=first; j<last; i++, j++)
     {
      hCtrl = GetDlgItem( hDlg, i );
      len = (int) SendMessage( hCtrl, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len==0 ) x[j] = dft_conc;
      else x[j] = strtod( buff, NULL );
      if( (x[j]==HUGE_VAL) || (x[j]==-HUGE_VAL) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SetFocus( hCtrl );
       return TRUE;
      }
     }
     /* check need for going back to begginning				*/
	 if ( circle )
	 {
	  circle = FALSE;
	  SendMessage( hDlg, WM_USER+1, 0, (DWORD) 0 );
	  break;
	 }
     /* update working variables                            */
	 first = last;
     last += 10;
     if ( last >= totmet )
     {
      last = totmet;
      circle = TRUE;
     }
     /* update metabolite names								*/
     for( j=first, i=IDT_M0; j<last; j++, i++ )
      SetDlgItemText( hDlg, i, (LPSTR) metname[j]);

     /* update edit boxes									*/
     for( j=first, i=IDE_M0; j<last; j++, i++ )
     {
      gcvt( x[j], 16, buff );
      SetDlgItemText( hDlg, i, (LPSTR) buff);
     }
     /* show from first to last								*/
	 for( j=first, i=IDT_M0, k=IDE_M0; j<last; j++, i++, k++ )
     {
      hCtrl = GetDlgItem( hDlg, k );
      ShowWindow( hCtrl, SW_SHOW );
      hCtrl = GetDlgItem( hDlg, i );
      ShowWindow( hCtrl, SW_SHOW );
     }
     /* hide from last to 9											*/
     for( ; k<=IDE_M9; i++, k++ )
     {
      hCtrl = GetDlgItem( hDlg, k );
      ShowWindow( hCtrl, SW_HIDE );
      hCtrl = GetDlgItem( hDlg, i );
      ShowWindow( hCtrl, SW_HIDE );
     }
     break;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Metabolite initial concentrations" );
     break;

    case IDOK:
	 /* get the concentrations from the edit boxes			*/
     for( i=IDE_M0, j=first; j<last; i++, j++)
     {
      hCtrl = GetDlgItem( hDlg, i);
      len = (int) SendMessage( hCtrl, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len==0 ) x[j] = dft_conc;
      else x[j] = strtod( buff, NULL );
      if( (x[j]==HUGE_VAL) || (x[j]==-HUGE_VAL) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SetFocus( hCtrl );
       return TRUE;
      }
     }
	 /* copy metname back from its mirror									*/
     _fmemcpy( (void __far *) xu,
	           (void __far *) x,
	           (size_t) MAX_MET * sizeof( double ) );
	 notsaved = 1;
     EndDialog(hDlg, TRUE);
     break;

    case IDCANCEL:
     /* Ignore data values entered into the controls        */
     /* and dismiss the dialog window returning FALSE       */
     EndDialog(hDlg, FALSE);
     break;
   }
   break;    /* End of WM_COMMAND                                 */

  default:
   return FALSE;
 }
 return TRUE;
} /* End of EdConc                                      */

