#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Loops dialog box         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "topgvar.h"					/* global variables						*/

void ModSel( HWND hCB, int r, unsigned char modn );

#pragma alloc_text( CODE4, ModSel, EdLoop)

void ModSel( HWND hCB, int r, unsigned char modn )
{
 char name[NAME_L];
 int i, j;

 /* first get the text of the new metabolite					*/
 SendMessage( hCB, WM_GETTEXT, (WORD) NAME_L, (DWORD) (LPSTR) name);
 if( ! strcmp( "<not defined>", name ) )
 {
  for( j=0; j<totm; j++ )
   if( (*lp)[r][j] == modn )
   {
    (*lp)[r][j] = 0;
    nmd[r]--;
   }
 }
 else
 {
  for( i=0; i<totm; i++)
   if( ! lstrcmp( &metn[i][0], name ) ) break;
  if( i==totm )						/* metab. not yet defined			*/
  {
   lstrcpy( &metn[i][0], name );
   totm++;
   for(j=0; j<nst; j++) sto[i*MAX_MET + j] = 0;
   intm[i] = 0;
  }
  if( (*lp)[r][i]==0) nmd[r]++; 	/* increase nmd if no modif. before	*/
  (*lp)[r][i] = modn;
 }
}

BOOL FAR PASCAL EdLoop( HWND hDlg, WORD message, WORD wParam, LONG lParam )
{
 static	HWND	hReactLst, hCombo, hMoreButt, hTitle, hCount;
 static int	ridx[MAX_STEP];
 static int react_sel;
 static unsigned char modfnum;
 int i, j, r;
 char buff[128];

 switch( message )
 {
  case WM_INITDIALOG:
   lbWidth = 0;											/* set the width of the list box to 0	*/

   /* show the image on the mirror.				*/
   _fmemcpy( (void __far *) lp,
   	         (void __far *) loop,
             (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
   _fmemcpy( (void __far *) kinet,
   	         (void __far *) kinetu,
             (size_t) MAX_STEP * sizeof( int ) );
   _fmemcpy( (void __far *) metn,
   	         (void __far *) metname,
   	         (size_t) MAX_MET * NAME_L * sizeof( char ) );
   _fmemcpy( (void __far *) sto,
   	         (void __far *) stoiu,
             (size_t) MAX_MET * MAX_STEP * sizeof( int ) );
   _fmemcpy( (void __far *) intm,
   			 (void __far *) intmet,
   			 (size_t) MAX_MET * sizeof( int ) );
   _fmemcpy( (void __far *) nmd,
 	         (void __far *) nmod,
             (size_t) MAX_STEP * sizeof( unsigned char ) );
   nst = nsteps;
   totm = totmet;

   /* get handles to controls									*/
   hReactLst = GetDlgItem( hDlg, IDC_REACTLST );
   hCombo = GetDlgItem( hDlg, IDC_LOOPLST );
   hMoreButt = GetDlgItem( hDlg, ID_MORE );
   hTitle = GetDlgItem( hDlg, IDSTAT_3 );
   hCount = GetDlgItem( hDlg, IDSTAT_1 );

   /* insert <not defined> in the first position of the combo box	*/
   SendMessage( hCombo, CB_INSERTSTRING, -1, (DWORD) (LPSTR) "<not defined>" );

   /* insert all metabolites to the combo box						*/
   for( i=0; i<totmet; i++ )
    SendMessage( hCombo, CB_INSERTSTRING, -1, (DWORD) metname[i] );

   /* initialize hReactLst: add all reactions with modifiers	*/
   for( i=0,j=0; i<nsteps; i++ )
    if( ktype[kinet[i]].nmodf > 0 )
    {
     ridx[j] = i;
     AddReactLst( hReactLst, i, 0, 0, &totmet, metname, stoiu, intmet, revers, rstr );
     j++;
    }

    /* select the first reaction of hReactLst						*/
    SendMessage( hReactLst, LB_SETCURSEL, 0, 0 );
    react_sel = 0;

    /* it is the first modf that we are dealing with now			*/
    modfnum = 1;
    /* display its ordinal number									*/
    wsprintf( (LPSTR) buff, "%d%s modifier", modfnum,
              (modfnum % 10) == 1 ? (LPSTR) "st"
                                  : ( (modfnum % 10) == 2 ? (LPSTR) "nd"
                                                          : ( (modfnum % 10) == 3 ? (LPSTR) "rd"
                                                                                  : (LPSTR) "th"
                                                             )
                                    )
            );
    SendMessage( hTitle, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );

    /* if this type has several modfs show the MORE button			*/
    if( ktype[kinet[ridx[react_sel]]].nmodf > 1 )
    {
     ShowWindow( hMoreButt, SW_SHOW );
     wsprintf( buff, "This reaction has %d modifiers",
                     ktype[kinet[ridx[react_sel]]].nmodf );
    }
    else
    {
     ShowWindow( hMoreButt, SW_HIDE );
     wsprintf( buff, "This reaction has 1 modifier" );
    }
    SendMessage( hCount, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );

   /* select the appropriate modifier								*/
   for(i=0; i<totm; i++)
    if( (*lp)[ridx[react_sel]][i] == modfnum )
    {
     SendMessage( hCombo, CB_SETCURSEL, i+1, 0 );
     break;
    }
   if( i==totm ) SendMessage( hCombo, CB_SETCURSEL, 0, 0 );

   return( TRUE );

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_REACTLST:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      /* process previous selection										*/
      ModSel( hCombo, ridx[react_sel], modfnum );

      /* select the appropriate reaction of hReactLst					*/
      if( ( react_sel = (int) SendMessage( hReactLst, LB_GETCURSEL, 0, 0 ) ) != LB_ERR )
      {
       /* signal that it is the first modf that we are dealing with now	*/
       modfnum = 1;
       /* display its ordinal number									*/
       wsprintf( (LPSTR) buff, "%d%s modifier", modfnum,
                 (modfnum % 10) == 1 ? (LPSTR) "st"
                                     : ( (modfnum % 10) == 2 ? (LPSTR) "nd"
                                                             : ( (modfnum % 10) == 3 ? (LPSTR) "rd"
                                                                                     : (LPSTR) "th"
                                                               )
                                       )
               );
       SendMessage( hTitle, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );

       /* if this type has several modfs show the MORE button			*/
       if( ktype[kinet[ridx[react_sel]]].nmodf > 1 )
       {
        ShowWindow( hMoreButt, SW_SHOW );
        wsprintf( buff, "This reaction has %d modifiers",
                        ktype[kinet[ridx[react_sel]]].nmodf );
       }
       else
       {
        ShowWindow( hMoreButt, SW_HIDE );
        wsprintf( buff, "This reaction has 1 modifier" );
       }
       SendMessage( hCount, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );

       /* select the appropriate modifier								*/
       for(i=0; i<totm; i++)
        if( (*lp)[ridx[react_sel]][i] == modfnum )
        {
         SendMessage( hCombo, CB_SETCURSEL, i+1, 0 );
         break;
        }
       if( i==totm ) SendMessage( hCombo, CB_SETCURSEL, 0, 0 );
       return TRUE;
      }
      else return FALSE;
     }
     else return FALSE;

    case ID_MORE:
     ModSel( hCombo, ridx[react_sel], modfnum );
     if( modfnum == ktype[kinet[ridx[react_sel]]].nmodf ) modfnum = 1;
     else modfnum++;
     wsprintf( (LPSTR) buff, "%d%s modifier", modfnum,
               (modfnum % 10) == 1 ? (LPSTR) "st"
                                   : ( (modfnum % 10) == 2 ? (LPSTR) "nd"
                                                           : ( (modfnum % 10) == 3 ? (LPSTR) "rd"
                                                                                   : (LPSTR) "th"
                                                              )
                                     )
             );
     SendMessage( hTitle, WM_SETTEXT, 0, (DWORD) (LPSTR) buff );

     /* select the appropriate modifier								*/
     for(i=0; i<totm; i++)
      if( (*lp)[ridx[react_sel]][i] == modfnum )
      {
       SendMessage( hCombo, CB_SETCURSEL, i+1, 0 );
       break;
      }
     if( i==totm ) SendMessage( hCombo, CB_SETCURSEL, 0, 0 );
     return TRUE;

    case IDC_HELP:                        /* Help for this Dialog Box			 */
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Loop editor" );
     return( TRUE );

    case IDOK:
     ModSel( hCombo, ridx[react_sel], modfnum );
     /* copy the altered image to the original	*/
     _fmemcpy( (void __far *) loop,
   	           (void __far *) lp,
               (size_t) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
     _fmemcpy( (void __far *) kinetu,
   	           (void __far *) kinet,
               (size_t) MAX_STEP * sizeof( int ) );
     _fmemcpy( (void __far *) metname,
   	           (void __far *) metn,
   	           (size_t) MAX_MET * NAME_L * sizeof( char ) );
     _fmemcpy( (void __far *) stoiu,
   	           (void __far *) sto,
               (size_t) MAX_MET * MAX_STEP * sizeof( int ) );
     _fmemcpy( (void __far *) intmet,
   			   (void __far *) intm,
   			   (size_t) MAX_MET * sizeof( int ) );
     _fmemcpy( (void __far *) nmod,
 	           (void __far *) nmd,
               (size_t) MAX_STEP * sizeof( unsigned char ) );
     nsteps = nst;
     totmet = totm;

     for( i=0, loopass=0; i<nsteps ; i++)
     {
      /* copy nmd to nmod						*/
      nmod[i] = nmd[i];
      /* count the number of assigned loops		*/
      if( (ktype[kinet[i]].nmodf>0) &&
          (ktype[kinet[i]].nmodf == nmod[i]) ) loopass++;
     }
     notsaved = 1;
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDOK );
     return( TRUE );

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return( TRUE );
   }

  default: return( FALSE );
 }
}