/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <ctype.h>

/***
 *  Function    :  chcase
 *
 *  Description :  change case of a 2-byte character.
 *   		   All special characters are translated (...)
 *
 *  Parameters  :  in   char      car      char to translate
 *                 in   casetype  type     UPPER/LOWER
 *                                        
 *  Value       :  type = { UPPER, LOWER }
 *
 *  Decisions   :  If character > 255, no change made.
 *
 *  Return      :  code of char translated
 *
 *  OS/Compiler :  All
 ***/

int chcase( int car, casetype type )

{ if ( car > 255 ) return car;

  switch( car )
	{
	  case '':
	  case '':
	  case '':
  	  case '':
	  case '':
	  case '': car = 'a'; break;

	  case '':
	  case '': car = 'A'; break;

	  case '':
	  case '':
	  case '':
	  case '': car = 'e'; break;

	  case '': car = 'E'; break;

	  case '':
	  case '':
	  case '':
	  case '': car = 'i'; break;

	  case '':
	  case '':
  	  case '':
	  case '':
	  case '': car = 'o'; break;

	  case '': car = 'O'; break;

	  case '':
	  case '':
	  case '':
	  case '': car = 'u'; break;

	  case '': car = 'U'; break;

	  case '': car = 'y'; break;

	  case '': car = 'c'; break;

	  case '': car = 'C'; break;

	  case '': car = 'n'; break;

	  case '': car = 'N'; break;
	}

  if ( type == UPPER ) return toupper(car);
  if ( type == LOWER ) return tolower(car);
  return car;
}
